/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.openstack4j.openstack.trove.domain;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.huawei.openstack4j.model.ModelEntity;
import com.huawei.openstack4j.openstack.common.ListResult;
import java.beans.ConstructorProperties;
import java.util.List;

public class Database
implements ModelEntity {
    private static final long serialVersionUID = 4318036798508606114L;
    private String name;
    @JsonProperty(value="character_set")
    private String dbCharacterSet;
    @JsonProperty(value="collate")
    private String dbCollation;

    public static DatabaseBuilder builder() {
        return new DatabaseBuilder();
    }

    public DatabaseBuilder toBuilder() {
        return new DatabaseBuilder().name(this.name).dbCharacterSet(this.dbCharacterSet).dbCollation(this.dbCollation);
    }

    public String getName() {
        return this.name;
    }

    public String getDbCharacterSet() {
        return this.dbCharacterSet;
    }

    public String getDbCollation() {
        return this.dbCollation;
    }

    public String toString() {
        return "Database(name=" + this.getName() + ", dbCharacterSet=" + this.getDbCharacterSet() + ", dbCollation=" + this.getDbCollation() + ")";
    }

    public Database() {
    }

    @ConstructorProperties(value={"name", "dbCharacterSet", "dbCollation"})
    public Database(String name, String dbCharacterSet, String dbCollation) {
        this.name = name;
        this.dbCharacterSet = dbCharacterSet;
        this.dbCollation = dbCollation;
    }

    public static class DatabaseBuilder {
        private String name;
        private String dbCharacterSet;
        private String dbCollation;

        DatabaseBuilder() {
        }

        public DatabaseBuilder name(String name) {
            this.name = name;
            return this;
        }

        public DatabaseBuilder dbCharacterSet(String dbCharacterSet) {
            this.dbCharacterSet = dbCharacterSet;
            return this;
        }

        public DatabaseBuilder dbCollation(String dbCollation) {
            this.dbCollation = dbCollation;
            return this;
        }

        public Database build() {
            return new Database(this.name, this.dbCharacterSet, this.dbCollation);
        }

        public String toString() {
            return "Database.DatabaseBuilder(name=" + this.name + ", dbCharacterSet=" + this.dbCharacterSet + ", dbCollation=" + this.dbCollation + ")";
        }
    }

    public static class Databases
    extends ListResult<Database> {
        private static final long serialVersionUID = 1L;
        @JsonProperty(value="databases")
        private List<Database> troveDatabaseList;

        public List<Database> getTroveDatabaseList() {
            return this.troveDatabaseList;
        }

        public void setTroveDatabaseList(List<Database> troveDatabaseList) {
            this.troveDatabaseList = troveDatabaseList;
        }

        @Override
        protected List<Database> value() {
            return this.troveDatabaseList;
        }
    }
}

