/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.openstack4j.openstack.trove.domain;

import com.fasterxml.jackson.annotation.JsonFormat;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonRootName;
import com.huawei.openstack4j.model.ModelEntity;
import com.huawei.openstack4j.openstack.common.GenericLink;
import com.huawei.openstack4j.openstack.common.ListResult;
import com.huawei.openstack4j.openstack.trove.constant.DatastoreType;
import com.huawei.openstack4j.openstack.trove.constant.InstanceType;
import com.huawei.openstack4j.openstack.trove.domain.DatabaseConfig;
import com.huawei.openstack4j.openstack.trove.domain.Datastore;
import com.huawei.openstack4j.openstack.trove.domain.InstanceFlavor;
import com.huawei.openstack4j.openstack.trove.domain.Volume;
import java.beans.ConstructorProperties;
import java.util.Date;
import java.util.List;

@JsonRootName(value="instance")
public class DatabaseInstance
implements ModelEntity {
    private static final long serialVersionUID = -7399474725379713926L;
    String id;
    String name;
    String ip;
    String hostname;
    String status;
    Volume volume;
    Datastore datastore;
    InstanceFlavor flavor;
    @JsonFormat(pattern="yyyy-MM-dd'T'HH:mm:ss")
    Date created;
    @JsonFormat(pattern="yyyy-MM-dd'T'HH:mm:ss")
    Date updated;
    @JsonProperty(value="links")
    List<GenericLink> links;
    @JsonProperty(value="configurationStatus")
    String configurationStatus;
    @JsonProperty(value="paramsGroupId")
    String configurationId;
    DatastoreType type;
    @JsonProperty(value="subnetid")
    String subnetId;
    InstanceType role;
    String internalSubnetId;
    String group;
    @JsonProperty(value="securegroup")
    String secureGroupId;
    @JsonProperty(value="vpc")
    String vpcId;
    @JsonProperty(value="azcode")
    String availabilityZone;
    String region;
    String fault;
    DatabaseConfig configuration;
    String locality;
    List<DatabaseInstance> replicas;
    @JsonProperty(value="replica_of")
    List<DatabaseInstance> replicaOf;
    @JsonProperty(value="dbuser")
    String dbUser;
    String storageEngine;
    Integer payModel;
    @JsonProperty(value="cluster_id")
    String clusterId;

    public static DatabaseInstanceBuilder builder() {
        return new DatabaseInstanceBuilder();
    }

    public DatabaseInstanceBuilder toBuilder() {
        return new DatabaseInstanceBuilder().id(this.id).name(this.name).ip(this.ip).hostname(this.hostname).status(this.status).volume(this.volume).datastore(this.datastore).flavor(this.flavor).created(this.created).updated(this.updated).links(this.links).configurationStatus(this.configurationStatus).configurationId(this.configurationId).type(this.type).subnetId(this.subnetId).role(this.role).internalSubnetId(this.internalSubnetId).group(this.group).secureGroupId(this.secureGroupId).vpcId(this.vpcId).availabilityZone(this.availabilityZone).region(this.region).fault(this.fault).configuration(this.configuration).locality(this.locality).replicas(this.replicas).replicaOf(this.replicaOf).dbUser(this.dbUser).storageEngine(this.storageEngine).payModel(this.payModel).clusterId(this.clusterId);
    }

    public String getId() {
        return this.id;
    }

    public String getName() {
        return this.name;
    }

    public String getIp() {
        return this.ip;
    }

    public String getHostname() {
        return this.hostname;
    }

    public String getStatus() {
        return this.status;
    }

    public Volume getVolume() {
        return this.volume;
    }

    public Datastore getDatastore() {
        return this.datastore;
    }

    public InstanceFlavor getFlavor() {
        return this.flavor;
    }

    public Date getCreated() {
        return this.created;
    }

    public Date getUpdated() {
        return this.updated;
    }

    public List<GenericLink> getLinks() {
        return this.links;
    }

    public String getConfigurationStatus() {
        return this.configurationStatus;
    }

    public String getConfigurationId() {
        return this.configurationId;
    }

    public DatastoreType getType() {
        return this.type;
    }

    public String getSubnetId() {
        return this.subnetId;
    }

    public InstanceType getRole() {
        return this.role;
    }

    public String getInternalSubnetId() {
        return this.internalSubnetId;
    }

    public String getGroup() {
        return this.group;
    }

    public String getSecureGroupId() {
        return this.secureGroupId;
    }

    public String getVpcId() {
        return this.vpcId;
    }

    public String getAvailabilityZone() {
        return this.availabilityZone;
    }

    public String getRegion() {
        return this.region;
    }

    public String getFault() {
        return this.fault;
    }

    public DatabaseConfig getConfiguration() {
        return this.configuration;
    }

    public String getLocality() {
        return this.locality;
    }

    public List<DatabaseInstance> getReplicas() {
        return this.replicas;
    }

    public List<DatabaseInstance> getReplicaOf() {
        return this.replicaOf;
    }

    public String getDbUser() {
        return this.dbUser;
    }

    public String getStorageEngine() {
        return this.storageEngine;
    }

    public Integer getPayModel() {
        return this.payModel;
    }

    public String getClusterId() {
        return this.clusterId;
    }

    public String toString() {
        return "DatabaseInstance(id=" + this.getId() + ", name=" + this.getName() + ", ip=" + this.getIp() + ", hostname=" + this.getHostname() + ", status=" + this.getStatus() + ", volume=" + this.getVolume() + ", datastore=" + this.getDatastore() + ", flavor=" + this.getFlavor() + ", created=" + this.getCreated() + ", updated=" + this.getUpdated() + ", links=" + this.getLinks() + ", configurationStatus=" + this.getConfigurationStatus() + ", configurationId=" + this.getConfigurationId() + ", type=" + (Object)((Object)this.getType()) + ", subnetId=" + this.getSubnetId() + ", role=" + (Object)((Object)this.getRole()) + ", internalSubnetId=" + this.getInternalSubnetId() + ", group=" + this.getGroup() + ", secureGroupId=" + this.getSecureGroupId() + ", vpcId=" + this.getVpcId() + ", availabilityZone=" + this.getAvailabilityZone() + ", region=" + this.getRegion() + ", fault=" + this.getFault() + ", configuration=" + this.getConfiguration() + ", locality=" + this.getLocality() + ", replicas=" + this.getReplicas() + ", replicaOf=" + this.getReplicaOf() + ", dbUser=" + this.getDbUser() + ", storageEngine=" + this.getStorageEngine() + ", payModel=" + this.getPayModel() + ", clusterId=" + this.getClusterId() + ")";
    }

    public DatabaseInstance() {
    }

    @ConstructorProperties(value={"id", "name", "ip", "hostname", "status", "volume", "datastore", "flavor", "created", "updated", "links", "configurationStatus", "configurationId", "type", "subnetId", "role", "internalSubnetId", "group", "secureGroupId", "vpcId", "availabilityZone", "region", "fault", "configuration", "locality", "replicas", "replicaOf", "dbUser", "storageEngine", "payModel", "clusterId"})
    public DatabaseInstance(String id, String name, String ip, String hostname, String status, Volume volume, Datastore datastore, InstanceFlavor flavor, Date created, Date updated, List<GenericLink> links, String configurationStatus, String configurationId, DatastoreType type, String subnetId, InstanceType role, String internalSubnetId, String group, String secureGroupId, String vpcId, String availabilityZone, String region, String fault, DatabaseConfig configuration, String locality, List<DatabaseInstance> replicas, List<DatabaseInstance> replicaOf, String dbUser, String storageEngine, Integer payModel, String clusterId) {
        this.id = id;
        this.name = name;
        this.ip = ip;
        this.hostname = hostname;
        this.status = status;
        this.volume = volume;
        this.datastore = datastore;
        this.flavor = flavor;
        this.created = created;
        this.updated = updated;
        this.links = links;
        this.configurationStatus = configurationStatus;
        this.configurationId = configurationId;
        this.type = type;
        this.subnetId = subnetId;
        this.role = role;
        this.internalSubnetId = internalSubnetId;
        this.group = group;
        this.secureGroupId = secureGroupId;
        this.vpcId = vpcId;
        this.availabilityZone = availabilityZone;
        this.region = region;
        this.fault = fault;
        this.configuration = configuration;
        this.locality = locality;
        this.replicas = replicas;
        this.replicaOf = replicaOf;
        this.dbUser = dbUser;
        this.storageEngine = storageEngine;
        this.payModel = payModel;
        this.clusterId = clusterId;
    }

    public static class DatabaseInstanceBuilder {
        private String id;
        private String name;
        private String ip;
        private String hostname;
        private String status;
        private Volume volume;
        private Datastore datastore;
        private InstanceFlavor flavor;
        private Date created;
        private Date updated;
        private List<GenericLink> links;
        private String configurationStatus;
        private String configurationId;
        private DatastoreType type;
        private String subnetId;
        private InstanceType role;
        private String internalSubnetId;
        private String group;
        private String secureGroupId;
        private String vpcId;
        private String availabilityZone;
        private String region;
        private String fault;
        private DatabaseConfig configuration;
        private String locality;
        private List<DatabaseInstance> replicas;
        private List<DatabaseInstance> replicaOf;
        private String dbUser;
        private String storageEngine;
        private Integer payModel;
        private String clusterId;

        DatabaseInstanceBuilder() {
        }

        public DatabaseInstanceBuilder id(String id) {
            this.id = id;
            return this;
        }

        public DatabaseInstanceBuilder name(String name) {
            this.name = name;
            return this;
        }

        public DatabaseInstanceBuilder ip(String ip) {
            this.ip = ip;
            return this;
        }

        public DatabaseInstanceBuilder hostname(String hostname) {
            this.hostname = hostname;
            return this;
        }

        public DatabaseInstanceBuilder status(String status) {
            this.status = status;
            return this;
        }

        public DatabaseInstanceBuilder volume(Volume volume) {
            this.volume = volume;
            return this;
        }

        public DatabaseInstanceBuilder datastore(Datastore datastore) {
            this.datastore = datastore;
            return this;
        }

        public DatabaseInstanceBuilder flavor(InstanceFlavor flavor) {
            this.flavor = flavor;
            return this;
        }

        public DatabaseInstanceBuilder created(Date created) {
            this.created = created;
            return this;
        }

        public DatabaseInstanceBuilder updated(Date updated) {
            this.updated = updated;
            return this;
        }

        public DatabaseInstanceBuilder links(List<GenericLink> links) {
            this.links = links;
            return this;
        }

        public DatabaseInstanceBuilder configurationStatus(String configurationStatus) {
            this.configurationStatus = configurationStatus;
            return this;
        }

        public DatabaseInstanceBuilder configurationId(String configurationId) {
            this.configurationId = configurationId;
            return this;
        }

        public DatabaseInstanceBuilder type(DatastoreType type) {
            this.type = type;
            return this;
        }

        public DatabaseInstanceBuilder subnetId(String subnetId) {
            this.subnetId = subnetId;
            return this;
        }

        public DatabaseInstanceBuilder role(InstanceType role) {
            this.role = role;
            return this;
        }

        public DatabaseInstanceBuilder internalSubnetId(String internalSubnetId) {
            this.internalSubnetId = internalSubnetId;
            return this;
        }

        public DatabaseInstanceBuilder group(String group) {
            this.group = group;
            return this;
        }

        public DatabaseInstanceBuilder secureGroupId(String secureGroupId) {
            this.secureGroupId = secureGroupId;
            return this;
        }

        public DatabaseInstanceBuilder vpcId(String vpcId) {
            this.vpcId = vpcId;
            return this;
        }

        public DatabaseInstanceBuilder availabilityZone(String availabilityZone) {
            this.availabilityZone = availabilityZone;
            return this;
        }

        public DatabaseInstanceBuilder region(String region) {
            this.region = region;
            return this;
        }

        public DatabaseInstanceBuilder fault(String fault) {
            this.fault = fault;
            return this;
        }

        public DatabaseInstanceBuilder configuration(DatabaseConfig configuration) {
            this.configuration = configuration;
            return this;
        }

        public DatabaseInstanceBuilder locality(String locality) {
            this.locality = locality;
            return this;
        }

        public DatabaseInstanceBuilder replicas(List<DatabaseInstance> replicas) {
            this.replicas = replicas;
            return this;
        }

        public DatabaseInstanceBuilder replicaOf(List<DatabaseInstance> replicaOf) {
            this.replicaOf = replicaOf;
            return this;
        }

        public DatabaseInstanceBuilder dbUser(String dbUser) {
            this.dbUser = dbUser;
            return this;
        }

        public DatabaseInstanceBuilder storageEngine(String storageEngine) {
            this.storageEngine = storageEngine;
            return this;
        }

        public DatabaseInstanceBuilder payModel(Integer payModel) {
            this.payModel = payModel;
            return this;
        }

        public DatabaseInstanceBuilder clusterId(String clusterId) {
            this.clusterId = clusterId;
            return this;
        }

        public DatabaseInstance build() {
            return new DatabaseInstance(this.id, this.name, this.ip, this.hostname, this.status, this.volume, this.datastore, this.flavor, this.created, this.updated, this.links, this.configurationStatus, this.configurationId, this.type, this.subnetId, this.role, this.internalSubnetId, this.group, this.secureGroupId, this.vpcId, this.availabilityZone, this.region, this.fault, this.configuration, this.locality, this.replicas, this.replicaOf, this.dbUser, this.storageEngine, this.payModel, this.clusterId);
        }

        public String toString() {
            return "DatabaseInstance.DatabaseInstanceBuilder(id=" + this.id + ", name=" + this.name + ", ip=" + this.ip + ", hostname=" + this.hostname + ", status=" + this.status + ", volume=" + this.volume + ", datastore=" + this.datastore + ", flavor=" + this.flavor + ", created=" + this.created + ", updated=" + this.updated + ", links=" + this.links + ", configurationStatus=" + this.configurationStatus + ", configurationId=" + this.configurationId + ", type=" + (Object)((Object)this.type) + ", subnetId=" + this.subnetId + ", role=" + (Object)((Object)this.role) + ", internalSubnetId=" + this.internalSubnetId + ", group=" + this.group + ", secureGroupId=" + this.secureGroupId + ", vpcId=" + this.vpcId + ", availabilityZone=" + this.availabilityZone + ", region=" + this.region + ", fault=" + this.fault + ", configuration=" + this.configuration + ", locality=" + this.locality + ", replicas=" + this.replicas + ", replicaOf=" + this.replicaOf + ", dbUser=" + this.dbUser + ", storageEngine=" + this.storageEngine + ", payModel=" + this.payModel + ", clusterId=" + this.clusterId + ")";
        }
    }

    public static class DatabaseInstanceWraps
    extends ListResult<DatabaseInstanceWrap> {
        private static final long serialVersionUID = 1L;
        @JsonProperty(value="instances")
        private List<DatabaseInstanceWrap> instances;

        @Override
        protected List<DatabaseInstanceWrap> value() {
            return this.instances;
        }
    }

    public static class DatabaseInstanceWrap {
        @JsonProperty(value="instance")
        DatabaseInstance instance;

        public DatabaseInstance getInstance() {
            return this.instance;
        }

        public void setInstance(DatabaseInstance instance) {
            this.instance = instance;
        }
    }

    public static class DatabaseInstances
    extends ListResult<DatabaseInstance> {
        private static final long serialVersionUID = 1L;
        @JsonProperty(value="instances")
        private List<DatabaseInstance> instances;

        @Override
        protected List<DatabaseInstance> value() {
            return this.instances;
        }
    }
}

