/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.openstack4j.openstack.trove.domain;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonRootName;
import com.huawei.openstack4j.model.ModelEntity;
import com.huawei.openstack4j.openstack.common.IdResourceEntity;
import com.huawei.openstack4j.openstack.trove.domain.Database;
import com.huawei.openstack4j.openstack.trove.domain.DatabaseUser;
import com.huawei.openstack4j.openstack.trove.domain.Datastore;
import com.huawei.openstack4j.openstack.trove.domain.NIC;
import com.huawei.openstack4j.openstack.trove.domain.RestorePoint;
import com.huawei.openstack4j.openstack.trove.domain.Volume;
import java.beans.ConstructorProperties;
import java.util.List;

@JsonRootName(value="instance")
public class DatabaseInstanceCreate
implements ModelEntity {
    static final long serialVersionUID = -7844139328996206764L;
    @JsonProperty(value="datastore")
    Datastore datastore;
    @JsonProperty(value="name")
    String name;
    @JsonProperty(value="flavorRef")
    String flavorRef;
    @JsonProperty(value="users")
    List<DatabaseUser> users;
    @JsonProperty(value="volume")
    Volume volume;
    @JsonProperty(value="configuration")
    String configurationId;
    @JsonProperty(value="availability_zone")
    String availabilityZone;
    @JsonProperty(value="vpc")
    String vpcId;
    @JsonProperty(value="nics")
    List<NIC> nics;
    @JsonProperty(value="databases")
    List<Database> databases;
    @JsonProperty(value="modules")
    List<String> modules;
    @JsonProperty(value="restorePoint")
    RestorePoint restorePoint;
    @JsonProperty(value="cluster_config")
    IdResourceEntity clusterConfig;

    public static DatabaseInstanceCreateBuilder builder() {
        return new DatabaseInstanceCreateBuilder();
    }

    public DatabaseInstanceCreateBuilder toBuilder() {
        return new DatabaseInstanceCreateBuilder().datastore(this.datastore).name(this.name).flavorRef(this.flavorRef).users(this.users).volume(this.volume).configurationId(this.configurationId).availabilityZone(this.availabilityZone).vpcId(this.vpcId).nics(this.nics).databases(this.databases).modules(this.modules).restorePoint(this.restorePoint).clusterConfig(this.clusterConfig);
    }

    public Datastore getDatastore() {
        return this.datastore;
    }

    public String getName() {
        return this.name;
    }

    public String getFlavorRef() {
        return this.flavorRef;
    }

    public List<DatabaseUser> getUsers() {
        return this.users;
    }

    public Volume getVolume() {
        return this.volume;
    }

    public String getConfigurationId() {
        return this.configurationId;
    }

    public String getAvailabilityZone() {
        return this.availabilityZone;
    }

    public String getVpcId() {
        return this.vpcId;
    }

    public List<NIC> getNics() {
        return this.nics;
    }

    public List<Database> getDatabases() {
        return this.databases;
    }

    public List<String> getModules() {
        return this.modules;
    }

    public RestorePoint getRestorePoint() {
        return this.restorePoint;
    }

    public IdResourceEntity getClusterConfig() {
        return this.clusterConfig;
    }

    public String toString() {
        return "DatabaseInstanceCreate(datastore=" + this.getDatastore() + ", name=" + this.getName() + ", flavorRef=" + this.getFlavorRef() + ", users=" + this.getUsers() + ", volume=" + this.getVolume() + ", configurationId=" + this.getConfigurationId() + ", availabilityZone=" + this.getAvailabilityZone() + ", vpcId=" + this.getVpcId() + ", nics=" + this.getNics() + ", databases=" + this.getDatabases() + ", modules=" + this.getModules() + ", restorePoint=" + this.getRestorePoint() + ", clusterConfig=" + this.getClusterConfig() + ")";
    }

    public DatabaseInstanceCreate() {
    }

    @ConstructorProperties(value={"datastore", "name", "flavorRef", "users", "volume", "configurationId", "availabilityZone", "vpcId", "nics", "databases", "modules", "restorePoint", "clusterConfig"})
    public DatabaseInstanceCreate(Datastore datastore, String name, String flavorRef, List<DatabaseUser> users, Volume volume, String configurationId, String availabilityZone, String vpcId, List<NIC> nics, List<Database> databases, List<String> modules, RestorePoint restorePoint, IdResourceEntity clusterConfig) {
        this.datastore = datastore;
        this.name = name;
        this.flavorRef = flavorRef;
        this.users = users;
        this.volume = volume;
        this.configurationId = configurationId;
        this.availabilityZone = availabilityZone;
        this.vpcId = vpcId;
        this.nics = nics;
        this.databases = databases;
        this.modules = modules;
        this.restorePoint = restorePoint;
        this.clusterConfig = clusterConfig;
    }

    public static class DatabaseInstanceCreateBuilder {
        private Datastore datastore;
        private String name;
        private String flavorRef;
        private List<DatabaseUser> users;
        private Volume volume;
        private String configurationId;
        private String availabilityZone;
        private String vpcId;
        private List<NIC> nics;
        private List<Database> databases;
        private List<String> modules;
        private RestorePoint restorePoint;
        private IdResourceEntity clusterConfig;

        DatabaseInstanceCreateBuilder() {
        }

        public DatabaseInstanceCreateBuilder datastore(Datastore datastore) {
            this.datastore = datastore;
            return this;
        }

        public DatabaseInstanceCreateBuilder name(String name) {
            this.name = name;
            return this;
        }

        public DatabaseInstanceCreateBuilder flavorRef(String flavorRef) {
            this.flavorRef = flavorRef;
            return this;
        }

        public DatabaseInstanceCreateBuilder users(List<DatabaseUser> users) {
            this.users = users;
            return this;
        }

        public DatabaseInstanceCreateBuilder volume(Volume volume) {
            this.volume = volume;
            return this;
        }

        public DatabaseInstanceCreateBuilder configurationId(String configurationId) {
            this.configurationId = configurationId;
            return this;
        }

        public DatabaseInstanceCreateBuilder availabilityZone(String availabilityZone) {
            this.availabilityZone = availabilityZone;
            return this;
        }

        public DatabaseInstanceCreateBuilder vpcId(String vpcId) {
            this.vpcId = vpcId;
            return this;
        }

        public DatabaseInstanceCreateBuilder nics(List<NIC> nics) {
            this.nics = nics;
            return this;
        }

        public DatabaseInstanceCreateBuilder databases(List<Database> databases) {
            this.databases = databases;
            return this;
        }

        public DatabaseInstanceCreateBuilder modules(List<String> modules) {
            this.modules = modules;
            return this;
        }

        public DatabaseInstanceCreateBuilder restorePoint(RestorePoint restorePoint) {
            this.restorePoint = restorePoint;
            return this;
        }

        public DatabaseInstanceCreateBuilder clusterConfig(IdResourceEntity clusterConfig) {
            this.clusterConfig = clusterConfig;
            return this;
        }

        public DatabaseInstanceCreate build() {
            return new DatabaseInstanceCreate(this.datastore, this.name, this.flavorRef, this.users, this.volume, this.configurationId, this.availabilityZone, this.vpcId, this.nics, this.databases, this.modules, this.restorePoint, this.clusterConfig);
        }

        public String toString() {
            return "DatabaseInstanceCreate.DatabaseInstanceCreateBuilder(datastore=" + this.datastore + ", name=" + this.name + ", flavorRef=" + this.flavorRef + ", users=" + this.users + ", volume=" + this.volume + ", configurationId=" + this.configurationId + ", availabilityZone=" + this.availabilityZone + ", vpcId=" + this.vpcId + ", nics=" + this.nics + ", databases=" + this.databases + ", modules=" + this.modules + ", restorePoint=" + this.restorePoint + ", clusterConfig=" + this.clusterConfig + ")";
        }
    }
}

