/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.openstack4j.openstack.trove.internal;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonRootName;
import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import com.huawei.openstack4j.openstack.trove.domain.DatabaseParam;
import com.huawei.openstack4j.openstack.trove.internal.BaseTroveServices;
import java.util.List;
import java.util.Map;

public class TroveDatabaseParamService
extends BaseTroveServices {
    public List<DatabaseParam> list(String dataStoreVersionId) {
        Preconditions.checkArgument((!Strings.isNullOrEmpty((String)dataStoreVersionId) ? 1 : 0) != 0, (Object)"parameter `dataStoreVersionId` should not be empty");
        return this.get(DatabaseParam.Parameters.class, this.uri("/datastores/versions/%s/parameters", dataStoreVersionId)).execute().getList();
    }

    public DatabaseParam get(String dataStoreVersionId, String paramName) {
        Preconditions.checkArgument((!Strings.isNullOrEmpty((String)dataStoreVersionId) ? 1 : 0) != 0, (Object)"parameter `dataStoreVersionId` should not be empty");
        Preconditions.checkArgument((!Strings.isNullOrEmpty((String)paramName) ? 1 : 0) != 0, (Object)"parameter `paramName` should not be empty");
        return (DatabaseParam)this.get(DatabaseParam.Parameters.class, this.uri("/datastores/versions/%s/parameters/%s", dataStoreVersionId, paramName)).execute().getList().get(0);
    }

    public Map<String, String> getDefaultParamsByInstance(String instanceId) {
        Preconditions.checkArgument((!Strings.isNullOrEmpty((String)instanceId) ? 1 : 0) != 0, (Object)"parameter `instanceId` should not be empty");
        GetDefaultParamsResponse response = this.get(GetDefaultParamsResponse.class, this.uri("/instances/%s/configuration", instanceId)).execute();
        return response.getParams();
    }

    @JsonRootName(value="instance")
    static class GetDefaultParamsResponse {
        @JsonProperty(value="configuration")
        Map<String, String> params;

        GetDefaultParamsResponse() {
        }

        public Map<String, String> getParams() {
            return this.params;
        }

        public void setParams(Map<String, String> params) {
            this.params = params;
        }
    }
}

