/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.openstack4j.openstack.vpc.v1.domain;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonRootName;
import com.huawei.openstack4j.model.ModelEntity;
import com.huawei.openstack4j.openstack.common.ListResult;
import com.huawei.openstack4j.openstack.vpc.v1.domain.Route;
import java.beans.ConstructorProperties;
import java.util.List;

@JsonRootName(value="vpc")
public class Vpc
implements ModelEntity {
    private static final long serialVersionUID = 1L;
    private String id;
    private String name;
    private String cidr;
    private String status;
    @JsonProperty(value="enterprise_project_id")
    private String enterpriseProjectId;
    @JsonProperty(value="routes")
    private List<Route> routes;

    public static VpcBuilder builder() {
        return new VpcBuilder();
    }

    public VpcBuilder toBuilder() {
        return new VpcBuilder().id(this.id).name(this.name).cidr(this.cidr).status(this.status).enterpriseProjectId(this.enterpriseProjectId).routes(this.routes);
    }

    public String getId() {
        return this.id;
    }

    public String getName() {
        return this.name;
    }

    public String getCidr() {
        return this.cidr;
    }

    public String getStatus() {
        return this.status;
    }

    public String getEnterpriseProjectId() {
        return this.enterpriseProjectId;
    }

    public List<Route> getRoutes() {
        return this.routes;
    }

    public String toString() {
        return "Vpc(id=" + this.getId() + ", name=" + this.getName() + ", cidr=" + this.getCidr() + ", status=" + this.getStatus() + ", enterpriseProjectId=" + this.getEnterpriseProjectId() + ", routes=" + this.getRoutes() + ")";
    }

    public Vpc() {
    }

    @ConstructorProperties(value={"id", "name", "cidr", "status", "enterpriseProjectId", "routes"})
    public Vpc(String id, String name, String cidr, String status, String enterpriseProjectId, List<Route> routes) {
        this.id = id;
        this.name = name;
        this.cidr = cidr;
        this.status = status;
        this.enterpriseProjectId = enterpriseProjectId;
        this.routes = routes;
    }

    public static class VpcBuilder {
        private String id;
        private String name;
        private String cidr;
        private String status;
        private String enterpriseProjectId;
        private List<Route> routes;

        VpcBuilder() {
        }

        public VpcBuilder id(String id) {
            this.id = id;
            return this;
        }

        public VpcBuilder name(String name) {
            this.name = name;
            return this;
        }

        public VpcBuilder cidr(String cidr) {
            this.cidr = cidr;
            return this;
        }

        public VpcBuilder status(String status) {
            this.status = status;
            return this;
        }

        public VpcBuilder enterpriseProjectId(String enterpriseProjectId) {
            this.enterpriseProjectId = enterpriseProjectId;
            return this;
        }

        public VpcBuilder routes(List<Route> routes) {
            this.routes = routes;
            return this;
        }

        public Vpc build() {
            return new Vpc(this.id, this.name, this.cidr, this.status, this.enterpriseProjectId, this.routes);
        }

        public String toString() {
            return "Vpc.VpcBuilder(id=" + this.id + ", name=" + this.name + ", cidr=" + this.cidr + ", status=" + this.status + ", enterpriseProjectId=" + this.enterpriseProjectId + ", routes=" + this.routes + ")";
        }
    }

    public static class Vpcs
    extends ListResult<Vpc> {
        private static final long serialVersionUID = 1L;
        @JsonProperty(value="vpcs")
        private List<Vpc> vpcs;

        @Override
        public List<Vpc> value() {
            return this.vpcs;
        }
    }
}

