/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.openstack4j.openstack.vpc.v1.internal;

import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import com.huawei.openstack4j.api.types.ServiceType;
import com.huawei.openstack4j.core.transport.Config;
import com.huawei.openstack4j.core.transport.HttpMethod;
import com.huawei.openstack4j.model.common.ActionResponse;
import com.huawei.openstack4j.openstack.common.functions.RemoveProjectIdFromURL;
import com.huawei.openstack4j.openstack.internal.BaseOpenStackService;
import com.huawei.openstack4j.openstack.vpc.v1.domain.Port;
import com.huawei.openstack4j.openstack.vpc.v1.domain.PortCreate;
import com.huawei.openstack4j.openstack.vpc.v1.domain.PortUpdate;
import java.util.List;
import java.util.Map;

public class PortService
extends BaseOpenStackService {
    public static String CONTENT_JSON = "application/json;charset=utf-8";

    public PortService() {
        super(ServiceType.VPC, RemoveProjectIdFromURL.INSTANCE);
    }

    public List<? extends Port> list() {
        return this.list(null);
    }

    public List<? extends Port> list(Map<String, String> filteringParams) {
        BaseOpenStackService.Invocation<Port.Ports> flavorInvocation = this.get(Port.Ports.class, this.uri("/ports", new Object[0]));
        if (filteringParams != null) {
            for (Map.Entry<String, String> entry : filteringParams.entrySet()) {
                flavorInvocation = flavorInvocation.param(entry.getKey(), entry.getValue());
            }
        }
        return flavorInvocation.execute().getList();
    }

    public Port create(PortCreate port) {
        Preconditions.checkNotNull((Object)port, (Object)"parameter `port` should not be null");
        Preconditions.checkNotNull((Object)port.getNetworkId(), (Object)"parameter `port.networkId` should not be empty");
        return this.post(Port.class, this.uri("/ports", new Object[0])).entity(port).execute();
    }

    public Port get(String portId) {
        Preconditions.checkArgument((!Strings.isNullOrEmpty((String)portId) ? 1 : 0) != 0, (Object)"parameter `portId` should not be empty");
        return this.get(Port.class, this.uri("/ports/%s", portId)).execute();
    }

    public Port update(String portId, PortUpdate portUpdate) {
        Preconditions.checkNotNull((Object)portUpdate, (Object)"parameter `portUpdate` should not be null");
        Preconditions.checkNotNull((Object)portId, (Object)"parameter `portId` should not be empty");
        return this.put(Port.class, this.uri("/ports/%s", portId)).entity(portUpdate).execute();
    }

    public ActionResponse delete(String portId) {
        Preconditions.checkArgument((!Strings.isNullOrEmpty((String)portId) ? 1 : 0) != 0, (Object)"parameter `portId` should not be empty");
        return this.deleteWithResponse(this.uri("/ports/%s", portId)).execute();
    }

    @Override
    protected <R> BaseOpenStackService.Invocation<R> builder(Class<R> returnType, String path, HttpMethod method) {
        BaseOpenStackService.Invocation<R> invocation = super.builder(returnType, path, method);
        Config config = invocation.getRequest().getConfig();
        return invocation.header("Content-Type", CONTENT_JSON).header("X-Language", config.getLanguage());
    }
}

