/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.openstack4j.openstack.vpc.v1.internal;

import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import com.huawei.openstack4j.model.common.ActionResponse;
import com.huawei.openstack4j.openstack.internal.BaseOpenStackService;
import com.huawei.openstack4j.openstack.vpc.v1.domain.PrivateIp;
import com.huawei.openstack4j.openstack.vpc.v1.internal.BaseVirtualPrivateCloudService;
import java.util.List;
import java.util.Map;

public class PrivateIpService
extends BaseVirtualPrivateCloudService {
    public List<? extends PrivateIp> list(String subnetId) {
        return this.list(subnetId, null);
    }

    public List<? extends PrivateIp> list(String subnetId, Map<String, String> filteringParams) {
        BaseOpenStackService.Invocation<PrivateIp.PrivateIps> flavorInvocation = this.get(PrivateIp.PrivateIps.class, this.uri("/subnets/%s/privateips", subnetId));
        if (filteringParams != null) {
            for (Map.Entry<String, String> entry : filteringParams.entrySet()) {
                flavorInvocation = flavorInvocation.param(entry.getKey(), entry.getValue());
            }
        }
        return flavorInvocation.execute().getList();
    }

    public List<? extends PrivateIp> apply(PrivateIp.PrivateIps privateIps) {
        Preconditions.checkNotNull((Object)privateIps, (Object)"parameter `privateips` should not be null");
        for (PrivateIp privateIp : privateIps.getList()) {
            Preconditions.checkNotNull((Object)privateIp.getSubnetId(), (Object)"parameter `subnetId` should not be null");
        }
        return this.post(PrivateIp.PrivateIps.class, this.uri("/privateips", new Object[0])).entity(privateIps).execute().getList();
    }

    public PrivateIp get(String privateIpId) {
        Preconditions.checkArgument((!Strings.isNullOrEmpty((String)privateIpId) ? 1 : 0) != 0, (Object)"parameter `privateIpId` should not be empty");
        return this.get(PrivateIp.class, this.uri("/privateips/%s", privateIpId)).execute();
    }

    public ActionResponse delete(String privateIpId) {
        Preconditions.checkArgument((!Strings.isNullOrEmpty((String)privateIpId) ? 1 : 0) != 0, (Object)"parameter `privateipId` should not be empty");
        return this.deleteWithResponse(this.uri("/privateips/%s", privateIpId)).execute();
    }
}

