/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.openstack4j.openstack.vpc.v1.internal;

import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import com.huawei.openstack4j.model.common.ActionResponse;
import com.huawei.openstack4j.openstack.internal.BaseOpenStackService;
import com.huawei.openstack4j.openstack.vpc.v1.domain.SecurityGroup;
import com.huawei.openstack4j.openstack.vpc.v1.domain.SecurityGroupCreate;
import com.huawei.openstack4j.openstack.vpc.v1.domain.SecurityGroupRule;
import com.huawei.openstack4j.openstack.vpc.v1.internal.BaseVirtualPrivateCloudService;
import java.util.List;
import java.util.Map;

public class SecurityGroupService
extends BaseVirtualPrivateCloudService {
    public List<? extends SecurityGroup> list() {
        return this.list(null);
    }

    public List<? extends SecurityGroup> list(Map<String, String> filteringParams) {
        BaseOpenStackService.Invocation<SecurityGroup.SecurityGroups> securityGroupsInvocation = this.get(SecurityGroup.SecurityGroups.class, this.uri("/security-groups", new Object[0]));
        if (filteringParams != null) {
            for (Map.Entry<String, String> entry : filteringParams.entrySet()) {
                securityGroupsInvocation = securityGroupsInvocation.param(entry.getKey(), entry.getValue());
            }
        }
        return securityGroupsInvocation.execute().getList();
    }

    public SecurityGroup create(SecurityGroupCreate securityGroupCreate) {
        Preconditions.checkNotNull((Object)securityGroupCreate, (Object)"parameter `securityGroupCreate` should not be null");
        Preconditions.checkNotNull((Object)securityGroupCreate.getName(), (Object)"parameter `securityGroup.name should not be empty");
        return this.post(SecurityGroup.class, this.uri("/security-groups", new Object[0])).entity(securityGroupCreate).execute();
    }

    public SecurityGroup get(String securityGroupId) {
        Preconditions.checkArgument((!Strings.isNullOrEmpty((String)securityGroupId) ? 1 : 0) != 0, (Object)"parameter `securityGroupId` should not be empty");
        return this.get(SecurityGroup.class, this.uri("/security-groups/%s", securityGroupId)).execute();
    }

    public ActionResponse delete(String securityGroupId) {
        Preconditions.checkArgument((!Strings.isNullOrEmpty((String)securityGroupId) ? 1 : 0) != 0, (Object)"parameter `securityGroupId` should not be empty");
        return this.deleteWithResponse(this.uri("/security-groups/%s", securityGroupId)).execute();
    }

    public SecurityGroupRule createSecurityGroupRule(SecurityGroupRule securityGroupRuleCreate) {
        Preconditions.checkNotNull((Object)securityGroupRuleCreate, (Object)"parameter `securityGroupRuleCreate` should not be null");
        Preconditions.checkNotNull((Object)securityGroupRuleCreate.getSecurityGroupId(), (Object)"parameter `SecurityGroupId` should not be null");
        Preconditions.checkNotNull((Object)securityGroupRuleCreate.getDirection(), (Object)"parameter `Direction` should not be empty");
        return this.post(SecurityGroupRule.class, this.uri("/security-group-rules", new Object[0])).entity(securityGroupRuleCreate).execute();
    }

    public SecurityGroupRule getSecurityGroupRule(String securityGroupRuleId) {
        Preconditions.checkArgument((!Strings.isNullOrEmpty((String)securityGroupRuleId) ? 1 : 0) != 0, (Object)"parameter `securityGroupRuleId` should not be empty");
        return this.get(SecurityGroupRule.class, this.uri("/security-group-rules/%s", securityGroupRuleId)).execute();
    }

    public List<? extends SecurityGroupRule> listSecurityGroupRules(Map<String, String> filteringParams) {
        BaseOpenStackService.Invocation<SecurityGroupRule.SecurityGroupRules> securityGroupRulesInvocation = this.get(SecurityGroupRule.SecurityGroupRules.class, this.uri("/security-group-rules", new Object[0]));
        if (filteringParams != null) {
            for (Map.Entry<String, String> entry : filteringParams.entrySet()) {
                securityGroupRulesInvocation = securityGroupRulesInvocation.param(entry.getKey(), entry.getValue());
            }
        }
        return securityGroupRulesInvocation.execute().getList();
    }

    public List<? extends SecurityGroupRule> listSecurityGroupRules() {
        return this.listSecurityGroupRules(null);
    }

    public ActionResponse deleteSecurityGroupRule(String securityGroupRuleId) {
        Preconditions.checkArgument((!Strings.isNullOrEmpty((String)securityGroupRuleId) ? 1 : 0) != 0, (Object)"parameter `securityGroupRuleId` should not be empty");
        return this.deleteWithResponse(this.uri("/security-group-rules/%s", securityGroupRuleId)).execute();
    }
}

