/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.openstack4j.openstack.vpc.v2.domain;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonRootName;
import com.huawei.openstack4j.model.ModelEntity;
import com.huawei.openstack4j.openstack.common.ListResult;
import com.huawei.openstack4j.openstack.vpc.v2.contants.RouteType;
import java.beans.ConstructorProperties;
import java.util.List;

@JsonRootName(value="route")
public class Route
implements ModelEntity {
    private static final long serialVersionUID = 6908131351845573231L;
    private String id;
    private String destination;
    private String nexthop;
    private RouteType type;
    @JsonProperty(value="vpc_id")
    private String vpcId;
    @JsonProperty(value="tenant_id")
    private String tenantId;

    public static RouteBuilder builder() {
        return new RouteBuilder();
    }

    public String getId() {
        return this.id;
    }

    public String getDestination() {
        return this.destination;
    }

    public String getNexthop() {
        return this.nexthop;
    }

    public RouteType getType() {
        return this.type;
    }

    public String getVpcId() {
        return this.vpcId;
    }

    public String getTenantId() {
        return this.tenantId;
    }

    public String toString() {
        return "Route(id=" + this.getId() + ", destination=" + this.getDestination() + ", nexthop=" + this.getNexthop() + ", type=" + (Object)((Object)this.getType()) + ", vpcId=" + this.getVpcId() + ", tenantId=" + this.getTenantId() + ")";
    }

    public Route() {
    }

    @ConstructorProperties(value={"id", "destination", "nexthop", "type", "vpcId", "tenantId"})
    public Route(String id, String destination, String nexthop, RouteType type, String vpcId, String tenantId) {
        this.id = id;
        this.destination = destination;
        this.nexthop = nexthop;
        this.type = type;
        this.vpcId = vpcId;
        this.tenantId = tenantId;
    }

    public static class RouteBuilder {
        private String id;
        private String destination;
        private String nexthop;
        private RouteType type;
        private String vpcId;
        private String tenantId;

        RouteBuilder() {
        }

        public RouteBuilder id(String id) {
            this.id = id;
            return this;
        }

        public RouteBuilder destination(String destination) {
            this.destination = destination;
            return this;
        }

        public RouteBuilder nexthop(String nexthop) {
            this.nexthop = nexthop;
            return this;
        }

        public RouteBuilder type(RouteType type) {
            this.type = type;
            return this;
        }

        public RouteBuilder vpcId(String vpcId) {
            this.vpcId = vpcId;
            return this;
        }

        public RouteBuilder tenantId(String tenantId) {
            this.tenantId = tenantId;
            return this;
        }

        public Route build() {
            return new Route(this.id, this.destination, this.nexthop, this.type, this.vpcId, this.tenantId);
        }

        public String toString() {
            return "Route.RouteBuilder(id=" + this.id + ", destination=" + this.destination + ", nexthop=" + this.nexthop + ", type=" + (Object)((Object)this.type) + ", vpcId=" + this.vpcId + ", tenantId=" + this.tenantId + ")";
        }
    }

    public static class Routes
    extends ListResult<Route> {
        private static final long serialVersionUID = -3982425518245263388L;
        @JsonProperty(value="routes")
        private List<Route> Routes;

        @Override
        protected List<Route> value() {
            return this.Routes;
        }
    }
}

