/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.openstack4j.openstack.vpc.v2.internal;

import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import com.huawei.openstack4j.model.common.ActionResponse;
import com.huawei.openstack4j.openstack.compute.functions.ToActionResponseFunction;
import com.huawei.openstack4j.openstack.vpc.v2.domain.AsyncBandWidthRespEntity;
import com.huawei.openstack4j.openstack.vpc.v2.domain.BandwidthBatchCreate;
import com.huawei.openstack4j.openstack.vpc.v2.domain.BandwidthCreate;
import com.huawei.openstack4j.openstack.vpc.v2.domain.BandwidthInsert;
import com.huawei.openstack4j.openstack.vpc.v2.domain.BandwidthRemove;
import com.huawei.openstack4j.openstack.vpc.v2.domain.BandwidthResp;
import com.huawei.openstack4j.openstack.vpc.v2.domain.PublicIpInfo;
import com.huawei.openstack4j.openstack.vpc.v2.domain.VirtualBandWidths;
import com.huawei.openstack4j.openstack.vpc.v2.internal.BaseVirtualPrivateCloudService;
import java.util.List;

public class BandWidthService
extends BaseVirtualPrivateCloudService {
    public AsyncBandWidthRespEntity update(VirtualBandWidths bandWidth, String bandwidthId) {
        Preconditions.checkArgument((null != bandWidth.getBandwidth() ? 1 : 0) != 0, (Object)"parameter `bandwidth` should not be empty");
        return this.put(AsyncBandWidthRespEntity.class, "/bandwidths/" + bandwidthId).entity(bandWidth).execute();
    }

    public BandwidthResp create(BandwidthCreate bandwidthCreate) {
        Preconditions.checkArgument((null != bandwidthCreate ? 1 : 0) != 0, (Object)"parameter `bandwidthCreate` should not be empty");
        Preconditions.checkArgument((!Strings.isNullOrEmpty((String)bandwidthCreate.getName()) ? 1 : 0) != 0, (Object)"parameter `bandwidthCreate.name` should not be empty");
        Preconditions.checkArgument((null != bandwidthCreate.getSize() ? 1 : 0) != 0, (Object)"parameter `bandwidthCreate.size` should not be empty");
        return this.post(BandwidthResp.class, this.uri("/bandwidths", new Object[0])).entity(bandwidthCreate).execute();
    }

    public List<BandwidthResp> batchCreate(BandwidthBatchCreate bandwidthBatchCreate) {
        Preconditions.checkArgument((null != bandwidthBatchCreate ? 1 : 0) != 0, (Object)"parameter `bandwidthBatchCreate` should not be empty");
        Preconditions.checkArgument((!Strings.isNullOrEmpty((String)bandwidthBatchCreate.getName()) ? 1 : 0) != 0, (Object)"parameter `bandwidthBatchCreate.name` should not be empty");
        Preconditions.checkArgument((null != bandwidthBatchCreate.getSize() ? 1 : 0) != 0, (Object)"parameter `bandwidthBatchCreate.size` should not be empty");
        Preconditions.checkArgument((null != bandwidthBatchCreate.getCount() ? 1 : 0) != 0, (Object)"parameter `bandwidthBatchCreate.count` should not be empty");
        return this.post(BandwidthResp.BandwidthResps.class, this.uri("/batch-bandwidths", new Object[0])).entity(bandwidthBatchCreate).execute().getList();
    }

    public ActionResponse delete(String bandwidthId) {
        Preconditions.checkArgument((!Strings.isNullOrEmpty((String)bandwidthId) ? 1 : 0) != 0, (Object)"parameter `bandwidthId` should not be empty");
        return ToActionResponseFunction.INSTANCE.apply(this.delete(Void.class, this.uri("/bandwidths/%s", bandwidthId)).executeWithResponse());
    }

    public BandwidthResp insert(String bandwidthId, BandwidthInsert bandwidthInsert) {
        Preconditions.checkArgument((!Strings.isNullOrEmpty((String)bandwidthId) ? 1 : 0) != 0, (Object)"parameter `bandwidthId` should not be empty");
        Preconditions.checkArgument((null != bandwidthInsert ? 1 : 0) != 0, (Object)"parameter `bandwidthInsert` should not be empty");
        for (PublicIpInfo publicIpInfo : bandwidthInsert.getPublicipInfo()) {
            Preconditions.checkArgument((!Strings.isNullOrEmpty((String)publicIpInfo.getPublicipId()) ? 1 : 0) != 0, (Object)"parameter `publicIpInfo.publicipId` should not be empty");
        }
        return this.post(BandwidthResp.class, this.uri("/bandwidths/%s/insert", bandwidthId)).entity(bandwidthInsert).execute();
    }

    public ActionResponse remove(String bandwidthId, BandwidthRemove bandwidthRemove) {
        Preconditions.checkArgument((!Strings.isNullOrEmpty((String)bandwidthId) ? 1 : 0) != 0, (Object)"parameter `bandwidthId` should not be empty");
        Preconditions.checkArgument((null != bandwidthRemove ? 1 : 0) != 0, (Object)"parameter `bandwidthRemove` should not be empty");
        Preconditions.checkArgument((null != bandwidthRemove.getSize() ? 1 : 0) != 0, (Object)"parameter `bandwidthRemove.size` should not be empty");
        Preconditions.checkArgument((null != bandwidthRemove.getChargeMode() ? 1 : 0) != 0, (Object)"parameter `bandwidthRemove.chargeMode` should not be empty");
        Preconditions.checkArgument((null != bandwidthRemove.getPublicipInfo() ? 1 : 0) != 0, (Object)"parameter `bandwidthRemove.publicipInfo` should not be empty");
        for (PublicIpInfo publicIpInfo : bandwidthRemove.getPublicipInfo()) {
            Preconditions.checkArgument((!Strings.isNullOrEmpty((String)publicIpInfo.getPublicipId()) ? 1 : 0) != 0, (Object)"parameter `publicIpInfo.publicipId` should not be empty");
        }
        return ToActionResponseFunction.INSTANCE.apply(this.post(Void.class, this.uri("/bandwidths/%s/remove", bandwidthId)).entity(bandwidthRemove).executeWithResponse());
    }
}

