/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.openstack4j.openstack.vpc.v2.internal;

import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import com.huawei.openstack4j.api.types.ServiceType;
import com.huawei.openstack4j.model.common.ActionResponse;
import com.huawei.openstack4j.openstack.common.functions.RemoveProjectIdFromURL;
import com.huawei.openstack4j.openstack.compute.functions.ToActionResponseFunction;
import com.huawei.openstack4j.openstack.internal.BaseOpenStackService;
import com.huawei.openstack4j.openstack.vpc.v2.domain.Peering;
import com.huawei.openstack4j.openstack.vpc.v2.domain.PeeringCreate;
import com.huawei.openstack4j.openstack.vpc.v2.domain.PeeringRequest;
import com.huawei.openstack4j.openstack.vpc.v2.domain.PeeringUpdate;
import java.util.List;
import java.util.Map;

public class PeeringService
extends BaseOpenStackService {
    public PeeringService() {
        super(ServiceType.VPC2, RemoveProjectIdFromURL.INSTANCE);
    }

    public List<Peering> list() {
        return this.list(null);
    }

    public List<Peering> list(Map<String, String> filteringParams) {
        BaseOpenStackService.Invocation<Peering.Peerings> req = this.get(Peering.Peerings.class, this.uri("/vpc/peerings", new Object[0]));
        if (filteringParams != null) {
            for (Map.Entry<String, String> entry : filteringParams.entrySet()) {
                req = req.param(entry.getKey(), entry.getValue());
            }
        }
        return req.execute().getList();
    }

    public Peering get(String peeringId) {
        Preconditions.checkArgument((!Strings.isNullOrEmpty((String)peeringId) ? 1 : 0) != 0, (Object)"parameter `peeringId` should not be empty");
        return this.get(Peering.class, this.uri("/vpc/peerings/%s", peeringId)).execute();
    }

    public Peering create(PeeringCreate peeringCreate) {
        Preconditions.checkArgument((peeringCreate != null ? 1 : 0) != 0, (Object)"parameter `peeringCreate` should not be empty");
        Preconditions.checkArgument((!Strings.isNullOrEmpty((String)peeringCreate.getName()) ? 1 : 0) != 0, (Object)"parameter `name` should not be empty");
        Preconditions.checkArgument((!Strings.isNullOrEmpty((String)peeringCreate.getRequestVpcInfo().getVpcId()) ? 1 : 0) != 0, (Object)"parameter `requestVpcInfo.vpcId` should not be empty");
        Preconditions.checkArgument((!Strings.isNullOrEmpty((String)peeringCreate.getAcceptVpcInfo().getVpcId()) ? 1 : 0) != 0, (Object)"parameter `acceptVpcInfo.vpcId` should not be empty");
        return this.post(Peering.class, this.uri("/vpc/peerings", new Object[0])).entity(peeringCreate).execute();
    }

    public PeeringRequest accept(String peeringId) {
        Preconditions.checkArgument((!Strings.isNullOrEmpty((String)peeringId) ? 1 : 0) != 0, (Object)"parameter `peeringId` should not be empty");
        return this.put(PeeringRequest.class, this.uri("/vpc/peerings/%s/accept", peeringId)).execute();
    }

    public PeeringRequest reject(String peeringId) {
        Preconditions.checkArgument((!Strings.isNullOrEmpty((String)peeringId) ? 1 : 0) != 0, (Object)"parameter `peeringId` should not be empty");
        return this.put(PeeringRequest.class, this.uri("/vpc/peerings/%s/reject", peeringId)).execute();
    }

    public Peering update(String peeringId, PeeringUpdate peeringUpdate) {
        Preconditions.checkArgument((!Strings.isNullOrEmpty((String)peeringId) ? 1 : 0) != 0, (Object)"parameter `peeringId` should not be empty");
        Preconditions.checkArgument((!Strings.isNullOrEmpty((String)peeringUpdate.getName()) ? 1 : 0) != 0, (Object)"parameter `peeringUpdate.name` should not be empty");
        return this.put(Peering.class, this.uri("/vpc/peerings/%s", peeringId)).entity(peeringUpdate).execute();
    }

    public ActionResponse delete(String peeringId) {
        Preconditions.checkArgument((!Strings.isNullOrEmpty((String)peeringId) ? 1 : 0) != 0, (Object)"parameter `peeringId` should not be empty");
        return ToActionResponseFunction.INSTANCE.apply(this.delete(Void.class, this.uri("/vpc/peerings/%s", peeringId)).executeWithResponse());
    }
}

