/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.openstack4j.utils;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonRootName;
import com.huawei.openstack4j.core.transport.HttpMethod;
import com.huawei.openstack4j.core.transport.HttpRequest;
import com.huawei.openstack4j.core.transport.HttpResponse;
import com.huawei.openstack4j.core.transport.ObjectMapperSingleton;
import com.huawei.openstack4j.core.transport.internal.HttpExecutor;
import java.util.HashMap;

public class ECSMetadataUtils {
    private static final String OPENSTACK_METADATA_ROOT = "/openstack/latest";
    private static final String EC2_METADATA_ROOT = "/latest/meta-data";
    private static final String ECS_METADATA_SERIVCE_URL = "http://169.254.169.254";
    private static final String EC2_METADATA_SERVICE_OVERRIDE_URL = "ecsMetadataServiceOverrideEndpoint";

    public static SecurityKey getSecurityKey() {
        String securityKeyInfo = ECSMetadataUtils.getResource(String.class, "/openstack/latest/securitykey");
        return ECSMetadataUtils.jsonToObject(securityKeyInfo, SecurityKey.class);
    }

    public static String getInstanceType() {
        return ECSMetadataUtils.getResource(String.class, "/latest/meta-data/instance-type");
    }

    public static String getEndpointForECSMetadataService() {
        String overridUrl = System.getProperty(EC2_METADATA_SERVICE_OVERRIDE_URL);
        return overridUrl != null ? overridUrl : ECS_METADATA_SERIVCE_URL;
    }

    private static <T> T getResource(Class<T> returnType, String path) {
        String endpoint = ECSMetadataUtils.getEndpointForECSMetadataService();
        HashMap<String, String> headers = new HashMap<String, String>();
        headers.put("Accept", "*/*");
        HttpRequest<T> build = HttpRequest.builder(returnType).method(HttpMethod.GET).headers(headers).endpoint(endpoint).path(path).build();
        HttpResponse res = HttpExecutor.create().execute(build);
        return res.getEntity(returnType);
    }

    public static <T> T jsonToObject(String json, Class<T> clazz) {
        try {
            return (T)ObjectMapperSingleton.getContext(clazz).readValue(json, clazz);
        }
        catch (Exception e) {
            throw new RuntimeException("Unable to parse Json String.", e);
        }
    }

    @JsonRootName(value="credential")
    public static class SecurityKey {
        public String access;
        public String secret;
        @JsonProperty(value="securitytoken")
        public String securityToken;
        @JsonProperty(value="expires_at")
        public String expiresAt;
    }
}

