/*
 * Decompiled with CFR 0.152.
 */
package com.mayabot.nlp.segment;

import com.google.common.collect.Lists;
import com.mayabot.nlp.segment.LexerReader;
import com.mayabot.nlp.segment.Sentence;
import com.mayabot.nlp.segment.WordTerm;
import java.util.ArrayList;
import java.util.function.Consumer;

public interface Lexer {
    public void scan(char[] var1, Consumer<WordTerm> var2);

    default public void scan(String text, Consumer<WordTerm> consumer) {
        this.scan(text.toCharArray(), consumer);
    }

    default public Sentence scan(String text) {
        if (text == null || text.isEmpty()) {
            return Sentence.of();
        }
        ArrayList target = Lists.newArrayListWithExpectedSize((int)Math.min(text.length() / 2, 4));
        this.scan(text.toCharArray(), target::add);
        return Sentence.of(target);
    }

    default public LexerReader reader() {
        return LexerReader.from(this);
    }

    default public LexerReader filterReader(boolean punctuation, boolean stopWord) {
        return LexerReader.filter(this, punctuation, stopWord);
    }
}

