/*
 * Decompiled with CFR 0.152.
 */
package com.mayabot.nlp.segment;

import com.mayabot.nlp.segment.Nature;
import com.mayabot.nlp.segment.WordAndNature;
import java.io.Serializable;
import java.util.List;

public final class WordTerm
implements Serializable,
WordAndNature {
    static final long serialVersionUID = 1L;
    public final String word;
    private Nature nature;
    public int offset;
    private int posInc = 1;
    private List<WordTerm> subword;
    private String customFlag;

    public WordTerm(String word) {
        this.word = word;
    }

    public WordTerm(String word, Nature nature) {
        this.word = word;
        this.nature = nature;
    }

    public WordTerm(String word, Nature nature, int offset) {
        this.word = word;
        this.nature = nature;
        this.offset = offset;
    }

    public Nature getNature() {
        return this.nature;
    }

    public String getNatureString() {
        if (this.nature == null) {
            return "";
        }
        return this.nature.name();
    }

    public void setNature(Nature nature) {
        this.nature = nature;
    }

    public int getOffset() {
        return this.offset;
    }

    public List<WordTerm> getSubword() {
        return this.subword;
    }

    public boolean hasSubword() {
        return this.subword != null && !this.subword.isEmpty();
    }

    @Override
    public String getWord() {
        return this.word;
    }

    @Override
    public String getNatureName() {
        return this.getNatureString();
    }

    public void setOffset(int offset) {
        this.offset = offset;
    }

    public void setSubword(List<WordTerm> subword) {
        this.subword = subword;
    }

    public String getCustomFlag() {
        return this.customFlag;
    }

    public void setCustomFlag(String customFlag) {
        this.customFlag = customFlag;
    }

    public int length() {
        return this.word.length();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        if (this.nature == null) {
            sb.append(this.word);
        } else {
            sb.append(this.word).append("/").append((Object)this.nature);
        }
        if (this.subword != null) {
            sb.append(this.subword);
        }
        return sb.toString();
    }

    public int getPosInc() {
        return this.posInc;
    }

    public WordTerm setPosInc(int posInc) {
        this.posInc = posInc;
        return this;
    }
}

