/*
 * Decompiled with CFR 0.152.
 */
package com.mayabot.nlp.segment.lexer.core;

import com.google.common.base.CharMatcher;
import com.google.common.base.Charsets;
import com.google.common.base.Splitter;
import com.google.common.hash.Hasher;
import com.google.common.hash.Hashing;
import com.mayabot.nlp.MynlpEnv;
import com.mayabot.nlp.collection.dat.DoubleArrayTrieStringIntMap;
import com.mayabot.nlp.injector.Singleton;
import com.mayabot.nlp.logging.InternalLogger;
import com.mayabot.nlp.logging.InternalLoggerFactory;
import com.mayabot.nlp.resources.NlpResource;
import com.mayabot.nlp.resources.UseLines;
import com.mayabot.nlp.segment.lexer.core.BaseNlpResourceExternalizable;
import com.mayabot.nlp.segment.lexer.core.CoreDictPatch;
import com.mayabot.nlp.segment.lexer.core.CoreDictPathWrap;
import com.mayabot.nlp.segment.lexer.core.CoreDictionary;
import com.mayabot.nlp.segment.lexer.core.DictionaryAbsWords;
import com.mayabot.nlp.utils.CharSourceLineReader;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.List;
import java.util.TreeMap;
import kotlin.Pair;
import org.jetbrains.annotations.Nullable;

@Singleton
public class CoreDictionaryImpl
extends BaseNlpResourceExternalizable
implements CoreDictionary {
    private final MynlpEnv env;
    private InternalLogger logger = InternalLoggerFactory.getInstance(CoreDictionaryImpl.class);
    private final String path = "core-dict/CoreDict.txt";
    private int totalFreq;
    private DoubleArrayTrieStringIntMap trie;
    @Nullable
    private CoreDictPatch coreDictPatch;

    public CoreDictionaryImpl(MynlpEnv env, CoreDictPathWrap coreDictPathWrap) throws Exception {
        super(env);
        this.env = env;
        this.coreDictPatch = coreDictPathWrap.getCoreDictPatch();
        this.restore();
    }

    @Override
    public void refresh() throws Exception {
        this.restore();
    }

    @Override
    public int totalFreq() {
        return this.totalFreq;
    }

    @Override
    public void loadFromSource() throws Exception {
        NlpResource dictResource = this.env.loadResource("core-dict/CoreDict.txt");
        if (dictResource == null) {
            throw new RuntimeException("Not Found dict resource core-dict/CoreDict.txt");
        }
        TreeMap<Object, Object> map = new TreeMap<Object, Object>();
        int maxFreq = 0;
        Splitter splitter = Splitter.on((CharMatcher)CharMatcher.breakingWhitespace()).omitEmptyStrings().trimResults();
        CharSourceLineReader reader = UseLines.lineReader((InputStream)dictResource.inputStream());
        Object object = null;
        try {
            while (reader.hasNext()) {
                String string = (String)reader.next();
                List param = splitter.splitToList((CharSequence)string);
                if (param.size() != 2) continue;
                Integer count = Integer.valueOf((String)param.get(1));
                map.put(param.get(0), count);
                maxFreq += count.intValue();
            }
        }
        catch (Throwable throwable) {
            object = throwable;
            throw throwable;
        }
        finally {
            if (reader != null) {
                if (object != null) {
                    try {
                        reader.close();
                    }
                    catch (Throwable throwable) {
                        ((Throwable)object).addSuppressed(throwable);
                    }
                } else {
                    reader.close();
                }
            }
        }
        if (this.coreDictPatch != null) {
            List<String> deleted;
            List<Pair<String, Integer>> list = this.coreDictPatch.addDict();
            if (list != null) {
                for (Pair pair : list) {
                    map.put(pair.getFirst(), pair.getSecond());
                }
            }
            if ((deleted = this.coreDictPatch.deleteDict()) != null) {
                for (String word : deleted) {
                    map.remove(word);
                }
            }
        }
        this.totalFreq = maxFreq;
        for (String label : DictionaryAbsWords.allLabel()) {
            if (map.containsKey(label)) continue;
            map.put(label, 1);
        }
        if (map.isEmpty()) {
            throw new RuntimeException("not found core dict file ");
        }
        this.trie = new DoubleArrayTrieStringIntMap(map);
    }

    @Override
    public String sourceVersion() {
        String version = this.env.hashResource("core-dict/CoreDict.txt");
        if (version == null) {
            version = "";
        }
        Hasher hasher = Hashing.murmur3_32().newHasher().putString((CharSequence)version, Charsets.UTF_8).putString((CharSequence)"v2", Charsets.UTF_8);
        if (this.coreDictPatch != null) {
            hasher.putString((CharSequence)this.coreDictPatch.dictVersion(), Charsets.UTF_8);
        }
        return hasher.hash().toString();
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeInt(this.totalFreq);
        this.trie.save((DataOutput)out);
        out.flush();
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException {
        this.totalFreq = in.readInt();
        this.trie = new DoubleArrayTrieStringIntMap((DataInput)in);
    }

    public int wordFreq(String key) {
        int c = this.trie.get((CharSequence)key);
        if (c == -1) {
            c = 0;
        }
        return c;
    }

    public int wordFreq(int wordID) {
        return this.trie.get(wordID);
    }

    public int wordId(CharSequence key) {
        return this.trie.indexOf(key);
    }

    public int wordId(CharSequence key, int pos, int len, int nodePos) {
        return this.trie.indexOf(key, pos, len, nodePos);
    }

    public int wordId(char[] chars, int pos, int len) {
        return this.trie.indexOf(chars, pos, len);
    }

    public int wordId(char[] keyChars, int pos, int len, int nodePos) {
        return this.trie.indexOf(keyChars, pos, len, nodePos);
    }

    public boolean contains(String key) {
        return this.trie.indexOf((CharSequence)key) >= 0;
    }

    public int getWordID(String word) {
        return this.trie.indexOf((CharSequence)word);
    }

    @Override
    public DoubleArrayTrieStringIntMap.DATMapMatcherInt match(char[] text, int offset) {
        return this.trie.match(text, offset);
    }

    public int size() {
        return this.trie.size();
    }
}

