/*
 * Decompiled with CFR 0.152.
 */
package com.mayabot.nlp.segment.plugins.pattern;

import com.mayabot.nlp.segment.Nature;
import com.mayabot.nlp.segment.WordpathProcessor;
import com.mayabot.nlp.segment.common.BaseSegmentComponent;
import com.mayabot.nlp.segment.wordnet.Vertex;
import com.mayabot.nlp.segment.wordnet.Wordnet;
import com.mayabot.nlp.segment.wordnet.Wordpath;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jetbrains.annotations.NotNull;

public class PatternWordpathProcessor
extends BaseSegmentComponent
implements WordpathProcessor {
    private Pattern pattern;

    public PatternWordpathProcessor(@NotNull Pattern pattern) {
        super(-500);
        this.pattern = pattern;
    }

    @Override
    public Wordpath process(Wordpath wordPath) {
        Wordnet wordnet = wordPath.getWordnet();
        Matcher matcher = this.pattern.matcher(wordnet);
        while (matcher.find()) {
            int len;
            int start = matcher.start();
            if (wordPath.willCutOtherWords(start, len = matcher.end() - start)) continue;
            Vertex vertex = wordPath.combine(start, len);
            vertex.setAbsWordNatureAndFreq(Nature.x);
        }
        return wordPath;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PatternWordpathProcessor that = (PatternWordpathProcessor)o;
        return this.pattern.equals(that.pattern);
    }

    public int hashCode() {
        return this.pattern.hashCode();
    }
}

