/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.spectator.aws;

import com.amazonaws.metrics.MetricCollector;
import com.amazonaws.metrics.RequestMetricCollector;
import com.amazonaws.metrics.ServiceMetricCollector;
import com.netflix.spectator.api.Registry;
import com.netflix.spectator.aws.SpectatorRequestMetricCollector;
import com.netflix.spectator.impl.Preconditions;

public class SpectatorMetricCollector
extends MetricCollector {
    private final RequestMetricCollector requestMetricCollector;

    public SpectatorMetricCollector(Registry registry) {
        Preconditions.checkNotNull((Object)registry, (String)"registry");
        this.requestMetricCollector = new SpectatorRequestMetricCollector(registry);
    }

    public boolean start() {
        return true;
    }

    public boolean stop() {
        return true;
    }

    public boolean isEnabled() {
        return Boolean.valueOf(System.getProperty("spectator.ext.aws.enabled", "true"));
    }

    public RequestMetricCollector getRequestMetricCollector() {
        return this.requestMetricCollector;
    }

    public ServiceMetricCollector getServiceMetricCollector() {
        return ServiceMetricCollector.NONE;
    }
}

