/*
 * Decompiled with CFR 0.152.
 */
package com.networknt.handler;

import com.networknt.config.Config;
import com.networknt.handler.config.HandlerConfig;
import com.networknt.httpstring.AttachmentConstants;
import com.networknt.status.Status;
import io.undertow.server.HttpHandler;
import io.undertow.server.HttpServerExchange;
import io.undertow.util.Headers;
import java.util.Arrays;
import java.util.HashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public interface LightHttpHandler
extends HttpHandler {
    public static final Logger logger = LoggerFactory.getLogger(LightHttpHandler.class);
    public static final String ERROR_NOT_DEFINED = "ERR10042";
    public static final String CONFIG_NAME = "handler";
    public static final String AUDIT_ON_ERROR = "auditOnError";
    public static final String AUDIT_STACK_TRACE = "auditStackTrace";
    public static final HandlerConfig config = (HandlerConfig)Config.getInstance().getJsonObjectConfig("handler", HandlerConfig.class);
    public static final boolean auditOnError = config != null ? config.getAuditOnError() : false;
    public static final boolean auditStackTrace = config != null ? config.getAuditStackTrace() : false;

    default public void setExchangeStatus(HttpServerExchange exchange, String code, Object ... args) {
        Status status = new Status(code, args);
        if (status.getStatusCode() == 0) {
            status = new Status(ERROR_NOT_DEFINED, new Object[]{code});
        }
        exchange.setStatusCode(status.getStatusCode());
        exchange.getResponseHeaders().put(Headers.CONTENT_TYPE, "application/json");
        status.setDescription(status.getDescription().replaceAll("\\\\", "\\\\\\\\"));
        exchange.getResponseSender().send(status.toString());
        Object[] elements = Thread.currentThread().getStackTrace();
        logger.error(status.toString() + " at " + elements[2].getClassName() + "." + elements[2].getMethodName() + "(" + elements[2].getFileName() + ":" + elements[2].getLineNumber() + ")");
        HashMap<String, Status> auditInfo = (HashMap<String, Status>)exchange.getAttachment(AttachmentConstants.AUDIT_INFO);
        if (auditInfo == null) {
            auditInfo = new HashMap<String, Status>();
            exchange.putAttachment(AttachmentConstants.AUDIT_INFO, auditInfo);
        }
        if (auditOnError) {
            auditInfo.put("Status", status);
        }
        if (auditStackTrace) {
            auditInfo.put("StackTrace", (Status)Arrays.toString(elements));
        }
    }

    default public void setExchangeStatus(HttpServerExchange exchange, Status status) {
        exchange.setStatusCode(status.getStatusCode());
        exchange.getResponseHeaders().put(Headers.CONTENT_TYPE, "application/json");
        status.setDescription(status.getDescription().replaceAll("\\\\", "\\\\\\\\"));
        exchange.getResponseSender().send(status.toString());
        StackTraceElement[] elements = Thread.currentThread().getStackTrace();
        logger.error(status.toString() + " at " + elements[2].getClassName() + "." + elements[2].getMethodName() + "(" + elements[2].getFileName() + ":" + elements[2].getLineNumber() + ")");
    }
}

