/*
 * Decompiled with CFR 0.152.
 */
package com.weibo.api.motan.cluster.loadbalance;

import com.weibo.api.motan.cluster.loadbalance.AbstractLoadBalance;
import com.weibo.api.motan.core.extension.SpiMeta;
import com.weibo.api.motan.rpc.Referer;
import com.weibo.api.motan.rpc.Request;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;

@SpiMeta(name="consistent")
public class ConsistentHashLoadBalance<T>
extends AbstractLoadBalance<T> {
    private List<Referer<T>> consistentHashReferers;

    @Override
    public void onRefresh(List<Referer<T>> referers) {
        super.onRefresh(referers);
        ArrayList<Referer<T>> copyReferers = new ArrayList<Referer<T>>(referers);
        ArrayList<Referer<T>> tempRefers = new ArrayList<Referer<T>>();
        for (int i = 0; i < 1000; ++i) {
            Collections.shuffle(copyReferers);
            for (Referer referer : copyReferers) {
                tempRefers.add(referer);
            }
        }
        this.consistentHashReferers = tempRefers;
    }

    @Override
    protected Referer<T> doSelect(Request request) {
        int hash = this.getHash(request);
        for (int i = 0; i < this.getReferers().size(); ++i) {
            Referer<T> ref = this.consistentHashReferers.get((hash + i) % this.consistentHashReferers.size());
            if (!ref.isAvailable()) continue;
            return ref;
        }
        return null;
    }

    @Override
    protected void doSelectToHolder(Request request, List<Referer<T>> refersHolder) {
        List referers = this.getReferers();
        int hash = this.getHash(request);
        for (int i = 0; i < referers.size(); ++i) {
            Referer<T> ref = this.consistentHashReferers.get((hash + i) % this.consistentHashReferers.size());
            if (!ref.isAvailable()) continue;
            refersHolder.add(ref);
        }
    }

    private int getHash(Request request) {
        if (request.getArguments() == null || request.getArguments().length == 0) {
            return request.hashCode();
        }
        return Arrays.hashCode(request.getArguments());
    }
}

