
package io.fabric8.kubernetes.api.model;

import java.util.HashMap;
import java.util.Map;
import javax.annotation.Generated;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import io.fabric8.kubernetes.api.model.Container;
import io.fabric8.kubernetes.api.model.Doneable;
import io.fabric8.kubernetes.api.model.IntOrString;
import io.fabric8.kubernetes.api.model.LabelSelector;
import io.fabric8.kubernetes.api.model.LocalObjectReference;
import io.fabric8.kubernetes.api.model.ObjectReference;
import io.fabric8.kubernetes.api.model.PersistentVolumeClaim;
import io.fabric8.kubernetes.api.model.PodTemplateSpec;
import io.fabric8.kubernetes.api.model.ResourceRequirements;
import io.fabric8.kubernetes.api.model.admission.AdmissionRequest;
import io.fabric8.kubernetes.api.model.admission.AdmissionResponse;
import io.fabric8.kubernetes.api.model.admission.AdmissionReview;
import io.fabric8.kubernetes.api.model.admissionregistration.MutatingWebhookConfiguration;
import io.fabric8.kubernetes.api.model.admissionregistration.MutatingWebhookConfigurationList;
import io.fabric8.kubernetes.api.model.admissionregistration.Rule;
import io.fabric8.kubernetes.api.model.admissionregistration.RuleWithOperations;
import io.fabric8.kubernetes.api.model.admissionregistration.ServiceReference;
import io.fabric8.kubernetes.api.model.admissionregistration.ValidatingWebhookConfiguration;
import io.fabric8.kubernetes.api.model.admissionregistration.ValidatingWebhookConfigurationList;
import io.fabric8.kubernetes.api.model.authentication.TokenReview;
import io.fabric8.kubernetes.api.model.authorization.LocalSubjectAccessReview;
import io.fabric8.kubernetes.api.model.authorization.SelfSubjectAccessReview;
import io.fabric8.kubernetes.api.model.authorization.SelfSubjectRulesReview;
import io.fabric8.kubernetes.api.model.authorization.SubjectAccessReview;
import io.fabric8.kubernetes.api.model.version.Info;
import io.sundr.builder.annotations.Buildable;
import io.sundr.builder.annotations.BuildableReference;
import io.sundr.builder.annotations.Inline;
import lombok.EqualsAndHashCode;
import lombok.ToString;

@JsonInclude(JsonInclude.Include.NON_NULL)
@Generated("org.jsonschema2pojo")
@JsonPropertyOrder({
    "apiVersion",
    "kind",
    "metadata",
    "APIGroup",
    "APIGroupList",
    "AdmissionRequest",
    "AdmissionResponse",
    "AdmissionReview",
    "BaseKubernetesList",
    "CreateOptions",
    "DeleteOptions",
    "GetOptions",
    "Info",
    "K8sLocalSubjectAccessReview",
    "K8sSubjectAccessReview",
    "ListOptions",
    "MutatingWebhookConfiguration",
    "MutatingWebhookConfigurationList",
    "ObjectMeta",
    "Operation",
    "Patch",
    "PatchOptions",
    "PatchType",
    "Quantity",
    "RootPaths",
    "Rule",
    "RuleWithOperations",
    "SelfSubjectAccessReview",
    "SelfSubjectRulesReview",
    "ServiceReference",
    "Status",
    "Time",
    "TokenReview",
    "TypeMeta",
    "UpdateOptions",
    "ValidatingWebhookConfiguration",
    "ValidatingWebhookConfigurationList"
})
@JsonDeserialize(using = com.fasterxml.jackson.databind.JsonDeserializer.None.class)
@ToString
@EqualsAndHashCode
@Buildable(editableEnabled = false, validationEnabled = false, generateBuilderPackage = false, lazyCollectionInitEnabled = false, builderPackage = "io.fabric8.kubernetes.api.builder", inline = {
    @Inline(type = Doneable.class, prefix = "Doneable", value = "done")
}, refs = {
    @BuildableReference(io.fabric8.kubernetes.api.model.ObjectMeta.class),
    @BuildableReference(LabelSelector.class),
    @BuildableReference(Container.class),
    @BuildableReference(PodTemplateSpec.class),
    @BuildableReference(ResourceRequirements.class),
    @BuildableReference(IntOrString.class),
    @BuildableReference(ObjectReference.class),
    @BuildableReference(LocalObjectReference.class),
    @BuildableReference(PersistentVolumeClaim.class)
})
public class KubeSchema {

    /**
     * 
     * 
     */
    @JsonProperty("APIGroup")
    private APIGroup aPIGroup;
    /**
     * 
     * 
     */
    @JsonProperty("APIGroupList")
    private APIGroupList aPIGroupList;
    /**
     * 
     * 
     */
    @JsonProperty("AdmissionRequest")
    private AdmissionRequest admissionRequest;
    /**
     * 
     * 
     */
    @JsonProperty("AdmissionResponse")
    private AdmissionResponse admissionResponse;
    /**
     * 
     * 
     */
    @JsonProperty("AdmissionReview")
    private AdmissionReview admissionReview;
    /**
     * 
     * 
     */
    @JsonProperty("BaseKubernetesList")
    private BaseKubernetesList baseKubernetesList;
    /**
     * 
     * 
     */
    @JsonProperty("CreateOptions")
    private CreateOptions createOptions;
    /**
     * 
     * 
     */
    @JsonProperty("DeleteOptions")
    private DeleteOptions deleteOptions;
    /**
     * 
     * 
     */
    @JsonProperty("GetOptions")
    private GetOptions getOptions;
    /**
     * 
     * 
     */
    @JsonProperty("Info")
    private Info info;
    /**
     * 
     * 
     */
    @JsonProperty("K8sLocalSubjectAccessReview")
    private LocalSubjectAccessReview k8sLocalSubjectAccessReview;
    /**
     * 
     * 
     */
    @JsonProperty("K8sSubjectAccessReview")
    private SubjectAccessReview k8sSubjectAccessReview;
    /**
     * 
     * 
     */
    @JsonProperty("ListOptions")
    private ListOptions listOptions;
    /**
     * 
     * 
     */
    @JsonProperty("MutatingWebhookConfiguration")
    private MutatingWebhookConfiguration mutatingWebhookConfiguration;
    /**
     * 
     * 
     */
    @JsonProperty("MutatingWebhookConfigurationList")
    private MutatingWebhookConfigurationList mutatingWebhookConfigurationList;
    /**
     * 
     * 
     */
    @JsonProperty("ObjectMeta")
    private io.fabric8.kubernetes.api.model.ObjectMeta objectMeta;
    /**
     * 
     * 
     */
    @JsonProperty("Operation")
    private java.lang.String operation;
    /**
     * 
     * 
     */
    @JsonProperty("Patch")
    private Patch patch;
    /**
     * 
     * 
     */
    @JsonProperty("PatchOptions")
    private PatchOptions patchOptions;
    /**
     * 
     * 
     */
    @JsonProperty("PatchType")
    private java.lang.String patchType;
    /**
     * 
     * 
     */
    @JsonProperty("Quantity")
    private Quantity quantity;
    /**
     * 
     * 
     */
    @JsonProperty("RootPaths")
    private RootPaths rootPaths;
    /**
     * 
     * 
     */
    @JsonProperty("Rule")
    private Rule rule;
    /**
     * 
     * 
     */
    @JsonProperty("RuleWithOperations")
    private RuleWithOperations ruleWithOperations;
    /**
     * 
     * 
     */
    @JsonProperty("SelfSubjectAccessReview")
    private SelfSubjectAccessReview selfSubjectAccessReview;
    /**
     * 
     * 
     */
    @JsonProperty("SelfSubjectRulesReview")
    private SelfSubjectRulesReview selfSubjectRulesReview;
    /**
     * 
     * 
     */
    @JsonProperty("ServiceReference")
    private ServiceReference serviceReference;
    /**
     * 
     * 
     */
    @JsonProperty("Status")
    private Status status;
    /**
     * 
     * 
     */
    @JsonProperty("Time")
    private String time;
    /**
     * 
     * 
     */
    @JsonProperty("TokenReview")
    private TokenReview tokenReview;
    /**
     * 
     * 
     */
    @JsonProperty("TypeMeta")
    private TypeMeta typeMeta;
    /**
     * 
     * 
     */
    @JsonProperty("UpdateOptions")
    private UpdateOptions updateOptions;
    /**
     * 
     * 
     */
    @JsonProperty("ValidatingWebhookConfiguration")
    private ValidatingWebhookConfiguration validatingWebhookConfiguration;
    /**
     * 
     * 
     */
    @JsonProperty("ValidatingWebhookConfigurationList")
    private ValidatingWebhookConfigurationList validatingWebhookConfigurationList;
    @JsonIgnore
    private Map<java.lang.String, Object> additionalProperties = new HashMap<java.lang.String, Object>();

    /**
     * No args constructor for use in serialization
     * 
     */
    public KubeSchema() {
    }

    /**
     * 
     * @param listOptions
     * @param aPIGroupList
     * @param admissionRequest
     * @param serviceReference
     * @param patchType
     * @param selfSubjectRulesReview
     * @param validatingWebhookConfigurationList
     * @param baseKubernetesList
     * @param rule
     * @param updateOptions
     * @param k8sLocalSubjectAccessReview
     * @param patch
     * @param mutatingWebhookConfigurationList
     * @param rootPaths
     * @param info
     * @param patchOptions
     * @param deleteOptions
     * @param quantity
     * @param ruleWithOperations
     * @param admissionResponse
     * @param createOptions
     * @param selfSubjectAccessReview
     * @param aPIGroup
     * @param typeMeta
     * @param validatingWebhookConfiguration
     * @param k8sSubjectAccessReview
     * @param objectMeta
     * @param tokenReview
     * @param getOptions
     * @param time
     * @param admissionReview
     * @param operation
     * @param mutatingWebhookConfiguration
     * @param status
     */
    public KubeSchema(APIGroup aPIGroup, APIGroupList aPIGroupList, AdmissionRequest admissionRequest, AdmissionResponse admissionResponse, AdmissionReview admissionReview, BaseKubernetesList baseKubernetesList, CreateOptions createOptions, DeleteOptions deleteOptions, GetOptions getOptions, Info info, LocalSubjectAccessReview k8sLocalSubjectAccessReview, SubjectAccessReview k8sSubjectAccessReview, ListOptions listOptions, MutatingWebhookConfiguration mutatingWebhookConfiguration, MutatingWebhookConfigurationList mutatingWebhookConfigurationList, io.fabric8.kubernetes.api.model.ObjectMeta objectMeta, java.lang.String operation, Patch patch, PatchOptions patchOptions, java.lang.String patchType, Quantity quantity, RootPaths rootPaths, Rule rule, RuleWithOperations ruleWithOperations, SelfSubjectAccessReview selfSubjectAccessReview, SelfSubjectRulesReview selfSubjectRulesReview, ServiceReference serviceReference, Status status, String time, TokenReview tokenReview, TypeMeta typeMeta, UpdateOptions updateOptions, ValidatingWebhookConfiguration validatingWebhookConfiguration, ValidatingWebhookConfigurationList validatingWebhookConfigurationList) {
        this.aPIGroup = aPIGroup;
        this.aPIGroupList = aPIGroupList;
        this.admissionRequest = admissionRequest;
        this.admissionResponse = admissionResponse;
        this.admissionReview = admissionReview;
        this.baseKubernetesList = baseKubernetesList;
        this.createOptions = createOptions;
        this.deleteOptions = deleteOptions;
        this.getOptions = getOptions;
        this.info = info;
        this.k8sLocalSubjectAccessReview = k8sLocalSubjectAccessReview;
        this.k8sSubjectAccessReview = k8sSubjectAccessReview;
        this.listOptions = listOptions;
        this.mutatingWebhookConfiguration = mutatingWebhookConfiguration;
        this.mutatingWebhookConfigurationList = mutatingWebhookConfigurationList;
        this.objectMeta = objectMeta;
        this.operation = operation;
        this.patch = patch;
        this.patchOptions = patchOptions;
        this.patchType = patchType;
        this.quantity = quantity;
        this.rootPaths = rootPaths;
        this.rule = rule;
        this.ruleWithOperations = ruleWithOperations;
        this.selfSubjectAccessReview = selfSubjectAccessReview;
        this.selfSubjectRulesReview = selfSubjectRulesReview;
        this.serviceReference = serviceReference;
        this.status = status;
        this.time = time;
        this.tokenReview = tokenReview;
        this.typeMeta = typeMeta;
        this.updateOptions = updateOptions;
        this.validatingWebhookConfiguration = validatingWebhookConfiguration;
        this.validatingWebhookConfigurationList = validatingWebhookConfigurationList;
    }

    /**
     * 
     * 
     * @return
     *     The aPIGroup
     */
    @JsonProperty("APIGroup")
    public APIGroup getAPIGroup() {
        return aPIGroup;
    }

    /**
     * 
     * 
     * @param aPIGroup
     *     The APIGroup
     */
    @JsonProperty("APIGroup")
    public void setAPIGroup(APIGroup aPIGroup) {
        this.aPIGroup = aPIGroup;
    }

    /**
     * 
     * 
     * @return
     *     The aPIGroupList
     */
    @JsonProperty("APIGroupList")
    public APIGroupList getAPIGroupList() {
        return aPIGroupList;
    }

    /**
     * 
     * 
     * @param aPIGroupList
     *     The APIGroupList
     */
    @JsonProperty("APIGroupList")
    public void setAPIGroupList(APIGroupList aPIGroupList) {
        this.aPIGroupList = aPIGroupList;
    }

    /**
     * 
     * 
     * @return
     *     The admissionRequest
     */
    @JsonProperty("AdmissionRequest")
    public AdmissionRequest getAdmissionRequest() {
        return admissionRequest;
    }

    /**
     * 
     * 
     * @param admissionRequest
     *     The AdmissionRequest
     */
    @JsonProperty("AdmissionRequest")
    public void setAdmissionRequest(AdmissionRequest admissionRequest) {
        this.admissionRequest = admissionRequest;
    }

    /**
     * 
     * 
     * @return
     *     The admissionResponse
     */
    @JsonProperty("AdmissionResponse")
    public AdmissionResponse getAdmissionResponse() {
        return admissionResponse;
    }

    /**
     * 
     * 
     * @param admissionResponse
     *     The AdmissionResponse
     */
    @JsonProperty("AdmissionResponse")
    public void setAdmissionResponse(AdmissionResponse admissionResponse) {
        this.admissionResponse = admissionResponse;
    }

    /**
     * 
     * 
     * @return
     *     The admissionReview
     */
    @JsonProperty("AdmissionReview")
    public AdmissionReview getAdmissionReview() {
        return admissionReview;
    }

    /**
     * 
     * 
     * @param admissionReview
     *     The AdmissionReview
     */
    @JsonProperty("AdmissionReview")
    public void setAdmissionReview(AdmissionReview admissionReview) {
        this.admissionReview = admissionReview;
    }

    /**
     * 
     * 
     * @return
     *     The baseKubernetesList
     */
    @JsonProperty("BaseKubernetesList")
    public BaseKubernetesList getBaseKubernetesList() {
        return baseKubernetesList;
    }

    /**
     * 
     * 
     * @param baseKubernetesList
     *     The BaseKubernetesList
     */
    @JsonProperty("BaseKubernetesList")
    public void setBaseKubernetesList(BaseKubernetesList baseKubernetesList) {
        this.baseKubernetesList = baseKubernetesList;
    }

    /**
     * 
     * 
     * @return
     *     The createOptions
     */
    @JsonProperty("CreateOptions")
    public CreateOptions getCreateOptions() {
        return createOptions;
    }

    /**
     * 
     * 
     * @param createOptions
     *     The CreateOptions
     */
    @JsonProperty("CreateOptions")
    public void setCreateOptions(CreateOptions createOptions) {
        this.createOptions = createOptions;
    }

    /**
     * 
     * 
     * @return
     *     The deleteOptions
     */
    @JsonProperty("DeleteOptions")
    public DeleteOptions getDeleteOptions() {
        return deleteOptions;
    }

    /**
     * 
     * 
     * @param deleteOptions
     *     The DeleteOptions
     */
    @JsonProperty("DeleteOptions")
    public void setDeleteOptions(DeleteOptions deleteOptions) {
        this.deleteOptions = deleteOptions;
    }

    /**
     * 
     * 
     * @return
     *     The getOptions
     */
    @JsonProperty("GetOptions")
    public GetOptions getGetOptions() {
        return getOptions;
    }

    /**
     * 
     * 
     * @param getOptions
     *     The GetOptions
     */
    @JsonProperty("GetOptions")
    public void setGetOptions(GetOptions getOptions) {
        this.getOptions = getOptions;
    }

    /**
     * 
     * 
     * @return
     *     The info
     */
    @JsonProperty("Info")
    public Info getInfo() {
        return info;
    }

    /**
     * 
     * 
     * @param info
     *     The Info
     */
    @JsonProperty("Info")
    public void setInfo(Info info) {
        this.info = info;
    }

    /**
     * 
     * 
     * @return
     *     The k8sLocalSubjectAccessReview
     */
    @JsonProperty("K8sLocalSubjectAccessReview")
    public LocalSubjectAccessReview getK8sLocalSubjectAccessReview() {
        return k8sLocalSubjectAccessReview;
    }

    /**
     * 
     * 
     * @param k8sLocalSubjectAccessReview
     *     The K8sLocalSubjectAccessReview
     */
    @JsonProperty("K8sLocalSubjectAccessReview")
    public void setK8sLocalSubjectAccessReview(LocalSubjectAccessReview k8sLocalSubjectAccessReview) {
        this.k8sLocalSubjectAccessReview = k8sLocalSubjectAccessReview;
    }

    /**
     * 
     * 
     * @return
     *     The k8sSubjectAccessReview
     */
    @JsonProperty("K8sSubjectAccessReview")
    public SubjectAccessReview getK8sSubjectAccessReview() {
        return k8sSubjectAccessReview;
    }

    /**
     * 
     * 
     * @param k8sSubjectAccessReview
     *     The K8sSubjectAccessReview
     */
    @JsonProperty("K8sSubjectAccessReview")
    public void setK8sSubjectAccessReview(SubjectAccessReview k8sSubjectAccessReview) {
        this.k8sSubjectAccessReview = k8sSubjectAccessReview;
    }

    /**
     * 
     * 
     * @return
     *     The listOptions
     */
    @JsonProperty("ListOptions")
    public ListOptions getListOptions() {
        return listOptions;
    }

    /**
     * 
     * 
     * @param listOptions
     *     The ListOptions
     */
    @JsonProperty("ListOptions")
    public void setListOptions(ListOptions listOptions) {
        this.listOptions = listOptions;
    }

    /**
     * 
     * 
     * @return
     *     The mutatingWebhookConfiguration
     */
    @JsonProperty("MutatingWebhookConfiguration")
    public MutatingWebhookConfiguration getMutatingWebhookConfiguration() {
        return mutatingWebhookConfiguration;
    }

    /**
     * 
     * 
     * @param mutatingWebhookConfiguration
     *     The MutatingWebhookConfiguration
     */
    @JsonProperty("MutatingWebhookConfiguration")
    public void setMutatingWebhookConfiguration(MutatingWebhookConfiguration mutatingWebhookConfiguration) {
        this.mutatingWebhookConfiguration = mutatingWebhookConfiguration;
    }

    /**
     * 
     * 
     * @return
     *     The mutatingWebhookConfigurationList
     */
    @JsonProperty("MutatingWebhookConfigurationList")
    public MutatingWebhookConfigurationList getMutatingWebhookConfigurationList() {
        return mutatingWebhookConfigurationList;
    }

    /**
     * 
     * 
     * @param mutatingWebhookConfigurationList
     *     The MutatingWebhookConfigurationList
     */
    @JsonProperty("MutatingWebhookConfigurationList")
    public void setMutatingWebhookConfigurationList(MutatingWebhookConfigurationList mutatingWebhookConfigurationList) {
        this.mutatingWebhookConfigurationList = mutatingWebhookConfigurationList;
    }

    /**
     * 
     * 
     * @return
     *     The objectMeta
     */
    @JsonProperty("ObjectMeta")
    public io.fabric8.kubernetes.api.model.ObjectMeta getObjectMeta() {
        return objectMeta;
    }

    /**
     * 
     * 
     * @param objectMeta
     *     The ObjectMeta
     */
    @JsonProperty("ObjectMeta")
    public void setObjectMeta(io.fabric8.kubernetes.api.model.ObjectMeta objectMeta) {
        this.objectMeta = objectMeta;
    }

    /**
     * 
     * 
     * @return
     *     The operation
     */
    @JsonProperty("Operation")
    public java.lang.String getOperation() {
        return operation;
    }

    /**
     * 
     * 
     * @param operation
     *     The Operation
     */
    @JsonProperty("Operation")
    public void setOperation(java.lang.String operation) {
        this.operation = operation;
    }

    /**
     * 
     * 
     * @return
     *     The patch
     */
    @JsonProperty("Patch")
    public Patch getPatch() {
        return patch;
    }

    /**
     * 
     * 
     * @param patch
     *     The Patch
     */
    @JsonProperty("Patch")
    public void setPatch(Patch patch) {
        this.patch = patch;
    }

    /**
     * 
     * 
     * @return
     *     The patchOptions
     */
    @JsonProperty("PatchOptions")
    public PatchOptions getPatchOptions() {
        return patchOptions;
    }

    /**
     * 
     * 
     * @param patchOptions
     *     The PatchOptions
     */
    @JsonProperty("PatchOptions")
    public void setPatchOptions(PatchOptions patchOptions) {
        this.patchOptions = patchOptions;
    }

    /**
     * 
     * 
     * @return
     *     The patchType
     */
    @JsonProperty("PatchType")
    public java.lang.String getPatchType() {
        return patchType;
    }

    /**
     * 
     * 
     * @param patchType
     *     The PatchType
     */
    @JsonProperty("PatchType")
    public void setPatchType(java.lang.String patchType) {
        this.patchType = patchType;
    }

    /**
     * 
     * 
     * @return
     *     The quantity
     */
    @JsonProperty("Quantity")
    public Quantity getQuantity() {
        return quantity;
    }

    /**
     * 
     * 
     * @param quantity
     *     The Quantity
     */
    @JsonProperty("Quantity")
    public void setQuantity(Quantity quantity) {
        this.quantity = quantity;
    }

    /**
     * 
     * 
     * @return
     *     The rootPaths
     */
    @JsonProperty("RootPaths")
    public RootPaths getRootPaths() {
        return rootPaths;
    }

    /**
     * 
     * 
     * @param rootPaths
     *     The RootPaths
     */
    @JsonProperty("RootPaths")
    public void setRootPaths(RootPaths rootPaths) {
        this.rootPaths = rootPaths;
    }

    /**
     * 
     * 
     * @return
     *     The rule
     */
    @JsonProperty("Rule")
    public Rule getRule() {
        return rule;
    }

    /**
     * 
     * 
     * @param rule
     *     The Rule
     */
    @JsonProperty("Rule")
    public void setRule(Rule rule) {
        this.rule = rule;
    }

    /**
     * 
     * 
     * @return
     *     The ruleWithOperations
     */
    @JsonProperty("RuleWithOperations")
    public RuleWithOperations getRuleWithOperations() {
        return ruleWithOperations;
    }

    /**
     * 
     * 
     * @param ruleWithOperations
     *     The RuleWithOperations
     */
    @JsonProperty("RuleWithOperations")
    public void setRuleWithOperations(RuleWithOperations ruleWithOperations) {
        this.ruleWithOperations = ruleWithOperations;
    }

    /**
     * 
     * 
     * @return
     *     The selfSubjectAccessReview
     */
    @JsonProperty("SelfSubjectAccessReview")
    public SelfSubjectAccessReview getSelfSubjectAccessReview() {
        return selfSubjectAccessReview;
    }

    /**
     * 
     * 
     * @param selfSubjectAccessReview
     *     The SelfSubjectAccessReview
     */
    @JsonProperty("SelfSubjectAccessReview")
    public void setSelfSubjectAccessReview(SelfSubjectAccessReview selfSubjectAccessReview) {
        this.selfSubjectAccessReview = selfSubjectAccessReview;
    }

    /**
     * 
     * 
     * @return
     *     The selfSubjectRulesReview
     */
    @JsonProperty("SelfSubjectRulesReview")
    public SelfSubjectRulesReview getSelfSubjectRulesReview() {
        return selfSubjectRulesReview;
    }

    /**
     * 
     * 
     * @param selfSubjectRulesReview
     *     The SelfSubjectRulesReview
     */
    @JsonProperty("SelfSubjectRulesReview")
    public void setSelfSubjectRulesReview(SelfSubjectRulesReview selfSubjectRulesReview) {
        this.selfSubjectRulesReview = selfSubjectRulesReview;
    }

    /**
     * 
     * 
     * @return
     *     The serviceReference
     */
    @JsonProperty("ServiceReference")
    public ServiceReference getServiceReference() {
        return serviceReference;
    }

    /**
     * 
     * 
     * @param serviceReference
     *     The ServiceReference
     */
    @JsonProperty("ServiceReference")
    public void setServiceReference(ServiceReference serviceReference) {
        this.serviceReference = serviceReference;
    }

    /**
     * 
     * 
     * @return
     *     The status
     */
    @JsonProperty("Status")
    public Status getStatus() {
        return status;
    }

    /**
     * 
     * 
     * @param status
     *     The Status
     */
    @JsonProperty("Status")
    public void setStatus(Status status) {
        this.status = status;
    }

    /**
     * 
     * 
     * @return
     *     The time
     */
    @JsonProperty("Time")
    public String getTime() {
        return time;
    }

    /**
     * 
     * 
     * @param time
     *     The Time
     */
    @JsonProperty("Time")
    public void setTime(String time) {
        this.time = time;
    }

    /**
     * 
     * 
     * @return
     *     The tokenReview
     */
    @JsonProperty("TokenReview")
    public TokenReview getTokenReview() {
        return tokenReview;
    }

    /**
     * 
     * 
     * @param tokenReview
     *     The TokenReview
     */
    @JsonProperty("TokenReview")
    public void setTokenReview(TokenReview tokenReview) {
        this.tokenReview = tokenReview;
    }

    /**
     * 
     * 
     * @return
     *     The typeMeta
     */
    @JsonProperty("TypeMeta")
    public TypeMeta getTypeMeta() {
        return typeMeta;
    }

    /**
     * 
     * 
     * @param typeMeta
     *     The TypeMeta
     */
    @JsonProperty("TypeMeta")
    public void setTypeMeta(TypeMeta typeMeta) {
        this.typeMeta = typeMeta;
    }

    /**
     * 
     * 
     * @return
     *     The updateOptions
     */
    @JsonProperty("UpdateOptions")
    public UpdateOptions getUpdateOptions() {
        return updateOptions;
    }

    /**
     * 
     * 
     * @param updateOptions
     *     The UpdateOptions
     */
    @JsonProperty("UpdateOptions")
    public void setUpdateOptions(UpdateOptions updateOptions) {
        this.updateOptions = updateOptions;
    }

    /**
     * 
     * 
     * @return
     *     The validatingWebhookConfiguration
     */
    @JsonProperty("ValidatingWebhookConfiguration")
    public ValidatingWebhookConfiguration getValidatingWebhookConfiguration() {
        return validatingWebhookConfiguration;
    }

    /**
     * 
     * 
     * @param validatingWebhookConfiguration
     *     The ValidatingWebhookConfiguration
     */
    @JsonProperty("ValidatingWebhookConfiguration")
    public void setValidatingWebhookConfiguration(ValidatingWebhookConfiguration validatingWebhookConfiguration) {
        this.validatingWebhookConfiguration = validatingWebhookConfiguration;
    }

    /**
     * 
     * 
     * @return
     *     The validatingWebhookConfigurationList
     */
    @JsonProperty("ValidatingWebhookConfigurationList")
    public ValidatingWebhookConfigurationList getValidatingWebhookConfigurationList() {
        return validatingWebhookConfigurationList;
    }

    /**
     * 
     * 
     * @param validatingWebhookConfigurationList
     *     The ValidatingWebhookConfigurationList
     */
    @JsonProperty("ValidatingWebhookConfigurationList")
    public void setValidatingWebhookConfigurationList(ValidatingWebhookConfigurationList validatingWebhookConfigurationList) {
        this.validatingWebhookConfigurationList = validatingWebhookConfigurationList;
    }

    @JsonAnyGetter
    public Map<java.lang.String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    @JsonAnySetter
    public void setAdditionalProperty(java.lang.String name, Object value) {
        this.additionalProperties.put(name, value);
    }

}
