package io.fabric8.kubernetes.api.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;

public class PodConditionBuilder extends io.fabric8.kubernetes.api.model.PodConditionFluentImpl<io.fabric8.kubernetes.api.model.PodConditionBuilder> implements io.fabric8.kubernetes.api.builder.VisitableBuilder<io.fabric8.kubernetes.api.model.PodCondition,io.fabric8.kubernetes.api.model.PodConditionBuilder> {

    io.fabric8.kubernetes.api.model.PodConditionFluent<?> fluent;
    java.lang.Boolean validationEnabled;

    public PodConditionBuilder() {
        this(true);
    }

    public PodConditionBuilder(java.lang.Boolean validationEnabled) {
        this(new PodCondition(), validationEnabled);
    }

    public PodConditionBuilder(io.fabric8.kubernetes.api.model.PodConditionFluent<?> fluent) {
        this(fluent, true);
    }

    public PodConditionBuilder(io.fabric8.kubernetes.api.model.PodConditionFluent<?> fluent,java.lang.Boolean validationEnabled) {
        this(fluent, new PodCondition(), validationEnabled);
    }

    public PodConditionBuilder(io.fabric8.kubernetes.api.model.PodConditionFluent<?> fluent,io.fabric8.kubernetes.api.model.PodCondition instance) {
        this(fluent, instance, true);
    }

    public PodConditionBuilder(io.fabric8.kubernetes.api.model.PodConditionFluent<?> fluent,io.fabric8.kubernetes.api.model.PodCondition instance,java.lang.Boolean validationEnabled) {
        this.fluent = fluent; 
        fluent.withLastProbeTime(instance.getLastProbeTime()); 
        fluent.withLastTransitionTime(instance.getLastTransitionTime()); 
        fluent.withMessage(instance.getMessage()); 
        fluent.withReason(instance.getReason()); 
        fluent.withStatus(instance.getStatus()); 
        fluent.withType(instance.getType()); 
        this.validationEnabled = validationEnabled; 
    }

    public PodConditionBuilder(io.fabric8.kubernetes.api.model.PodCondition instance) {
        this(instance,true);
    }

    public PodConditionBuilder(io.fabric8.kubernetes.api.model.PodCondition instance,java.lang.Boolean validationEnabled) {
        this.fluent = this; 
        this.withLastProbeTime(instance.getLastProbeTime()); 
        this.withLastTransitionTime(instance.getLastTransitionTime()); 
        this.withMessage(instance.getMessage()); 
        this.withReason(instance.getReason()); 
        this.withStatus(instance.getStatus()); 
        this.withType(instance.getType()); 
        this.validationEnabled = validationEnabled; 
    }

    public io.fabric8.kubernetes.api.model.PodCondition build() {
        PodCondition buildable = new PodCondition(fluent.getLastProbeTime(),fluent.getLastTransitionTime(),fluent.getMessage(),fluent.getReason(),fluent.getStatus(),fluent.getType());
        return buildable;
    }

    public boolean equals(java.lang.Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        if (!super.equals(o)) return false;
        PodConditionBuilder that = (PodConditionBuilder) o;
        if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;
        
        if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
        return true;
    }

    public int hashCode() {
        return java.util.Objects.hash(fluent,  validationEnabled,  super.hashCode());
    }

}
