package io.fabric8.kubernetes.api.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;

public class RBDPersistentVolumeSourceBuilder extends io.fabric8.kubernetes.api.model.RBDPersistentVolumeSourceFluentImpl<io.fabric8.kubernetes.api.model.RBDPersistentVolumeSourceBuilder> implements io.fabric8.kubernetes.api.builder.VisitableBuilder<io.fabric8.kubernetes.api.model.RBDPersistentVolumeSource,io.fabric8.kubernetes.api.model.RBDPersistentVolumeSourceBuilder> {

    io.fabric8.kubernetes.api.model.RBDPersistentVolumeSourceFluent<?> fluent;
    java.lang.Boolean validationEnabled;

    public RBDPersistentVolumeSourceBuilder() {
        this(true);
    }

    public RBDPersistentVolumeSourceBuilder(java.lang.Boolean validationEnabled) {
        this(new RBDPersistentVolumeSource(), validationEnabled);
    }

    public RBDPersistentVolumeSourceBuilder(io.fabric8.kubernetes.api.model.RBDPersistentVolumeSourceFluent<?> fluent) {
        this(fluent, true);
    }

    public RBDPersistentVolumeSourceBuilder(io.fabric8.kubernetes.api.model.RBDPersistentVolumeSourceFluent<?> fluent,java.lang.Boolean validationEnabled) {
        this(fluent, new RBDPersistentVolumeSource(), validationEnabled);
    }

    public RBDPersistentVolumeSourceBuilder(io.fabric8.kubernetes.api.model.RBDPersistentVolumeSourceFluent<?> fluent,io.fabric8.kubernetes.api.model.RBDPersistentVolumeSource instance) {
        this(fluent, instance, true);
    }

    public RBDPersistentVolumeSourceBuilder(io.fabric8.kubernetes.api.model.RBDPersistentVolumeSourceFluent<?> fluent,io.fabric8.kubernetes.api.model.RBDPersistentVolumeSource instance,java.lang.Boolean validationEnabled) {
        this.fluent = fluent; 
        fluent.withFsType(instance.getFsType()); 
        fluent.withImage(instance.getImage()); 
        fluent.withKeyring(instance.getKeyring()); 
        fluent.withMonitors(instance.getMonitors()); 
        fluent.withPool(instance.getPool()); 
        fluent.withReadOnly(instance.getReadOnly()); 
        fluent.withSecretRef(instance.getSecretRef()); 
        fluent.withUser(instance.getUser()); 
        this.validationEnabled = validationEnabled; 
    }

    public RBDPersistentVolumeSourceBuilder(io.fabric8.kubernetes.api.model.RBDPersistentVolumeSource instance) {
        this(instance,true);
    }

    public RBDPersistentVolumeSourceBuilder(io.fabric8.kubernetes.api.model.RBDPersistentVolumeSource instance,java.lang.Boolean validationEnabled) {
        this.fluent = this; 
        this.withFsType(instance.getFsType()); 
        this.withImage(instance.getImage()); 
        this.withKeyring(instance.getKeyring()); 
        this.withMonitors(instance.getMonitors()); 
        this.withPool(instance.getPool()); 
        this.withReadOnly(instance.getReadOnly()); 
        this.withSecretRef(instance.getSecretRef()); 
        this.withUser(instance.getUser()); 
        this.validationEnabled = validationEnabled; 
    }

    public io.fabric8.kubernetes.api.model.RBDPersistentVolumeSource build() {
        RBDPersistentVolumeSource buildable = new RBDPersistentVolumeSource(fluent.getFsType(),fluent.getImage(),fluent.getKeyring(),fluent.getMonitors(),fluent.getPool(),fluent.getReadOnly(),fluent.getSecretRef(),fluent.getUser());
        return buildable;
    }

    public boolean equals(java.lang.Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        if (!super.equals(o)) return false;
        RBDPersistentVolumeSourceBuilder that = (RBDPersistentVolumeSourceBuilder) o;
        if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;
        
        if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
        return true;
    }

    public int hashCode() {
        return java.util.Objects.hash(fluent,  validationEnabled,  super.hashCode());
    }

}
