package io.fabric8.kubernetes.api.model;

import io.fabric8.kubernetes.api.builder.Nested;
import java.lang.String;
import java.lang.Deprecated;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.lang.Boolean;
import java.lang.Long;
import java.lang.Object;

public class VolumeProjectionFluentImpl<A extends io.fabric8.kubernetes.api.model.VolumeProjectionFluent<A>> extends io.fabric8.kubernetes.api.builder.BaseFluent<A> implements io.fabric8.kubernetes.api.model.VolumeProjectionFluent<A> {

    private io.fabric8.kubernetes.api.model.ConfigMapProjectionBuilder configMap;
    private io.fabric8.kubernetes.api.model.DownwardAPIProjectionBuilder downwardAPI;
    private io.fabric8.kubernetes.api.model.SecretProjectionBuilder secret;
    private io.fabric8.kubernetes.api.model.ServiceAccountTokenProjectionBuilder serviceAccountToken;

    public VolumeProjectionFluentImpl() {
    }

    public VolumeProjectionFluentImpl(io.fabric8.kubernetes.api.model.VolumeProjection instance) {
        this.withConfigMap(instance.getConfigMap()); 
        this.withDownwardAPI(instance.getDownwardAPI()); 
        this.withSecret(instance.getSecret()); 
        this.withServiceAccountToken(instance.getServiceAccountToken()); 
    }

    
    @java.lang.Deprecated
        
    /**
     * This method has been deprecated, please use method buildConfigMap instead.
     * @return The buildable object.
     */
        public io.fabric8.kubernetes.api.model.ConfigMapProjection getConfigMap() {
        return this.configMap!=null?this.configMap.build():null;
    }

    public io.fabric8.kubernetes.api.model.ConfigMapProjection buildConfigMap() {
        return this.configMap!=null?this.configMap.build():null;
    }

    public A withConfigMap(io.fabric8.kubernetes.api.model.ConfigMapProjection configMap) {
        _visitables.get("configMap").remove(this.configMap);
        if (configMap!=null){ this.configMap= new io.fabric8.kubernetes.api.model.ConfigMapProjectionBuilder(configMap); _visitables.get("configMap").add(this.configMap);} return (A) this;
    }

    public java.lang.Boolean hasConfigMap() {
        return this.configMap != null;
    }

    public io.fabric8.kubernetes.api.model.VolumeProjectionFluent.ConfigMapNested<A> withNewConfigMap() {
        return new io.fabric8.kubernetes.api.model.VolumeProjectionFluentImpl.ConfigMapNestedImpl();
    }

    public io.fabric8.kubernetes.api.model.VolumeProjectionFluent.ConfigMapNested<A> withNewConfigMapLike(io.fabric8.kubernetes.api.model.ConfigMapProjection item) {
        return new io.fabric8.kubernetes.api.model.VolumeProjectionFluentImpl.ConfigMapNestedImpl(item);
    }

    public io.fabric8.kubernetes.api.model.VolumeProjectionFluent.ConfigMapNested<A> editConfigMap() {
        return withNewConfigMapLike(getConfigMap());
    }

    public io.fabric8.kubernetes.api.model.VolumeProjectionFluent.ConfigMapNested<A> editOrNewConfigMap() {
        return withNewConfigMapLike(getConfigMap() != null ? getConfigMap(): new io.fabric8.kubernetes.api.model.ConfigMapProjectionBuilder().build());
    }

    public io.fabric8.kubernetes.api.model.VolumeProjectionFluent.ConfigMapNested<A> editOrNewConfigMapLike(io.fabric8.kubernetes.api.model.ConfigMapProjection item) {
        return withNewConfigMapLike(getConfigMap() != null ? getConfigMap(): item);
    }

    
    @java.lang.Deprecated
        
    /**
     * This method has been deprecated, please use method buildDownwardAPI instead.
     * @return The buildable object.
     */
        public io.fabric8.kubernetes.api.model.DownwardAPIProjection getDownwardAPI() {
        return this.downwardAPI!=null?this.downwardAPI.build():null;
    }

    public io.fabric8.kubernetes.api.model.DownwardAPIProjection buildDownwardAPI() {
        return this.downwardAPI!=null?this.downwardAPI.build():null;
    }

    public A withDownwardAPI(io.fabric8.kubernetes.api.model.DownwardAPIProjection downwardAPI) {
        _visitables.get("downwardAPI").remove(this.downwardAPI);
        if (downwardAPI!=null){ this.downwardAPI= new io.fabric8.kubernetes.api.model.DownwardAPIProjectionBuilder(downwardAPI); _visitables.get("downwardAPI").add(this.downwardAPI);} return (A) this;
    }

    public java.lang.Boolean hasDownwardAPI() {
        return this.downwardAPI != null;
    }

    public io.fabric8.kubernetes.api.model.VolumeProjectionFluent.DownwardAPINested<A> withNewDownwardAPI() {
        return new io.fabric8.kubernetes.api.model.VolumeProjectionFluentImpl.DownwardAPINestedImpl();
    }

    public io.fabric8.kubernetes.api.model.VolumeProjectionFluent.DownwardAPINested<A> withNewDownwardAPILike(io.fabric8.kubernetes.api.model.DownwardAPIProjection item) {
        return new io.fabric8.kubernetes.api.model.VolumeProjectionFluentImpl.DownwardAPINestedImpl(item);
    }

    public io.fabric8.kubernetes.api.model.VolumeProjectionFluent.DownwardAPINested<A> editDownwardAPI() {
        return withNewDownwardAPILike(getDownwardAPI());
    }

    public io.fabric8.kubernetes.api.model.VolumeProjectionFluent.DownwardAPINested<A> editOrNewDownwardAPI() {
        return withNewDownwardAPILike(getDownwardAPI() != null ? getDownwardAPI(): new io.fabric8.kubernetes.api.model.DownwardAPIProjectionBuilder().build());
    }

    public io.fabric8.kubernetes.api.model.VolumeProjectionFluent.DownwardAPINested<A> editOrNewDownwardAPILike(io.fabric8.kubernetes.api.model.DownwardAPIProjection item) {
        return withNewDownwardAPILike(getDownwardAPI() != null ? getDownwardAPI(): item);
    }

    
    @java.lang.Deprecated
        
    /**
     * This method has been deprecated, please use method buildSecret instead.
     * @return The buildable object.
     */
        public io.fabric8.kubernetes.api.model.SecretProjection getSecret() {
        return this.secret!=null?this.secret.build():null;
    }

    public io.fabric8.kubernetes.api.model.SecretProjection buildSecret() {
        return this.secret!=null?this.secret.build():null;
    }

    public A withSecret(io.fabric8.kubernetes.api.model.SecretProjection secret) {
        _visitables.get("secret").remove(this.secret);
        if (secret!=null){ this.secret= new io.fabric8.kubernetes.api.model.SecretProjectionBuilder(secret); _visitables.get("secret").add(this.secret);} return (A) this;
    }

    public java.lang.Boolean hasSecret() {
        return this.secret != null;
    }

    public io.fabric8.kubernetes.api.model.VolumeProjectionFluent.SecretNested<A> withNewSecret() {
        return new io.fabric8.kubernetes.api.model.VolumeProjectionFluentImpl.SecretNestedImpl();
    }

    public io.fabric8.kubernetes.api.model.VolumeProjectionFluent.SecretNested<A> withNewSecretLike(io.fabric8.kubernetes.api.model.SecretProjection item) {
        return new io.fabric8.kubernetes.api.model.VolumeProjectionFluentImpl.SecretNestedImpl(item);
    }

    public io.fabric8.kubernetes.api.model.VolumeProjectionFluent.SecretNested<A> editSecret() {
        return withNewSecretLike(getSecret());
    }

    public io.fabric8.kubernetes.api.model.VolumeProjectionFluent.SecretNested<A> editOrNewSecret() {
        return withNewSecretLike(getSecret() != null ? getSecret(): new io.fabric8.kubernetes.api.model.SecretProjectionBuilder().build());
    }

    public io.fabric8.kubernetes.api.model.VolumeProjectionFluent.SecretNested<A> editOrNewSecretLike(io.fabric8.kubernetes.api.model.SecretProjection item) {
        return withNewSecretLike(getSecret() != null ? getSecret(): item);
    }

    
    @java.lang.Deprecated
        
    /**
     * This method has been deprecated, please use method buildServiceAccountToken instead.
     * @return The buildable object.
     */
        public io.fabric8.kubernetes.api.model.ServiceAccountTokenProjection getServiceAccountToken() {
        return this.serviceAccountToken!=null?this.serviceAccountToken.build():null;
    }

    public io.fabric8.kubernetes.api.model.ServiceAccountTokenProjection buildServiceAccountToken() {
        return this.serviceAccountToken!=null?this.serviceAccountToken.build():null;
    }

    public A withServiceAccountToken(io.fabric8.kubernetes.api.model.ServiceAccountTokenProjection serviceAccountToken) {
        _visitables.get("serviceAccountToken").remove(this.serviceAccountToken);
        if (serviceAccountToken!=null){ this.serviceAccountToken= new io.fabric8.kubernetes.api.model.ServiceAccountTokenProjectionBuilder(serviceAccountToken); _visitables.get("serviceAccountToken").add(this.serviceAccountToken);} return (A) this;
    }

    public java.lang.Boolean hasServiceAccountToken() {
        return this.serviceAccountToken != null;
    }

    public A withNewServiceAccountToken(java.lang.String audience,java.lang.Long expirationSeconds,java.lang.String path) {
        return (A)withServiceAccountToken(new ServiceAccountTokenProjection(audience, expirationSeconds, path));
    }

    public io.fabric8.kubernetes.api.model.VolumeProjectionFluent.ServiceAccountTokenNested<A> withNewServiceAccountToken() {
        return new io.fabric8.kubernetes.api.model.VolumeProjectionFluentImpl.ServiceAccountTokenNestedImpl();
    }

    public io.fabric8.kubernetes.api.model.VolumeProjectionFluent.ServiceAccountTokenNested<A> withNewServiceAccountTokenLike(io.fabric8.kubernetes.api.model.ServiceAccountTokenProjection item) {
        return new io.fabric8.kubernetes.api.model.VolumeProjectionFluentImpl.ServiceAccountTokenNestedImpl(item);
    }

    public io.fabric8.kubernetes.api.model.VolumeProjectionFluent.ServiceAccountTokenNested<A> editServiceAccountToken() {
        return withNewServiceAccountTokenLike(getServiceAccountToken());
    }

    public io.fabric8.kubernetes.api.model.VolumeProjectionFluent.ServiceAccountTokenNested<A> editOrNewServiceAccountToken() {
        return withNewServiceAccountTokenLike(getServiceAccountToken() != null ? getServiceAccountToken(): new io.fabric8.kubernetes.api.model.ServiceAccountTokenProjectionBuilder().build());
    }

    public io.fabric8.kubernetes.api.model.VolumeProjectionFluent.ServiceAccountTokenNested<A> editOrNewServiceAccountTokenLike(io.fabric8.kubernetes.api.model.ServiceAccountTokenProjection item) {
        return withNewServiceAccountTokenLike(getServiceAccountToken() != null ? getServiceAccountToken(): item);
    }

    public boolean equals(java.lang.Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        VolumeProjectionFluentImpl that = (VolumeProjectionFluentImpl) o;
        if (configMap != null ? !configMap.equals(that.configMap) :that.configMap != null) return false;
        if (downwardAPI != null ? !downwardAPI.equals(that.downwardAPI) :that.downwardAPI != null) return false;
        if (secret != null ? !secret.equals(that.secret) :that.secret != null) return false;
        if (serviceAccountToken != null ? !serviceAccountToken.equals(that.serviceAccountToken) :that.serviceAccountToken != null) return false;
        return true;
    }

    public int hashCode() {
        return java.util.Objects.hash(configMap,  downwardAPI,  secret,  serviceAccountToken,  super.hashCode());
    }

    public class ConfigMapNestedImpl<N> extends io.fabric8.kubernetes.api.model.ConfigMapProjectionFluentImpl<io.fabric8.kubernetes.api.model.VolumeProjectionFluent.ConfigMapNested<N>> implements io.fabric8.kubernetes.api.model.VolumeProjectionFluent.ConfigMapNested<N>,io.fabric8.kubernetes.api.builder.Nested<N> {
        private final io.fabric8.kubernetes.api.model.ConfigMapProjectionBuilder builder;

            ConfigMapNestedImpl(io.fabric8.kubernetes.api.model.ConfigMapProjection item) {
                this.builder = new io.fabric8.kubernetes.api.model.ConfigMapProjectionBuilder(this, item);
                        
            }

            ConfigMapNestedImpl() {
                this.builder = new io.fabric8.kubernetes.api.model.ConfigMapProjectionBuilder(this);
                        
            }

            public N and() {
                return (N) VolumeProjectionFluentImpl.this.withConfigMap(builder.build());
            }

            public N endConfigMap() {
                return and();
            }
    }


    public class DownwardAPINestedImpl<N> extends io.fabric8.kubernetes.api.model.DownwardAPIProjectionFluentImpl<io.fabric8.kubernetes.api.model.VolumeProjectionFluent.DownwardAPINested<N>> implements io.fabric8.kubernetes.api.model.VolumeProjectionFluent.DownwardAPINested<N>,io.fabric8.kubernetes.api.builder.Nested<N> {
        private final io.fabric8.kubernetes.api.model.DownwardAPIProjectionBuilder builder;

            DownwardAPINestedImpl(io.fabric8.kubernetes.api.model.DownwardAPIProjection item) {
                this.builder = new io.fabric8.kubernetes.api.model.DownwardAPIProjectionBuilder(this, item);
                        
            }

            DownwardAPINestedImpl() {
                this.builder = new io.fabric8.kubernetes.api.model.DownwardAPIProjectionBuilder(this);
                        
            }

            public N and() {
                return (N) VolumeProjectionFluentImpl.this.withDownwardAPI(builder.build());
            }

            public N endDownwardAPI() {
                return and();
            }
    }


    public class SecretNestedImpl<N> extends io.fabric8.kubernetes.api.model.SecretProjectionFluentImpl<io.fabric8.kubernetes.api.model.VolumeProjectionFluent.SecretNested<N>> implements io.fabric8.kubernetes.api.model.VolumeProjectionFluent.SecretNested<N>,io.fabric8.kubernetes.api.builder.Nested<N> {
        private final io.fabric8.kubernetes.api.model.SecretProjectionBuilder builder;

            SecretNestedImpl(io.fabric8.kubernetes.api.model.SecretProjection item) {
                this.builder = new io.fabric8.kubernetes.api.model.SecretProjectionBuilder(this, item);
                        
            }

            SecretNestedImpl() {
                this.builder = new io.fabric8.kubernetes.api.model.SecretProjectionBuilder(this);
                        
            }

            public N and() {
                return (N) VolumeProjectionFluentImpl.this.withSecret(builder.build());
            }

            public N endSecret() {
                return and();
            }
    }


    public class ServiceAccountTokenNestedImpl<N> extends io.fabric8.kubernetes.api.model.ServiceAccountTokenProjectionFluentImpl<io.fabric8.kubernetes.api.model.VolumeProjectionFluent.ServiceAccountTokenNested<N>> implements io.fabric8.kubernetes.api.model.VolumeProjectionFluent.ServiceAccountTokenNested<N>,io.fabric8.kubernetes.api.builder.Nested<N> {
        private final io.fabric8.kubernetes.api.model.ServiceAccountTokenProjectionBuilder builder;

            ServiceAccountTokenNestedImpl(io.fabric8.kubernetes.api.model.ServiceAccountTokenProjection item) {
                this.builder = new io.fabric8.kubernetes.api.model.ServiceAccountTokenProjectionBuilder(this, item);
                        
            }

            ServiceAccountTokenNestedImpl() {
                this.builder = new io.fabric8.kubernetes.api.model.ServiceAccountTokenProjectionBuilder(this);
                        
            }

            public N and() {
                return (N) VolumeProjectionFluentImpl.this.withServiceAccountToken(builder.build());
            }

            public N endServiceAccountToken() {
                return and();
            }
    }


}
