/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.api.model;

import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.builder.Nested;
import io.fabric8.kubernetes.api.model.HTTPGetAction;
import io.fabric8.kubernetes.api.model.HTTPGetActionFluent;
import io.fabric8.kubernetes.api.model.HTTPHeader;
import io.fabric8.kubernetes.api.model.HTTPHeaderBuilder;
import io.fabric8.kubernetes.api.model.HTTPHeaderFluentImpl;
import io.fabric8.kubernetes.api.model.IntOrString;
import io.fabric8.kubernetes.api.model.IntOrStringBuilder;
import io.fabric8.kubernetes.api.model.IntOrStringFluentImpl;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.function.Predicate;

public class HTTPGetActionFluentImpl<A extends HTTPGetActionFluent<A>>
extends BaseFluent<A>
implements HTTPGetActionFluent<A> {
    private String host;
    private List<HTTPHeaderBuilder> httpHeaders = new ArrayList<HTTPHeaderBuilder>();
    private String path;
    private IntOrStringBuilder port;
    private String scheme;

    public HTTPGetActionFluentImpl() {
    }

    public HTTPGetActionFluentImpl(HTTPGetAction instance) {
        this.withHost(instance.getHost());
        this.withHttpHeaders(instance.getHttpHeaders());
        this.withPath(instance.getPath());
        this.withPort(instance.getPort());
        this.withScheme(instance.getScheme());
    }

    @Override
    public String getHost() {
        return this.host;
    }

    @Override
    public A withHost(String host) {
        this.host = host;
        return (A)this;
    }

    @Override
    public Boolean hasHost() {
        return this.host != null;
    }

    @Override
    @Deprecated
    public A withNewHost(String arg0) {
        return this.withHost(new String(arg0));
    }

    @Override
    public A addToHttpHeaders(int index, HTTPHeader item) {
        if (this.httpHeaders == null) {
            this.httpHeaders = new ArrayList<HTTPHeaderBuilder>();
        }
        HTTPHeaderBuilder builder = new HTTPHeaderBuilder(item);
        this._visitables.get("httpHeaders").add(index >= 0 ? index : this._visitables.get("httpHeaders").size(), builder);
        this.httpHeaders.add(index >= 0 ? index : this.httpHeaders.size(), builder);
        return (A)this;
    }

    @Override
    public A setToHttpHeaders(int index, HTTPHeader item) {
        if (this.httpHeaders == null) {
            this.httpHeaders = new ArrayList<HTTPHeaderBuilder>();
        }
        HTTPHeaderBuilder builder = new HTTPHeaderBuilder(item);
        if (index < 0 || index >= this._visitables.get("httpHeaders").size()) {
            this._visitables.get("httpHeaders").add(builder);
        } else {
            this._visitables.get("httpHeaders").set(index, builder);
        }
        if (index < 0 || index >= this.httpHeaders.size()) {
            this.httpHeaders.add(builder);
        } else {
            this.httpHeaders.set(index, builder);
        }
        return (A)this;
    }

    @Override
    public A addToHttpHeaders(HTTPHeader ... items) {
        if (this.httpHeaders == null) {
            this.httpHeaders = new ArrayList<HTTPHeaderBuilder>();
        }
        for (HTTPHeader item : items) {
            HTTPHeaderBuilder builder = new HTTPHeaderBuilder(item);
            this._visitables.get("httpHeaders").add(builder);
            this.httpHeaders.add(builder);
        }
        return (A)this;
    }

    @Override
    public A addAllToHttpHeaders(Collection<HTTPHeader> items) {
        if (this.httpHeaders == null) {
            this.httpHeaders = new ArrayList<HTTPHeaderBuilder>();
        }
        for (HTTPHeader item : items) {
            HTTPHeaderBuilder builder = new HTTPHeaderBuilder(item);
            this._visitables.get("httpHeaders").add(builder);
            this.httpHeaders.add(builder);
        }
        return (A)this;
    }

    @Override
    public A removeFromHttpHeaders(HTTPHeader ... items) {
        for (HTTPHeader item : items) {
            HTTPHeaderBuilder builder = new HTTPHeaderBuilder(item);
            this._visitables.get("httpHeaders").remove(builder);
            if (this.httpHeaders == null) continue;
            this.httpHeaders.remove(builder);
        }
        return (A)this;
    }

    @Override
    public A removeAllFromHttpHeaders(Collection<HTTPHeader> items) {
        for (HTTPHeader item : items) {
            HTTPHeaderBuilder builder = new HTTPHeaderBuilder(item);
            this._visitables.get("httpHeaders").remove(builder);
            if (this.httpHeaders == null) continue;
            this.httpHeaders.remove(builder);
        }
        return (A)this;
    }

    @Override
    public A removeMatchingFromHttpHeaders(Predicate<HTTPHeaderBuilder> predicate) {
        if (this.httpHeaders == null) {
            return (A)this;
        }
        Iterator<HTTPHeaderBuilder> each = this.httpHeaders.iterator();
        Object visitables = this._visitables.get("httpHeaders");
        while (each.hasNext()) {
            HTTPHeaderBuilder builder = each.next();
            if (!predicate.test(builder)) continue;
            visitables.remove(builder);
            each.remove();
        }
        return (A)this;
    }

    @Override
    @Deprecated
    public List<HTTPHeader> getHttpHeaders() {
        return HTTPGetActionFluentImpl.build(this.httpHeaders);
    }

    @Override
    public List<HTTPHeader> buildHttpHeaders() {
        return HTTPGetActionFluentImpl.build(this.httpHeaders);
    }

    @Override
    public HTTPHeader buildHttpHeader(int index) {
        return this.httpHeaders.get(index).build();
    }

    @Override
    public HTTPHeader buildFirstHttpHeader() {
        return this.httpHeaders.get(0).build();
    }

    @Override
    public HTTPHeader buildLastHttpHeader() {
        return this.httpHeaders.get(this.httpHeaders.size() - 1).build();
    }

    @Override
    public HTTPHeader buildMatchingHttpHeader(Predicate<HTTPHeaderBuilder> predicate) {
        for (HTTPHeaderBuilder item : this.httpHeaders) {
            if (!predicate.test(item)) continue;
            return item.build();
        }
        return null;
    }

    @Override
    public Boolean hasMatchingHttpHeader(Predicate<HTTPHeaderBuilder> predicate) {
        for (HTTPHeaderBuilder item : this.httpHeaders) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    @Override
    public A withHttpHeaders(List<HTTPHeader> httpHeaders) {
        if (this.httpHeaders != null) {
            this._visitables.get("httpHeaders").removeAll(this.httpHeaders);
        }
        if (httpHeaders != null) {
            this.httpHeaders = new ArrayList<HTTPHeaderBuilder>();
            for (HTTPHeader item : httpHeaders) {
                this.addToHttpHeaders(item);
            }
        } else {
            this.httpHeaders = null;
        }
        return (A)this;
    }

    @Override
    public A withHttpHeaders(HTTPHeader ... httpHeaders) {
        if (this.httpHeaders != null) {
            this.httpHeaders.clear();
        }
        if (httpHeaders != null) {
            for (HTTPHeader item : httpHeaders) {
                this.addToHttpHeaders(item);
            }
        }
        return (A)this;
    }

    @Override
    public Boolean hasHttpHeaders() {
        return this.httpHeaders != null && !this.httpHeaders.isEmpty();
    }

    @Override
    public A addNewHttpHeader(String name, String value) {
        return this.addToHttpHeaders(new HTTPHeader(name, value));
    }

    @Override
    public HTTPGetActionFluent.HttpHeadersNested<A> addNewHttpHeader() {
        return new HttpHeadersNestedImpl();
    }

    @Override
    public HTTPGetActionFluent.HttpHeadersNested<A> addNewHttpHeaderLike(HTTPHeader item) {
        return new HttpHeadersNestedImpl(-1, item);
    }

    @Override
    public HTTPGetActionFluent.HttpHeadersNested<A> setNewHttpHeaderLike(int index, HTTPHeader item) {
        return new HttpHeadersNestedImpl(index, item);
    }

    @Override
    public HTTPGetActionFluent.HttpHeadersNested<A> editHttpHeader(int index) {
        if (this.httpHeaders.size() <= index) {
            throw new RuntimeException("Can't edit httpHeaders. Index exceeds size.");
        }
        return this.setNewHttpHeaderLike(index, this.buildHttpHeader(index));
    }

    @Override
    public HTTPGetActionFluent.HttpHeadersNested<A> editFirstHttpHeader() {
        if (this.httpHeaders.size() == 0) {
            throw new RuntimeException("Can't edit first httpHeaders. The list is empty.");
        }
        return this.setNewHttpHeaderLike(0, this.buildHttpHeader(0));
    }

    @Override
    public HTTPGetActionFluent.HttpHeadersNested<A> editLastHttpHeader() {
        int index = this.httpHeaders.size() - 1;
        if (index < 0) {
            throw new RuntimeException("Can't edit last httpHeaders. The list is empty.");
        }
        return this.setNewHttpHeaderLike(index, this.buildHttpHeader(index));
    }

    @Override
    public HTTPGetActionFluent.HttpHeadersNested<A> editMatchingHttpHeader(Predicate<HTTPHeaderBuilder> predicate) {
        int index = -1;
        for (int i = 0; i < this.httpHeaders.size(); ++i) {
            if (!predicate.test(this.httpHeaders.get(i))) continue;
            index = i;
            break;
        }
        if (index < 0) {
            throw new RuntimeException("Can't edit matching httpHeaders. No match found.");
        }
        return this.setNewHttpHeaderLike(index, this.buildHttpHeader(index));
    }

    @Override
    public String getPath() {
        return this.path;
    }

    @Override
    public A withPath(String path) {
        this.path = path;
        return (A)this;
    }

    @Override
    public Boolean hasPath() {
        return this.path != null;
    }

    @Override
    @Deprecated
    public A withNewPath(String arg0) {
        return this.withPath(new String(arg0));
    }

    @Override
    @Deprecated
    public IntOrString getPort() {
        return this.port != null ? this.port.build() : null;
    }

    @Override
    public IntOrString buildPort() {
        return this.port != null ? this.port.build() : null;
    }

    @Override
    public A withPort(IntOrString port) {
        this._visitables.get("port").remove(this.port);
        if (port != null) {
            this.port = new IntOrStringBuilder(port);
            this._visitables.get("port").add(this.port);
        }
        return (A)this;
    }

    @Override
    public Boolean hasPort() {
        return this.port != null;
    }

    @Override
    public A withNewPort(Integer intVal) {
        return this.withPort(new IntOrString(intVal));
    }

    @Override
    public A withNewPort(String strVal) {
        return this.withPort(new IntOrString(strVal));
    }

    @Override
    public HTTPGetActionFluent.PortNested<A> withNewPort() {
        return new PortNestedImpl();
    }

    @Override
    public HTTPGetActionFluent.PortNested<A> withNewPortLike(IntOrString item) {
        return new PortNestedImpl(item);
    }

    @Override
    public HTTPGetActionFluent.PortNested<A> editPort() {
        return this.withNewPortLike(this.getPort());
    }

    @Override
    public HTTPGetActionFluent.PortNested<A> editOrNewPort() {
        return this.withNewPortLike(this.getPort() != null ? this.getPort() : new IntOrStringBuilder().build());
    }

    @Override
    public HTTPGetActionFluent.PortNested<A> editOrNewPortLike(IntOrString item) {
        return this.withNewPortLike(this.getPort() != null ? this.getPort() : item);
    }

    @Override
    public String getScheme() {
        return this.scheme;
    }

    @Override
    public A withScheme(String scheme) {
        this.scheme = scheme;
        return (A)this;
    }

    @Override
    public Boolean hasScheme() {
        return this.scheme != null;
    }

    @Override
    @Deprecated
    public A withNewScheme(String arg0) {
        return this.withScheme(new String(arg0));
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        HTTPGetActionFluentImpl that = (HTTPGetActionFluentImpl)o;
        if (this.host != null ? !this.host.equals(that.host) : that.host != null) {
            return false;
        }
        if (this.httpHeaders != null ? !this.httpHeaders.equals(that.httpHeaders) : that.httpHeaders != null) {
            return false;
        }
        if (this.path != null ? !this.path.equals(that.path) : that.path != null) {
            return false;
        }
        if (this.port != null ? !this.port.equals(that.port) : that.port != null) {
            return false;
        }
        return !(this.scheme != null ? !this.scheme.equals(that.scheme) : that.scheme != null);
    }

    public int hashCode() {
        return Objects.hash(this.host, this.httpHeaders, this.path, this.port, this.scheme, super.hashCode());
    }

    public class PortNestedImpl<N>
    extends IntOrStringFluentImpl<HTTPGetActionFluent.PortNested<N>>
    implements HTTPGetActionFluent.PortNested<N>,
    Nested<N> {
        private final IntOrStringBuilder builder;

        PortNestedImpl(IntOrString item) {
            this.builder = new IntOrStringBuilder(this, item);
        }

        PortNestedImpl() {
            this.builder = new IntOrStringBuilder(this);
        }

        @Override
        public N and() {
            return (N)HTTPGetActionFluentImpl.this.withPort(this.builder.build());
        }

        @Override
        public N endPort() {
            return this.and();
        }
    }

    public class HttpHeadersNestedImpl<N>
    extends HTTPHeaderFluentImpl<HTTPGetActionFluent.HttpHeadersNested<N>>
    implements HTTPGetActionFluent.HttpHeadersNested<N>,
    Nested<N> {
        private final HTTPHeaderBuilder builder;
        private final int index;

        HttpHeadersNestedImpl(int index, HTTPHeader item) {
            this.index = index;
            this.builder = new HTTPHeaderBuilder(this, item);
        }

        HttpHeadersNestedImpl() {
            this.index = -1;
            this.builder = new HTTPHeaderBuilder(this);
        }

        @Override
        public N and() {
            return (N)HTTPGetActionFluentImpl.this.setToHttpHeaders(this.index, this.builder.build());
        }

        @Override
        public N endHttpHeader() {
            return this.and();
        }
    }
}

