package io.fabric8.kubernetes.api.model.policy.v1;

import io.fabric8.kubernetes.api.model.Condition;
import java.util.ArrayList;
import java.lang.String;
import java.util.LinkedHashMap;
import java.util.function.Predicate;
import java.lang.Integer;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.lang.Long;
import java.util.Collection;
import java.lang.Object;
import java.util.List;
import java.lang.Boolean;
import java.util.Map;

 /**
  * Generated
  */
public class PodDisruptionBudgetStatusFluentImpl<A extends io.fabric8.kubernetes.api.model.policy.v1.PodDisruptionBudgetStatusFluent<A>> extends io.fabric8.kubernetes.api.builder.BaseFluent<A> implements io.fabric8.kubernetes.api.model.policy.v1.PodDisruptionBudgetStatusFluent<A>{
  public PodDisruptionBudgetStatusFluentImpl() {
  }
  public PodDisruptionBudgetStatusFluentImpl(io.fabric8.kubernetes.api.model.policy.v1.PodDisruptionBudgetStatus instance) {
    this.withConditions(instance.getConditions()); 
    this.withCurrentHealthy(instance.getCurrentHealthy()); 
    this.withDesiredHealthy(instance.getDesiredHealthy()); 
    this.withDisruptedPods(instance.getDisruptedPods()); 
    this.withDisruptionsAllowed(instance.getDisruptionsAllowed()); 
    this.withExpectedPods(instance.getExpectedPods()); 
    this.withObservedGeneration(instance.getObservedGeneration()); 
  }
  private java.util.List<io.fabric8.kubernetes.api.model.Condition> conditions = new java.util.ArrayList<io.fabric8.kubernetes.api.model.Condition>();
  private java.lang.Integer currentHealthy;
  private java.lang.Integer desiredHealthy;
  private java.util.Map<java.lang.String,java.lang.String> disruptedPods;
  private java.lang.Integer disruptionsAllowed;
  private java.lang.Integer expectedPods;
  private java.lang.Long observedGeneration;
  public A addToConditions(java.lang.Integer index,io.fabric8.kubernetes.api.model.Condition item) {
    if (this.conditions == null) {this.conditions = new java.util.ArrayList<io.fabric8.kubernetes.api.model.Condition>();}
    this.conditions.add(index, item);
    return (A)this;
  }
  public A setToConditions(java.lang.Integer index,io.fabric8.kubernetes.api.model.Condition item) {
    if (this.conditions == null) {this.conditions = new java.util.ArrayList<io.fabric8.kubernetes.api.model.Condition>();}
    this.conditions.set(index, item); return (A)this;
  }
  public A addToConditions(io.fabric8.kubernetes.api.model.Condition... items) {
    if (this.conditions == null) {this.conditions = new java.util.ArrayList<io.fabric8.kubernetes.api.model.Condition>();}
    for (io.fabric8.kubernetes.api.model.Condition item : items) {this.conditions.add(item);} return (A)this;
  }
  public A addAllToConditions(java.util.Collection<io.fabric8.kubernetes.api.model.Condition> items) {
    if (this.conditions == null) {this.conditions = new java.util.ArrayList<io.fabric8.kubernetes.api.model.Condition>();}
    for (io.fabric8.kubernetes.api.model.Condition item : items) {this.conditions.add(item);} return (A)this;
  }
  public A removeFromConditions(io.fabric8.kubernetes.api.model.Condition... items) {
    for (io.fabric8.kubernetes.api.model.Condition item : items) {if (this.conditions!= null){ this.conditions.remove(item);}} return (A)this;
  }
  public A removeAllFromConditions(java.util.Collection<io.fabric8.kubernetes.api.model.Condition> items) {
    for (io.fabric8.kubernetes.api.model.Condition item : items) {if (this.conditions!= null){ this.conditions.remove(item);}} return (A)this;
  }
  public java.util.List<io.fabric8.kubernetes.api.model.Condition> getConditions() {
    return this.conditions;
  }
  public io.fabric8.kubernetes.api.model.Condition getCondition(java.lang.Integer index) {
    return this.conditions.get(index);
  }
  public io.fabric8.kubernetes.api.model.Condition getFirstCondition() {
    return this.conditions.get(0);
  }
  public io.fabric8.kubernetes.api.model.Condition getLastCondition() {
    return this.conditions.get(conditions.size() - 1);
  }
  public io.fabric8.kubernetes.api.model.Condition getMatchingCondition(java.util.function.Predicate<io.fabric8.kubernetes.api.model.Condition> predicate) {
    for (io.fabric8.kubernetes.api.model.Condition item: conditions) { if(predicate.test(item)){ return item;} } return null;
  }
  public java.lang.Boolean hasMatchingCondition(java.util.function.Predicate<io.fabric8.kubernetes.api.model.Condition> predicate) {
    for (io.fabric8.kubernetes.api.model.Condition item: conditions) { if(predicate.test(item)){ return true;} } return false;
  }
  public A withConditions(java.util.List<io.fabric8.kubernetes.api.model.Condition> conditions) {
    if (conditions != null) {this.conditions = new java.util.ArrayList<io.fabric8.kubernetes.api.model.Condition>(); for (io.fabric8.kubernetes.api.model.Condition item : conditions){this.addToConditions(item);}} else { this.conditions = null;} return (A) this;
  }
  public A withConditions(io.fabric8.kubernetes.api.model.Condition... conditions) {
    if (this.conditions != null) {this.conditions.clear();}
    if (conditions != null) {for (io.fabric8.kubernetes.api.model.Condition item :conditions){ this.addToConditions(item);}} return (A) this;
  }
  public java.lang.Boolean hasConditions() {
    return conditions != null && !conditions.isEmpty();
  }
  public java.lang.Integer getCurrentHealthy() {
    return this.currentHealthy;
  }
  public A withCurrentHealthy(java.lang.Integer currentHealthy) {
    this.currentHealthy=currentHealthy; return (A) this;
  }
  public java.lang.Boolean hasCurrentHealthy() {
    return this.currentHealthy != null;
  }
  public java.lang.Integer getDesiredHealthy() {
    return this.desiredHealthy;
  }
  public A withDesiredHealthy(java.lang.Integer desiredHealthy) {
    this.desiredHealthy=desiredHealthy; return (A) this;
  }
  public java.lang.Boolean hasDesiredHealthy() {
    return this.desiredHealthy != null;
  }
  public A addToDisruptedPods(java.lang.String key,java.lang.String value) {
    if(this.disruptedPods == null && key != null && value != null) { this.disruptedPods = new java.util.LinkedHashMap<java.lang.String,java.lang.String>(); }
    if(key != null && value != null) {this.disruptedPods.put(key, value);} return (A)this;
  }
  public A addToDisruptedPods(java.util.Map<java.lang.String,java.lang.String> map) {
    if(this.disruptedPods == null && map != null) { this.disruptedPods = new java.util.LinkedHashMap<java.lang.String,java.lang.String>(); }
    if(map != null) { this.disruptedPods.putAll(map);} return (A)this;
  }
  public A removeFromDisruptedPods(java.lang.String key) {
    if(this.disruptedPods == null) { return (A) this; }
    if(key != null && this.disruptedPods != null) {this.disruptedPods.remove(key);} return (A)this;
  }
  public A removeFromDisruptedPods(java.util.Map<java.lang.String,java.lang.String> map) {
    if(this.disruptedPods == null) { return (A) this; }
    if(map != null) { for(Object key : map.keySet()) {if (this.disruptedPods != null){this.disruptedPods.remove(key);}}} return (A)this;
  }
  public java.util.Map<java.lang.String,java.lang.String> getDisruptedPods() {
    return this.disruptedPods;
  }
  public <K,V>A withDisruptedPods(java.util.Map<java.lang.String,java.lang.String> disruptedPods) {
    if (disruptedPods == null) { this.disruptedPods =  null;} else {this.disruptedPods = new java.util.LinkedHashMap<java.lang.String,java.lang.String>(disruptedPods);} return (A) this;
  }
  public java.lang.Boolean hasDisruptedPods() {
    return this.disruptedPods != null;
  }
  public java.lang.Integer getDisruptionsAllowed() {
    return this.disruptionsAllowed;
  }
  public A withDisruptionsAllowed(java.lang.Integer disruptionsAllowed) {
    this.disruptionsAllowed=disruptionsAllowed; return (A) this;
  }
  public java.lang.Boolean hasDisruptionsAllowed() {
    return this.disruptionsAllowed != null;
  }
  public java.lang.Integer getExpectedPods() {
    return this.expectedPods;
  }
  public A withExpectedPods(java.lang.Integer expectedPods) {
    this.expectedPods=expectedPods; return (A) this;
  }
  public java.lang.Boolean hasExpectedPods() {
    return this.expectedPods != null;
  }
  public java.lang.Long getObservedGeneration() {
    return this.observedGeneration;
  }
  public A withObservedGeneration(java.lang.Long observedGeneration) {
    this.observedGeneration=observedGeneration; return (A) this;
  }
  public java.lang.Boolean hasObservedGeneration() {
    return this.observedGeneration != null;
  }
  public boolean equals(java.lang.Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    PodDisruptionBudgetStatusFluentImpl that = (PodDisruptionBudgetStatusFluentImpl) o;
    if (conditions != null ? !conditions.equals(that.conditions) :that.conditions != null) return false;
    if (currentHealthy != null ? !currentHealthy.equals(that.currentHealthy) :that.currentHealthy != null) return false;
    if (desiredHealthy != null ? !desiredHealthy.equals(that.desiredHealthy) :that.desiredHealthy != null) return false;
    if (disruptedPods != null ? !disruptedPods.equals(that.disruptedPods) :that.disruptedPods != null) return false;
    if (disruptionsAllowed != null ? !disruptionsAllowed.equals(that.disruptionsAllowed) :that.disruptionsAllowed != null) return false;
    if (expectedPods != null ? !expectedPods.equals(that.expectedPods) :that.expectedPods != null) return false;
    if (observedGeneration != null ? !observedGeneration.equals(that.observedGeneration) :that.observedGeneration != null) return false;
    return true;
  }
  public int hashCode() {
    return java.util.Objects.hash(conditions,  currentHealthy,  desiredHealthy,  disruptedPods,  disruptionsAllowed,  expectedPods,  observedGeneration,  super.hashCode());
  }
  
}