package io.fabric8.kubernetes.api.model.policy.v1beta1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.util.ArrayList;
import java.lang.String;
import java.util.function.Predicate;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.util.List;
import java.lang.Boolean;
import java.util.Collection;
import java.lang.Object;
import io.fabric8.kubernetes.api.builder.Nested;
import java.lang.Deprecated;
import java.util.Iterator;
import java.lang.Integer;

 /**
  * Generated
  */
public class PodSecurityPolicySpecFluentImpl<A extends io.fabric8.kubernetes.api.model.policy.v1beta1.PodSecurityPolicySpecFluent<A>> extends io.fabric8.kubernetes.api.builder.BaseFluent<A> implements io.fabric8.kubernetes.api.model.policy.v1beta1.PodSecurityPolicySpecFluent<A>{
  public PodSecurityPolicySpecFluentImpl() {
  }
  public PodSecurityPolicySpecFluentImpl(io.fabric8.kubernetes.api.model.policy.v1beta1.PodSecurityPolicySpec instance) {
    this.withAllowPrivilegeEscalation(instance.getAllowPrivilegeEscalation()); 
    this.withAllowedCSIDrivers(instance.getAllowedCSIDrivers()); 
    this.withAllowedCapabilities(instance.getAllowedCapabilities()); 
    this.withAllowedFlexVolumes(instance.getAllowedFlexVolumes()); 
    this.withAllowedHostPaths(instance.getAllowedHostPaths()); 
    this.withAllowedProcMountTypes(instance.getAllowedProcMountTypes()); 
    this.withAllowedUnsafeSysctls(instance.getAllowedUnsafeSysctls()); 
    this.withDefaultAddCapabilities(instance.getDefaultAddCapabilities()); 
    this.withDefaultAllowPrivilegeEscalation(instance.getDefaultAllowPrivilegeEscalation()); 
    this.withForbiddenSysctls(instance.getForbiddenSysctls()); 
    this.withFsGroup(instance.getFsGroup()); 
    this.withHostIPC(instance.getHostIPC()); 
    this.withHostNetwork(instance.getHostNetwork()); 
    this.withHostPID(instance.getHostPID()); 
    this.withHostPorts(instance.getHostPorts()); 
    this.withPrivileged(instance.getPrivileged()); 
    this.withReadOnlyRootFilesystem(instance.getReadOnlyRootFilesystem()); 
    this.withRequiredDropCapabilities(instance.getRequiredDropCapabilities()); 
    this.withRunAsGroup(instance.getRunAsGroup()); 
    this.withRunAsUser(instance.getRunAsUser()); 
    this.withRuntimeClass(instance.getRuntimeClass()); 
    this.withSeLinux(instance.getSeLinux()); 
    this.withSupplementalGroups(instance.getSupplementalGroups()); 
    this.withVolumes(instance.getVolumes()); 
  }
  private java.lang.Boolean allowPrivilegeEscalation;
  private java.util.List<io.fabric8.kubernetes.api.model.policy.v1beta1.AllowedCSIDriverBuilder> allowedCSIDrivers =  new java.util.ArrayList<io.fabric8.kubernetes.api.model.policy.v1beta1.AllowedCSIDriverBuilder>();
  private java.util.List<java.lang.String> allowedCapabilities = new java.util.ArrayList<java.lang.String>();
  private java.util.List<io.fabric8.kubernetes.api.model.policy.v1beta1.AllowedFlexVolumeBuilder> allowedFlexVolumes =  new java.util.ArrayList<io.fabric8.kubernetes.api.model.policy.v1beta1.AllowedFlexVolumeBuilder>();
  private java.util.List<io.fabric8.kubernetes.api.model.policy.v1beta1.AllowedHostPathBuilder> allowedHostPaths =  new java.util.ArrayList<io.fabric8.kubernetes.api.model.policy.v1beta1.AllowedHostPathBuilder>();
  private java.util.List<java.lang.String> allowedProcMountTypes = new java.util.ArrayList<java.lang.String>();
  private java.util.List<java.lang.String> allowedUnsafeSysctls = new java.util.ArrayList<java.lang.String>();
  private java.util.List<java.lang.String> defaultAddCapabilities = new java.util.ArrayList<java.lang.String>();
  private java.lang.Boolean defaultAllowPrivilegeEscalation;
  private java.util.List<java.lang.String> forbiddenSysctls = new java.util.ArrayList<java.lang.String>();
  private io.fabric8.kubernetes.api.model.policy.v1beta1.FSGroupStrategyOptionsBuilder fsGroup;
  private java.lang.Boolean hostIPC;
  private java.lang.Boolean hostNetwork;
  private java.lang.Boolean hostPID;
  private java.util.List<io.fabric8.kubernetes.api.model.policy.v1beta1.HostPortRangeBuilder> hostPorts =  new java.util.ArrayList<io.fabric8.kubernetes.api.model.policy.v1beta1.HostPortRangeBuilder>();
  private java.lang.Boolean privileged;
  private java.lang.Boolean readOnlyRootFilesystem;
  private java.util.List<java.lang.String> requiredDropCapabilities = new java.util.ArrayList<java.lang.String>();
  private io.fabric8.kubernetes.api.model.policy.v1beta1.RunAsGroupStrategyOptionsBuilder runAsGroup;
  private io.fabric8.kubernetes.api.model.policy.v1beta1.RunAsUserStrategyOptionsBuilder runAsUser;
  private io.fabric8.kubernetes.api.model.policy.v1beta1.RuntimeClassStrategyOptionsBuilder runtimeClass;
  private io.fabric8.kubernetes.api.model.policy.v1beta1.SELinuxStrategyOptionsBuilder seLinux;
  private io.fabric8.kubernetes.api.model.policy.v1beta1.SupplementalGroupsStrategyOptionsBuilder supplementalGroups;
  private java.util.List<java.lang.String> volumes = new java.util.ArrayList<java.lang.String>();
  public java.lang.Boolean getAllowPrivilegeEscalation() {
    return this.allowPrivilegeEscalation;
  }
  public A withAllowPrivilegeEscalation(java.lang.Boolean allowPrivilegeEscalation) {
    this.allowPrivilegeEscalation=allowPrivilegeEscalation; return (A) this;
  }
  public java.lang.Boolean hasAllowPrivilegeEscalation() {
    return this.allowPrivilegeEscalation != null;
  }
  public A addToAllowedCSIDrivers(java.lang.Integer index,io.fabric8.kubernetes.api.model.policy.v1beta1.AllowedCSIDriver item) {
    if (this.allowedCSIDrivers == null) {this.allowedCSIDrivers = new java.util.ArrayList<io.fabric8.kubernetes.api.model.policy.v1beta1.AllowedCSIDriverBuilder>();}
    io.fabric8.kubernetes.api.model.policy.v1beta1.AllowedCSIDriverBuilder builder = new io.fabric8.kubernetes.api.model.policy.v1beta1.AllowedCSIDriverBuilder(item);_visitables.get("allowedCSIDrivers").add(index >= 0 ? index : _visitables.get("allowedCSIDrivers").size(), builder);this.allowedCSIDrivers.add(index >= 0 ? index : allowedCSIDrivers.size(), builder); return (A)this;
  }
  public A setToAllowedCSIDrivers(java.lang.Integer index,io.fabric8.kubernetes.api.model.policy.v1beta1.AllowedCSIDriver item) {
    if (this.allowedCSIDrivers == null) {this.allowedCSIDrivers = new java.util.ArrayList<io.fabric8.kubernetes.api.model.policy.v1beta1.AllowedCSIDriverBuilder>();}
    io.fabric8.kubernetes.api.model.policy.v1beta1.AllowedCSIDriverBuilder builder = new io.fabric8.kubernetes.api.model.policy.v1beta1.AllowedCSIDriverBuilder(item);
    if (index < 0 || index >= _visitables.get("allowedCSIDrivers").size()) { _visitables.get("allowedCSIDrivers").add(builder); } else { _visitables.get("allowedCSIDrivers").set(index, builder);}
    if (index < 0 || index >= allowedCSIDrivers.size()) { allowedCSIDrivers.add(builder); } else { allowedCSIDrivers.set(index, builder);}
     return (A)this;
  }
  public A addToAllowedCSIDrivers(io.fabric8.kubernetes.api.model.policy.v1beta1.AllowedCSIDriver... items) {
    if (this.allowedCSIDrivers == null) {this.allowedCSIDrivers = new java.util.ArrayList<io.fabric8.kubernetes.api.model.policy.v1beta1.AllowedCSIDriverBuilder>();}
    for (io.fabric8.kubernetes.api.model.policy.v1beta1.AllowedCSIDriver item : items) {io.fabric8.kubernetes.api.model.policy.v1beta1.AllowedCSIDriverBuilder builder = new io.fabric8.kubernetes.api.model.policy.v1beta1.AllowedCSIDriverBuilder(item);_visitables.get("allowedCSIDrivers").add(builder);this.allowedCSIDrivers.add(builder);} return (A)this;
  }
  public A addAllToAllowedCSIDrivers(java.util.Collection<io.fabric8.kubernetes.api.model.policy.v1beta1.AllowedCSIDriver> items) {
    if (this.allowedCSIDrivers == null) {this.allowedCSIDrivers = new java.util.ArrayList<io.fabric8.kubernetes.api.model.policy.v1beta1.AllowedCSIDriverBuilder>();}
    for (io.fabric8.kubernetes.api.model.policy.v1beta1.AllowedCSIDriver item : items) {io.fabric8.kubernetes.api.model.policy.v1beta1.AllowedCSIDriverBuilder builder = new io.fabric8.kubernetes.api.model.policy.v1beta1.AllowedCSIDriverBuilder(item);_visitables.get("allowedCSIDrivers").add(builder);this.allowedCSIDrivers.add(builder);} return (A)this;
  }
  public A removeFromAllowedCSIDrivers(io.fabric8.kubernetes.api.model.policy.v1beta1.AllowedCSIDriver... items) {
    for (io.fabric8.kubernetes.api.model.policy.v1beta1.AllowedCSIDriver item : items) {io.fabric8.kubernetes.api.model.policy.v1beta1.AllowedCSIDriverBuilder builder = new io.fabric8.kubernetes.api.model.policy.v1beta1.AllowedCSIDriverBuilder(item);_visitables.get("allowedCSIDrivers").remove(builder);if (this.allowedCSIDrivers != null) {this.allowedCSIDrivers.remove(builder);}} return (A)this;
  }
  public A removeAllFromAllowedCSIDrivers(java.util.Collection<io.fabric8.kubernetes.api.model.policy.v1beta1.AllowedCSIDriver> items) {
    for (io.fabric8.kubernetes.api.model.policy.v1beta1.AllowedCSIDriver item : items) {io.fabric8.kubernetes.api.model.policy.v1beta1.AllowedCSIDriverBuilder builder = new io.fabric8.kubernetes.api.model.policy.v1beta1.AllowedCSIDriverBuilder(item);_visitables.get("allowedCSIDrivers").remove(builder);if (this.allowedCSIDrivers != null) {this.allowedCSIDrivers.remove(builder);}} return (A)this;
  }
  public A removeMatchingFromAllowedCSIDrivers(java.util.function.Predicate<io.fabric8.kubernetes.api.model.policy.v1beta1.AllowedCSIDriverBuilder> predicate) {
    if (allowedCSIDrivers == null) return (A) this;
    final Iterator<io.fabric8.kubernetes.api.model.policy.v1beta1.AllowedCSIDriverBuilder> each = allowedCSIDrivers.iterator();
    final List visitables = _visitables.get("allowedCSIDrivers");
    while (each.hasNext()) {
      io.fabric8.kubernetes.api.model.policy.v1beta1.AllowedCSIDriverBuilder builder = each.next();
      if (predicate.test(builder)) {
        visitables.remove(builder);
        each.remove();
      }
    }
    return (A)this;
  }
  
  /**
   * This method has been deprecated, please use method buildAllowedCSIDrivers instead.
   * @return The buildable object.
   */
  @java.lang.Deprecated
  public java.util.List<io.fabric8.kubernetes.api.model.policy.v1beta1.AllowedCSIDriver> getAllowedCSIDrivers() {
    return build(allowedCSIDrivers);
  }
  public java.util.List<io.fabric8.kubernetes.api.model.policy.v1beta1.AllowedCSIDriver> buildAllowedCSIDrivers() {
    return build(allowedCSIDrivers);
  }
  public io.fabric8.kubernetes.api.model.policy.v1beta1.AllowedCSIDriver buildAllowedCSIDriver(java.lang.Integer index) {
    return this.allowedCSIDrivers.get(index).build();
  }
  public io.fabric8.kubernetes.api.model.policy.v1beta1.AllowedCSIDriver buildFirstAllowedCSIDriver() {
    return this.allowedCSIDrivers.get(0).build();
  }
  public io.fabric8.kubernetes.api.model.policy.v1beta1.AllowedCSIDriver buildLastAllowedCSIDriver() {
    return this.allowedCSIDrivers.get(allowedCSIDrivers.size() - 1).build();
  }
  public io.fabric8.kubernetes.api.model.policy.v1beta1.AllowedCSIDriver buildMatchingAllowedCSIDriver(java.util.function.Predicate<io.fabric8.kubernetes.api.model.policy.v1beta1.AllowedCSIDriverBuilder> predicate) {
    for (io.fabric8.kubernetes.api.model.policy.v1beta1.AllowedCSIDriverBuilder item: allowedCSIDrivers) { if(predicate.test(item)){ return item.build();} } return null;
  }
  public java.lang.Boolean hasMatchingAllowedCSIDriver(java.util.function.Predicate<io.fabric8.kubernetes.api.model.policy.v1beta1.AllowedCSIDriverBuilder> predicate) {
    for (io.fabric8.kubernetes.api.model.policy.v1beta1.AllowedCSIDriverBuilder item: allowedCSIDrivers) { if(predicate.test(item)){ return true;} } return false;
  }
  public A withAllowedCSIDrivers(java.util.List<io.fabric8.kubernetes.api.model.policy.v1beta1.AllowedCSIDriver> allowedCSIDrivers) {
    if (this.allowedCSIDrivers != null) { _visitables.get("allowedCSIDrivers").removeAll(this.allowedCSIDrivers);}
    if (allowedCSIDrivers != null) {this.allowedCSIDrivers = new java.util.ArrayList<io.fabric8.kubernetes.api.model.policy.v1beta1.AllowedCSIDriverBuilder>(); for (io.fabric8.kubernetes.api.model.policy.v1beta1.AllowedCSIDriver item : allowedCSIDrivers){this.addToAllowedCSIDrivers(item);}} else { this.allowedCSIDrivers = null;} return (A) this;
  }
  public A withAllowedCSIDrivers(io.fabric8.kubernetes.api.model.policy.v1beta1.AllowedCSIDriver... allowedCSIDrivers) {
    if (this.allowedCSIDrivers != null) {this.allowedCSIDrivers.clear();}
    if (allowedCSIDrivers != null) {for (io.fabric8.kubernetes.api.model.policy.v1beta1.AllowedCSIDriver item :allowedCSIDrivers){ this.addToAllowedCSIDrivers(item);}} return (A) this;
  }
  public java.lang.Boolean hasAllowedCSIDrivers() {
    return allowedCSIDrivers != null && !allowedCSIDrivers.isEmpty();
  }
  public A addNewAllowedCSIDriver(java.lang.String name) {
    return (A)addToAllowedCSIDrivers(new AllowedCSIDriver(name));
  }
  public io.fabric8.kubernetes.api.model.policy.v1beta1.PodSecurityPolicySpecFluent.AllowedCSIDriversNested<A> addNewAllowedCSIDriver() {
    return new io.fabric8.kubernetes.api.model.policy.v1beta1.PodSecurityPolicySpecFluentImpl.AllowedCSIDriversNestedImpl();
  }
  public io.fabric8.kubernetes.api.model.policy.v1beta1.PodSecurityPolicySpecFluent.AllowedCSIDriversNested<A> addNewAllowedCSIDriverLike(io.fabric8.kubernetes.api.model.policy.v1beta1.AllowedCSIDriver item) {
    return new io.fabric8.kubernetes.api.model.policy.v1beta1.PodSecurityPolicySpecFluentImpl.AllowedCSIDriversNestedImpl(-1, item);
  }
  public io.fabric8.kubernetes.api.model.policy.v1beta1.PodSecurityPolicySpecFluent.AllowedCSIDriversNested<A> setNewAllowedCSIDriverLike(java.lang.Integer index,io.fabric8.kubernetes.api.model.policy.v1beta1.AllowedCSIDriver item) {
    return new io.fabric8.kubernetes.api.model.policy.v1beta1.PodSecurityPolicySpecFluentImpl.AllowedCSIDriversNestedImpl(index, item);
  }
  public io.fabric8.kubernetes.api.model.policy.v1beta1.PodSecurityPolicySpecFluent.AllowedCSIDriversNested<A> editAllowedCSIDriver(java.lang.Integer index) {
    if (allowedCSIDrivers.size() <= index) throw new RuntimeException("Can't edit allowedCSIDrivers. Index exceeds size.");
    return setNewAllowedCSIDriverLike(index, buildAllowedCSIDriver(index));
  }
  public io.fabric8.kubernetes.api.model.policy.v1beta1.PodSecurityPolicySpecFluent.AllowedCSIDriversNested<A> editFirstAllowedCSIDriver() {
    if (allowedCSIDrivers.size() == 0) throw new RuntimeException("Can't edit first allowedCSIDrivers. The list is empty.");
    return setNewAllowedCSIDriverLike(0, buildAllowedCSIDriver(0));
  }
  public io.fabric8.kubernetes.api.model.policy.v1beta1.PodSecurityPolicySpecFluent.AllowedCSIDriversNested<A> editLastAllowedCSIDriver() {
    int index = allowedCSIDrivers.size() - 1;
    if (index < 0) throw new RuntimeException("Can't edit last allowedCSIDrivers. The list is empty.");
    return setNewAllowedCSIDriverLike(index, buildAllowedCSIDriver(index));
  }
  public io.fabric8.kubernetes.api.model.policy.v1beta1.PodSecurityPolicySpecFluent.AllowedCSIDriversNested<A> editMatchingAllowedCSIDriver(java.util.function.Predicate<io.fabric8.kubernetes.api.model.policy.v1beta1.AllowedCSIDriverBuilder> predicate) {
    int index = -1;
    for (int i=0;i<allowedCSIDrivers.size();i++) { 
    if (predicate.test(allowedCSIDrivers.get(i))) {index = i; break;}
    } 
    if (index < 0) throw new RuntimeException("Can't edit matching allowedCSIDrivers. No match found.");
    return setNewAllowedCSIDriverLike(index, buildAllowedCSIDriver(index));
  }
  public A addToAllowedCapabilities(java.lang.Integer index,java.lang.String item) {
    if (this.allowedCapabilities == null) {this.allowedCapabilities = new java.util.ArrayList<java.lang.String>();}
    this.allowedCapabilities.add(index, item);
    return (A)this;
  }
  public A setToAllowedCapabilities(java.lang.Integer index,java.lang.String item) {
    if (this.allowedCapabilities == null) {this.allowedCapabilities = new java.util.ArrayList<java.lang.String>();}
    this.allowedCapabilities.set(index, item); return (A)this;
  }
  public A addToAllowedCapabilities(java.lang.String... items) {
    if (this.allowedCapabilities == null) {this.allowedCapabilities = new java.util.ArrayList<java.lang.String>();}
    for (java.lang.String item : items) {this.allowedCapabilities.add(item);} return (A)this;
  }
  public A addAllToAllowedCapabilities(java.util.Collection<java.lang.String> items) {
    if (this.allowedCapabilities == null) {this.allowedCapabilities = new java.util.ArrayList<java.lang.String>();}
    for (java.lang.String item : items) {this.allowedCapabilities.add(item);} return (A)this;
  }
  public A removeFromAllowedCapabilities(java.lang.String... items) {
    for (java.lang.String item : items) {if (this.allowedCapabilities!= null){ this.allowedCapabilities.remove(item);}} return (A)this;
  }
  public A removeAllFromAllowedCapabilities(java.util.Collection<java.lang.String> items) {
    for (java.lang.String item : items) {if (this.allowedCapabilities!= null){ this.allowedCapabilities.remove(item);}} return (A)this;
  }
  public java.util.List<java.lang.String> getAllowedCapabilities() {
    return this.allowedCapabilities;
  }
  public java.lang.String getAllowedCapability(java.lang.Integer index) {
    return this.allowedCapabilities.get(index);
  }
  public java.lang.String getFirstAllowedCapability() {
    return this.allowedCapabilities.get(0);
  }
  public java.lang.String getLastAllowedCapability() {
    return this.allowedCapabilities.get(allowedCapabilities.size() - 1);
  }
  public java.lang.String getMatchingAllowedCapability(java.util.function.Predicate<java.lang.String> predicate) {
    for (java.lang.String item: allowedCapabilities) { if(predicate.test(item)){ return item;} } return null;
  }
  public java.lang.Boolean hasMatchingAllowedCapability(java.util.function.Predicate<java.lang.String> predicate) {
    for (java.lang.String item: allowedCapabilities) { if(predicate.test(item)){ return true;} } return false;
  }
  public A withAllowedCapabilities(java.util.List<java.lang.String> allowedCapabilities) {
    if (allowedCapabilities != null) {this.allowedCapabilities = new java.util.ArrayList<java.lang.String>(); for (java.lang.String item : allowedCapabilities){this.addToAllowedCapabilities(item);}} else { this.allowedCapabilities = null;} return (A) this;
  }
  public A withAllowedCapabilities(java.lang.String... allowedCapabilities) {
    if (this.allowedCapabilities != null) {this.allowedCapabilities.clear();}
    if (allowedCapabilities != null) {for (java.lang.String item :allowedCapabilities){ this.addToAllowedCapabilities(item);}} return (A) this;
  }
  public java.lang.Boolean hasAllowedCapabilities() {
    return allowedCapabilities != null && !allowedCapabilities.isEmpty();
  }
  public A addNewAllowedCapability(java.lang.String arg0) {
    return (A)addToAllowedCapabilities(new String(arg0));
  }
  public A addToAllowedFlexVolumes(java.lang.Integer index,io.fabric8.kubernetes.api.model.policy.v1beta1.AllowedFlexVolume item) {
    if (this.allowedFlexVolumes == null) {this.allowedFlexVolumes = new java.util.ArrayList<io.fabric8.kubernetes.api.model.policy.v1beta1.AllowedFlexVolumeBuilder>();}
    io.fabric8.kubernetes.api.model.policy.v1beta1.AllowedFlexVolumeBuilder builder = new io.fabric8.kubernetes.api.model.policy.v1beta1.AllowedFlexVolumeBuilder(item);_visitables.get("allowedFlexVolumes").add(index >= 0 ? index : _visitables.get("allowedFlexVolumes").size(), builder);this.allowedFlexVolumes.add(index >= 0 ? index : allowedFlexVolumes.size(), builder); return (A)this;
  }
  public A setToAllowedFlexVolumes(java.lang.Integer index,io.fabric8.kubernetes.api.model.policy.v1beta1.AllowedFlexVolume item) {
    if (this.allowedFlexVolumes == null) {this.allowedFlexVolumes = new java.util.ArrayList<io.fabric8.kubernetes.api.model.policy.v1beta1.AllowedFlexVolumeBuilder>();}
    io.fabric8.kubernetes.api.model.policy.v1beta1.AllowedFlexVolumeBuilder builder = new io.fabric8.kubernetes.api.model.policy.v1beta1.AllowedFlexVolumeBuilder(item);
    if (index < 0 || index >= _visitables.get("allowedFlexVolumes").size()) { _visitables.get("allowedFlexVolumes").add(builder); } else { _visitables.get("allowedFlexVolumes").set(index, builder);}
    if (index < 0 || index >= allowedFlexVolumes.size()) { allowedFlexVolumes.add(builder); } else { allowedFlexVolumes.set(index, builder);}
     return (A)this;
  }
  public A addToAllowedFlexVolumes(io.fabric8.kubernetes.api.model.policy.v1beta1.AllowedFlexVolume... items) {
    if (this.allowedFlexVolumes == null) {this.allowedFlexVolumes = new java.util.ArrayList<io.fabric8.kubernetes.api.model.policy.v1beta1.AllowedFlexVolumeBuilder>();}
    for (io.fabric8.kubernetes.api.model.policy.v1beta1.AllowedFlexVolume item : items) {io.fabric8.kubernetes.api.model.policy.v1beta1.AllowedFlexVolumeBuilder builder = new io.fabric8.kubernetes.api.model.policy.v1beta1.AllowedFlexVolumeBuilder(item);_visitables.get("allowedFlexVolumes").add(builder);this.allowedFlexVolumes.add(builder);} return (A)this;
  }
  public A addAllToAllowedFlexVolumes(java.util.Collection<io.fabric8.kubernetes.api.model.policy.v1beta1.AllowedFlexVolume> items) {
    if (this.allowedFlexVolumes == null) {this.allowedFlexVolumes = new java.util.ArrayList<io.fabric8.kubernetes.api.model.policy.v1beta1.AllowedFlexVolumeBuilder>();}
    for (io.fabric8.kubernetes.api.model.policy.v1beta1.AllowedFlexVolume item : items) {io.fabric8.kubernetes.api.model.policy.v1beta1.AllowedFlexVolumeBuilder builder = new io.fabric8.kubernetes.api.model.policy.v1beta1.AllowedFlexVolumeBuilder(item);_visitables.get("allowedFlexVolumes").add(builder);this.allowedFlexVolumes.add(builder);} return (A)this;
  }
  public A removeFromAllowedFlexVolumes(io.fabric8.kubernetes.api.model.policy.v1beta1.AllowedFlexVolume... items) {
    for (io.fabric8.kubernetes.api.model.policy.v1beta1.AllowedFlexVolume item : items) {io.fabric8.kubernetes.api.model.policy.v1beta1.AllowedFlexVolumeBuilder builder = new io.fabric8.kubernetes.api.model.policy.v1beta1.AllowedFlexVolumeBuilder(item);_visitables.get("allowedFlexVolumes").remove(builder);if (this.allowedFlexVolumes != null) {this.allowedFlexVolumes.remove(builder);}} return (A)this;
  }
  public A removeAllFromAllowedFlexVolumes(java.util.Collection<io.fabric8.kubernetes.api.model.policy.v1beta1.AllowedFlexVolume> items) {
    for (io.fabric8.kubernetes.api.model.policy.v1beta1.AllowedFlexVolume item : items) {io.fabric8.kubernetes.api.model.policy.v1beta1.AllowedFlexVolumeBuilder builder = new io.fabric8.kubernetes.api.model.policy.v1beta1.AllowedFlexVolumeBuilder(item);_visitables.get("allowedFlexVolumes").remove(builder);if (this.allowedFlexVolumes != null) {this.allowedFlexVolumes.remove(builder);}} return (A)this;
  }
  public A removeMatchingFromAllowedFlexVolumes(java.util.function.Predicate<io.fabric8.kubernetes.api.model.policy.v1beta1.AllowedFlexVolumeBuilder> predicate) {
    if (allowedFlexVolumes == null) return (A) this;
    final Iterator<io.fabric8.kubernetes.api.model.policy.v1beta1.AllowedFlexVolumeBuilder> each = allowedFlexVolumes.iterator();
    final List visitables = _visitables.get("allowedFlexVolumes");
    while (each.hasNext()) {
      io.fabric8.kubernetes.api.model.policy.v1beta1.AllowedFlexVolumeBuilder builder = each.next();
      if (predicate.test(builder)) {
        visitables.remove(builder);
        each.remove();
      }
    }
    return (A)this;
  }
  
  /**
   * This method has been deprecated, please use method buildAllowedFlexVolumes instead.
   * @return The buildable object.
   */
  @java.lang.Deprecated
  public java.util.List<io.fabric8.kubernetes.api.model.policy.v1beta1.AllowedFlexVolume> getAllowedFlexVolumes() {
    return build(allowedFlexVolumes);
  }
  public java.util.List<io.fabric8.kubernetes.api.model.policy.v1beta1.AllowedFlexVolume> buildAllowedFlexVolumes() {
    return build(allowedFlexVolumes);
  }
  public io.fabric8.kubernetes.api.model.policy.v1beta1.AllowedFlexVolume buildAllowedFlexVolume(java.lang.Integer index) {
    return this.allowedFlexVolumes.get(index).build();
  }
  public io.fabric8.kubernetes.api.model.policy.v1beta1.AllowedFlexVolume buildFirstAllowedFlexVolume() {
    return this.allowedFlexVolumes.get(0).build();
  }
  public io.fabric8.kubernetes.api.model.policy.v1beta1.AllowedFlexVolume buildLastAllowedFlexVolume() {
    return this.allowedFlexVolumes.get(allowedFlexVolumes.size() - 1).build();
  }
  public io.fabric8.kubernetes.api.model.policy.v1beta1.AllowedFlexVolume buildMatchingAllowedFlexVolume(java.util.function.Predicate<io.fabric8.kubernetes.api.model.policy.v1beta1.AllowedFlexVolumeBuilder> predicate) {
    for (io.fabric8.kubernetes.api.model.policy.v1beta1.AllowedFlexVolumeBuilder item: allowedFlexVolumes) { if(predicate.test(item)){ return item.build();} } return null;
  }
  public java.lang.Boolean hasMatchingAllowedFlexVolume(java.util.function.Predicate<io.fabric8.kubernetes.api.model.policy.v1beta1.AllowedFlexVolumeBuilder> predicate) {
    for (io.fabric8.kubernetes.api.model.policy.v1beta1.AllowedFlexVolumeBuilder item: allowedFlexVolumes) { if(predicate.test(item)){ return true;} } return false;
  }
  public A withAllowedFlexVolumes(java.util.List<io.fabric8.kubernetes.api.model.policy.v1beta1.AllowedFlexVolume> allowedFlexVolumes) {
    if (this.allowedFlexVolumes != null) { _visitables.get("allowedFlexVolumes").removeAll(this.allowedFlexVolumes);}
    if (allowedFlexVolumes != null) {this.allowedFlexVolumes = new java.util.ArrayList<io.fabric8.kubernetes.api.model.policy.v1beta1.AllowedFlexVolumeBuilder>(); for (io.fabric8.kubernetes.api.model.policy.v1beta1.AllowedFlexVolume item : allowedFlexVolumes){this.addToAllowedFlexVolumes(item);}} else { this.allowedFlexVolumes = null;} return (A) this;
  }
  public A withAllowedFlexVolumes(io.fabric8.kubernetes.api.model.policy.v1beta1.AllowedFlexVolume... allowedFlexVolumes) {
    if (this.allowedFlexVolumes != null) {this.allowedFlexVolumes.clear();}
    if (allowedFlexVolumes != null) {for (io.fabric8.kubernetes.api.model.policy.v1beta1.AllowedFlexVolume item :allowedFlexVolumes){ this.addToAllowedFlexVolumes(item);}} return (A) this;
  }
  public java.lang.Boolean hasAllowedFlexVolumes() {
    return allowedFlexVolumes != null && !allowedFlexVolumes.isEmpty();
  }
  public A addNewAllowedFlexVolume(java.lang.String driver) {
    return (A)addToAllowedFlexVolumes(new AllowedFlexVolume(driver));
  }
  public io.fabric8.kubernetes.api.model.policy.v1beta1.PodSecurityPolicySpecFluent.AllowedFlexVolumesNested<A> addNewAllowedFlexVolume() {
    return new io.fabric8.kubernetes.api.model.policy.v1beta1.PodSecurityPolicySpecFluentImpl.AllowedFlexVolumesNestedImpl();
  }
  public io.fabric8.kubernetes.api.model.policy.v1beta1.PodSecurityPolicySpecFluent.AllowedFlexVolumesNested<A> addNewAllowedFlexVolumeLike(io.fabric8.kubernetes.api.model.policy.v1beta1.AllowedFlexVolume item) {
    return new io.fabric8.kubernetes.api.model.policy.v1beta1.PodSecurityPolicySpecFluentImpl.AllowedFlexVolumesNestedImpl(-1, item);
  }
  public io.fabric8.kubernetes.api.model.policy.v1beta1.PodSecurityPolicySpecFluent.AllowedFlexVolumesNested<A> setNewAllowedFlexVolumeLike(java.lang.Integer index,io.fabric8.kubernetes.api.model.policy.v1beta1.AllowedFlexVolume item) {
    return new io.fabric8.kubernetes.api.model.policy.v1beta1.PodSecurityPolicySpecFluentImpl.AllowedFlexVolumesNestedImpl(index, item);
  }
  public io.fabric8.kubernetes.api.model.policy.v1beta1.PodSecurityPolicySpecFluent.AllowedFlexVolumesNested<A> editAllowedFlexVolume(java.lang.Integer index) {
    if (allowedFlexVolumes.size() <= index) throw new RuntimeException("Can't edit allowedFlexVolumes. Index exceeds size.");
    return setNewAllowedFlexVolumeLike(index, buildAllowedFlexVolume(index));
  }
  public io.fabric8.kubernetes.api.model.policy.v1beta1.PodSecurityPolicySpecFluent.AllowedFlexVolumesNested<A> editFirstAllowedFlexVolume() {
    if (allowedFlexVolumes.size() == 0) throw new RuntimeException("Can't edit first allowedFlexVolumes. The list is empty.");
    return setNewAllowedFlexVolumeLike(0, buildAllowedFlexVolume(0));
  }
  public io.fabric8.kubernetes.api.model.policy.v1beta1.PodSecurityPolicySpecFluent.AllowedFlexVolumesNested<A> editLastAllowedFlexVolume() {
    int index = allowedFlexVolumes.size() - 1;
    if (index < 0) throw new RuntimeException("Can't edit last allowedFlexVolumes. The list is empty.");
    return setNewAllowedFlexVolumeLike(index, buildAllowedFlexVolume(index));
  }
  public io.fabric8.kubernetes.api.model.policy.v1beta1.PodSecurityPolicySpecFluent.AllowedFlexVolumesNested<A> editMatchingAllowedFlexVolume(java.util.function.Predicate<io.fabric8.kubernetes.api.model.policy.v1beta1.AllowedFlexVolumeBuilder> predicate) {
    int index = -1;
    for (int i=0;i<allowedFlexVolumes.size();i++) { 
    if (predicate.test(allowedFlexVolumes.get(i))) {index = i; break;}
    } 
    if (index < 0) throw new RuntimeException("Can't edit matching allowedFlexVolumes. No match found.");
    return setNewAllowedFlexVolumeLike(index, buildAllowedFlexVolume(index));
  }
  public A addToAllowedHostPaths(java.lang.Integer index,io.fabric8.kubernetes.api.model.policy.v1beta1.AllowedHostPath item) {
    if (this.allowedHostPaths == null) {this.allowedHostPaths = new java.util.ArrayList<io.fabric8.kubernetes.api.model.policy.v1beta1.AllowedHostPathBuilder>();}
    io.fabric8.kubernetes.api.model.policy.v1beta1.AllowedHostPathBuilder builder = new io.fabric8.kubernetes.api.model.policy.v1beta1.AllowedHostPathBuilder(item);_visitables.get("allowedHostPaths").add(index >= 0 ? index : _visitables.get("allowedHostPaths").size(), builder);this.allowedHostPaths.add(index >= 0 ? index : allowedHostPaths.size(), builder); return (A)this;
  }
  public A setToAllowedHostPaths(java.lang.Integer index,io.fabric8.kubernetes.api.model.policy.v1beta1.AllowedHostPath item) {
    if (this.allowedHostPaths == null) {this.allowedHostPaths = new java.util.ArrayList<io.fabric8.kubernetes.api.model.policy.v1beta1.AllowedHostPathBuilder>();}
    io.fabric8.kubernetes.api.model.policy.v1beta1.AllowedHostPathBuilder builder = new io.fabric8.kubernetes.api.model.policy.v1beta1.AllowedHostPathBuilder(item);
    if (index < 0 || index >= _visitables.get("allowedHostPaths").size()) { _visitables.get("allowedHostPaths").add(builder); } else { _visitables.get("allowedHostPaths").set(index, builder);}
    if (index < 0 || index >= allowedHostPaths.size()) { allowedHostPaths.add(builder); } else { allowedHostPaths.set(index, builder);}
     return (A)this;
  }
  public A addToAllowedHostPaths(io.fabric8.kubernetes.api.model.policy.v1beta1.AllowedHostPath... items) {
    if (this.allowedHostPaths == null) {this.allowedHostPaths = new java.util.ArrayList<io.fabric8.kubernetes.api.model.policy.v1beta1.AllowedHostPathBuilder>();}
    for (io.fabric8.kubernetes.api.model.policy.v1beta1.AllowedHostPath item : items) {io.fabric8.kubernetes.api.model.policy.v1beta1.AllowedHostPathBuilder builder = new io.fabric8.kubernetes.api.model.policy.v1beta1.AllowedHostPathBuilder(item);_visitables.get("allowedHostPaths").add(builder);this.allowedHostPaths.add(builder);} return (A)this;
  }
  public A addAllToAllowedHostPaths(java.util.Collection<io.fabric8.kubernetes.api.model.policy.v1beta1.AllowedHostPath> items) {
    if (this.allowedHostPaths == null) {this.allowedHostPaths = new java.util.ArrayList<io.fabric8.kubernetes.api.model.policy.v1beta1.AllowedHostPathBuilder>();}
    for (io.fabric8.kubernetes.api.model.policy.v1beta1.AllowedHostPath item : items) {io.fabric8.kubernetes.api.model.policy.v1beta1.AllowedHostPathBuilder builder = new io.fabric8.kubernetes.api.model.policy.v1beta1.AllowedHostPathBuilder(item);_visitables.get("allowedHostPaths").add(builder);this.allowedHostPaths.add(builder);} return (A)this;
  }
  public A removeFromAllowedHostPaths(io.fabric8.kubernetes.api.model.policy.v1beta1.AllowedHostPath... items) {
    for (io.fabric8.kubernetes.api.model.policy.v1beta1.AllowedHostPath item : items) {io.fabric8.kubernetes.api.model.policy.v1beta1.AllowedHostPathBuilder builder = new io.fabric8.kubernetes.api.model.policy.v1beta1.AllowedHostPathBuilder(item);_visitables.get("allowedHostPaths").remove(builder);if (this.allowedHostPaths != null) {this.allowedHostPaths.remove(builder);}} return (A)this;
  }
  public A removeAllFromAllowedHostPaths(java.util.Collection<io.fabric8.kubernetes.api.model.policy.v1beta1.AllowedHostPath> items) {
    for (io.fabric8.kubernetes.api.model.policy.v1beta1.AllowedHostPath item : items) {io.fabric8.kubernetes.api.model.policy.v1beta1.AllowedHostPathBuilder builder = new io.fabric8.kubernetes.api.model.policy.v1beta1.AllowedHostPathBuilder(item);_visitables.get("allowedHostPaths").remove(builder);if (this.allowedHostPaths != null) {this.allowedHostPaths.remove(builder);}} return (A)this;
  }
  public A removeMatchingFromAllowedHostPaths(java.util.function.Predicate<io.fabric8.kubernetes.api.model.policy.v1beta1.AllowedHostPathBuilder> predicate) {
    if (allowedHostPaths == null) return (A) this;
    final Iterator<io.fabric8.kubernetes.api.model.policy.v1beta1.AllowedHostPathBuilder> each = allowedHostPaths.iterator();
    final List visitables = _visitables.get("allowedHostPaths");
    while (each.hasNext()) {
      io.fabric8.kubernetes.api.model.policy.v1beta1.AllowedHostPathBuilder builder = each.next();
      if (predicate.test(builder)) {
        visitables.remove(builder);
        each.remove();
      }
    }
    return (A)this;
  }
  
  /**
   * This method has been deprecated, please use method buildAllowedHostPaths instead.
   * @return The buildable object.
   */
  @java.lang.Deprecated
  public java.util.List<io.fabric8.kubernetes.api.model.policy.v1beta1.AllowedHostPath> getAllowedHostPaths() {
    return build(allowedHostPaths);
  }
  public java.util.List<io.fabric8.kubernetes.api.model.policy.v1beta1.AllowedHostPath> buildAllowedHostPaths() {
    return build(allowedHostPaths);
  }
  public io.fabric8.kubernetes.api.model.policy.v1beta1.AllowedHostPath buildAllowedHostPath(java.lang.Integer index) {
    return this.allowedHostPaths.get(index).build();
  }
  public io.fabric8.kubernetes.api.model.policy.v1beta1.AllowedHostPath buildFirstAllowedHostPath() {
    return this.allowedHostPaths.get(0).build();
  }
  public io.fabric8.kubernetes.api.model.policy.v1beta1.AllowedHostPath buildLastAllowedHostPath() {
    return this.allowedHostPaths.get(allowedHostPaths.size() - 1).build();
  }
  public io.fabric8.kubernetes.api.model.policy.v1beta1.AllowedHostPath buildMatchingAllowedHostPath(java.util.function.Predicate<io.fabric8.kubernetes.api.model.policy.v1beta1.AllowedHostPathBuilder> predicate) {
    for (io.fabric8.kubernetes.api.model.policy.v1beta1.AllowedHostPathBuilder item: allowedHostPaths) { if(predicate.test(item)){ return item.build();} } return null;
  }
  public java.lang.Boolean hasMatchingAllowedHostPath(java.util.function.Predicate<io.fabric8.kubernetes.api.model.policy.v1beta1.AllowedHostPathBuilder> predicate) {
    for (io.fabric8.kubernetes.api.model.policy.v1beta1.AllowedHostPathBuilder item: allowedHostPaths) { if(predicate.test(item)){ return true;} } return false;
  }
  public A withAllowedHostPaths(java.util.List<io.fabric8.kubernetes.api.model.policy.v1beta1.AllowedHostPath> allowedHostPaths) {
    if (this.allowedHostPaths != null) { _visitables.get("allowedHostPaths").removeAll(this.allowedHostPaths);}
    if (allowedHostPaths != null) {this.allowedHostPaths = new java.util.ArrayList<io.fabric8.kubernetes.api.model.policy.v1beta1.AllowedHostPathBuilder>(); for (io.fabric8.kubernetes.api.model.policy.v1beta1.AllowedHostPath item : allowedHostPaths){this.addToAllowedHostPaths(item);}} else { this.allowedHostPaths = null;} return (A) this;
  }
  public A withAllowedHostPaths(io.fabric8.kubernetes.api.model.policy.v1beta1.AllowedHostPath... allowedHostPaths) {
    if (this.allowedHostPaths != null) {this.allowedHostPaths.clear();}
    if (allowedHostPaths != null) {for (io.fabric8.kubernetes.api.model.policy.v1beta1.AllowedHostPath item :allowedHostPaths){ this.addToAllowedHostPaths(item);}} return (A) this;
  }
  public java.lang.Boolean hasAllowedHostPaths() {
    return allowedHostPaths != null && !allowedHostPaths.isEmpty();
  }
  public A addNewAllowedHostPath(java.lang.String pathPrefix,java.lang.Boolean readOnly) {
    return (A)addToAllowedHostPaths(new AllowedHostPath(pathPrefix, readOnly));
  }
  public io.fabric8.kubernetes.api.model.policy.v1beta1.PodSecurityPolicySpecFluent.AllowedHostPathsNested<A> addNewAllowedHostPath() {
    return new io.fabric8.kubernetes.api.model.policy.v1beta1.PodSecurityPolicySpecFluentImpl.AllowedHostPathsNestedImpl();
  }
  public io.fabric8.kubernetes.api.model.policy.v1beta1.PodSecurityPolicySpecFluent.AllowedHostPathsNested<A> addNewAllowedHostPathLike(io.fabric8.kubernetes.api.model.policy.v1beta1.AllowedHostPath item) {
    return new io.fabric8.kubernetes.api.model.policy.v1beta1.PodSecurityPolicySpecFluentImpl.AllowedHostPathsNestedImpl(-1, item);
  }
  public io.fabric8.kubernetes.api.model.policy.v1beta1.PodSecurityPolicySpecFluent.AllowedHostPathsNested<A> setNewAllowedHostPathLike(java.lang.Integer index,io.fabric8.kubernetes.api.model.policy.v1beta1.AllowedHostPath item) {
    return new io.fabric8.kubernetes.api.model.policy.v1beta1.PodSecurityPolicySpecFluentImpl.AllowedHostPathsNestedImpl(index, item);
  }
  public io.fabric8.kubernetes.api.model.policy.v1beta1.PodSecurityPolicySpecFluent.AllowedHostPathsNested<A> editAllowedHostPath(java.lang.Integer index) {
    if (allowedHostPaths.size() <= index) throw new RuntimeException("Can't edit allowedHostPaths. Index exceeds size.");
    return setNewAllowedHostPathLike(index, buildAllowedHostPath(index));
  }
  public io.fabric8.kubernetes.api.model.policy.v1beta1.PodSecurityPolicySpecFluent.AllowedHostPathsNested<A> editFirstAllowedHostPath() {
    if (allowedHostPaths.size() == 0) throw new RuntimeException("Can't edit first allowedHostPaths. The list is empty.");
    return setNewAllowedHostPathLike(0, buildAllowedHostPath(0));
  }
  public io.fabric8.kubernetes.api.model.policy.v1beta1.PodSecurityPolicySpecFluent.AllowedHostPathsNested<A> editLastAllowedHostPath() {
    int index = allowedHostPaths.size() - 1;
    if (index < 0) throw new RuntimeException("Can't edit last allowedHostPaths. The list is empty.");
    return setNewAllowedHostPathLike(index, buildAllowedHostPath(index));
  }
  public io.fabric8.kubernetes.api.model.policy.v1beta1.PodSecurityPolicySpecFluent.AllowedHostPathsNested<A> editMatchingAllowedHostPath(java.util.function.Predicate<io.fabric8.kubernetes.api.model.policy.v1beta1.AllowedHostPathBuilder> predicate) {
    int index = -1;
    for (int i=0;i<allowedHostPaths.size();i++) { 
    if (predicate.test(allowedHostPaths.get(i))) {index = i; break;}
    } 
    if (index < 0) throw new RuntimeException("Can't edit matching allowedHostPaths. No match found.");
    return setNewAllowedHostPathLike(index, buildAllowedHostPath(index));
  }
  public A addToAllowedProcMountTypes(java.lang.Integer index,java.lang.String item) {
    if (this.allowedProcMountTypes == null) {this.allowedProcMountTypes = new java.util.ArrayList<java.lang.String>();}
    this.allowedProcMountTypes.add(index, item);
    return (A)this;
  }
  public A setToAllowedProcMountTypes(java.lang.Integer index,java.lang.String item) {
    if (this.allowedProcMountTypes == null) {this.allowedProcMountTypes = new java.util.ArrayList<java.lang.String>();}
    this.allowedProcMountTypes.set(index, item); return (A)this;
  }
  public A addToAllowedProcMountTypes(java.lang.String... items) {
    if (this.allowedProcMountTypes == null) {this.allowedProcMountTypes = new java.util.ArrayList<java.lang.String>();}
    for (java.lang.String item : items) {this.allowedProcMountTypes.add(item);} return (A)this;
  }
  public A addAllToAllowedProcMountTypes(java.util.Collection<java.lang.String> items) {
    if (this.allowedProcMountTypes == null) {this.allowedProcMountTypes = new java.util.ArrayList<java.lang.String>();}
    for (java.lang.String item : items) {this.allowedProcMountTypes.add(item);} return (A)this;
  }
  public A removeFromAllowedProcMountTypes(java.lang.String... items) {
    for (java.lang.String item : items) {if (this.allowedProcMountTypes!= null){ this.allowedProcMountTypes.remove(item);}} return (A)this;
  }
  public A removeAllFromAllowedProcMountTypes(java.util.Collection<java.lang.String> items) {
    for (java.lang.String item : items) {if (this.allowedProcMountTypes!= null){ this.allowedProcMountTypes.remove(item);}} return (A)this;
  }
  public java.util.List<java.lang.String> getAllowedProcMountTypes() {
    return this.allowedProcMountTypes;
  }
  public java.lang.String getAllowedProcMountType(java.lang.Integer index) {
    return this.allowedProcMountTypes.get(index);
  }
  public java.lang.String getFirstAllowedProcMountType() {
    return this.allowedProcMountTypes.get(0);
  }
  public java.lang.String getLastAllowedProcMountType() {
    return this.allowedProcMountTypes.get(allowedProcMountTypes.size() - 1);
  }
  public java.lang.String getMatchingAllowedProcMountType(java.util.function.Predicate<java.lang.String> predicate) {
    for (java.lang.String item: allowedProcMountTypes) { if(predicate.test(item)){ return item;} } return null;
  }
  public java.lang.Boolean hasMatchingAllowedProcMountType(java.util.function.Predicate<java.lang.String> predicate) {
    for (java.lang.String item: allowedProcMountTypes) { if(predicate.test(item)){ return true;} } return false;
  }
  public A withAllowedProcMountTypes(java.util.List<java.lang.String> allowedProcMountTypes) {
    if (allowedProcMountTypes != null) {this.allowedProcMountTypes = new java.util.ArrayList<java.lang.String>(); for (java.lang.String item : allowedProcMountTypes){this.addToAllowedProcMountTypes(item);}} else { this.allowedProcMountTypes = null;} return (A) this;
  }
  public A withAllowedProcMountTypes(java.lang.String... allowedProcMountTypes) {
    if (this.allowedProcMountTypes != null) {this.allowedProcMountTypes.clear();}
    if (allowedProcMountTypes != null) {for (java.lang.String item :allowedProcMountTypes){ this.addToAllowedProcMountTypes(item);}} return (A) this;
  }
  public java.lang.Boolean hasAllowedProcMountTypes() {
    return allowedProcMountTypes != null && !allowedProcMountTypes.isEmpty();
  }
  public A addNewAllowedProcMountType(java.lang.String arg0) {
    return (A)addToAllowedProcMountTypes(new String(arg0));
  }
  public A addToAllowedUnsafeSysctls(java.lang.Integer index,java.lang.String item) {
    if (this.allowedUnsafeSysctls == null) {this.allowedUnsafeSysctls = new java.util.ArrayList<java.lang.String>();}
    this.allowedUnsafeSysctls.add(index, item);
    return (A)this;
  }
  public A setToAllowedUnsafeSysctls(java.lang.Integer index,java.lang.String item) {
    if (this.allowedUnsafeSysctls == null) {this.allowedUnsafeSysctls = new java.util.ArrayList<java.lang.String>();}
    this.allowedUnsafeSysctls.set(index, item); return (A)this;
  }
  public A addToAllowedUnsafeSysctls(java.lang.String... items) {
    if (this.allowedUnsafeSysctls == null) {this.allowedUnsafeSysctls = new java.util.ArrayList<java.lang.String>();}
    for (java.lang.String item : items) {this.allowedUnsafeSysctls.add(item);} return (A)this;
  }
  public A addAllToAllowedUnsafeSysctls(java.util.Collection<java.lang.String> items) {
    if (this.allowedUnsafeSysctls == null) {this.allowedUnsafeSysctls = new java.util.ArrayList<java.lang.String>();}
    for (java.lang.String item : items) {this.allowedUnsafeSysctls.add(item);} return (A)this;
  }
  public A removeFromAllowedUnsafeSysctls(java.lang.String... items) {
    for (java.lang.String item : items) {if (this.allowedUnsafeSysctls!= null){ this.allowedUnsafeSysctls.remove(item);}} return (A)this;
  }
  public A removeAllFromAllowedUnsafeSysctls(java.util.Collection<java.lang.String> items) {
    for (java.lang.String item : items) {if (this.allowedUnsafeSysctls!= null){ this.allowedUnsafeSysctls.remove(item);}} return (A)this;
  }
  public java.util.List<java.lang.String> getAllowedUnsafeSysctls() {
    return this.allowedUnsafeSysctls;
  }
  public java.lang.String getAllowedUnsafeSysctl(java.lang.Integer index) {
    return this.allowedUnsafeSysctls.get(index);
  }
  public java.lang.String getFirstAllowedUnsafeSysctl() {
    return this.allowedUnsafeSysctls.get(0);
  }
  public java.lang.String getLastAllowedUnsafeSysctl() {
    return this.allowedUnsafeSysctls.get(allowedUnsafeSysctls.size() - 1);
  }
  public java.lang.String getMatchingAllowedUnsafeSysctl(java.util.function.Predicate<java.lang.String> predicate) {
    for (java.lang.String item: allowedUnsafeSysctls) { if(predicate.test(item)){ return item;} } return null;
  }
  public java.lang.Boolean hasMatchingAllowedUnsafeSysctl(java.util.function.Predicate<java.lang.String> predicate) {
    for (java.lang.String item: allowedUnsafeSysctls) { if(predicate.test(item)){ return true;} } return false;
  }
  public A withAllowedUnsafeSysctls(java.util.List<java.lang.String> allowedUnsafeSysctls) {
    if (allowedUnsafeSysctls != null) {this.allowedUnsafeSysctls = new java.util.ArrayList<java.lang.String>(); for (java.lang.String item : allowedUnsafeSysctls){this.addToAllowedUnsafeSysctls(item);}} else { this.allowedUnsafeSysctls = null;} return (A) this;
  }
  public A withAllowedUnsafeSysctls(java.lang.String... allowedUnsafeSysctls) {
    if (this.allowedUnsafeSysctls != null) {this.allowedUnsafeSysctls.clear();}
    if (allowedUnsafeSysctls != null) {for (java.lang.String item :allowedUnsafeSysctls){ this.addToAllowedUnsafeSysctls(item);}} return (A) this;
  }
  public java.lang.Boolean hasAllowedUnsafeSysctls() {
    return allowedUnsafeSysctls != null && !allowedUnsafeSysctls.isEmpty();
  }
  public A addNewAllowedUnsafeSysctl(java.lang.String arg0) {
    return (A)addToAllowedUnsafeSysctls(new String(arg0));
  }
  public A addToDefaultAddCapabilities(java.lang.Integer index,java.lang.String item) {
    if (this.defaultAddCapabilities == null) {this.defaultAddCapabilities = new java.util.ArrayList<java.lang.String>();}
    this.defaultAddCapabilities.add(index, item);
    return (A)this;
  }
  public A setToDefaultAddCapabilities(java.lang.Integer index,java.lang.String item) {
    if (this.defaultAddCapabilities == null) {this.defaultAddCapabilities = new java.util.ArrayList<java.lang.String>();}
    this.defaultAddCapabilities.set(index, item); return (A)this;
  }
  public A addToDefaultAddCapabilities(java.lang.String... items) {
    if (this.defaultAddCapabilities == null) {this.defaultAddCapabilities = new java.util.ArrayList<java.lang.String>();}
    for (java.lang.String item : items) {this.defaultAddCapabilities.add(item);} return (A)this;
  }
  public A addAllToDefaultAddCapabilities(java.util.Collection<java.lang.String> items) {
    if (this.defaultAddCapabilities == null) {this.defaultAddCapabilities = new java.util.ArrayList<java.lang.String>();}
    for (java.lang.String item : items) {this.defaultAddCapabilities.add(item);} return (A)this;
  }
  public A removeFromDefaultAddCapabilities(java.lang.String... items) {
    for (java.lang.String item : items) {if (this.defaultAddCapabilities!= null){ this.defaultAddCapabilities.remove(item);}} return (A)this;
  }
  public A removeAllFromDefaultAddCapabilities(java.util.Collection<java.lang.String> items) {
    for (java.lang.String item : items) {if (this.defaultAddCapabilities!= null){ this.defaultAddCapabilities.remove(item);}} return (A)this;
  }
  public java.util.List<java.lang.String> getDefaultAddCapabilities() {
    return this.defaultAddCapabilities;
  }
  public java.lang.String getDefaultAddCapability(java.lang.Integer index) {
    return this.defaultAddCapabilities.get(index);
  }
  public java.lang.String getFirstDefaultAddCapability() {
    return this.defaultAddCapabilities.get(0);
  }
  public java.lang.String getLastDefaultAddCapability() {
    return this.defaultAddCapabilities.get(defaultAddCapabilities.size() - 1);
  }
  public java.lang.String getMatchingDefaultAddCapability(java.util.function.Predicate<java.lang.String> predicate) {
    for (java.lang.String item: defaultAddCapabilities) { if(predicate.test(item)){ return item;} } return null;
  }
  public java.lang.Boolean hasMatchingDefaultAddCapability(java.util.function.Predicate<java.lang.String> predicate) {
    for (java.lang.String item: defaultAddCapabilities) { if(predicate.test(item)){ return true;} } return false;
  }
  public A withDefaultAddCapabilities(java.util.List<java.lang.String> defaultAddCapabilities) {
    if (defaultAddCapabilities != null) {this.defaultAddCapabilities = new java.util.ArrayList<java.lang.String>(); for (java.lang.String item : defaultAddCapabilities){this.addToDefaultAddCapabilities(item);}} else { this.defaultAddCapabilities = null;} return (A) this;
  }
  public A withDefaultAddCapabilities(java.lang.String... defaultAddCapabilities) {
    if (this.defaultAddCapabilities != null) {this.defaultAddCapabilities.clear();}
    if (defaultAddCapabilities != null) {for (java.lang.String item :defaultAddCapabilities){ this.addToDefaultAddCapabilities(item);}} return (A) this;
  }
  public java.lang.Boolean hasDefaultAddCapabilities() {
    return defaultAddCapabilities != null && !defaultAddCapabilities.isEmpty();
  }
  public A addNewDefaultAddCapability(java.lang.String arg0) {
    return (A)addToDefaultAddCapabilities(new String(arg0));
  }
  public java.lang.Boolean getDefaultAllowPrivilegeEscalation() {
    return this.defaultAllowPrivilegeEscalation;
  }
  public A withDefaultAllowPrivilegeEscalation(java.lang.Boolean defaultAllowPrivilegeEscalation) {
    this.defaultAllowPrivilegeEscalation=defaultAllowPrivilegeEscalation; return (A) this;
  }
  public java.lang.Boolean hasDefaultAllowPrivilegeEscalation() {
    return this.defaultAllowPrivilegeEscalation != null;
  }
  public A addToForbiddenSysctls(java.lang.Integer index,java.lang.String item) {
    if (this.forbiddenSysctls == null) {this.forbiddenSysctls = new java.util.ArrayList<java.lang.String>();}
    this.forbiddenSysctls.add(index, item);
    return (A)this;
  }
  public A setToForbiddenSysctls(java.lang.Integer index,java.lang.String item) {
    if (this.forbiddenSysctls == null) {this.forbiddenSysctls = new java.util.ArrayList<java.lang.String>();}
    this.forbiddenSysctls.set(index, item); return (A)this;
  }
  public A addToForbiddenSysctls(java.lang.String... items) {
    if (this.forbiddenSysctls == null) {this.forbiddenSysctls = new java.util.ArrayList<java.lang.String>();}
    for (java.lang.String item : items) {this.forbiddenSysctls.add(item);} return (A)this;
  }
  public A addAllToForbiddenSysctls(java.util.Collection<java.lang.String> items) {
    if (this.forbiddenSysctls == null) {this.forbiddenSysctls = new java.util.ArrayList<java.lang.String>();}
    for (java.lang.String item : items) {this.forbiddenSysctls.add(item);} return (A)this;
  }
  public A removeFromForbiddenSysctls(java.lang.String... items) {
    for (java.lang.String item : items) {if (this.forbiddenSysctls!= null){ this.forbiddenSysctls.remove(item);}} return (A)this;
  }
  public A removeAllFromForbiddenSysctls(java.util.Collection<java.lang.String> items) {
    for (java.lang.String item : items) {if (this.forbiddenSysctls!= null){ this.forbiddenSysctls.remove(item);}} return (A)this;
  }
  public java.util.List<java.lang.String> getForbiddenSysctls() {
    return this.forbiddenSysctls;
  }
  public java.lang.String getForbiddenSysctl(java.lang.Integer index) {
    return this.forbiddenSysctls.get(index);
  }
  public java.lang.String getFirstForbiddenSysctl() {
    return this.forbiddenSysctls.get(0);
  }
  public java.lang.String getLastForbiddenSysctl() {
    return this.forbiddenSysctls.get(forbiddenSysctls.size() - 1);
  }
  public java.lang.String getMatchingForbiddenSysctl(java.util.function.Predicate<java.lang.String> predicate) {
    for (java.lang.String item: forbiddenSysctls) { if(predicate.test(item)){ return item;} } return null;
  }
  public java.lang.Boolean hasMatchingForbiddenSysctl(java.util.function.Predicate<java.lang.String> predicate) {
    for (java.lang.String item: forbiddenSysctls) { if(predicate.test(item)){ return true;} } return false;
  }
  public A withForbiddenSysctls(java.util.List<java.lang.String> forbiddenSysctls) {
    if (forbiddenSysctls != null) {this.forbiddenSysctls = new java.util.ArrayList<java.lang.String>(); for (java.lang.String item : forbiddenSysctls){this.addToForbiddenSysctls(item);}} else { this.forbiddenSysctls = null;} return (A) this;
  }
  public A withForbiddenSysctls(java.lang.String... forbiddenSysctls) {
    if (this.forbiddenSysctls != null) {this.forbiddenSysctls.clear();}
    if (forbiddenSysctls != null) {for (java.lang.String item :forbiddenSysctls){ this.addToForbiddenSysctls(item);}} return (A) this;
  }
  public java.lang.Boolean hasForbiddenSysctls() {
    return forbiddenSysctls != null && !forbiddenSysctls.isEmpty();
  }
  public A addNewForbiddenSysctl(java.lang.String arg0) {
    return (A)addToForbiddenSysctls(new String(arg0));
  }
  
  /**
   * This method has been deprecated, please use method buildFsGroup instead.
   * @return The buildable object.
   */
  @java.lang.Deprecated
  public io.fabric8.kubernetes.api.model.policy.v1beta1.FSGroupStrategyOptions getFsGroup() {
    return this.fsGroup!=null?this.fsGroup.build():null;
  }
  public io.fabric8.kubernetes.api.model.policy.v1beta1.FSGroupStrategyOptions buildFsGroup() {
    return this.fsGroup!=null?this.fsGroup.build():null;
  }
  public A withFsGroup(io.fabric8.kubernetes.api.model.policy.v1beta1.FSGroupStrategyOptions fsGroup) {
    _visitables.get("fsGroup").remove(this.fsGroup);
    if (fsGroup!=null){ this.fsGroup= new io.fabric8.kubernetes.api.model.policy.v1beta1.FSGroupStrategyOptionsBuilder(fsGroup); _visitables.get("fsGroup").add(this.fsGroup);} return (A) this;
  }
  public java.lang.Boolean hasFsGroup() {
    return this.fsGroup != null;
  }
  public io.fabric8.kubernetes.api.model.policy.v1beta1.PodSecurityPolicySpecFluent.FsGroupNested<A> withNewFsGroup() {
    return new io.fabric8.kubernetes.api.model.policy.v1beta1.PodSecurityPolicySpecFluentImpl.FsGroupNestedImpl();
  }
  public io.fabric8.kubernetes.api.model.policy.v1beta1.PodSecurityPolicySpecFluent.FsGroupNested<A> withNewFsGroupLike(io.fabric8.kubernetes.api.model.policy.v1beta1.FSGroupStrategyOptions item) {
    return new io.fabric8.kubernetes.api.model.policy.v1beta1.PodSecurityPolicySpecFluentImpl.FsGroupNestedImpl(item);
  }
  public io.fabric8.kubernetes.api.model.policy.v1beta1.PodSecurityPolicySpecFluent.FsGroupNested<A> editFsGroup() {
    return withNewFsGroupLike(getFsGroup());
  }
  public io.fabric8.kubernetes.api.model.policy.v1beta1.PodSecurityPolicySpecFluent.FsGroupNested<A> editOrNewFsGroup() {
    return withNewFsGroupLike(getFsGroup() != null ? getFsGroup(): new io.fabric8.kubernetes.api.model.policy.v1beta1.FSGroupStrategyOptionsBuilder().build());
  }
  public io.fabric8.kubernetes.api.model.policy.v1beta1.PodSecurityPolicySpecFluent.FsGroupNested<A> editOrNewFsGroupLike(io.fabric8.kubernetes.api.model.policy.v1beta1.FSGroupStrategyOptions item) {
    return withNewFsGroupLike(getFsGroup() != null ? getFsGroup(): item);
  }
  public java.lang.Boolean getHostIPC() {
    return this.hostIPC;
  }
  public A withHostIPC(java.lang.Boolean hostIPC) {
    this.hostIPC=hostIPC; return (A) this;
  }
  public java.lang.Boolean hasHostIPC() {
    return this.hostIPC != null;
  }
  public java.lang.Boolean getHostNetwork() {
    return this.hostNetwork;
  }
  public A withHostNetwork(java.lang.Boolean hostNetwork) {
    this.hostNetwork=hostNetwork; return (A) this;
  }
  public java.lang.Boolean hasHostNetwork() {
    return this.hostNetwork != null;
  }
  public java.lang.Boolean getHostPID() {
    return this.hostPID;
  }
  public A withHostPID(java.lang.Boolean hostPID) {
    this.hostPID=hostPID; return (A) this;
  }
  public java.lang.Boolean hasHostPID() {
    return this.hostPID != null;
  }
  public A addToHostPorts(java.lang.Integer index,io.fabric8.kubernetes.api.model.policy.v1beta1.HostPortRange item) {
    if (this.hostPorts == null) {this.hostPorts = new java.util.ArrayList<io.fabric8.kubernetes.api.model.policy.v1beta1.HostPortRangeBuilder>();}
    io.fabric8.kubernetes.api.model.policy.v1beta1.HostPortRangeBuilder builder = new io.fabric8.kubernetes.api.model.policy.v1beta1.HostPortRangeBuilder(item);_visitables.get("hostPorts").add(index >= 0 ? index : _visitables.get("hostPorts").size(), builder);this.hostPorts.add(index >= 0 ? index : hostPorts.size(), builder); return (A)this;
  }
  public A setToHostPorts(java.lang.Integer index,io.fabric8.kubernetes.api.model.policy.v1beta1.HostPortRange item) {
    if (this.hostPorts == null) {this.hostPorts = new java.util.ArrayList<io.fabric8.kubernetes.api.model.policy.v1beta1.HostPortRangeBuilder>();}
    io.fabric8.kubernetes.api.model.policy.v1beta1.HostPortRangeBuilder builder = new io.fabric8.kubernetes.api.model.policy.v1beta1.HostPortRangeBuilder(item);
    if (index < 0 || index >= _visitables.get("hostPorts").size()) { _visitables.get("hostPorts").add(builder); } else { _visitables.get("hostPorts").set(index, builder);}
    if (index < 0 || index >= hostPorts.size()) { hostPorts.add(builder); } else { hostPorts.set(index, builder);}
     return (A)this;
  }
  public A addToHostPorts(io.fabric8.kubernetes.api.model.policy.v1beta1.HostPortRange... items) {
    if (this.hostPorts == null) {this.hostPorts = new java.util.ArrayList<io.fabric8.kubernetes.api.model.policy.v1beta1.HostPortRangeBuilder>();}
    for (io.fabric8.kubernetes.api.model.policy.v1beta1.HostPortRange item : items) {io.fabric8.kubernetes.api.model.policy.v1beta1.HostPortRangeBuilder builder = new io.fabric8.kubernetes.api.model.policy.v1beta1.HostPortRangeBuilder(item);_visitables.get("hostPorts").add(builder);this.hostPorts.add(builder);} return (A)this;
  }
  public A addAllToHostPorts(java.util.Collection<io.fabric8.kubernetes.api.model.policy.v1beta1.HostPortRange> items) {
    if (this.hostPorts == null) {this.hostPorts = new java.util.ArrayList<io.fabric8.kubernetes.api.model.policy.v1beta1.HostPortRangeBuilder>();}
    for (io.fabric8.kubernetes.api.model.policy.v1beta1.HostPortRange item : items) {io.fabric8.kubernetes.api.model.policy.v1beta1.HostPortRangeBuilder builder = new io.fabric8.kubernetes.api.model.policy.v1beta1.HostPortRangeBuilder(item);_visitables.get("hostPorts").add(builder);this.hostPorts.add(builder);} return (A)this;
  }
  public A removeFromHostPorts(io.fabric8.kubernetes.api.model.policy.v1beta1.HostPortRange... items) {
    for (io.fabric8.kubernetes.api.model.policy.v1beta1.HostPortRange item : items) {io.fabric8.kubernetes.api.model.policy.v1beta1.HostPortRangeBuilder builder = new io.fabric8.kubernetes.api.model.policy.v1beta1.HostPortRangeBuilder(item);_visitables.get("hostPorts").remove(builder);if (this.hostPorts != null) {this.hostPorts.remove(builder);}} return (A)this;
  }
  public A removeAllFromHostPorts(java.util.Collection<io.fabric8.kubernetes.api.model.policy.v1beta1.HostPortRange> items) {
    for (io.fabric8.kubernetes.api.model.policy.v1beta1.HostPortRange item : items) {io.fabric8.kubernetes.api.model.policy.v1beta1.HostPortRangeBuilder builder = new io.fabric8.kubernetes.api.model.policy.v1beta1.HostPortRangeBuilder(item);_visitables.get("hostPorts").remove(builder);if (this.hostPorts != null) {this.hostPorts.remove(builder);}} return (A)this;
  }
  public A removeMatchingFromHostPorts(java.util.function.Predicate<io.fabric8.kubernetes.api.model.policy.v1beta1.HostPortRangeBuilder> predicate) {
    if (hostPorts == null) return (A) this;
    final Iterator<io.fabric8.kubernetes.api.model.policy.v1beta1.HostPortRangeBuilder> each = hostPorts.iterator();
    final List visitables = _visitables.get("hostPorts");
    while (each.hasNext()) {
      io.fabric8.kubernetes.api.model.policy.v1beta1.HostPortRangeBuilder builder = each.next();
      if (predicate.test(builder)) {
        visitables.remove(builder);
        each.remove();
      }
    }
    return (A)this;
  }
  
  /**
   * This method has been deprecated, please use method buildHostPorts instead.
   * @return The buildable object.
   */
  @java.lang.Deprecated
  public java.util.List<io.fabric8.kubernetes.api.model.policy.v1beta1.HostPortRange> getHostPorts() {
    return build(hostPorts);
  }
  public java.util.List<io.fabric8.kubernetes.api.model.policy.v1beta1.HostPortRange> buildHostPorts() {
    return build(hostPorts);
  }
  public io.fabric8.kubernetes.api.model.policy.v1beta1.HostPortRange buildHostPort(java.lang.Integer index) {
    return this.hostPorts.get(index).build();
  }
  public io.fabric8.kubernetes.api.model.policy.v1beta1.HostPortRange buildFirstHostPort() {
    return this.hostPorts.get(0).build();
  }
  public io.fabric8.kubernetes.api.model.policy.v1beta1.HostPortRange buildLastHostPort() {
    return this.hostPorts.get(hostPorts.size() - 1).build();
  }
  public io.fabric8.kubernetes.api.model.policy.v1beta1.HostPortRange buildMatchingHostPort(java.util.function.Predicate<io.fabric8.kubernetes.api.model.policy.v1beta1.HostPortRangeBuilder> predicate) {
    for (io.fabric8.kubernetes.api.model.policy.v1beta1.HostPortRangeBuilder item: hostPorts) { if(predicate.test(item)){ return item.build();} } return null;
  }
  public java.lang.Boolean hasMatchingHostPort(java.util.function.Predicate<io.fabric8.kubernetes.api.model.policy.v1beta1.HostPortRangeBuilder> predicate) {
    for (io.fabric8.kubernetes.api.model.policy.v1beta1.HostPortRangeBuilder item: hostPorts) { if(predicate.test(item)){ return true;} } return false;
  }
  public A withHostPorts(java.util.List<io.fabric8.kubernetes.api.model.policy.v1beta1.HostPortRange> hostPorts) {
    if (this.hostPorts != null) { _visitables.get("hostPorts").removeAll(this.hostPorts);}
    if (hostPorts != null) {this.hostPorts = new java.util.ArrayList<io.fabric8.kubernetes.api.model.policy.v1beta1.HostPortRangeBuilder>(); for (io.fabric8.kubernetes.api.model.policy.v1beta1.HostPortRange item : hostPorts){this.addToHostPorts(item);}} else { this.hostPorts = null;} return (A) this;
  }
  public A withHostPorts(io.fabric8.kubernetes.api.model.policy.v1beta1.HostPortRange... hostPorts) {
    if (this.hostPorts != null) {this.hostPorts.clear();}
    if (hostPorts != null) {for (io.fabric8.kubernetes.api.model.policy.v1beta1.HostPortRange item :hostPorts){ this.addToHostPorts(item);}} return (A) this;
  }
  public java.lang.Boolean hasHostPorts() {
    return hostPorts != null && !hostPorts.isEmpty();
  }
  public A addNewHostPort(java.lang.Integer max,java.lang.Integer min) {
    return (A)addToHostPorts(new HostPortRange(max, min));
  }
  public io.fabric8.kubernetes.api.model.policy.v1beta1.PodSecurityPolicySpecFluent.HostPortsNested<A> addNewHostPort() {
    return new io.fabric8.kubernetes.api.model.policy.v1beta1.PodSecurityPolicySpecFluentImpl.HostPortsNestedImpl();
  }
  public io.fabric8.kubernetes.api.model.policy.v1beta1.PodSecurityPolicySpecFluent.HostPortsNested<A> addNewHostPortLike(io.fabric8.kubernetes.api.model.policy.v1beta1.HostPortRange item) {
    return new io.fabric8.kubernetes.api.model.policy.v1beta1.PodSecurityPolicySpecFluentImpl.HostPortsNestedImpl(-1, item);
  }
  public io.fabric8.kubernetes.api.model.policy.v1beta1.PodSecurityPolicySpecFluent.HostPortsNested<A> setNewHostPortLike(java.lang.Integer index,io.fabric8.kubernetes.api.model.policy.v1beta1.HostPortRange item) {
    return new io.fabric8.kubernetes.api.model.policy.v1beta1.PodSecurityPolicySpecFluentImpl.HostPortsNestedImpl(index, item);
  }
  public io.fabric8.kubernetes.api.model.policy.v1beta1.PodSecurityPolicySpecFluent.HostPortsNested<A> editHostPort(java.lang.Integer index) {
    if (hostPorts.size() <= index) throw new RuntimeException("Can't edit hostPorts. Index exceeds size.");
    return setNewHostPortLike(index, buildHostPort(index));
  }
  public io.fabric8.kubernetes.api.model.policy.v1beta1.PodSecurityPolicySpecFluent.HostPortsNested<A> editFirstHostPort() {
    if (hostPorts.size() == 0) throw new RuntimeException("Can't edit first hostPorts. The list is empty.");
    return setNewHostPortLike(0, buildHostPort(0));
  }
  public io.fabric8.kubernetes.api.model.policy.v1beta1.PodSecurityPolicySpecFluent.HostPortsNested<A> editLastHostPort() {
    int index = hostPorts.size() - 1;
    if (index < 0) throw new RuntimeException("Can't edit last hostPorts. The list is empty.");
    return setNewHostPortLike(index, buildHostPort(index));
  }
  public io.fabric8.kubernetes.api.model.policy.v1beta1.PodSecurityPolicySpecFluent.HostPortsNested<A> editMatchingHostPort(java.util.function.Predicate<io.fabric8.kubernetes.api.model.policy.v1beta1.HostPortRangeBuilder> predicate) {
    int index = -1;
    for (int i=0;i<hostPorts.size();i++) { 
    if (predicate.test(hostPorts.get(i))) {index = i; break;}
    } 
    if (index < 0) throw new RuntimeException("Can't edit matching hostPorts. No match found.");
    return setNewHostPortLike(index, buildHostPort(index));
  }
  public java.lang.Boolean getPrivileged() {
    return this.privileged;
  }
  public A withPrivileged(java.lang.Boolean privileged) {
    this.privileged=privileged; return (A) this;
  }
  public java.lang.Boolean hasPrivileged() {
    return this.privileged != null;
  }
  public java.lang.Boolean getReadOnlyRootFilesystem() {
    return this.readOnlyRootFilesystem;
  }
  public A withReadOnlyRootFilesystem(java.lang.Boolean readOnlyRootFilesystem) {
    this.readOnlyRootFilesystem=readOnlyRootFilesystem; return (A) this;
  }
  public java.lang.Boolean hasReadOnlyRootFilesystem() {
    return this.readOnlyRootFilesystem != null;
  }
  public A addToRequiredDropCapabilities(java.lang.Integer index,java.lang.String item) {
    if (this.requiredDropCapabilities == null) {this.requiredDropCapabilities = new java.util.ArrayList<java.lang.String>();}
    this.requiredDropCapabilities.add(index, item);
    return (A)this;
  }
  public A setToRequiredDropCapabilities(java.lang.Integer index,java.lang.String item) {
    if (this.requiredDropCapabilities == null) {this.requiredDropCapabilities = new java.util.ArrayList<java.lang.String>();}
    this.requiredDropCapabilities.set(index, item); return (A)this;
  }
  public A addToRequiredDropCapabilities(java.lang.String... items) {
    if (this.requiredDropCapabilities == null) {this.requiredDropCapabilities = new java.util.ArrayList<java.lang.String>();}
    for (java.lang.String item : items) {this.requiredDropCapabilities.add(item);} return (A)this;
  }
  public A addAllToRequiredDropCapabilities(java.util.Collection<java.lang.String> items) {
    if (this.requiredDropCapabilities == null) {this.requiredDropCapabilities = new java.util.ArrayList<java.lang.String>();}
    for (java.lang.String item : items) {this.requiredDropCapabilities.add(item);} return (A)this;
  }
  public A removeFromRequiredDropCapabilities(java.lang.String... items) {
    for (java.lang.String item : items) {if (this.requiredDropCapabilities!= null){ this.requiredDropCapabilities.remove(item);}} return (A)this;
  }
  public A removeAllFromRequiredDropCapabilities(java.util.Collection<java.lang.String> items) {
    for (java.lang.String item : items) {if (this.requiredDropCapabilities!= null){ this.requiredDropCapabilities.remove(item);}} return (A)this;
  }
  public java.util.List<java.lang.String> getRequiredDropCapabilities() {
    return this.requiredDropCapabilities;
  }
  public java.lang.String getRequiredDropCapability(java.lang.Integer index) {
    return this.requiredDropCapabilities.get(index);
  }
  public java.lang.String getFirstRequiredDropCapability() {
    return this.requiredDropCapabilities.get(0);
  }
  public java.lang.String getLastRequiredDropCapability() {
    return this.requiredDropCapabilities.get(requiredDropCapabilities.size() - 1);
  }
  public java.lang.String getMatchingRequiredDropCapability(java.util.function.Predicate<java.lang.String> predicate) {
    for (java.lang.String item: requiredDropCapabilities) { if(predicate.test(item)){ return item;} } return null;
  }
  public java.lang.Boolean hasMatchingRequiredDropCapability(java.util.function.Predicate<java.lang.String> predicate) {
    for (java.lang.String item: requiredDropCapabilities) { if(predicate.test(item)){ return true;} } return false;
  }
  public A withRequiredDropCapabilities(java.util.List<java.lang.String> requiredDropCapabilities) {
    if (requiredDropCapabilities != null) {this.requiredDropCapabilities = new java.util.ArrayList<java.lang.String>(); for (java.lang.String item : requiredDropCapabilities){this.addToRequiredDropCapabilities(item);}} else { this.requiredDropCapabilities = null;} return (A) this;
  }
  public A withRequiredDropCapabilities(java.lang.String... requiredDropCapabilities) {
    if (this.requiredDropCapabilities != null) {this.requiredDropCapabilities.clear();}
    if (requiredDropCapabilities != null) {for (java.lang.String item :requiredDropCapabilities){ this.addToRequiredDropCapabilities(item);}} return (A) this;
  }
  public java.lang.Boolean hasRequiredDropCapabilities() {
    return requiredDropCapabilities != null && !requiredDropCapabilities.isEmpty();
  }
  public A addNewRequiredDropCapability(java.lang.String arg0) {
    return (A)addToRequiredDropCapabilities(new String(arg0));
  }
  
  /**
   * This method has been deprecated, please use method buildRunAsGroup instead.
   * @return The buildable object.
   */
  @java.lang.Deprecated
  public io.fabric8.kubernetes.api.model.policy.v1beta1.RunAsGroupStrategyOptions getRunAsGroup() {
    return this.runAsGroup!=null?this.runAsGroup.build():null;
  }
  public io.fabric8.kubernetes.api.model.policy.v1beta1.RunAsGroupStrategyOptions buildRunAsGroup() {
    return this.runAsGroup!=null?this.runAsGroup.build():null;
  }
  public A withRunAsGroup(io.fabric8.kubernetes.api.model.policy.v1beta1.RunAsGroupStrategyOptions runAsGroup) {
    _visitables.get("runAsGroup").remove(this.runAsGroup);
    if (runAsGroup!=null){ this.runAsGroup= new io.fabric8.kubernetes.api.model.policy.v1beta1.RunAsGroupStrategyOptionsBuilder(runAsGroup); _visitables.get("runAsGroup").add(this.runAsGroup);} return (A) this;
  }
  public java.lang.Boolean hasRunAsGroup() {
    return this.runAsGroup != null;
  }
  public io.fabric8.kubernetes.api.model.policy.v1beta1.PodSecurityPolicySpecFluent.RunAsGroupNested<A> withNewRunAsGroup() {
    return new io.fabric8.kubernetes.api.model.policy.v1beta1.PodSecurityPolicySpecFluentImpl.RunAsGroupNestedImpl();
  }
  public io.fabric8.kubernetes.api.model.policy.v1beta1.PodSecurityPolicySpecFluent.RunAsGroupNested<A> withNewRunAsGroupLike(io.fabric8.kubernetes.api.model.policy.v1beta1.RunAsGroupStrategyOptions item) {
    return new io.fabric8.kubernetes.api.model.policy.v1beta1.PodSecurityPolicySpecFluentImpl.RunAsGroupNestedImpl(item);
  }
  public io.fabric8.kubernetes.api.model.policy.v1beta1.PodSecurityPolicySpecFluent.RunAsGroupNested<A> editRunAsGroup() {
    return withNewRunAsGroupLike(getRunAsGroup());
  }
  public io.fabric8.kubernetes.api.model.policy.v1beta1.PodSecurityPolicySpecFluent.RunAsGroupNested<A> editOrNewRunAsGroup() {
    return withNewRunAsGroupLike(getRunAsGroup() != null ? getRunAsGroup(): new io.fabric8.kubernetes.api.model.policy.v1beta1.RunAsGroupStrategyOptionsBuilder().build());
  }
  public io.fabric8.kubernetes.api.model.policy.v1beta1.PodSecurityPolicySpecFluent.RunAsGroupNested<A> editOrNewRunAsGroupLike(io.fabric8.kubernetes.api.model.policy.v1beta1.RunAsGroupStrategyOptions item) {
    return withNewRunAsGroupLike(getRunAsGroup() != null ? getRunAsGroup(): item);
  }
  
  /**
   * This method has been deprecated, please use method buildRunAsUser instead.
   * @return The buildable object.
   */
  @java.lang.Deprecated
  public io.fabric8.kubernetes.api.model.policy.v1beta1.RunAsUserStrategyOptions getRunAsUser() {
    return this.runAsUser!=null?this.runAsUser.build():null;
  }
  public io.fabric8.kubernetes.api.model.policy.v1beta1.RunAsUserStrategyOptions buildRunAsUser() {
    return this.runAsUser!=null?this.runAsUser.build():null;
  }
  public A withRunAsUser(io.fabric8.kubernetes.api.model.policy.v1beta1.RunAsUserStrategyOptions runAsUser) {
    _visitables.get("runAsUser").remove(this.runAsUser);
    if (runAsUser!=null){ this.runAsUser= new io.fabric8.kubernetes.api.model.policy.v1beta1.RunAsUserStrategyOptionsBuilder(runAsUser); _visitables.get("runAsUser").add(this.runAsUser);} return (A) this;
  }
  public java.lang.Boolean hasRunAsUser() {
    return this.runAsUser != null;
  }
  public io.fabric8.kubernetes.api.model.policy.v1beta1.PodSecurityPolicySpecFluent.RunAsUserNested<A> withNewRunAsUser() {
    return new io.fabric8.kubernetes.api.model.policy.v1beta1.PodSecurityPolicySpecFluentImpl.RunAsUserNestedImpl();
  }
  public io.fabric8.kubernetes.api.model.policy.v1beta1.PodSecurityPolicySpecFluent.RunAsUserNested<A> withNewRunAsUserLike(io.fabric8.kubernetes.api.model.policy.v1beta1.RunAsUserStrategyOptions item) {
    return new io.fabric8.kubernetes.api.model.policy.v1beta1.PodSecurityPolicySpecFluentImpl.RunAsUserNestedImpl(item);
  }
  public io.fabric8.kubernetes.api.model.policy.v1beta1.PodSecurityPolicySpecFluent.RunAsUserNested<A> editRunAsUser() {
    return withNewRunAsUserLike(getRunAsUser());
  }
  public io.fabric8.kubernetes.api.model.policy.v1beta1.PodSecurityPolicySpecFluent.RunAsUserNested<A> editOrNewRunAsUser() {
    return withNewRunAsUserLike(getRunAsUser() != null ? getRunAsUser(): new io.fabric8.kubernetes.api.model.policy.v1beta1.RunAsUserStrategyOptionsBuilder().build());
  }
  public io.fabric8.kubernetes.api.model.policy.v1beta1.PodSecurityPolicySpecFluent.RunAsUserNested<A> editOrNewRunAsUserLike(io.fabric8.kubernetes.api.model.policy.v1beta1.RunAsUserStrategyOptions item) {
    return withNewRunAsUserLike(getRunAsUser() != null ? getRunAsUser(): item);
  }
  
  /**
   * This method has been deprecated, please use method buildRuntimeClass instead.
   * @return The buildable object.
   */
  @java.lang.Deprecated
  public io.fabric8.kubernetes.api.model.policy.v1beta1.RuntimeClassStrategyOptions getRuntimeClass() {
    return this.runtimeClass!=null?this.runtimeClass.build():null;
  }
  public io.fabric8.kubernetes.api.model.policy.v1beta1.RuntimeClassStrategyOptions buildRuntimeClass() {
    return this.runtimeClass!=null?this.runtimeClass.build():null;
  }
  public A withRuntimeClass(io.fabric8.kubernetes.api.model.policy.v1beta1.RuntimeClassStrategyOptions runtimeClass) {
    _visitables.get("runtimeClass").remove(this.runtimeClass);
    if (runtimeClass!=null){ this.runtimeClass= new io.fabric8.kubernetes.api.model.policy.v1beta1.RuntimeClassStrategyOptionsBuilder(runtimeClass); _visitables.get("runtimeClass").add(this.runtimeClass);} return (A) this;
  }
  public java.lang.Boolean hasRuntimeClass() {
    return this.runtimeClass != null;
  }
  public io.fabric8.kubernetes.api.model.policy.v1beta1.PodSecurityPolicySpecFluent.RuntimeClassNested<A> withNewRuntimeClass() {
    return new io.fabric8.kubernetes.api.model.policy.v1beta1.PodSecurityPolicySpecFluentImpl.RuntimeClassNestedImpl();
  }
  public io.fabric8.kubernetes.api.model.policy.v1beta1.PodSecurityPolicySpecFluent.RuntimeClassNested<A> withNewRuntimeClassLike(io.fabric8.kubernetes.api.model.policy.v1beta1.RuntimeClassStrategyOptions item) {
    return new io.fabric8.kubernetes.api.model.policy.v1beta1.PodSecurityPolicySpecFluentImpl.RuntimeClassNestedImpl(item);
  }
  public io.fabric8.kubernetes.api.model.policy.v1beta1.PodSecurityPolicySpecFluent.RuntimeClassNested<A> editRuntimeClass() {
    return withNewRuntimeClassLike(getRuntimeClass());
  }
  public io.fabric8.kubernetes.api.model.policy.v1beta1.PodSecurityPolicySpecFluent.RuntimeClassNested<A> editOrNewRuntimeClass() {
    return withNewRuntimeClassLike(getRuntimeClass() != null ? getRuntimeClass(): new io.fabric8.kubernetes.api.model.policy.v1beta1.RuntimeClassStrategyOptionsBuilder().build());
  }
  public io.fabric8.kubernetes.api.model.policy.v1beta1.PodSecurityPolicySpecFluent.RuntimeClassNested<A> editOrNewRuntimeClassLike(io.fabric8.kubernetes.api.model.policy.v1beta1.RuntimeClassStrategyOptions item) {
    return withNewRuntimeClassLike(getRuntimeClass() != null ? getRuntimeClass(): item);
  }
  
  /**
   * This method has been deprecated, please use method buildSeLinux instead.
   * @return The buildable object.
   */
  @java.lang.Deprecated
  public io.fabric8.kubernetes.api.model.policy.v1beta1.SELinuxStrategyOptions getSeLinux() {
    return this.seLinux!=null?this.seLinux.build():null;
  }
  public io.fabric8.kubernetes.api.model.policy.v1beta1.SELinuxStrategyOptions buildSeLinux() {
    return this.seLinux!=null?this.seLinux.build():null;
  }
  public A withSeLinux(io.fabric8.kubernetes.api.model.policy.v1beta1.SELinuxStrategyOptions seLinux) {
    _visitables.get("seLinux").remove(this.seLinux);
    if (seLinux!=null){ this.seLinux= new io.fabric8.kubernetes.api.model.policy.v1beta1.SELinuxStrategyOptionsBuilder(seLinux); _visitables.get("seLinux").add(this.seLinux);} return (A) this;
  }
  public java.lang.Boolean hasSeLinux() {
    return this.seLinux != null;
  }
  public io.fabric8.kubernetes.api.model.policy.v1beta1.PodSecurityPolicySpecFluent.SeLinuxNested<A> withNewSeLinux() {
    return new io.fabric8.kubernetes.api.model.policy.v1beta1.PodSecurityPolicySpecFluentImpl.SeLinuxNestedImpl();
  }
  public io.fabric8.kubernetes.api.model.policy.v1beta1.PodSecurityPolicySpecFluent.SeLinuxNested<A> withNewSeLinuxLike(io.fabric8.kubernetes.api.model.policy.v1beta1.SELinuxStrategyOptions item) {
    return new io.fabric8.kubernetes.api.model.policy.v1beta1.PodSecurityPolicySpecFluentImpl.SeLinuxNestedImpl(item);
  }
  public io.fabric8.kubernetes.api.model.policy.v1beta1.PodSecurityPolicySpecFluent.SeLinuxNested<A> editSeLinux() {
    return withNewSeLinuxLike(getSeLinux());
  }
  public io.fabric8.kubernetes.api.model.policy.v1beta1.PodSecurityPolicySpecFluent.SeLinuxNested<A> editOrNewSeLinux() {
    return withNewSeLinuxLike(getSeLinux() != null ? getSeLinux(): new io.fabric8.kubernetes.api.model.policy.v1beta1.SELinuxStrategyOptionsBuilder().build());
  }
  public io.fabric8.kubernetes.api.model.policy.v1beta1.PodSecurityPolicySpecFluent.SeLinuxNested<A> editOrNewSeLinuxLike(io.fabric8.kubernetes.api.model.policy.v1beta1.SELinuxStrategyOptions item) {
    return withNewSeLinuxLike(getSeLinux() != null ? getSeLinux(): item);
  }
  
  /**
   * This method has been deprecated, please use method buildSupplementalGroups instead.
   * @return The buildable object.
   */
  @java.lang.Deprecated
  public io.fabric8.kubernetes.api.model.policy.v1beta1.SupplementalGroupsStrategyOptions getSupplementalGroups() {
    return this.supplementalGroups!=null?this.supplementalGroups.build():null;
  }
  public io.fabric8.kubernetes.api.model.policy.v1beta1.SupplementalGroupsStrategyOptions buildSupplementalGroups() {
    return this.supplementalGroups!=null?this.supplementalGroups.build():null;
  }
  public A withSupplementalGroups(io.fabric8.kubernetes.api.model.policy.v1beta1.SupplementalGroupsStrategyOptions supplementalGroups) {
    _visitables.get("supplementalGroups").remove(this.supplementalGroups);
    if (supplementalGroups!=null){ this.supplementalGroups= new io.fabric8.kubernetes.api.model.policy.v1beta1.SupplementalGroupsStrategyOptionsBuilder(supplementalGroups); _visitables.get("supplementalGroups").add(this.supplementalGroups);} return (A) this;
  }
  public java.lang.Boolean hasSupplementalGroups() {
    return this.supplementalGroups != null;
  }
  public io.fabric8.kubernetes.api.model.policy.v1beta1.PodSecurityPolicySpecFluent.SupplementalGroupsNested<A> withNewSupplementalGroups() {
    return new io.fabric8.kubernetes.api.model.policy.v1beta1.PodSecurityPolicySpecFluentImpl.SupplementalGroupsNestedImpl();
  }
  public io.fabric8.kubernetes.api.model.policy.v1beta1.PodSecurityPolicySpecFluent.SupplementalGroupsNested<A> withNewSupplementalGroupsLike(io.fabric8.kubernetes.api.model.policy.v1beta1.SupplementalGroupsStrategyOptions item) {
    return new io.fabric8.kubernetes.api.model.policy.v1beta1.PodSecurityPolicySpecFluentImpl.SupplementalGroupsNestedImpl(item);
  }
  public io.fabric8.kubernetes.api.model.policy.v1beta1.PodSecurityPolicySpecFluent.SupplementalGroupsNested<A> editSupplementalGroups() {
    return withNewSupplementalGroupsLike(getSupplementalGroups());
  }
  public io.fabric8.kubernetes.api.model.policy.v1beta1.PodSecurityPolicySpecFluent.SupplementalGroupsNested<A> editOrNewSupplementalGroups() {
    return withNewSupplementalGroupsLike(getSupplementalGroups() != null ? getSupplementalGroups(): new io.fabric8.kubernetes.api.model.policy.v1beta1.SupplementalGroupsStrategyOptionsBuilder().build());
  }
  public io.fabric8.kubernetes.api.model.policy.v1beta1.PodSecurityPolicySpecFluent.SupplementalGroupsNested<A> editOrNewSupplementalGroupsLike(io.fabric8.kubernetes.api.model.policy.v1beta1.SupplementalGroupsStrategyOptions item) {
    return withNewSupplementalGroupsLike(getSupplementalGroups() != null ? getSupplementalGroups(): item);
  }
  public A addToVolumes(java.lang.Integer index,java.lang.String item) {
    if (this.volumes == null) {this.volumes = new java.util.ArrayList<java.lang.String>();}
    this.volumes.add(index, item);
    return (A)this;
  }
  public A setToVolumes(java.lang.Integer index,java.lang.String item) {
    if (this.volumes == null) {this.volumes = new java.util.ArrayList<java.lang.String>();}
    this.volumes.set(index, item); return (A)this;
  }
  public A addToVolumes(java.lang.String... items) {
    if (this.volumes == null) {this.volumes = new java.util.ArrayList<java.lang.String>();}
    for (java.lang.String item : items) {this.volumes.add(item);} return (A)this;
  }
  public A addAllToVolumes(java.util.Collection<java.lang.String> items) {
    if (this.volumes == null) {this.volumes = new java.util.ArrayList<java.lang.String>();}
    for (java.lang.String item : items) {this.volumes.add(item);} return (A)this;
  }
  public A removeFromVolumes(java.lang.String... items) {
    for (java.lang.String item : items) {if (this.volumes!= null){ this.volumes.remove(item);}} return (A)this;
  }
  public A removeAllFromVolumes(java.util.Collection<java.lang.String> items) {
    for (java.lang.String item : items) {if (this.volumes!= null){ this.volumes.remove(item);}} return (A)this;
  }
  public java.util.List<java.lang.String> getVolumes() {
    return this.volumes;
  }
  public java.lang.String getVolume(java.lang.Integer index) {
    return this.volumes.get(index);
  }
  public java.lang.String getFirstVolume() {
    return this.volumes.get(0);
  }
  public java.lang.String getLastVolume() {
    return this.volumes.get(volumes.size() - 1);
  }
  public java.lang.String getMatchingVolume(java.util.function.Predicate<java.lang.String> predicate) {
    for (java.lang.String item: volumes) { if(predicate.test(item)){ return item;} } return null;
  }
  public java.lang.Boolean hasMatchingVolume(java.util.function.Predicate<java.lang.String> predicate) {
    for (java.lang.String item: volumes) { if(predicate.test(item)){ return true;} } return false;
  }
  public A withVolumes(java.util.List<java.lang.String> volumes) {
    if (volumes != null) {this.volumes = new java.util.ArrayList<java.lang.String>(); for (java.lang.String item : volumes){this.addToVolumes(item);}} else { this.volumes = null;} return (A) this;
  }
  public A withVolumes(java.lang.String... volumes) {
    if (this.volumes != null) {this.volumes.clear();}
    if (volumes != null) {for (java.lang.String item :volumes){ this.addToVolumes(item);}} return (A) this;
  }
  public java.lang.Boolean hasVolumes() {
    return volumes != null && !volumes.isEmpty();
  }
  public A addNewVolume(java.lang.String arg0) {
    return (A)addToVolumes(new String(arg0));
  }
  public boolean equals(java.lang.Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    PodSecurityPolicySpecFluentImpl that = (PodSecurityPolicySpecFluentImpl) o;
    if (allowPrivilegeEscalation != null ? !allowPrivilegeEscalation.equals(that.allowPrivilegeEscalation) :that.allowPrivilegeEscalation != null) return false;
    if (allowedCSIDrivers != null ? !allowedCSIDrivers.equals(that.allowedCSIDrivers) :that.allowedCSIDrivers != null) return false;
    if (allowedCapabilities != null ? !allowedCapabilities.equals(that.allowedCapabilities) :that.allowedCapabilities != null) return false;
    if (allowedFlexVolumes != null ? !allowedFlexVolumes.equals(that.allowedFlexVolumes) :that.allowedFlexVolumes != null) return false;
    if (allowedHostPaths != null ? !allowedHostPaths.equals(that.allowedHostPaths) :that.allowedHostPaths != null) return false;
    if (allowedProcMountTypes != null ? !allowedProcMountTypes.equals(that.allowedProcMountTypes) :that.allowedProcMountTypes != null) return false;
    if (allowedUnsafeSysctls != null ? !allowedUnsafeSysctls.equals(that.allowedUnsafeSysctls) :that.allowedUnsafeSysctls != null) return false;
    if (defaultAddCapabilities != null ? !defaultAddCapabilities.equals(that.defaultAddCapabilities) :that.defaultAddCapabilities != null) return false;
    if (defaultAllowPrivilegeEscalation != null ? !defaultAllowPrivilegeEscalation.equals(that.defaultAllowPrivilegeEscalation) :that.defaultAllowPrivilegeEscalation != null) return false;
    if (forbiddenSysctls != null ? !forbiddenSysctls.equals(that.forbiddenSysctls) :that.forbiddenSysctls != null) return false;
    if (fsGroup != null ? !fsGroup.equals(that.fsGroup) :that.fsGroup != null) return false;
    if (hostIPC != null ? !hostIPC.equals(that.hostIPC) :that.hostIPC != null) return false;
    if (hostNetwork != null ? !hostNetwork.equals(that.hostNetwork) :that.hostNetwork != null) return false;
    if (hostPID != null ? !hostPID.equals(that.hostPID) :that.hostPID != null) return false;
    if (hostPorts != null ? !hostPorts.equals(that.hostPorts) :that.hostPorts != null) return false;
    if (privileged != null ? !privileged.equals(that.privileged) :that.privileged != null) return false;
    if (readOnlyRootFilesystem != null ? !readOnlyRootFilesystem.equals(that.readOnlyRootFilesystem) :that.readOnlyRootFilesystem != null) return false;
    if (requiredDropCapabilities != null ? !requiredDropCapabilities.equals(that.requiredDropCapabilities) :that.requiredDropCapabilities != null) return false;
    if (runAsGroup != null ? !runAsGroup.equals(that.runAsGroup) :that.runAsGroup != null) return false;
    if (runAsUser != null ? !runAsUser.equals(that.runAsUser) :that.runAsUser != null) return false;
    if (runtimeClass != null ? !runtimeClass.equals(that.runtimeClass) :that.runtimeClass != null) return false;
    if (seLinux != null ? !seLinux.equals(that.seLinux) :that.seLinux != null) return false;
    if (supplementalGroups != null ? !supplementalGroups.equals(that.supplementalGroups) :that.supplementalGroups != null) return false;
    if (volumes != null ? !volumes.equals(that.volumes) :that.volumes != null) return false;
    return true;
  }
  public int hashCode() {
    return java.util.Objects.hash(allowPrivilegeEscalation,  allowedCSIDrivers,  allowedCapabilities,  allowedFlexVolumes,  allowedHostPaths,  allowedProcMountTypes,  allowedUnsafeSysctls,  defaultAddCapabilities,  defaultAllowPrivilegeEscalation,  forbiddenSysctls,  fsGroup,  hostIPC,  hostNetwork,  hostPID,  hostPorts,  privileged,  readOnlyRootFilesystem,  requiredDropCapabilities,  runAsGroup,  runAsUser,  runtimeClass,  seLinux,  supplementalGroups,  volumes,  super.hashCode());
  }
  public class AllowedCSIDriversNestedImpl<N> extends io.fabric8.kubernetes.api.model.policy.v1beta1.AllowedCSIDriverFluentImpl<io.fabric8.kubernetes.api.model.policy.v1beta1.PodSecurityPolicySpecFluent.AllowedCSIDriversNested<N>> implements io.fabric8.kubernetes.api.model.policy.v1beta1.PodSecurityPolicySpecFluent.AllowedCSIDriversNested<N>,io.fabric8.kubernetes.api.builder.Nested<N>{
    AllowedCSIDriversNestedImpl(java.lang.Integer index,io.fabric8.kubernetes.api.model.policy.v1beta1.AllowedCSIDriver item) {
      this.index = index;
      this.builder = new io.fabric8.kubernetes.api.model.policy.v1beta1.AllowedCSIDriverBuilder(this, item);
    }
    AllowedCSIDriversNestedImpl() {
      this.index = -1;
      this.builder = new io.fabric8.kubernetes.api.model.policy.v1beta1.AllowedCSIDriverBuilder(this);
    }
    io.fabric8.kubernetes.api.model.policy.v1beta1.AllowedCSIDriverBuilder builder;
    java.lang.Integer index;
    public N and() {
      return (N) PodSecurityPolicySpecFluentImpl.this.setToAllowedCSIDrivers(index,builder.build());
    }
    public N endAllowedCSIDriver() {
      return and();
    }
    
  }
  public class AllowedFlexVolumesNestedImpl<N> extends io.fabric8.kubernetes.api.model.policy.v1beta1.AllowedFlexVolumeFluentImpl<io.fabric8.kubernetes.api.model.policy.v1beta1.PodSecurityPolicySpecFluent.AllowedFlexVolumesNested<N>> implements io.fabric8.kubernetes.api.model.policy.v1beta1.PodSecurityPolicySpecFluent.AllowedFlexVolumesNested<N>,io.fabric8.kubernetes.api.builder.Nested<N>{
    AllowedFlexVolumesNestedImpl(java.lang.Integer index,io.fabric8.kubernetes.api.model.policy.v1beta1.AllowedFlexVolume item) {
      this.index = index;
      this.builder = new io.fabric8.kubernetes.api.model.policy.v1beta1.AllowedFlexVolumeBuilder(this, item);
    }
    AllowedFlexVolumesNestedImpl() {
      this.index = -1;
      this.builder = new io.fabric8.kubernetes.api.model.policy.v1beta1.AllowedFlexVolumeBuilder(this);
    }
    io.fabric8.kubernetes.api.model.policy.v1beta1.AllowedFlexVolumeBuilder builder;
    java.lang.Integer index;
    public N and() {
      return (N) PodSecurityPolicySpecFluentImpl.this.setToAllowedFlexVolumes(index,builder.build());
    }
    public N endAllowedFlexVolume() {
      return and();
    }
    
  }
  public class AllowedHostPathsNestedImpl<N> extends io.fabric8.kubernetes.api.model.policy.v1beta1.AllowedHostPathFluentImpl<io.fabric8.kubernetes.api.model.policy.v1beta1.PodSecurityPolicySpecFluent.AllowedHostPathsNested<N>> implements io.fabric8.kubernetes.api.model.policy.v1beta1.PodSecurityPolicySpecFluent.AllowedHostPathsNested<N>,io.fabric8.kubernetes.api.builder.Nested<N>{
    AllowedHostPathsNestedImpl(java.lang.Integer index,io.fabric8.kubernetes.api.model.policy.v1beta1.AllowedHostPath item) {
      this.index = index;
      this.builder = new io.fabric8.kubernetes.api.model.policy.v1beta1.AllowedHostPathBuilder(this, item);
    }
    AllowedHostPathsNestedImpl() {
      this.index = -1;
      this.builder = new io.fabric8.kubernetes.api.model.policy.v1beta1.AllowedHostPathBuilder(this);
    }
    io.fabric8.kubernetes.api.model.policy.v1beta1.AllowedHostPathBuilder builder;
    java.lang.Integer index;
    public N and() {
      return (N) PodSecurityPolicySpecFluentImpl.this.setToAllowedHostPaths(index,builder.build());
    }
    public N endAllowedHostPath() {
      return and();
    }
    
  }
  public class FsGroupNestedImpl<N> extends io.fabric8.kubernetes.api.model.policy.v1beta1.FSGroupStrategyOptionsFluentImpl<io.fabric8.kubernetes.api.model.policy.v1beta1.PodSecurityPolicySpecFluent.FsGroupNested<N>> implements io.fabric8.kubernetes.api.model.policy.v1beta1.PodSecurityPolicySpecFluent.FsGroupNested<N>,io.fabric8.kubernetes.api.builder.Nested<N>{
    FsGroupNestedImpl(io.fabric8.kubernetes.api.model.policy.v1beta1.FSGroupStrategyOptions item) {
      this.builder = new io.fabric8.kubernetes.api.model.policy.v1beta1.FSGroupStrategyOptionsBuilder(this, item);
    }
    FsGroupNestedImpl() {
      this.builder = new io.fabric8.kubernetes.api.model.policy.v1beta1.FSGroupStrategyOptionsBuilder(this);
    }
    io.fabric8.kubernetes.api.model.policy.v1beta1.FSGroupStrategyOptionsBuilder builder;
    public N and() {
      return (N) PodSecurityPolicySpecFluentImpl.this.withFsGroup(builder.build());
    }
    public N endFsGroup() {
      return and();
    }
    
  }
  public class HostPortsNestedImpl<N> extends io.fabric8.kubernetes.api.model.policy.v1beta1.HostPortRangeFluentImpl<io.fabric8.kubernetes.api.model.policy.v1beta1.PodSecurityPolicySpecFluent.HostPortsNested<N>> implements io.fabric8.kubernetes.api.model.policy.v1beta1.PodSecurityPolicySpecFluent.HostPortsNested<N>,io.fabric8.kubernetes.api.builder.Nested<N>{
    HostPortsNestedImpl(java.lang.Integer index,io.fabric8.kubernetes.api.model.policy.v1beta1.HostPortRange item) {
      this.index = index;
      this.builder = new io.fabric8.kubernetes.api.model.policy.v1beta1.HostPortRangeBuilder(this, item);
    }
    HostPortsNestedImpl() {
      this.index = -1;
      this.builder = new io.fabric8.kubernetes.api.model.policy.v1beta1.HostPortRangeBuilder(this);
    }
    io.fabric8.kubernetes.api.model.policy.v1beta1.HostPortRangeBuilder builder;
    java.lang.Integer index;
    public N and() {
      return (N) PodSecurityPolicySpecFluentImpl.this.setToHostPorts(index,builder.build());
    }
    public N endHostPort() {
      return and();
    }
    
  }
  public class RunAsGroupNestedImpl<N> extends io.fabric8.kubernetes.api.model.policy.v1beta1.RunAsGroupStrategyOptionsFluentImpl<io.fabric8.kubernetes.api.model.policy.v1beta1.PodSecurityPolicySpecFluent.RunAsGroupNested<N>> implements io.fabric8.kubernetes.api.model.policy.v1beta1.PodSecurityPolicySpecFluent.RunAsGroupNested<N>,io.fabric8.kubernetes.api.builder.Nested<N>{
    RunAsGroupNestedImpl(io.fabric8.kubernetes.api.model.policy.v1beta1.RunAsGroupStrategyOptions item) {
      this.builder = new io.fabric8.kubernetes.api.model.policy.v1beta1.RunAsGroupStrategyOptionsBuilder(this, item);
    }
    RunAsGroupNestedImpl() {
      this.builder = new io.fabric8.kubernetes.api.model.policy.v1beta1.RunAsGroupStrategyOptionsBuilder(this);
    }
    io.fabric8.kubernetes.api.model.policy.v1beta1.RunAsGroupStrategyOptionsBuilder builder;
    public N and() {
      return (N) PodSecurityPolicySpecFluentImpl.this.withRunAsGroup(builder.build());
    }
    public N endRunAsGroup() {
      return and();
    }
    
  }
  public class RunAsUserNestedImpl<N> extends io.fabric8.kubernetes.api.model.policy.v1beta1.RunAsUserStrategyOptionsFluentImpl<io.fabric8.kubernetes.api.model.policy.v1beta1.PodSecurityPolicySpecFluent.RunAsUserNested<N>> implements io.fabric8.kubernetes.api.model.policy.v1beta1.PodSecurityPolicySpecFluent.RunAsUserNested<N>,io.fabric8.kubernetes.api.builder.Nested<N>{
    RunAsUserNestedImpl(io.fabric8.kubernetes.api.model.policy.v1beta1.RunAsUserStrategyOptions item) {
      this.builder = new io.fabric8.kubernetes.api.model.policy.v1beta1.RunAsUserStrategyOptionsBuilder(this, item);
    }
    RunAsUserNestedImpl() {
      this.builder = new io.fabric8.kubernetes.api.model.policy.v1beta1.RunAsUserStrategyOptionsBuilder(this);
    }
    io.fabric8.kubernetes.api.model.policy.v1beta1.RunAsUserStrategyOptionsBuilder builder;
    public N and() {
      return (N) PodSecurityPolicySpecFluentImpl.this.withRunAsUser(builder.build());
    }
    public N endRunAsUser() {
      return and();
    }
    
  }
  public class RuntimeClassNestedImpl<N> extends io.fabric8.kubernetes.api.model.policy.v1beta1.RuntimeClassStrategyOptionsFluentImpl<io.fabric8.kubernetes.api.model.policy.v1beta1.PodSecurityPolicySpecFluent.RuntimeClassNested<N>> implements io.fabric8.kubernetes.api.model.policy.v1beta1.PodSecurityPolicySpecFluent.RuntimeClassNested<N>,io.fabric8.kubernetes.api.builder.Nested<N>{
    RuntimeClassNestedImpl(io.fabric8.kubernetes.api.model.policy.v1beta1.RuntimeClassStrategyOptions item) {
      this.builder = new io.fabric8.kubernetes.api.model.policy.v1beta1.RuntimeClassStrategyOptionsBuilder(this, item);
    }
    RuntimeClassNestedImpl() {
      this.builder = new io.fabric8.kubernetes.api.model.policy.v1beta1.RuntimeClassStrategyOptionsBuilder(this);
    }
    io.fabric8.kubernetes.api.model.policy.v1beta1.RuntimeClassStrategyOptionsBuilder builder;
    public N and() {
      return (N) PodSecurityPolicySpecFluentImpl.this.withRuntimeClass(builder.build());
    }
    public N endRuntimeClass() {
      return and();
    }
    
  }
  public class SeLinuxNestedImpl<N> extends io.fabric8.kubernetes.api.model.policy.v1beta1.SELinuxStrategyOptionsFluentImpl<io.fabric8.kubernetes.api.model.policy.v1beta1.PodSecurityPolicySpecFluent.SeLinuxNested<N>> implements io.fabric8.kubernetes.api.model.policy.v1beta1.PodSecurityPolicySpecFluent.SeLinuxNested<N>,io.fabric8.kubernetes.api.builder.Nested<N>{
    SeLinuxNestedImpl(io.fabric8.kubernetes.api.model.policy.v1beta1.SELinuxStrategyOptions item) {
      this.builder = new io.fabric8.kubernetes.api.model.policy.v1beta1.SELinuxStrategyOptionsBuilder(this, item);
    }
    SeLinuxNestedImpl() {
      this.builder = new io.fabric8.kubernetes.api.model.policy.v1beta1.SELinuxStrategyOptionsBuilder(this);
    }
    io.fabric8.kubernetes.api.model.policy.v1beta1.SELinuxStrategyOptionsBuilder builder;
    public N and() {
      return (N) PodSecurityPolicySpecFluentImpl.this.withSeLinux(builder.build());
    }
    public N endSeLinux() {
      return and();
    }
    
  }
  public class SupplementalGroupsNestedImpl<N> extends io.fabric8.kubernetes.api.model.policy.v1beta1.SupplementalGroupsStrategyOptionsFluentImpl<io.fabric8.kubernetes.api.model.policy.v1beta1.PodSecurityPolicySpecFluent.SupplementalGroupsNested<N>> implements io.fabric8.kubernetes.api.model.policy.v1beta1.PodSecurityPolicySpecFluent.SupplementalGroupsNested<N>,io.fabric8.kubernetes.api.builder.Nested<N>{
    SupplementalGroupsNestedImpl(io.fabric8.kubernetes.api.model.policy.v1beta1.SupplementalGroupsStrategyOptions item) {
      this.builder = new io.fabric8.kubernetes.api.model.policy.v1beta1.SupplementalGroupsStrategyOptionsBuilder(this, item);
    }
    SupplementalGroupsNestedImpl() {
      this.builder = new io.fabric8.kubernetes.api.model.policy.v1beta1.SupplementalGroupsStrategyOptionsBuilder(this);
    }
    io.fabric8.kubernetes.api.model.policy.v1beta1.SupplementalGroupsStrategyOptionsBuilder builder;
    public N and() {
      return (N) PodSecurityPolicySpecFluentImpl.this.withSupplementalGroups(builder.build());
    }
    public N endSupplementalGroups() {
      return and();
    }
    
  }
  
}