/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.openshift.api.model;

import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.builder.Predicate;
import io.fabric8.openshift.api.model.ClusterRoleScopeRestriction;
import io.fabric8.openshift.api.model.ClusterRoleScopeRestrictionFluent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;

public class ClusterRoleScopeRestrictionFluentImpl<A extends ClusterRoleScopeRestrictionFluent<A>>
extends BaseFluent<A>
implements ClusterRoleScopeRestrictionFluent<A> {
    private Boolean allowEscalation;
    private List<String> namespaces = new ArrayList<String>();
    private List<String> roleNames = new ArrayList<String>();

    public ClusterRoleScopeRestrictionFluentImpl() {
    }

    public ClusterRoleScopeRestrictionFluentImpl(ClusterRoleScopeRestriction instance) {
        this.withAllowEscalation(instance.getAllowEscalation());
        this.withNamespaces(instance.getNamespaces());
        this.withRoleNames(instance.getRoleNames());
    }

    @Override
    public Boolean isAllowEscalation() {
        return this.allowEscalation;
    }

    @Override
    public A withAllowEscalation(Boolean allowEscalation) {
        this.allowEscalation = allowEscalation;
        return (A)this;
    }

    @Override
    public Boolean hasAllowEscalation() {
        return this.allowEscalation != null;
    }

    @Override
    public A withNewAllowEscalation(String arg1) {
        return this.withAllowEscalation(new Boolean(arg1));
    }

    @Override
    public A withNewAllowEscalation(boolean arg1) {
        return this.withAllowEscalation(new Boolean(arg1));
    }

    @Override
    public A addToNamespaces(int index, String item) {
        if (this.namespaces == null) {
            this.namespaces = new ArrayList<String>();
        }
        this.namespaces.add(index, item);
        return (A)this;
    }

    @Override
    public A setToNamespaces(int index, String item) {
        if (this.namespaces == null) {
            this.namespaces = new ArrayList<String>();
        }
        this.namespaces.set(index, item);
        return (A)this;
    }

    @Override
    public A addToNamespaces(String ... items) {
        if (this.namespaces == null) {
            this.namespaces = new ArrayList<String>();
        }
        for (String item : items) {
            this.namespaces.add(item);
        }
        return (A)this;
    }

    @Override
    public A addAllToNamespaces(Collection<String> items) {
        if (this.namespaces == null) {
            this.namespaces = new ArrayList<String>();
        }
        for (String item : items) {
            this.namespaces.add(item);
        }
        return (A)this;
    }

    @Override
    public A removeFromNamespaces(String ... items) {
        for (String item : items) {
            if (this.namespaces == null) continue;
            this.namespaces.remove(item);
        }
        return (A)this;
    }

    @Override
    public A removeAllFromNamespaces(Collection<String> items) {
        for (String item : items) {
            if (this.namespaces == null) continue;
            this.namespaces.remove(item);
        }
        return (A)this;
    }

    @Override
    public List<String> getNamespaces() {
        return this.namespaces;
    }

    @Override
    public String getNamespace(int index) {
        return this.namespaces.get(index);
    }

    @Override
    public String getFirstNamespace() {
        return this.namespaces.get(0);
    }

    @Override
    public String getLastNamespace() {
        return this.namespaces.get(this.namespaces.size() - 1);
    }

    @Override
    public String getMatchingNamespace(Predicate<String> predicate) {
        for (String item : this.namespaces) {
            if (!predicate.apply((Object)item).booleanValue()) continue;
            return item;
        }
        return null;
    }

    @Override
    public Boolean hasMatchingNamespace(Predicate<String> predicate) {
        for (String item : this.namespaces) {
            if (!predicate.apply((Object)item).booleanValue()) continue;
            return true;
        }
        return false;
    }

    @Override
    public A withNamespaces(List<String> namespaces) {
        if (this.namespaces != null) {
            this._visitables.get((Object)"namespaces").removeAll(this.namespaces);
        }
        if (namespaces != null) {
            this.namespaces = new ArrayList<String>();
            for (String item : namespaces) {
                this.addToNamespaces(item);
            }
        } else {
            this.namespaces = null;
        }
        return (A)this;
    }

    @Override
    public A withNamespaces(String ... namespaces) {
        if (this.namespaces != null) {
            this.namespaces.clear();
        }
        if (namespaces != null) {
            for (String item : namespaces) {
                this.addToNamespaces(item);
            }
        }
        return (A)this;
    }

    @Override
    public Boolean hasNamespaces() {
        return this.namespaces != null && !this.namespaces.isEmpty();
    }

    @Override
    public A addNewNamespace(String arg1) {
        return this.addToNamespaces(new String(arg1));
    }

    @Override
    public A addNewNamespace(StringBuilder arg1) {
        return this.addToNamespaces(new String(arg1));
    }

    @Override
    public A addNewNamespace(StringBuffer arg1) {
        return this.addToNamespaces(new String(arg1));
    }

    @Override
    public A addToRoleNames(int index, String item) {
        if (this.roleNames == null) {
            this.roleNames = new ArrayList<String>();
        }
        this.roleNames.add(index, item);
        return (A)this;
    }

    @Override
    public A setToRoleNames(int index, String item) {
        if (this.roleNames == null) {
            this.roleNames = new ArrayList<String>();
        }
        this.roleNames.set(index, item);
        return (A)this;
    }

    @Override
    public A addToRoleNames(String ... items) {
        if (this.roleNames == null) {
            this.roleNames = new ArrayList<String>();
        }
        for (String item : items) {
            this.roleNames.add(item);
        }
        return (A)this;
    }

    @Override
    public A addAllToRoleNames(Collection<String> items) {
        if (this.roleNames == null) {
            this.roleNames = new ArrayList<String>();
        }
        for (String item : items) {
            this.roleNames.add(item);
        }
        return (A)this;
    }

    @Override
    public A removeFromRoleNames(String ... items) {
        for (String item : items) {
            if (this.roleNames == null) continue;
            this.roleNames.remove(item);
        }
        return (A)this;
    }

    @Override
    public A removeAllFromRoleNames(Collection<String> items) {
        for (String item : items) {
            if (this.roleNames == null) continue;
            this.roleNames.remove(item);
        }
        return (A)this;
    }

    @Override
    public List<String> getRoleNames() {
        return this.roleNames;
    }

    @Override
    public String getRoleName(int index) {
        return this.roleNames.get(index);
    }

    @Override
    public String getFirstRoleName() {
        return this.roleNames.get(0);
    }

    @Override
    public String getLastRoleName() {
        return this.roleNames.get(this.roleNames.size() - 1);
    }

    @Override
    public String getMatchingRoleName(Predicate<String> predicate) {
        for (String item : this.roleNames) {
            if (!predicate.apply((Object)item).booleanValue()) continue;
            return item;
        }
        return null;
    }

    @Override
    public Boolean hasMatchingRoleName(Predicate<String> predicate) {
        for (String item : this.roleNames) {
            if (!predicate.apply((Object)item).booleanValue()) continue;
            return true;
        }
        return false;
    }

    @Override
    public A withRoleNames(List<String> roleNames) {
        if (this.roleNames != null) {
            this._visitables.get((Object)"roleNames").removeAll(this.roleNames);
        }
        if (roleNames != null) {
            this.roleNames = new ArrayList<String>();
            for (String item : roleNames) {
                this.addToRoleNames(item);
            }
        } else {
            this.roleNames = null;
        }
        return (A)this;
    }

    @Override
    public A withRoleNames(String ... roleNames) {
        if (this.roleNames != null) {
            this.roleNames.clear();
        }
        if (roleNames != null) {
            for (String item : roleNames) {
                this.addToRoleNames(item);
            }
        }
        return (A)this;
    }

    @Override
    public Boolean hasRoleNames() {
        return this.roleNames != null && !this.roleNames.isEmpty();
    }

    @Override
    public A addNewRoleName(String arg1) {
        return this.addToRoleNames(new String(arg1));
    }

    @Override
    public A addNewRoleName(StringBuilder arg1) {
        return this.addToRoleNames(new String(arg1));
    }

    @Override
    public A addNewRoleName(StringBuffer arg1) {
        return this.addToRoleNames(new String(arg1));
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ClusterRoleScopeRestrictionFluentImpl that = (ClusterRoleScopeRestrictionFluentImpl)o;
        if (this.allowEscalation != null ? !this.allowEscalation.equals(that.allowEscalation) : that.allowEscalation != null) {
            return false;
        }
        if (this.namespaces != null ? !this.namespaces.equals(that.namespaces) : that.namespaces != null) {
            return false;
        }
        return !(this.roleNames != null ? !this.roleNames.equals(that.roleNames) : that.roleNames != null);
    }

    public int hashCode() {
        return Objects.hash(this.allowEscalation, this.namespaces, this.roleNames, super.hashCode());
    }
}

