/*
 * Decompiled with CFR 0.152.
 */
package io.grpc.netty;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import io.grpc.Attributes;
import io.grpc.NameResolver;
import io.grpc.internal.AbstractManagedChannelImplBuilder;
import io.grpc.internal.ClientTransportFactory;
import io.grpc.internal.ConnectionClientTransport;
import io.grpc.internal.GrpcUtil;
import io.grpc.internal.SharedResourceHolder;
import io.grpc.netty.GrpcSslContexts;
import io.grpc.netty.NegotiationType;
import io.grpc.netty.NettyClientTransport;
import io.grpc.netty.ProtocolNegotiator;
import io.grpc.netty.ProtocolNegotiators;
import io.grpc.netty.Utils;
import io.netty.channel.Channel;
import io.netty.channel.ChannelOption;
import io.netty.channel.EventLoopGroup;
import io.netty.channel.socket.nio.NioSocketChannel;
import io.netty.handler.ssl.SslContext;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import javax.annotation.Nullable;
import javax.net.ssl.SSLException;

public final class NettyChannelBuilder
extends AbstractManagedChannelImplBuilder<NettyChannelBuilder> {
    public static final int DEFAULT_FLOW_CONTROL_WINDOW = 0x100000;
    private final Map<ChannelOption<?>, Object> channelOptions = new HashMap();
    private NegotiationType negotiationType = NegotiationType.TLS;
    private OverrideAuthorityChecker authorityChecker;
    private Class<? extends Channel> channelType = NioSocketChannel.class;
    @Nullable
    private EventLoopGroup eventLoopGroup;
    private SslContext sslContext;
    private int flowControlWindow = 0x100000;
    private int maxHeaderListSize = 8192;
    private boolean enableKeepAlive;
    private long keepAliveDelayNanos;
    private long keepAliveTimeoutNanos;
    private TransportCreationParamsFilterFactory dynamicParamsFactory;

    public static NettyChannelBuilder forAddress(SocketAddress serverAddress) {
        return new NettyChannelBuilder(serverAddress);
    }

    public static NettyChannelBuilder forAddress(String host, int port) {
        return new NettyChannelBuilder(host, port);
    }

    public static NettyChannelBuilder forTarget(String target) {
        return new NettyChannelBuilder(target);
    }

    NettyChannelBuilder(String host, int port) {
        this(GrpcUtil.authorityFromHostAndPort((String)host, (int)port));
    }

    NettyChannelBuilder(String target) {
        super(target);
    }

    NettyChannelBuilder(SocketAddress address) {
        super(address, NettyChannelBuilder.getAuthorityFromAddress(address));
    }

    private static String getAuthorityFromAddress(SocketAddress address) {
        if (address instanceof InetSocketAddress) {
            InetSocketAddress inetAddress = (InetSocketAddress)address;
            return GrpcUtil.authorityFromHostAndPort((String)inetAddress.getHostString(), (int)inetAddress.getPort());
        }
        return address.toString();
    }

    public NettyChannelBuilder channelType(Class<? extends Channel> channelType) {
        this.channelType = (Class)Preconditions.checkNotNull(channelType, (Object)"channelType");
        return this;
    }

    public <T> NettyChannelBuilder withOption(ChannelOption<T> option, T value) {
        this.channelOptions.put(option, value);
        return this;
    }

    public NettyChannelBuilder negotiationType(NegotiationType type) {
        this.negotiationType = type;
        return this;
    }

    public NettyChannelBuilder eventLoopGroup(@Nullable EventLoopGroup eventLoopGroup) {
        this.eventLoopGroup = eventLoopGroup;
        return this;
    }

    public NettyChannelBuilder sslContext(SslContext sslContext) {
        if (sslContext != null) {
            Preconditions.checkArgument((boolean)sslContext.isClient(), (Object)"Server SSL context can not be used for client channel");
            GrpcSslContexts.ensureAlpnAndH2Enabled(sslContext.applicationProtocolNegotiator());
        }
        this.sslContext = sslContext;
        return this;
    }

    public NettyChannelBuilder flowControlWindow(int flowControlWindow) {
        Preconditions.checkArgument((flowControlWindow > 0 ? 1 : 0) != 0, (Object)"flowControlWindow must be positive");
        this.flowControlWindow = flowControlWindow;
        return this;
    }

    @Deprecated
    public NettyChannelBuilder maxMessageSize(int maxMessageSize) {
        this.maxInboundMessageSize(maxMessageSize);
        return this;
    }

    public NettyChannelBuilder maxHeaderListSize(int maxHeaderListSize) {
        Preconditions.checkArgument((maxHeaderListSize > 0 ? 1 : 0) != 0, (Object)"maxHeaderListSize must be > 0");
        this.maxHeaderListSize = maxHeaderListSize;
        return this;
    }

    public NettyChannelBuilder usePlaintext(boolean skipNegotiation) {
        if (skipNegotiation) {
            this.negotiationType(NegotiationType.PLAINTEXT);
        } else {
            this.negotiationType(NegotiationType.PLAINTEXT_UPGRADE);
        }
        return this;
    }

    public final NettyChannelBuilder enableKeepAlive(boolean enable) {
        this.enableKeepAlive = enable;
        if (enable) {
            this.keepAliveDelayNanos = GrpcUtil.DEFAULT_KEEPALIVE_DELAY_NANOS;
            this.keepAliveTimeoutNanos = GrpcUtil.DEFAULT_KEEPALIVE_TIMEOUT_NANOS;
        }
        return this;
    }

    public final NettyChannelBuilder enableKeepAlive(boolean enable, long keepAliveDelay, TimeUnit delayUnit, long keepAliveTimeout, TimeUnit timeoutUnit) {
        this.enableKeepAlive = enable;
        if (enable) {
            this.keepAliveDelayNanos = delayUnit.toNanos(keepAliveDelay);
            this.keepAliveTimeoutNanos = timeoutUnit.toNanos(keepAliveTimeout);
        }
        return this;
    }

    protected ClientTransportFactory buildTransportFactory() {
        return new NettyTransportFactory(this.dynamicParamsFactory, this.channelType, this.channelOptions, this.negotiationType, this.sslContext, this.eventLoopGroup, this.flowControlWindow, this.maxInboundMessageSize(), this.maxHeaderListSize, this.enableKeepAlive, this.keepAliveDelayNanos, this.keepAliveTimeoutNanos);
    }

    protected Attributes getNameResolverParams() {
        int defaultPort;
        switch (this.negotiationType) {
            case PLAINTEXT: 
            case PLAINTEXT_UPGRADE: {
                defaultPort = 80;
                break;
            }
            case TLS: {
                defaultPort = 443;
                break;
            }
            default: {
                throw new AssertionError((Object)((Object)((Object)this.negotiationType) + " not handled"));
            }
        }
        return Attributes.newBuilder().set(NameResolver.Factory.PARAMS_DEFAULT_PORT, (Object)defaultPort).build();
    }

    void overrideAuthorityChecker(@Nullable OverrideAuthorityChecker authorityChecker) {
        this.authorityChecker = authorityChecker;
    }

    @VisibleForTesting
    static ProtocolNegotiator createProtocolNegotiator(String authority, NegotiationType negotiationType, SslContext sslContext) {
        ProtocolNegotiator negotiator = NettyChannelBuilder.createProtocolNegotiatorByType(authority, negotiationType, sslContext);
        String proxy = System.getenv("GRPC_PROXY_EXP");
        if (proxy != null) {
            String[] parts = proxy.split(":", 2);
            int port = 80;
            if (parts.length > 1) {
                port = Integer.parseInt(parts[1]);
            }
            InetSocketAddress proxyAddress = new InetSocketAddress(parts[0], port);
            negotiator = ProtocolNegotiators.httpProxy(proxyAddress, null, null, negotiator);
        }
        return negotiator;
    }

    private static ProtocolNegotiator createProtocolNegotiatorByType(String authority, NegotiationType negotiationType, SslContext sslContext) {
        switch (negotiationType) {
            case PLAINTEXT: {
                return ProtocolNegotiators.plaintext();
            }
            case PLAINTEXT_UPGRADE: {
                return ProtocolNegotiators.plaintextUpgrade();
            }
            case TLS: {
                if (sslContext == null) {
                    try {
                        sslContext = GrpcSslContexts.forClient().build();
                    }
                    catch (SSLException ex) {
                        throw new RuntimeException(ex);
                    }
                }
                return ProtocolNegotiators.tls(sslContext, authority);
            }
        }
        throw new IllegalArgumentException("Unsupported negotiationType: " + (Object)((Object)negotiationType));
    }

    protected String checkAuthority(String authority) {
        if (this.authorityChecker != null) {
            return this.authorityChecker.checkAuthority(authority);
        }
        return super.checkAuthority(authority);
    }

    void setDynamicParamsFactory(TransportCreationParamsFilterFactory factory) {
        this.dynamicParamsFactory = (TransportCreationParamsFilterFactory)Preconditions.checkNotNull((Object)factory, (Object)"factory");
    }

    private static final class NettyTransportFactory
    implements ClientTransportFactory {
        private final TransportCreationParamsFilterFactory transportCreationParamsFilterFactory;
        private final Class<? extends Channel> channelType;
        private final Map<ChannelOption<?>, ?> channelOptions;
        private final NegotiationType negotiationType;
        private final SslContext sslContext;
        private final EventLoopGroup group;
        private final boolean usingSharedGroup;
        private final int flowControlWindow;
        private final int maxMessageSize;
        private final int maxHeaderListSize;
        private final boolean enableKeepAlive;
        private final long keepAliveDelayNanos;
        private final long keepAliveTimeoutNanos;
        private boolean closed;

        NettyTransportFactory(TransportCreationParamsFilterFactory transportCreationParamsFilterFactory, Class<? extends Channel> channelType, Map<ChannelOption<?>, ?> channelOptions, NegotiationType negotiationType, SslContext sslContext, EventLoopGroup group, int flowControlWindow, int maxMessageSize, int maxHeaderListSize, boolean enableKeepAlive, long keepAliveDelayNanos, long keepAliveTimeoutNanos) {
            this.channelType = channelType;
            this.negotiationType = negotiationType;
            this.channelOptions = new HashMap(channelOptions);
            this.sslContext = sslContext;
            if (transportCreationParamsFilterFactory == null) {
                transportCreationParamsFilterFactory = new TransportCreationParamsFilterFactory(){

                    @Override
                    public TransportCreationParamsFilter create(SocketAddress targetServerAddress, String authority, String userAgent) {
                        return new DynamicNettyTransportParams(targetServerAddress, authority, userAgent);
                    }
                };
            }
            this.transportCreationParamsFilterFactory = transportCreationParamsFilterFactory;
            this.flowControlWindow = flowControlWindow;
            this.maxMessageSize = maxMessageSize;
            this.maxHeaderListSize = maxHeaderListSize;
            this.enableKeepAlive = enableKeepAlive;
            this.keepAliveDelayNanos = keepAliveDelayNanos;
            this.keepAliveTimeoutNanos = keepAliveTimeoutNanos;
            this.usingSharedGroup = group == null;
            this.group = this.usingSharedGroup ? (EventLoopGroup)SharedResourceHolder.get(Utils.DEFAULT_WORKER_EVENT_LOOP_GROUP) : group;
        }

        public ConnectionClientTransport newClientTransport(SocketAddress serverAddress, String authority, @Nullable String userAgent) {
            Preconditions.checkState((!this.closed ? 1 : 0) != 0, (Object)"The transport factory is closed.");
            TransportCreationParamsFilter dparams = this.transportCreationParamsFilterFactory.create(serverAddress, authority, userAgent);
            NettyClientTransport transport = new NettyClientTransport(dparams.getTargetServerAddress(), this.channelType, this.channelOptions, this.group, dparams.getProtocolNegotiator(), this.flowControlWindow, this.maxMessageSize, this.maxHeaderListSize, dparams.getAuthority(), dparams.getUserAgent());
            if (this.enableKeepAlive) {
                transport.enableKeepAlive(true, this.keepAliveDelayNanos, this.keepAliveTimeoutNanos);
            }
            return transport;
        }

        public void close() {
            if (this.closed) {
                return;
            }
            this.closed = true;
            if (this.usingSharedGroup) {
                SharedResourceHolder.release(Utils.DEFAULT_WORKER_EVENT_LOOP_GROUP, (Object)this.group);
            }
        }

        private final class DynamicNettyTransportParams
        implements TransportCreationParamsFilter {
            private final SocketAddress targetServerAddress;
            private final String authority;
            @Nullable
            private final String userAgent;

            private DynamicNettyTransportParams(SocketAddress targetServerAddress, String authority, String userAgent) {
                this.targetServerAddress = targetServerAddress;
                this.authority = authority;
                this.userAgent = userAgent;
            }

            @Override
            public SocketAddress getTargetServerAddress() {
                return this.targetServerAddress;
            }

            @Override
            public String getAuthority() {
                return this.authority;
            }

            @Override
            public String getUserAgent() {
                return this.userAgent;
            }

            @Override
            public ProtocolNegotiator getProtocolNegotiator() {
                return NettyChannelBuilder.createProtocolNegotiator(this.authority, NettyTransportFactory.this.negotiationType, NettyTransportFactory.this.sslContext);
            }
        }
    }

    static interface TransportCreationParamsFilter {
        public SocketAddress getTargetServerAddress();

        public String getAuthority();

        @Nullable
        public String getUserAgent();

        public ProtocolNegotiator getProtocolNegotiator();
    }

    static interface TransportCreationParamsFilterFactory {
        public TransportCreationParamsFilter create(SocketAddress var1, String var2, @Nullable String var3);
    }

    static interface OverrideAuthorityChecker {
        public String checkAuthority(String var1);
    }
}

