package io.kubernetes.client.openapi.models;

import io.kubernetes.client.fluent.VisitableBuilder;
import java.lang.StringBuilder;
import com.google.gson.annotations.SerializedName;
import io.kubernetes.client.fluent.Nested;
import java.util.ArrayList;
import java.lang.String;
import io.kubernetes.client.fluent.Predicate;
import java.lang.StringBuffer;
import java.lang.Deprecated;
import io.kubernetes.client.fluent.BaseFluent;
import java.util.Iterator;
import java.util.Collection;
import java.lang.Object;
import java.util.List;
import java.lang.Boolean;

public class V1APIResourceListFluentImpl<A extends V1APIResourceListFluent<A>> extends io.kubernetes.client.fluent.BaseFluent<A> implements V1APIResourceListFluent<A>{

    private String apiVersion;
    private String groupVersion;
    private String kind;
    private List<V1APIResourceBuilder> resources;

    public V1APIResourceListFluentImpl(){
    }
    public V1APIResourceListFluentImpl(V1APIResourceList instance){
            this.withApiVersion(instance.getApiVersion());

            this.withGroupVersion(instance.getGroupVersion());

            this.withKind(instance.getKind());

            this.withResources(instance.getResources());

    }

    public String getApiVersion(){
            return this.apiVersion;
    }

    public A withApiVersion(String apiVersion){
            this.apiVersion=apiVersion; return (A) this;
    }

    public Boolean hasApiVersion(){
            return this.apiVersion != null;
    }

    public A withNewApiVersion(String arg1){
            return (A)withApiVersion(new String(arg1));
    }

    public A withNewApiVersion(StringBuilder arg1){
            return (A)withApiVersion(new String(arg1));
    }

    public A withNewApiVersion(StringBuffer arg1){
            return (A)withApiVersion(new String(arg1));
    }

    public String getGroupVersion(){
            return this.groupVersion;
    }

    public A withGroupVersion(String groupVersion){
            this.groupVersion=groupVersion; return (A) this;
    }

    public Boolean hasGroupVersion(){
            return this.groupVersion != null;
    }

    public A withNewGroupVersion(String arg1){
            return (A)withGroupVersion(new String(arg1));
    }

    public A withNewGroupVersion(StringBuilder arg1){
            return (A)withGroupVersion(new String(arg1));
    }

    public A withNewGroupVersion(StringBuffer arg1){
            return (A)withGroupVersion(new String(arg1));
    }

    public String getKind(){
            return this.kind;
    }

    public A withKind(String kind){
            this.kind=kind; return (A) this;
    }

    public Boolean hasKind(){
            return this.kind != null;
    }

    public A withNewKind(String arg1){
            return (A)withKind(new String(arg1));
    }

    public A withNewKind(StringBuilder arg1){
            return (A)withKind(new String(arg1));
    }

    public A withNewKind(StringBuffer arg1){
            return (A)withKind(new String(arg1));
    }

    public A addToResources(int index,V1APIResource item){
            if (this.resources == null) {this.resources = new ArrayList<V1APIResourceBuilder>();}
            V1APIResourceBuilder builder = new V1APIResourceBuilder(item);_visitables.get("resources").add(index >= 0 ? index : _visitables.get("resources").size(), builder);this.resources.add(index >= 0 ? index : resources.size(), builder); return (A)this;
    }

    public A setToResources(int index,V1APIResource item){
            if (this.resources == null) {this.resources = new ArrayList<V1APIResourceBuilder>();}
            V1APIResourceBuilder builder = new V1APIResourceBuilder(item);
            if (index < 0 || index >= _visitables.get("resources").size()) { _visitables.get("resources").add(builder); } else { _visitables.get("resources").set(index, builder);}
            if (index < 0 || index >= resources.size()) { resources.add(builder); } else { resources.set(index, builder);}
             return (A)this;
    }

    public A addToResources(V1APIResource... items){
            if (this.resources == null) {this.resources = new ArrayList<V1APIResourceBuilder>();}
            for (V1APIResource item : items) {V1APIResourceBuilder builder = new V1APIResourceBuilder(item);_visitables.get("resources").add(builder);this.resources.add(builder);} return (A)this;
    }

    public A addAllToResources(Collection<V1APIResource> items){
            if (this.resources == null) {this.resources = new ArrayList<V1APIResourceBuilder>();}
            for (V1APIResource item : items) {V1APIResourceBuilder builder = new V1APIResourceBuilder(item);_visitables.get("resources").add(builder);this.resources.add(builder);} return (A)this;
    }

    public A removeFromResources(V1APIResource... items){
            for (V1APIResource item : items) {V1APIResourceBuilder builder = new V1APIResourceBuilder(item);_visitables.get("resources").remove(builder);if (this.resources != null) {this.resources.remove(builder);}} return (A)this;
    }

    public A removeAllFromResources(Collection<V1APIResource> items){
            for (V1APIResource item : items) {V1APIResourceBuilder builder = new V1APIResourceBuilder(item);_visitables.get("resources").remove(builder);if (this.resources != null) {this.resources.remove(builder);}} return (A)this;
    }

    public A removeMatchingFromResources(io.kubernetes.client.fluent.Predicate<V1APIResourceBuilder> predicate){
            if (resources == null) return (A) this;
            final Iterator<V1APIResourceBuilder> each = resources.iterator();
            final List visitables = _visitables.get("resources");
            while (each.hasNext()) {
              V1APIResourceBuilder builder = each.next();
              if (predicate.apply(builder)) {
                visitables.remove(builder);
                each.remove();
              }
            }
            return (A)this;
    }

    
/**
 * This method has been deprecated, please use method buildResources instead.
 * @return The buildable object.
 */
@Deprecated public List<V1APIResource> getResources(){
            return build(resources);
    }

    public List<V1APIResource> buildResources(){
            return build(resources);
    }

    public V1APIResource buildResource(int index){
            return this.resources.get(index).build();
    }

    public V1APIResource buildFirstResource(){
            return this.resources.get(0).build();
    }

    public V1APIResource buildLastResource(){
            return this.resources.get(resources.size() - 1).build();
    }

    public V1APIResource buildMatchingResource(io.kubernetes.client.fluent.Predicate<V1APIResourceBuilder> predicate){
            for (V1APIResourceBuilder item: resources) { if(predicate.apply(item)){ return item.build();} } return null;
    }

    public Boolean hasMatchingResource(io.kubernetes.client.fluent.Predicate<V1APIResourceBuilder> predicate){
            for (V1APIResourceBuilder item: resources) { if(predicate.apply(item)){ return true;} } return false;
    }

    public A withResources(List<V1APIResource> resources){
            if (this.resources != null) { _visitables.get("resources").removeAll(this.resources);}
            if (resources != null) {this.resources = new ArrayList<V1APIResourceBuilder>(); for (V1APIResource item : resources){this.addToResources(item);}} else { this.resources = null;} return (A) this;
    }

    public A withResources(V1APIResource... resources){
            if (this.resources != null) {this.resources.clear();}
            if (resources != null) {for (V1APIResource item :resources){ this.addToResources(item);}} return (A) this;
    }

    public Boolean hasResources(){
            return resources != null && !resources.isEmpty();
    }

    public V1APIResourceListFluent.ResourcesNested<A> addNewResource(){
            return new ResourcesNestedImpl();
    }

    public V1APIResourceListFluent.ResourcesNested<A> addNewResourceLike(V1APIResource item){
            return new ResourcesNestedImpl(-1, item);
    }

    public V1APIResourceListFluent.ResourcesNested<A> setNewResourceLike(int index,V1APIResource item){
            return new ResourcesNestedImpl(index, item);
    }

    public V1APIResourceListFluent.ResourcesNested<A> editResource(int index){
            if (resources.size() <= index) throw new RuntimeException("Can't edit resources. Index exceeds size.");
            return setNewResourceLike(index, buildResource(index));
    }

    public V1APIResourceListFluent.ResourcesNested<A> editFirstResource(){
            if (resources.size() == 0) throw new RuntimeException("Can't edit first resources. The list is empty.");
            return setNewResourceLike(0, buildResource(0));
    }

    public V1APIResourceListFluent.ResourcesNested<A> editLastResource(){
            int index = resources.size() - 1;
            if (index < 0) throw new RuntimeException("Can't edit last resources. The list is empty.");
            return setNewResourceLike(index, buildResource(index));
    }

    public V1APIResourceListFluent.ResourcesNested<A> editMatchingResource(io.kubernetes.client.fluent.Predicate<V1APIResourceBuilder> predicate){
            int index = -1;
            for (int i=0;i<resources.size();i++) { 
            if (predicate.apply(resources.get(i))) {index = i; break;}
            } 
            if (index < 0) throw new RuntimeException("Can't edit matching resources. No match found.");
            return setNewResourceLike(index, buildResource(index));
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            V1APIResourceListFluentImpl that = (V1APIResourceListFluentImpl) o;
            if (apiVersion != null ? !apiVersion.equals(that.apiVersion) :that.apiVersion != null) return false;
            if (groupVersion != null ? !groupVersion.equals(that.groupVersion) :that.groupVersion != null) return false;
            if (kind != null ? !kind.equals(that.kind) :that.kind != null) return false;
            if (resources != null ? !resources.equals(that.resources) :that.resources != null) return false;
            return true;
    }


    public class ResourcesNestedImpl<N> extends V1APIResourceFluentImpl<V1APIResourceListFluent.ResourcesNested<N>> implements V1APIResourceListFluent.ResourcesNested<N>,io.kubernetes.client.fluent.Nested<N>{

            private final V1APIResourceBuilder builder;
        private final int index;
    
            ResourcesNestedImpl(int index,V1APIResource item){
                    this.index = index;
                    this.builder = new V1APIResourceBuilder(this, item);
            }
            ResourcesNestedImpl(){
                    this.index = -1;
                    this.builder = new V1APIResourceBuilder(this);
            }
    
    public N and(){
            return (N) V1APIResourceListFluentImpl.this.setToResources(index, builder.build());
    }
    public N endResource(){
            return and();
    }

}


}
