package io.kubernetes.client.openapi.models;

import io.kubernetes.client.fluent.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;

public class V1CinderVolumeSourceBuilder extends V1CinderVolumeSourceFluentImpl<V1CinderVolumeSourceBuilder> implements VisitableBuilder<V1CinderVolumeSource,V1CinderVolumeSourceBuilder>{

    V1CinderVolumeSourceFluent<?> fluent;
    Boolean validationEnabled;

    public V1CinderVolumeSourceBuilder(){
            this(true);
    }
    public V1CinderVolumeSourceBuilder(Boolean validationEnabled){
            this(new V1CinderVolumeSource(), validationEnabled);
    }
    public V1CinderVolumeSourceBuilder(V1CinderVolumeSourceFluent<?> fluent){
            this(fluent, true);
    }
    public V1CinderVolumeSourceBuilder(V1CinderVolumeSourceFluent<?> fluent,Boolean validationEnabled){
            this(fluent, new V1CinderVolumeSource(), validationEnabled);
    }
    public V1CinderVolumeSourceBuilder(V1CinderVolumeSourceFluent<?> fluent,V1CinderVolumeSource instance){
            this(fluent, instance, true);
    }
    public V1CinderVolumeSourceBuilder(V1CinderVolumeSourceFluent<?> fluent,V1CinderVolumeSource instance,Boolean validationEnabled){
            this.fluent = fluent; 
            fluent.withFsType(instance.getFsType());

            fluent.withReadOnly(instance.getReadOnly());

            fluent.withSecretRef(instance.getSecretRef());

            fluent.withVolumeID(instance.getVolumeID());

            this.validationEnabled = validationEnabled; 
    }
    public V1CinderVolumeSourceBuilder(V1CinderVolumeSource instance){
            this(instance,true);
    }
    public V1CinderVolumeSourceBuilder(V1CinderVolumeSource instance,Boolean validationEnabled){
            this.fluent = this; 
            this.withFsType(instance.getFsType());

            this.withReadOnly(instance.getReadOnly());

            this.withSecretRef(instance.getSecretRef());

            this.withVolumeID(instance.getVolumeID());

            this.validationEnabled = validationEnabled; 
    }

    public V1CinderVolumeSource build(){
            V1CinderVolumeSource buildable = new V1CinderVolumeSource();
            buildable.setFsType(fluent.getFsType());
            buildable.setReadOnly(fluent.isReadOnly());
            buildable.setSecretRef(fluent.getSecretRef());
            buildable.setVolumeID(fluent.getVolumeID());
            return buildable;
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            if (!super.equals(o)) return false;
            V1CinderVolumeSourceBuilder that = (V1CinderVolumeSourceBuilder) o;
            if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;

            if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
            return true;
    }




}
