package io.kubernetes.client.openapi.models;

import io.kubernetes.client.fluent.VisitableBuilder;
import com.google.gson.annotations.SerializedName;
import io.kubernetes.client.fluent.Nested;
import java.util.ArrayList;
import org.joda.time.DateTime;
import io.kubernetes.client.fluent.Predicate;
import java.lang.Integer;
import java.lang.Deprecated;
import io.kubernetes.client.fluent.BaseFluent;
import java.util.Iterator;
import java.util.Collection;
import java.lang.Object;
import java.util.List;
import java.lang.Boolean;

public class V1JobStatusFluentImpl<A extends V1JobStatusFluent<A>> extends io.kubernetes.client.fluent.BaseFluent<A> implements V1JobStatusFluent<A>{

    private Integer active;
    private DateTime completionTime;
    private List<V1JobConditionBuilder> conditions;
    private Integer failed;
    private DateTime startTime;
    private Integer succeeded;

    public V1JobStatusFluentImpl(){
    }
    public V1JobStatusFluentImpl(V1JobStatus instance){
            this.withActive(instance.getActive());

            this.withCompletionTime(instance.getCompletionTime());

            this.withConditions(instance.getConditions());

            this.withFailed(instance.getFailed());

            this.withStartTime(instance.getStartTime());

            this.withSucceeded(instance.getSucceeded());

    }

    public Integer getActive(){
            return this.active;
    }

    public A withActive(Integer active){
            this.active=active; return (A) this;
    }

    public Boolean hasActive(){
            return this.active != null;
    }

    public DateTime getCompletionTime(){
            return this.completionTime;
    }

    public A withCompletionTime(DateTime completionTime){
            this.completionTime=completionTime; return (A) this;
    }

    public Boolean hasCompletionTime(){
            return this.completionTime != null;
    }

    public A withNewCompletionTime(int arg0,int arg1,int arg2,int arg3,int arg4){
            return (A)withCompletionTime(new DateTime(arg0, arg1, arg2, arg3, arg4));
    }

    public A withNewCompletionTime(Object arg0){
            return (A)withCompletionTime(new DateTime(arg0));
    }

    public A withNewCompletionTime(long arg0){
            return (A)withCompletionTime(new DateTime(arg0));
    }

    public A addToConditions(int index,V1JobCondition item){
            if (this.conditions == null) {this.conditions = new ArrayList<V1JobConditionBuilder>();}
            V1JobConditionBuilder builder = new V1JobConditionBuilder(item);_visitables.get("conditions").add(index >= 0 ? index : _visitables.get("conditions").size(), builder);this.conditions.add(index >= 0 ? index : conditions.size(), builder); return (A)this;
    }

    public A setToConditions(int index,V1JobCondition item){
            if (this.conditions == null) {this.conditions = new ArrayList<V1JobConditionBuilder>();}
            V1JobConditionBuilder builder = new V1JobConditionBuilder(item);
            if (index < 0 || index >= _visitables.get("conditions").size()) { _visitables.get("conditions").add(builder); } else { _visitables.get("conditions").set(index, builder);}
            if (index < 0 || index >= conditions.size()) { conditions.add(builder); } else { conditions.set(index, builder);}
             return (A)this;
    }

    public A addToConditions(V1JobCondition... items){
            if (this.conditions == null) {this.conditions = new ArrayList<V1JobConditionBuilder>();}
            for (V1JobCondition item : items) {V1JobConditionBuilder builder = new V1JobConditionBuilder(item);_visitables.get("conditions").add(builder);this.conditions.add(builder);} return (A)this;
    }

    public A addAllToConditions(Collection<V1JobCondition> items){
            if (this.conditions == null) {this.conditions = new ArrayList<V1JobConditionBuilder>();}
            for (V1JobCondition item : items) {V1JobConditionBuilder builder = new V1JobConditionBuilder(item);_visitables.get("conditions").add(builder);this.conditions.add(builder);} return (A)this;
    }

    public A removeFromConditions(V1JobCondition... items){
            for (V1JobCondition item : items) {V1JobConditionBuilder builder = new V1JobConditionBuilder(item);_visitables.get("conditions").remove(builder);if (this.conditions != null) {this.conditions.remove(builder);}} return (A)this;
    }

    public A removeAllFromConditions(Collection<V1JobCondition> items){
            for (V1JobCondition item : items) {V1JobConditionBuilder builder = new V1JobConditionBuilder(item);_visitables.get("conditions").remove(builder);if (this.conditions != null) {this.conditions.remove(builder);}} return (A)this;
    }

    public A removeMatchingFromConditions(io.kubernetes.client.fluent.Predicate<V1JobConditionBuilder> predicate){
            if (conditions == null) return (A) this;
            final Iterator<V1JobConditionBuilder> each = conditions.iterator();
            final List visitables = _visitables.get("conditions");
            while (each.hasNext()) {
              V1JobConditionBuilder builder = each.next();
              if (predicate.apply(builder)) {
                visitables.remove(builder);
                each.remove();
              }
            }
            return (A)this;
    }

    
/**
 * This method has been deprecated, please use method buildConditions instead.
 * @return The buildable object.
 */
@Deprecated public List<V1JobCondition> getConditions(){
            return build(conditions);
    }

    public List<V1JobCondition> buildConditions(){
            return build(conditions);
    }

    public V1JobCondition buildCondition(int index){
            return this.conditions.get(index).build();
    }

    public V1JobCondition buildFirstCondition(){
            return this.conditions.get(0).build();
    }

    public V1JobCondition buildLastCondition(){
            return this.conditions.get(conditions.size() - 1).build();
    }

    public V1JobCondition buildMatchingCondition(io.kubernetes.client.fluent.Predicate<V1JobConditionBuilder> predicate){
            for (V1JobConditionBuilder item: conditions) { if(predicate.apply(item)){ return item.build();} } return null;
    }

    public Boolean hasMatchingCondition(io.kubernetes.client.fluent.Predicate<V1JobConditionBuilder> predicate){
            for (V1JobConditionBuilder item: conditions) { if(predicate.apply(item)){ return true;} } return false;
    }

    public A withConditions(List<V1JobCondition> conditions){
            if (this.conditions != null) { _visitables.get("conditions").removeAll(this.conditions);}
            if (conditions != null) {this.conditions = new ArrayList<V1JobConditionBuilder>(); for (V1JobCondition item : conditions){this.addToConditions(item);}} else { this.conditions = null;} return (A) this;
    }

    public A withConditions(V1JobCondition... conditions){
            if (this.conditions != null) {this.conditions.clear();}
            if (conditions != null) {for (V1JobCondition item :conditions){ this.addToConditions(item);}} return (A) this;
    }

    public Boolean hasConditions(){
            return conditions != null && !conditions.isEmpty();
    }

    public V1JobStatusFluent.ConditionsNested<A> addNewCondition(){
            return new ConditionsNestedImpl();
    }

    public V1JobStatusFluent.ConditionsNested<A> addNewConditionLike(V1JobCondition item){
            return new ConditionsNestedImpl(-1, item);
    }

    public V1JobStatusFluent.ConditionsNested<A> setNewConditionLike(int index,V1JobCondition item){
            return new ConditionsNestedImpl(index, item);
    }

    public V1JobStatusFluent.ConditionsNested<A> editCondition(int index){
            if (conditions.size() <= index) throw new RuntimeException("Can't edit conditions. Index exceeds size.");
            return setNewConditionLike(index, buildCondition(index));
    }

    public V1JobStatusFluent.ConditionsNested<A> editFirstCondition(){
            if (conditions.size() == 0) throw new RuntimeException("Can't edit first conditions. The list is empty.");
            return setNewConditionLike(0, buildCondition(0));
    }

    public V1JobStatusFluent.ConditionsNested<A> editLastCondition(){
            int index = conditions.size() - 1;
            if (index < 0) throw new RuntimeException("Can't edit last conditions. The list is empty.");
            return setNewConditionLike(index, buildCondition(index));
    }

    public V1JobStatusFluent.ConditionsNested<A> editMatchingCondition(io.kubernetes.client.fluent.Predicate<V1JobConditionBuilder> predicate){
            int index = -1;
            for (int i=0;i<conditions.size();i++) { 
            if (predicate.apply(conditions.get(i))) {index = i; break;}
            } 
            if (index < 0) throw new RuntimeException("Can't edit matching conditions. No match found.");
            return setNewConditionLike(index, buildCondition(index));
    }

    public Integer getFailed(){
            return this.failed;
    }

    public A withFailed(Integer failed){
            this.failed=failed; return (A) this;
    }

    public Boolean hasFailed(){
            return this.failed != null;
    }

    public DateTime getStartTime(){
            return this.startTime;
    }

    public A withStartTime(DateTime startTime){
            this.startTime=startTime; return (A) this;
    }

    public Boolean hasStartTime(){
            return this.startTime != null;
    }

    public A withNewStartTime(int arg0,int arg1,int arg2,int arg3,int arg4){
            return (A)withStartTime(new DateTime(arg0, arg1, arg2, arg3, arg4));
    }

    public A withNewStartTime(Object arg0){
            return (A)withStartTime(new DateTime(arg0));
    }

    public A withNewStartTime(long arg0){
            return (A)withStartTime(new DateTime(arg0));
    }

    public Integer getSucceeded(){
            return this.succeeded;
    }

    public A withSucceeded(Integer succeeded){
            this.succeeded=succeeded; return (A) this;
    }

    public Boolean hasSucceeded(){
            return this.succeeded != null;
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            V1JobStatusFluentImpl that = (V1JobStatusFluentImpl) o;
            if (active != null ? !active.equals(that.active) :that.active != null) return false;
            if (completionTime != null ? !completionTime.equals(that.completionTime) :that.completionTime != null) return false;
            if (conditions != null ? !conditions.equals(that.conditions) :that.conditions != null) return false;
            if (failed != null ? !failed.equals(that.failed) :that.failed != null) return false;
            if (startTime != null ? !startTime.equals(that.startTime) :that.startTime != null) return false;
            if (succeeded != null ? !succeeded.equals(that.succeeded) :that.succeeded != null) return false;
            return true;
    }


    public class ConditionsNestedImpl<N> extends V1JobConditionFluentImpl<V1JobStatusFluent.ConditionsNested<N>> implements V1JobStatusFluent.ConditionsNested<N>,io.kubernetes.client.fluent.Nested<N>{

            private final V1JobConditionBuilder builder;
        private final int index;
    
            ConditionsNestedImpl(int index,V1JobCondition item){
                    this.index = index;
                    this.builder = new V1JobConditionBuilder(this, item);
            }
            ConditionsNestedImpl(){
                    this.index = -1;
                    this.builder = new V1JobConditionBuilder(this);
            }
    
    public N and(){
            return (N) V1JobStatusFluentImpl.this.setToConditions(index, builder.build());
    }
    public N endCondition(){
            return and();
    }

}


}
