package io.kubernetes.client.openapi.models;

import io.kubernetes.client.fluent.VisitableBuilder;
import java.lang.StringBuilder;
import com.google.gson.annotations.SerializedName;
import io.kubernetes.client.fluent.Nested;
import java.util.ArrayList;
import java.lang.String;
import io.kubernetes.client.fluent.Predicate;
import java.lang.Deprecated;
import io.kubernetes.client.fluent.BaseFluent;
import java.util.Iterator;
import java.util.List;
import java.lang.Boolean;
import java.lang.StringBuffer;
import java.util.Collection;
import java.lang.Object;

public class V1NodeSpecFluentImpl<A extends V1NodeSpecFluent<A>> extends io.kubernetes.client.fluent.BaseFluent<A> implements V1NodeSpecFluent<A>{

    private V1NodeConfigSourceBuilder configSource;
    private String externalID;
    private String podCIDR;
    private String providerID;
    private List<V1TaintBuilder> taints;
    private Boolean unschedulable;

    public V1NodeSpecFluentImpl(){
    }
    public V1NodeSpecFluentImpl(V1NodeSpec instance){
            this.withConfigSource(instance.getConfigSource());

            this.withExternalID(instance.getExternalID());

            this.withPodCIDR(instance.getPodCIDR());

            this.withProviderID(instance.getProviderID());

            this.withTaints(instance.getTaints());

            this.withUnschedulable(instance.getUnschedulable());

    }

    
/**
 * This method has been deprecated, please use method buildConfigSource instead.
 * @return The buildable object.
 */
@Deprecated public V1NodeConfigSource getConfigSource(){
            return this.configSource!=null?this.configSource.build():null;
    }

    public V1NodeConfigSource buildConfigSource(){
            return this.configSource!=null?this.configSource.build():null;
    }

    public A withConfigSource(V1NodeConfigSource configSource){
            _visitables.get("configSource").remove(this.configSource);
            if (configSource!=null){ this.configSource= new V1NodeConfigSourceBuilder(configSource); _visitables.get("configSource").add(this.configSource);} return (A) this;
    }

    public Boolean hasConfigSource(){
            return this.configSource != null;
    }

    public V1NodeSpecFluent.ConfigSourceNested<A> withNewConfigSource(){
            return new ConfigSourceNestedImpl();
    }

    public V1NodeSpecFluent.ConfigSourceNested<A> withNewConfigSourceLike(V1NodeConfigSource item){
            return new ConfigSourceNestedImpl(item);
    }

    public V1NodeSpecFluent.ConfigSourceNested<A> editConfigSource(){
            return withNewConfigSourceLike(getConfigSource());
    }

    public V1NodeSpecFluent.ConfigSourceNested<A> editOrNewConfigSource(){
            return withNewConfigSourceLike(getConfigSource() != null ? getConfigSource(): new V1NodeConfigSourceBuilder().build());
    }

    public V1NodeSpecFluent.ConfigSourceNested<A> editOrNewConfigSourceLike(V1NodeConfigSource item){
            return withNewConfigSourceLike(getConfigSource() != null ? getConfigSource(): item);
    }

    public String getExternalID(){
            return this.externalID;
    }

    public A withExternalID(String externalID){
            this.externalID=externalID; return (A) this;
    }

    public Boolean hasExternalID(){
            return this.externalID != null;
    }

    public A withNewExternalID(String arg1){
            return (A)withExternalID(new String(arg1));
    }

    public A withNewExternalID(StringBuilder arg1){
            return (A)withExternalID(new String(arg1));
    }

    public A withNewExternalID(StringBuffer arg1){
            return (A)withExternalID(new String(arg1));
    }

    public String getPodCIDR(){
            return this.podCIDR;
    }

    public A withPodCIDR(String podCIDR){
            this.podCIDR=podCIDR; return (A) this;
    }

    public Boolean hasPodCIDR(){
            return this.podCIDR != null;
    }

    public A withNewPodCIDR(String arg1){
            return (A)withPodCIDR(new String(arg1));
    }

    public A withNewPodCIDR(StringBuilder arg1){
            return (A)withPodCIDR(new String(arg1));
    }

    public A withNewPodCIDR(StringBuffer arg1){
            return (A)withPodCIDR(new String(arg1));
    }

    public String getProviderID(){
            return this.providerID;
    }

    public A withProviderID(String providerID){
            this.providerID=providerID; return (A) this;
    }

    public Boolean hasProviderID(){
            return this.providerID != null;
    }

    public A withNewProviderID(String arg1){
            return (A)withProviderID(new String(arg1));
    }

    public A withNewProviderID(StringBuilder arg1){
            return (A)withProviderID(new String(arg1));
    }

    public A withNewProviderID(StringBuffer arg1){
            return (A)withProviderID(new String(arg1));
    }

    public A addToTaints(int index,V1Taint item){
            if (this.taints == null) {this.taints = new ArrayList<V1TaintBuilder>();}
            V1TaintBuilder builder = new V1TaintBuilder(item);_visitables.get("taints").add(index >= 0 ? index : _visitables.get("taints").size(), builder);this.taints.add(index >= 0 ? index : taints.size(), builder); return (A)this;
    }

    public A setToTaints(int index,V1Taint item){
            if (this.taints == null) {this.taints = new ArrayList<V1TaintBuilder>();}
            V1TaintBuilder builder = new V1TaintBuilder(item);
            if (index < 0 || index >= _visitables.get("taints").size()) { _visitables.get("taints").add(builder); } else { _visitables.get("taints").set(index, builder);}
            if (index < 0 || index >= taints.size()) { taints.add(builder); } else { taints.set(index, builder);}
             return (A)this;
    }

    public A addToTaints(V1Taint... items){
            if (this.taints == null) {this.taints = new ArrayList<V1TaintBuilder>();}
            for (V1Taint item : items) {V1TaintBuilder builder = new V1TaintBuilder(item);_visitables.get("taints").add(builder);this.taints.add(builder);} return (A)this;
    }

    public A addAllToTaints(Collection<V1Taint> items){
            if (this.taints == null) {this.taints = new ArrayList<V1TaintBuilder>();}
            for (V1Taint item : items) {V1TaintBuilder builder = new V1TaintBuilder(item);_visitables.get("taints").add(builder);this.taints.add(builder);} return (A)this;
    }

    public A removeFromTaints(V1Taint... items){
            for (V1Taint item : items) {V1TaintBuilder builder = new V1TaintBuilder(item);_visitables.get("taints").remove(builder);if (this.taints != null) {this.taints.remove(builder);}} return (A)this;
    }

    public A removeAllFromTaints(Collection<V1Taint> items){
            for (V1Taint item : items) {V1TaintBuilder builder = new V1TaintBuilder(item);_visitables.get("taints").remove(builder);if (this.taints != null) {this.taints.remove(builder);}} return (A)this;
    }

    public A removeMatchingFromTaints(io.kubernetes.client.fluent.Predicate<V1TaintBuilder> predicate){
            if (taints == null) return (A) this;
            final Iterator<V1TaintBuilder> each = taints.iterator();
            final List visitables = _visitables.get("taints");
            while (each.hasNext()) {
              V1TaintBuilder builder = each.next();
              if (predicate.apply(builder)) {
                visitables.remove(builder);
                each.remove();
              }
            }
            return (A)this;
    }

    
/**
 * This method has been deprecated, please use method buildTaints instead.
 * @return The buildable object.
 */
@Deprecated public List<V1Taint> getTaints(){
            return build(taints);
    }

    public List<V1Taint> buildTaints(){
            return build(taints);
    }

    public V1Taint buildTaint(int index){
            return this.taints.get(index).build();
    }

    public V1Taint buildFirstTaint(){
            return this.taints.get(0).build();
    }

    public V1Taint buildLastTaint(){
            return this.taints.get(taints.size() - 1).build();
    }

    public V1Taint buildMatchingTaint(io.kubernetes.client.fluent.Predicate<V1TaintBuilder> predicate){
            for (V1TaintBuilder item: taints) { if(predicate.apply(item)){ return item.build();} } return null;
    }

    public Boolean hasMatchingTaint(io.kubernetes.client.fluent.Predicate<V1TaintBuilder> predicate){
            for (V1TaintBuilder item: taints) { if(predicate.apply(item)){ return true;} } return false;
    }

    public A withTaints(List<V1Taint> taints){
            if (this.taints != null) { _visitables.get("taints").removeAll(this.taints);}
            if (taints != null) {this.taints = new ArrayList<V1TaintBuilder>(); for (V1Taint item : taints){this.addToTaints(item);}} else { this.taints = null;} return (A) this;
    }

    public A withTaints(V1Taint... taints){
            if (this.taints != null) {this.taints.clear();}
            if (taints != null) {for (V1Taint item :taints){ this.addToTaints(item);}} return (A) this;
    }

    public Boolean hasTaints(){
            return taints != null && !taints.isEmpty();
    }

    public V1NodeSpecFluent.TaintsNested<A> addNewTaint(){
            return new TaintsNestedImpl();
    }

    public V1NodeSpecFluent.TaintsNested<A> addNewTaintLike(V1Taint item){
            return new TaintsNestedImpl(-1, item);
    }

    public V1NodeSpecFluent.TaintsNested<A> setNewTaintLike(int index,V1Taint item){
            return new TaintsNestedImpl(index, item);
    }

    public V1NodeSpecFluent.TaintsNested<A> editTaint(int index){
            if (taints.size() <= index) throw new RuntimeException("Can't edit taints. Index exceeds size.");
            return setNewTaintLike(index, buildTaint(index));
    }

    public V1NodeSpecFluent.TaintsNested<A> editFirstTaint(){
            if (taints.size() == 0) throw new RuntimeException("Can't edit first taints. The list is empty.");
            return setNewTaintLike(0, buildTaint(0));
    }

    public V1NodeSpecFluent.TaintsNested<A> editLastTaint(){
            int index = taints.size() - 1;
            if (index < 0) throw new RuntimeException("Can't edit last taints. The list is empty.");
            return setNewTaintLike(index, buildTaint(index));
    }

    public V1NodeSpecFluent.TaintsNested<A> editMatchingTaint(io.kubernetes.client.fluent.Predicate<V1TaintBuilder> predicate){
            int index = -1;
            for (int i=0;i<taints.size();i++) { 
            if (predicate.apply(taints.get(i))) {index = i; break;}
            } 
            if (index < 0) throw new RuntimeException("Can't edit matching taints. No match found.");
            return setNewTaintLike(index, buildTaint(index));
    }

    public Boolean isUnschedulable(){
            return this.unschedulable;
    }

    public A withUnschedulable(Boolean unschedulable){
            this.unschedulable=unschedulable; return (A) this;
    }

    public Boolean hasUnschedulable(){
            return this.unschedulable != null;
    }

    public A withNewUnschedulable(String arg1){
            return (A)withUnschedulable(new Boolean(arg1));
    }

    public A withNewUnschedulable(boolean arg1){
            return (A)withUnschedulable(new Boolean(arg1));
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            V1NodeSpecFluentImpl that = (V1NodeSpecFluentImpl) o;
            if (configSource != null ? !configSource.equals(that.configSource) :that.configSource != null) return false;
            if (externalID != null ? !externalID.equals(that.externalID) :that.externalID != null) return false;
            if (podCIDR != null ? !podCIDR.equals(that.podCIDR) :that.podCIDR != null) return false;
            if (providerID != null ? !providerID.equals(that.providerID) :that.providerID != null) return false;
            if (taints != null ? !taints.equals(that.taints) :that.taints != null) return false;
            if (unschedulable != null ? !unschedulable.equals(that.unschedulable) :that.unschedulable != null) return false;
            return true;
    }


    public class ConfigSourceNestedImpl<N> extends V1NodeConfigSourceFluentImpl<V1NodeSpecFluent.ConfigSourceNested<N>> implements V1NodeSpecFluent.ConfigSourceNested<N>,io.kubernetes.client.fluent.Nested<N>{

            private final V1NodeConfigSourceBuilder builder;
    
            ConfigSourceNestedImpl(V1NodeConfigSource item){
                    this.builder = new V1NodeConfigSourceBuilder(this, item);
            }
            ConfigSourceNestedImpl(){
                    this.builder = new V1NodeConfigSourceBuilder(this);
            }
    
    public N and(){
            return (N) V1NodeSpecFluentImpl.this.withConfigSource(builder.build());
    }
    public N endConfigSource(){
            return and();
    }

}
    public class TaintsNestedImpl<N> extends V1TaintFluentImpl<V1NodeSpecFluent.TaintsNested<N>> implements V1NodeSpecFluent.TaintsNested<N>,io.kubernetes.client.fluent.Nested<N>{

            private final V1TaintBuilder builder;
        private final int index;
    
            TaintsNestedImpl(int index,V1Taint item){
                    this.index = index;
                    this.builder = new V1TaintBuilder(this, item);
            }
            TaintsNestedImpl(){
                    this.index = -1;
                    this.builder = new V1TaintBuilder(this);
            }
    
    public N and(){
            return (N) V1NodeSpecFluentImpl.this.setToTaints(index, builder.build());
    }
    public N endTaint(){
            return and();
    }

}


}
