package io.kubernetes.client.openapi.models;

import java.lang.StringBuilder;
import com.google.gson.annotations.SerializedName;
import java.util.ArrayList;
import java.lang.String;
import io.kubernetes.client.fluent.Predicate;
import java.lang.StringBuffer;
import io.kubernetes.client.fluent.BaseFluent;
import java.util.Collection;
import java.lang.Object;
import java.util.List;
import java.lang.Boolean;

public class V1beta1CSINodeDriverFluentImpl<A extends V1beta1CSINodeDriverFluent<A>> extends io.kubernetes.client.fluent.BaseFluent<A> implements V1beta1CSINodeDriverFluent<A>{

    private String name;
    private String nodeID;
    private List<String> topologyKeys;

    public V1beta1CSINodeDriverFluentImpl(){
    }
    public V1beta1CSINodeDriverFluentImpl(V1beta1CSINodeDriver instance){
            this.withName(instance.getName());

            this.withNodeID(instance.getNodeID());

            this.withTopologyKeys(instance.getTopologyKeys());

    }

    public String getName(){
            return this.name;
    }

    public A withName(String name){
            this.name=name; return (A) this;
    }

    public Boolean hasName(){
            return this.name != null;
    }

    public A withNewName(String arg1){
            return (A)withName(new String(arg1));
    }

    public A withNewName(StringBuilder arg1){
            return (A)withName(new String(arg1));
    }

    public A withNewName(StringBuffer arg1){
            return (A)withName(new String(arg1));
    }

    public String getNodeID(){
            return this.nodeID;
    }

    public A withNodeID(String nodeID){
            this.nodeID=nodeID; return (A) this;
    }

    public Boolean hasNodeID(){
            return this.nodeID != null;
    }

    public A withNewNodeID(String arg1){
            return (A)withNodeID(new String(arg1));
    }

    public A withNewNodeID(StringBuilder arg1){
            return (A)withNodeID(new String(arg1));
    }

    public A withNewNodeID(StringBuffer arg1){
            return (A)withNodeID(new String(arg1));
    }

    public A addToTopologyKeys(int index,String item){
            if (this.topologyKeys == null) {this.topologyKeys = new ArrayList<String>();}
            this.topologyKeys.add(index, item);
            return (A)this;
    }

    public A setToTopologyKeys(int index,String item){
            if (this.topologyKeys == null) {this.topologyKeys = new ArrayList<String>();}
            this.topologyKeys.set(index, item); return (A)this;
    }

    public A addToTopologyKeys(String... items){
            if (this.topologyKeys == null) {this.topologyKeys = new ArrayList<String>();}
            for (String item : items) {this.topologyKeys.add(item);} return (A)this;
    }

    public A addAllToTopologyKeys(Collection<String> items){
            if (this.topologyKeys == null) {this.topologyKeys = new ArrayList<String>();}
            for (String item : items) {this.topologyKeys.add(item);} return (A)this;
    }

    public A removeFromTopologyKeys(String... items){
            for (String item : items) {if (this.topologyKeys!= null){ this.topologyKeys.remove(item);}} return (A)this;
    }

    public A removeAllFromTopologyKeys(Collection<String> items){
            for (String item : items) {if (this.topologyKeys!= null){ this.topologyKeys.remove(item);}} return (A)this;
    }

    public List<String> getTopologyKeys(){
            return this.topologyKeys;
    }

    public String getTopologyKey(int index){
            return this.topologyKeys.get(index);
    }

    public String getFirstTopologyKey(){
            return this.topologyKeys.get(0);
    }

    public String getLastTopologyKey(){
            return this.topologyKeys.get(topologyKeys.size() - 1);
    }

    public String getMatchingTopologyKey(io.kubernetes.client.fluent.Predicate<String> predicate){
            for (String item: topologyKeys) { if(predicate.apply(item)){ return item;} } return null;
    }

    public Boolean hasMatchingTopologyKey(io.kubernetes.client.fluent.Predicate<String> predicate){
            for (String item: topologyKeys) { if(predicate.apply(item)){ return true;} } return false;
    }

    public A withTopologyKeys(List<String> topologyKeys){
            if (this.topologyKeys != null) { _visitables.get("topologyKeys").removeAll(this.topologyKeys);}
            if (topologyKeys != null) {this.topologyKeys = new ArrayList<String>(); for (String item : topologyKeys){this.addToTopologyKeys(item);}} else { this.topologyKeys = null;} return (A) this;
    }

    public A withTopologyKeys(String... topologyKeys){
            if (this.topologyKeys != null) {this.topologyKeys.clear();}
            if (topologyKeys != null) {for (String item :topologyKeys){ this.addToTopologyKeys(item);}} return (A) this;
    }

    public Boolean hasTopologyKeys(){
            return topologyKeys != null && !topologyKeys.isEmpty();
    }

    public A addNewTopologyKey(String arg1){
            return (A)addToTopologyKeys(new String(arg1));
    }

    public A addNewTopologyKey(StringBuilder arg1){
            return (A)addToTopologyKeys(new String(arg1));
    }

    public A addNewTopologyKey(StringBuffer arg1){
            return (A)addToTopologyKeys(new String(arg1));
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            V1beta1CSINodeDriverFluentImpl that = (V1beta1CSINodeDriverFluentImpl) o;
            if (name != null ? !name.equals(that.name) :that.name != null) return false;
            if (nodeID != null ? !nodeID.equals(that.nodeID) :that.nodeID != null) return false;
            if (topologyKeys != null ? !topologyKeys.equals(that.topologyKeys) :that.topologyKeys != null) return false;
            return true;
    }




}
