package io.kubernetes.client.openapi.models;

import io.kubernetes.client.fluent.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;

public class V1beta1DaemonSetUpdateStrategyBuilder extends V1beta1DaemonSetUpdateStrategyFluentImpl<V1beta1DaemonSetUpdateStrategyBuilder> implements VisitableBuilder<V1beta1DaemonSetUpdateStrategy,V1beta1DaemonSetUpdateStrategyBuilder>{

    V1beta1DaemonSetUpdateStrategyFluent<?> fluent;
    Boolean validationEnabled;

    public V1beta1DaemonSetUpdateStrategyBuilder(){
            this(true);
    }
    public V1beta1DaemonSetUpdateStrategyBuilder(Boolean validationEnabled){
            this(new V1beta1DaemonSetUpdateStrategy(), validationEnabled);
    }
    public V1beta1DaemonSetUpdateStrategyBuilder(V1beta1DaemonSetUpdateStrategyFluent<?> fluent){
            this(fluent, true);
    }
    public V1beta1DaemonSetUpdateStrategyBuilder(V1beta1DaemonSetUpdateStrategyFluent<?> fluent,Boolean validationEnabled){
            this(fluent, new V1beta1DaemonSetUpdateStrategy(), validationEnabled);
    }
    public V1beta1DaemonSetUpdateStrategyBuilder(V1beta1DaemonSetUpdateStrategyFluent<?> fluent,V1beta1DaemonSetUpdateStrategy instance){
            this(fluent, instance, true);
    }
    public V1beta1DaemonSetUpdateStrategyBuilder(V1beta1DaemonSetUpdateStrategyFluent<?> fluent,V1beta1DaemonSetUpdateStrategy instance,Boolean validationEnabled){
            this.fluent = fluent; 
            fluent.withRollingUpdate(instance.getRollingUpdate());

            fluent.withType(instance.getType());

            this.validationEnabled = validationEnabled; 
    }
    public V1beta1DaemonSetUpdateStrategyBuilder(V1beta1DaemonSetUpdateStrategy instance){
            this(instance,true);
    }
    public V1beta1DaemonSetUpdateStrategyBuilder(V1beta1DaemonSetUpdateStrategy instance,Boolean validationEnabled){
            this.fluent = this; 
            this.withRollingUpdate(instance.getRollingUpdate());

            this.withType(instance.getType());

            this.validationEnabled = validationEnabled; 
    }

    public V1beta1DaemonSetUpdateStrategy build(){
            V1beta1DaemonSetUpdateStrategy buildable = new V1beta1DaemonSetUpdateStrategy();
            buildable.setRollingUpdate(fluent.getRollingUpdate());
            buildable.setType(fluent.getType());
            return buildable;
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            if (!super.equals(o)) return false;
            V1beta1DaemonSetUpdateStrategyBuilder that = (V1beta1DaemonSetUpdateStrategyBuilder) o;
            if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;

            if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
            return true;
    }




}
