package io.kubernetes.client.openapi.models;

import io.kubernetes.client.fluent.VisitableBuilder;
import java.lang.StringBuilder;
import com.google.gson.annotations.SerializedName;
import io.kubernetes.client.fluent.Nested;
import java.util.ArrayList;
import java.lang.String;
import io.kubernetes.client.fluent.Predicate;
import java.lang.Deprecated;
import io.kubernetes.client.fluent.BaseFluent;
import java.util.Iterator;
import java.util.List;
import java.lang.Boolean;
import java.lang.Integer;
import java.lang.StringBuffer;
import java.util.Collection;
import java.lang.Object;

public class V1beta1MutatingWebhookFluentImpl<A extends V1beta1MutatingWebhookFluent<A>> extends io.kubernetes.client.fluent.BaseFluent<A> implements V1beta1MutatingWebhookFluent<A>{

    private List<String> admissionReviewVersions;
    private AdmissionregistrationV1beta1WebhookClientConfigBuilder clientConfig;
    private String failurePolicy;
    private String matchPolicy;
    private String name;
    private V1LabelSelectorBuilder namespaceSelector;
    private V1LabelSelectorBuilder objectSelector;
    private String reinvocationPolicy;
    private List<V1beta1RuleWithOperationsBuilder> rules;
    private String sideEffects;
    private Integer timeoutSeconds;

    public V1beta1MutatingWebhookFluentImpl(){
    }
    public V1beta1MutatingWebhookFluentImpl(V1beta1MutatingWebhook instance){
            this.withAdmissionReviewVersions(instance.getAdmissionReviewVersions());

            this.withClientConfig(instance.getClientConfig());

            this.withFailurePolicy(instance.getFailurePolicy());

            this.withMatchPolicy(instance.getMatchPolicy());

            this.withName(instance.getName());

            this.withNamespaceSelector(instance.getNamespaceSelector());

            this.withObjectSelector(instance.getObjectSelector());

            this.withReinvocationPolicy(instance.getReinvocationPolicy());

            this.withRules(instance.getRules());

            this.withSideEffects(instance.getSideEffects());

            this.withTimeoutSeconds(instance.getTimeoutSeconds());

    }

    public A addToAdmissionReviewVersions(int index,String item){
            if (this.admissionReviewVersions == null) {this.admissionReviewVersions = new ArrayList<String>();}
            this.admissionReviewVersions.add(index, item);
            return (A)this;
    }

    public A setToAdmissionReviewVersions(int index,String item){
            if (this.admissionReviewVersions == null) {this.admissionReviewVersions = new ArrayList<String>();}
            this.admissionReviewVersions.set(index, item); return (A)this;
    }

    public A addToAdmissionReviewVersions(String... items){
            if (this.admissionReviewVersions == null) {this.admissionReviewVersions = new ArrayList<String>();}
            for (String item : items) {this.admissionReviewVersions.add(item);} return (A)this;
    }

    public A addAllToAdmissionReviewVersions(Collection<String> items){
            if (this.admissionReviewVersions == null) {this.admissionReviewVersions = new ArrayList<String>();}
            for (String item : items) {this.admissionReviewVersions.add(item);} return (A)this;
    }

    public A removeFromAdmissionReviewVersions(String... items){
            for (String item : items) {if (this.admissionReviewVersions!= null){ this.admissionReviewVersions.remove(item);}} return (A)this;
    }

    public A removeAllFromAdmissionReviewVersions(Collection<String> items){
            for (String item : items) {if (this.admissionReviewVersions!= null){ this.admissionReviewVersions.remove(item);}} return (A)this;
    }

    public List<String> getAdmissionReviewVersions(){
            return this.admissionReviewVersions;
    }

    public String getAdmissionReviewVersion(int index){
            return this.admissionReviewVersions.get(index);
    }

    public String getFirstAdmissionReviewVersion(){
            return this.admissionReviewVersions.get(0);
    }

    public String getLastAdmissionReviewVersion(){
            return this.admissionReviewVersions.get(admissionReviewVersions.size() - 1);
    }

    public String getMatchingAdmissionReviewVersion(io.kubernetes.client.fluent.Predicate<String> predicate){
            for (String item: admissionReviewVersions) { if(predicate.apply(item)){ return item;} } return null;
    }

    public Boolean hasMatchingAdmissionReviewVersion(io.kubernetes.client.fluent.Predicate<String> predicate){
            for (String item: admissionReviewVersions) { if(predicate.apply(item)){ return true;} } return false;
    }

    public A withAdmissionReviewVersions(List<String> admissionReviewVersions){
            if (this.admissionReviewVersions != null) { _visitables.get("admissionReviewVersions").removeAll(this.admissionReviewVersions);}
            if (admissionReviewVersions != null) {this.admissionReviewVersions = new ArrayList<String>(); for (String item : admissionReviewVersions){this.addToAdmissionReviewVersions(item);}} else { this.admissionReviewVersions = null;} return (A) this;
    }

    public A withAdmissionReviewVersions(String... admissionReviewVersions){
            if (this.admissionReviewVersions != null) {this.admissionReviewVersions.clear();}
            if (admissionReviewVersions != null) {for (String item :admissionReviewVersions){ this.addToAdmissionReviewVersions(item);}} return (A) this;
    }

    public Boolean hasAdmissionReviewVersions(){
            return admissionReviewVersions != null && !admissionReviewVersions.isEmpty();
    }

    public A addNewAdmissionReviewVersion(String arg1){
            return (A)addToAdmissionReviewVersions(new String(arg1));
    }

    public A addNewAdmissionReviewVersion(StringBuilder arg1){
            return (A)addToAdmissionReviewVersions(new String(arg1));
    }

    public A addNewAdmissionReviewVersion(StringBuffer arg1){
            return (A)addToAdmissionReviewVersions(new String(arg1));
    }

    
/**
 * This method has been deprecated, please use method buildClientConfig instead.
 * @return The buildable object.
 */
@Deprecated public AdmissionregistrationV1beta1WebhookClientConfig getClientConfig(){
            return this.clientConfig!=null?this.clientConfig.build():null;
    }

    public AdmissionregistrationV1beta1WebhookClientConfig buildClientConfig(){
            return this.clientConfig!=null?this.clientConfig.build():null;
    }

    public A withClientConfig(AdmissionregistrationV1beta1WebhookClientConfig clientConfig){
            _visitables.get("clientConfig").remove(this.clientConfig);
            if (clientConfig!=null){ this.clientConfig= new AdmissionregistrationV1beta1WebhookClientConfigBuilder(clientConfig); _visitables.get("clientConfig").add(this.clientConfig);} return (A) this;
    }

    public Boolean hasClientConfig(){
            return this.clientConfig != null;
    }

    public V1beta1MutatingWebhookFluent.ClientConfigNested<A> withNewClientConfig(){
            return new ClientConfigNestedImpl();
    }

    public V1beta1MutatingWebhookFluent.ClientConfigNested<A> withNewClientConfigLike(AdmissionregistrationV1beta1WebhookClientConfig item){
            return new ClientConfigNestedImpl(item);
    }

    public V1beta1MutatingWebhookFluent.ClientConfigNested<A> editClientConfig(){
            return withNewClientConfigLike(getClientConfig());
    }

    public V1beta1MutatingWebhookFluent.ClientConfigNested<A> editOrNewClientConfig(){
            return withNewClientConfigLike(getClientConfig() != null ? getClientConfig(): new AdmissionregistrationV1beta1WebhookClientConfigBuilder().build());
    }

    public V1beta1MutatingWebhookFluent.ClientConfigNested<A> editOrNewClientConfigLike(AdmissionregistrationV1beta1WebhookClientConfig item){
            return withNewClientConfigLike(getClientConfig() != null ? getClientConfig(): item);
    }

    public String getFailurePolicy(){
            return this.failurePolicy;
    }

    public A withFailurePolicy(String failurePolicy){
            this.failurePolicy=failurePolicy; return (A) this;
    }

    public Boolean hasFailurePolicy(){
            return this.failurePolicy != null;
    }

    public A withNewFailurePolicy(String arg1){
            return (A)withFailurePolicy(new String(arg1));
    }

    public A withNewFailurePolicy(StringBuilder arg1){
            return (A)withFailurePolicy(new String(arg1));
    }

    public A withNewFailurePolicy(StringBuffer arg1){
            return (A)withFailurePolicy(new String(arg1));
    }

    public String getMatchPolicy(){
            return this.matchPolicy;
    }

    public A withMatchPolicy(String matchPolicy){
            this.matchPolicy=matchPolicy; return (A) this;
    }

    public Boolean hasMatchPolicy(){
            return this.matchPolicy != null;
    }

    public A withNewMatchPolicy(String arg1){
            return (A)withMatchPolicy(new String(arg1));
    }

    public A withNewMatchPolicy(StringBuilder arg1){
            return (A)withMatchPolicy(new String(arg1));
    }

    public A withNewMatchPolicy(StringBuffer arg1){
            return (A)withMatchPolicy(new String(arg1));
    }

    public String getName(){
            return this.name;
    }

    public A withName(String name){
            this.name=name; return (A) this;
    }

    public Boolean hasName(){
            return this.name != null;
    }

    public A withNewName(String arg1){
            return (A)withName(new String(arg1));
    }

    public A withNewName(StringBuilder arg1){
            return (A)withName(new String(arg1));
    }

    public A withNewName(StringBuffer arg1){
            return (A)withName(new String(arg1));
    }

    
/**
 * This method has been deprecated, please use method buildNamespaceSelector instead.
 * @return The buildable object.
 */
@Deprecated public V1LabelSelector getNamespaceSelector(){
            return this.namespaceSelector!=null?this.namespaceSelector.build():null;
    }

    public V1LabelSelector buildNamespaceSelector(){
            return this.namespaceSelector!=null?this.namespaceSelector.build():null;
    }

    public A withNamespaceSelector(V1LabelSelector namespaceSelector){
            _visitables.get("namespaceSelector").remove(this.namespaceSelector);
            if (namespaceSelector!=null){ this.namespaceSelector= new V1LabelSelectorBuilder(namespaceSelector); _visitables.get("namespaceSelector").add(this.namespaceSelector);} return (A) this;
    }

    public Boolean hasNamespaceSelector(){
            return this.namespaceSelector != null;
    }

    public V1beta1MutatingWebhookFluent.NamespaceSelectorNested<A> withNewNamespaceSelector(){
            return new NamespaceSelectorNestedImpl();
    }

    public V1beta1MutatingWebhookFluent.NamespaceSelectorNested<A> withNewNamespaceSelectorLike(V1LabelSelector item){
            return new NamespaceSelectorNestedImpl(item);
    }

    public V1beta1MutatingWebhookFluent.NamespaceSelectorNested<A> editNamespaceSelector(){
            return withNewNamespaceSelectorLike(getNamespaceSelector());
    }

    public V1beta1MutatingWebhookFluent.NamespaceSelectorNested<A> editOrNewNamespaceSelector(){
            return withNewNamespaceSelectorLike(getNamespaceSelector() != null ? getNamespaceSelector(): new V1LabelSelectorBuilder().build());
    }

    public V1beta1MutatingWebhookFluent.NamespaceSelectorNested<A> editOrNewNamespaceSelectorLike(V1LabelSelector item){
            return withNewNamespaceSelectorLike(getNamespaceSelector() != null ? getNamespaceSelector(): item);
    }

    
/**
 * This method has been deprecated, please use method buildObjectSelector instead.
 * @return The buildable object.
 */
@Deprecated public V1LabelSelector getObjectSelector(){
            return this.objectSelector!=null?this.objectSelector.build():null;
    }

    public V1LabelSelector buildObjectSelector(){
            return this.objectSelector!=null?this.objectSelector.build():null;
    }

    public A withObjectSelector(V1LabelSelector objectSelector){
            _visitables.get("objectSelector").remove(this.objectSelector);
            if (objectSelector!=null){ this.objectSelector= new V1LabelSelectorBuilder(objectSelector); _visitables.get("objectSelector").add(this.objectSelector);} return (A) this;
    }

    public Boolean hasObjectSelector(){
            return this.objectSelector != null;
    }

    public V1beta1MutatingWebhookFluent.ObjectSelectorNested<A> withNewObjectSelector(){
            return new ObjectSelectorNestedImpl();
    }

    public V1beta1MutatingWebhookFluent.ObjectSelectorNested<A> withNewObjectSelectorLike(V1LabelSelector item){
            return new ObjectSelectorNestedImpl(item);
    }

    public V1beta1MutatingWebhookFluent.ObjectSelectorNested<A> editObjectSelector(){
            return withNewObjectSelectorLike(getObjectSelector());
    }

    public V1beta1MutatingWebhookFluent.ObjectSelectorNested<A> editOrNewObjectSelector(){
            return withNewObjectSelectorLike(getObjectSelector() != null ? getObjectSelector(): new V1LabelSelectorBuilder().build());
    }

    public V1beta1MutatingWebhookFluent.ObjectSelectorNested<A> editOrNewObjectSelectorLike(V1LabelSelector item){
            return withNewObjectSelectorLike(getObjectSelector() != null ? getObjectSelector(): item);
    }

    public String getReinvocationPolicy(){
            return this.reinvocationPolicy;
    }

    public A withReinvocationPolicy(String reinvocationPolicy){
            this.reinvocationPolicy=reinvocationPolicy; return (A) this;
    }

    public Boolean hasReinvocationPolicy(){
            return this.reinvocationPolicy != null;
    }

    public A withNewReinvocationPolicy(String arg1){
            return (A)withReinvocationPolicy(new String(arg1));
    }

    public A withNewReinvocationPolicy(StringBuilder arg1){
            return (A)withReinvocationPolicy(new String(arg1));
    }

    public A withNewReinvocationPolicy(StringBuffer arg1){
            return (A)withReinvocationPolicy(new String(arg1));
    }

    public A addToRules(int index,V1beta1RuleWithOperations item){
            if (this.rules == null) {this.rules = new ArrayList<V1beta1RuleWithOperationsBuilder>();}
            V1beta1RuleWithOperationsBuilder builder = new V1beta1RuleWithOperationsBuilder(item);_visitables.get("rules").add(index >= 0 ? index : _visitables.get("rules").size(), builder);this.rules.add(index >= 0 ? index : rules.size(), builder); return (A)this;
    }

    public A setToRules(int index,V1beta1RuleWithOperations item){
            if (this.rules == null) {this.rules = new ArrayList<V1beta1RuleWithOperationsBuilder>();}
            V1beta1RuleWithOperationsBuilder builder = new V1beta1RuleWithOperationsBuilder(item);
            if (index < 0 || index >= _visitables.get("rules").size()) { _visitables.get("rules").add(builder); } else { _visitables.get("rules").set(index, builder);}
            if (index < 0 || index >= rules.size()) { rules.add(builder); } else { rules.set(index, builder);}
             return (A)this;
    }

    public A addToRules(V1beta1RuleWithOperations... items){
            if (this.rules == null) {this.rules = new ArrayList<V1beta1RuleWithOperationsBuilder>();}
            for (V1beta1RuleWithOperations item : items) {V1beta1RuleWithOperationsBuilder builder = new V1beta1RuleWithOperationsBuilder(item);_visitables.get("rules").add(builder);this.rules.add(builder);} return (A)this;
    }

    public A addAllToRules(Collection<V1beta1RuleWithOperations> items){
            if (this.rules == null) {this.rules = new ArrayList<V1beta1RuleWithOperationsBuilder>();}
            for (V1beta1RuleWithOperations item : items) {V1beta1RuleWithOperationsBuilder builder = new V1beta1RuleWithOperationsBuilder(item);_visitables.get("rules").add(builder);this.rules.add(builder);} return (A)this;
    }

    public A removeFromRules(V1beta1RuleWithOperations... items){
            for (V1beta1RuleWithOperations item : items) {V1beta1RuleWithOperationsBuilder builder = new V1beta1RuleWithOperationsBuilder(item);_visitables.get("rules").remove(builder);if (this.rules != null) {this.rules.remove(builder);}} return (A)this;
    }

    public A removeAllFromRules(Collection<V1beta1RuleWithOperations> items){
            for (V1beta1RuleWithOperations item : items) {V1beta1RuleWithOperationsBuilder builder = new V1beta1RuleWithOperationsBuilder(item);_visitables.get("rules").remove(builder);if (this.rules != null) {this.rules.remove(builder);}} return (A)this;
    }

    public A removeMatchingFromRules(io.kubernetes.client.fluent.Predicate<V1beta1RuleWithOperationsBuilder> predicate){
            if (rules == null) return (A) this;
            final Iterator<V1beta1RuleWithOperationsBuilder> each = rules.iterator();
            final List visitables = _visitables.get("rules");
            while (each.hasNext()) {
              V1beta1RuleWithOperationsBuilder builder = each.next();
              if (predicate.apply(builder)) {
                visitables.remove(builder);
                each.remove();
              }
            }
            return (A)this;
    }

    
/**
 * This method has been deprecated, please use method buildRules instead.
 * @return The buildable object.
 */
@Deprecated public List<V1beta1RuleWithOperations> getRules(){
            return build(rules);
    }

    public List<V1beta1RuleWithOperations> buildRules(){
            return build(rules);
    }

    public V1beta1RuleWithOperations buildRule(int index){
            return this.rules.get(index).build();
    }

    public V1beta1RuleWithOperations buildFirstRule(){
            return this.rules.get(0).build();
    }

    public V1beta1RuleWithOperations buildLastRule(){
            return this.rules.get(rules.size() - 1).build();
    }

    public V1beta1RuleWithOperations buildMatchingRule(io.kubernetes.client.fluent.Predicate<V1beta1RuleWithOperationsBuilder> predicate){
            for (V1beta1RuleWithOperationsBuilder item: rules) { if(predicate.apply(item)){ return item.build();} } return null;
    }

    public Boolean hasMatchingRule(io.kubernetes.client.fluent.Predicate<V1beta1RuleWithOperationsBuilder> predicate){
            for (V1beta1RuleWithOperationsBuilder item: rules) { if(predicate.apply(item)){ return true;} } return false;
    }

    public A withRules(List<V1beta1RuleWithOperations> rules){
            if (this.rules != null) { _visitables.get("rules").removeAll(this.rules);}
            if (rules != null) {this.rules = new ArrayList<V1beta1RuleWithOperationsBuilder>(); for (V1beta1RuleWithOperations item : rules){this.addToRules(item);}} else { this.rules = null;} return (A) this;
    }

    public A withRules(V1beta1RuleWithOperations... rules){
            if (this.rules != null) {this.rules.clear();}
            if (rules != null) {for (V1beta1RuleWithOperations item :rules){ this.addToRules(item);}} return (A) this;
    }

    public Boolean hasRules(){
            return rules != null && !rules.isEmpty();
    }

    public V1beta1MutatingWebhookFluent.RulesNested<A> addNewRule(){
            return new RulesNestedImpl();
    }

    public V1beta1MutatingWebhookFluent.RulesNested<A> addNewRuleLike(V1beta1RuleWithOperations item){
            return new RulesNestedImpl(-1, item);
    }

    public V1beta1MutatingWebhookFluent.RulesNested<A> setNewRuleLike(int index,V1beta1RuleWithOperations item){
            return new RulesNestedImpl(index, item);
    }

    public V1beta1MutatingWebhookFluent.RulesNested<A> editRule(int index){
            if (rules.size() <= index) throw new RuntimeException("Can't edit rules. Index exceeds size.");
            return setNewRuleLike(index, buildRule(index));
    }

    public V1beta1MutatingWebhookFluent.RulesNested<A> editFirstRule(){
            if (rules.size() == 0) throw new RuntimeException("Can't edit first rules. The list is empty.");
            return setNewRuleLike(0, buildRule(0));
    }

    public V1beta1MutatingWebhookFluent.RulesNested<A> editLastRule(){
            int index = rules.size() - 1;
            if (index < 0) throw new RuntimeException("Can't edit last rules. The list is empty.");
            return setNewRuleLike(index, buildRule(index));
    }

    public V1beta1MutatingWebhookFluent.RulesNested<A> editMatchingRule(io.kubernetes.client.fluent.Predicate<V1beta1RuleWithOperationsBuilder> predicate){
            int index = -1;
            for (int i=0;i<rules.size();i++) { 
            if (predicate.apply(rules.get(i))) {index = i; break;}
            } 
            if (index < 0) throw new RuntimeException("Can't edit matching rules. No match found.");
            return setNewRuleLike(index, buildRule(index));
    }

    public String getSideEffects(){
            return this.sideEffects;
    }

    public A withSideEffects(String sideEffects){
            this.sideEffects=sideEffects; return (A) this;
    }

    public Boolean hasSideEffects(){
            return this.sideEffects != null;
    }

    public A withNewSideEffects(String arg1){
            return (A)withSideEffects(new String(arg1));
    }

    public A withNewSideEffects(StringBuilder arg1){
            return (A)withSideEffects(new String(arg1));
    }

    public A withNewSideEffects(StringBuffer arg1){
            return (A)withSideEffects(new String(arg1));
    }

    public Integer getTimeoutSeconds(){
            return this.timeoutSeconds;
    }

    public A withTimeoutSeconds(Integer timeoutSeconds){
            this.timeoutSeconds=timeoutSeconds; return (A) this;
    }

    public Boolean hasTimeoutSeconds(){
            return this.timeoutSeconds != null;
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            V1beta1MutatingWebhookFluentImpl that = (V1beta1MutatingWebhookFluentImpl) o;
            if (admissionReviewVersions != null ? !admissionReviewVersions.equals(that.admissionReviewVersions) :that.admissionReviewVersions != null) return false;
            if (clientConfig != null ? !clientConfig.equals(that.clientConfig) :that.clientConfig != null) return false;
            if (failurePolicy != null ? !failurePolicy.equals(that.failurePolicy) :that.failurePolicy != null) return false;
            if (matchPolicy != null ? !matchPolicy.equals(that.matchPolicy) :that.matchPolicy != null) return false;
            if (name != null ? !name.equals(that.name) :that.name != null) return false;
            if (namespaceSelector != null ? !namespaceSelector.equals(that.namespaceSelector) :that.namespaceSelector != null) return false;
            if (objectSelector != null ? !objectSelector.equals(that.objectSelector) :that.objectSelector != null) return false;
            if (reinvocationPolicy != null ? !reinvocationPolicy.equals(that.reinvocationPolicy) :that.reinvocationPolicy != null) return false;
            if (rules != null ? !rules.equals(that.rules) :that.rules != null) return false;
            if (sideEffects != null ? !sideEffects.equals(that.sideEffects) :that.sideEffects != null) return false;
            if (timeoutSeconds != null ? !timeoutSeconds.equals(that.timeoutSeconds) :that.timeoutSeconds != null) return false;
            return true;
    }


    public class ClientConfigNestedImpl<N> extends AdmissionregistrationV1beta1WebhookClientConfigFluentImpl<V1beta1MutatingWebhookFluent.ClientConfigNested<N>> implements V1beta1MutatingWebhookFluent.ClientConfigNested<N>,io.kubernetes.client.fluent.Nested<N>{

            private final AdmissionregistrationV1beta1WebhookClientConfigBuilder builder;
    
            ClientConfigNestedImpl(AdmissionregistrationV1beta1WebhookClientConfig item){
                    this.builder = new AdmissionregistrationV1beta1WebhookClientConfigBuilder(this, item);
            }
            ClientConfigNestedImpl(){
                    this.builder = new AdmissionregistrationV1beta1WebhookClientConfigBuilder(this);
            }
    
    public N and(){
            return (N) V1beta1MutatingWebhookFluentImpl.this.withClientConfig(builder.build());
    }
    public N endClientConfig(){
            return and();
    }

}
    public class NamespaceSelectorNestedImpl<N> extends V1LabelSelectorFluentImpl<V1beta1MutatingWebhookFluent.NamespaceSelectorNested<N>> implements V1beta1MutatingWebhookFluent.NamespaceSelectorNested<N>,io.kubernetes.client.fluent.Nested<N>{

            private final V1LabelSelectorBuilder builder;
    
            NamespaceSelectorNestedImpl(V1LabelSelector item){
                    this.builder = new V1LabelSelectorBuilder(this, item);
            }
            NamespaceSelectorNestedImpl(){
                    this.builder = new V1LabelSelectorBuilder(this);
            }
    
    public N and(){
            return (N) V1beta1MutatingWebhookFluentImpl.this.withNamespaceSelector(builder.build());
    }
    public N endNamespaceSelector(){
            return and();
    }

}
    public class ObjectSelectorNestedImpl<N> extends V1LabelSelectorFluentImpl<V1beta1MutatingWebhookFluent.ObjectSelectorNested<N>> implements V1beta1MutatingWebhookFluent.ObjectSelectorNested<N>,io.kubernetes.client.fluent.Nested<N>{

            private final V1LabelSelectorBuilder builder;
    
            ObjectSelectorNestedImpl(V1LabelSelector item){
                    this.builder = new V1LabelSelectorBuilder(this, item);
            }
            ObjectSelectorNestedImpl(){
                    this.builder = new V1LabelSelectorBuilder(this);
            }
    
    public N and(){
            return (N) V1beta1MutatingWebhookFluentImpl.this.withObjectSelector(builder.build());
    }
    public N endObjectSelector(){
            return and();
    }

}
    public class RulesNestedImpl<N> extends V1beta1RuleWithOperationsFluentImpl<V1beta1MutatingWebhookFluent.RulesNested<N>> implements V1beta1MutatingWebhookFluent.RulesNested<N>,io.kubernetes.client.fluent.Nested<N>{

            private final V1beta1RuleWithOperationsBuilder builder;
        private final int index;
    
            RulesNestedImpl(int index,V1beta1RuleWithOperations item){
                    this.index = index;
                    this.builder = new V1beta1RuleWithOperationsBuilder(this, item);
            }
            RulesNestedImpl(){
                    this.index = -1;
                    this.builder = new V1beta1RuleWithOperationsBuilder(this);
            }
    
    public N and(){
            return (N) V1beta1MutatingWebhookFluentImpl.this.setToRules(index, builder.build());
    }
    public N endRule(){
            return and();
    }

}


}
