package io.kubernetes.client.openapi.models;

import io.kubernetes.client.fluent.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;

public class V1beta2DaemonSetConditionBuilder extends V1beta2DaemonSetConditionFluentImpl<V1beta2DaemonSetConditionBuilder> implements VisitableBuilder<V1beta2DaemonSetCondition,V1beta2DaemonSetConditionBuilder>{

    V1beta2DaemonSetConditionFluent<?> fluent;
    Boolean validationEnabled;

    public V1beta2DaemonSetConditionBuilder(){
            this(true);
    }
    public V1beta2DaemonSetConditionBuilder(Boolean validationEnabled){
            this(new V1beta2DaemonSetCondition(), validationEnabled);
    }
    public V1beta2DaemonSetConditionBuilder(V1beta2DaemonSetConditionFluent<?> fluent){
            this(fluent, true);
    }
    public V1beta2DaemonSetConditionBuilder(V1beta2DaemonSetConditionFluent<?> fluent,Boolean validationEnabled){
            this(fluent, new V1beta2DaemonSetCondition(), validationEnabled);
    }
    public V1beta2DaemonSetConditionBuilder(V1beta2DaemonSetConditionFluent<?> fluent,V1beta2DaemonSetCondition instance){
            this(fluent, instance, true);
    }
    public V1beta2DaemonSetConditionBuilder(V1beta2DaemonSetConditionFluent<?> fluent,V1beta2DaemonSetCondition instance,Boolean validationEnabled){
            this.fluent = fluent; 
            fluent.withLastTransitionTime(instance.getLastTransitionTime());

            fluent.withMessage(instance.getMessage());

            fluent.withReason(instance.getReason());

            fluent.withStatus(instance.getStatus());

            fluent.withType(instance.getType());

            this.validationEnabled = validationEnabled; 
    }
    public V1beta2DaemonSetConditionBuilder(V1beta2DaemonSetCondition instance){
            this(instance,true);
    }
    public V1beta2DaemonSetConditionBuilder(V1beta2DaemonSetCondition instance,Boolean validationEnabled){
            this.fluent = this; 
            this.withLastTransitionTime(instance.getLastTransitionTime());

            this.withMessage(instance.getMessage());

            this.withReason(instance.getReason());

            this.withStatus(instance.getStatus());

            this.withType(instance.getType());

            this.validationEnabled = validationEnabled; 
    }

    public V1beta2DaemonSetCondition build(){
            V1beta2DaemonSetCondition buildable = new V1beta2DaemonSetCondition();
            buildable.setLastTransitionTime(fluent.getLastTransitionTime());
            buildable.setMessage(fluent.getMessage());
            buildable.setReason(fluent.getReason());
            buildable.setStatus(fluent.getStatus());
            buildable.setType(fluent.getType());
            return buildable;
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            if (!super.equals(o)) return false;
            V1beta2DaemonSetConditionBuilder that = (V1beta2DaemonSetConditionBuilder) o;
            if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;

            if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
            return true;
    }




}
