package io.kubernetes.client.openapi.models;

import io.kubernetes.client.fluent.VisitableBuilder;
import com.google.gson.annotations.SerializedName;
import io.kubernetes.client.fluent.Nested;
import java.util.ArrayList;
import io.kubernetes.client.fluent.Predicate;
import java.lang.Deprecated;
import io.kubernetes.client.fluent.BaseFluent;
import java.util.Iterator;
import java.util.List;
import java.lang.Boolean;
import java.lang.Integer;
import java.util.Collection;
import java.lang.Object;

public class V2beta2HorizontalPodAutoscalerSpecFluentImpl<A extends V2beta2HorizontalPodAutoscalerSpecFluent<A>> extends io.kubernetes.client.fluent.BaseFluent<A> implements V2beta2HorizontalPodAutoscalerSpecFluent<A>{

    private Integer maxReplicas;
    private List<V2beta2MetricSpecBuilder> metrics;
    private Integer minReplicas;
    private V2beta2CrossVersionObjectReferenceBuilder scaleTargetRef;

    public V2beta2HorizontalPodAutoscalerSpecFluentImpl(){
    }
    public V2beta2HorizontalPodAutoscalerSpecFluentImpl(V2beta2HorizontalPodAutoscalerSpec instance){
            this.withMaxReplicas(instance.getMaxReplicas());

            this.withMetrics(instance.getMetrics());

            this.withMinReplicas(instance.getMinReplicas());

            this.withScaleTargetRef(instance.getScaleTargetRef());

    }

    public Integer getMaxReplicas(){
            return this.maxReplicas;
    }

    public A withMaxReplicas(Integer maxReplicas){
            this.maxReplicas=maxReplicas; return (A) this;
    }

    public Boolean hasMaxReplicas(){
            return this.maxReplicas != null;
    }

    public A addToMetrics(int index,V2beta2MetricSpec item){
            if (this.metrics == null) {this.metrics = new ArrayList<V2beta2MetricSpecBuilder>();}
            V2beta2MetricSpecBuilder builder = new V2beta2MetricSpecBuilder(item);_visitables.get("metrics").add(index >= 0 ? index : _visitables.get("metrics").size(), builder);this.metrics.add(index >= 0 ? index : metrics.size(), builder); return (A)this;
    }

    public A setToMetrics(int index,V2beta2MetricSpec item){
            if (this.metrics == null) {this.metrics = new ArrayList<V2beta2MetricSpecBuilder>();}
            V2beta2MetricSpecBuilder builder = new V2beta2MetricSpecBuilder(item);
            if (index < 0 || index >= _visitables.get("metrics").size()) { _visitables.get("metrics").add(builder); } else { _visitables.get("metrics").set(index, builder);}
            if (index < 0 || index >= metrics.size()) { metrics.add(builder); } else { metrics.set(index, builder);}
             return (A)this;
    }

    public A addToMetrics(V2beta2MetricSpec... items){
            if (this.metrics == null) {this.metrics = new ArrayList<V2beta2MetricSpecBuilder>();}
            for (V2beta2MetricSpec item : items) {V2beta2MetricSpecBuilder builder = new V2beta2MetricSpecBuilder(item);_visitables.get("metrics").add(builder);this.metrics.add(builder);} return (A)this;
    }

    public A addAllToMetrics(Collection<V2beta2MetricSpec> items){
            if (this.metrics == null) {this.metrics = new ArrayList<V2beta2MetricSpecBuilder>();}
            for (V2beta2MetricSpec item : items) {V2beta2MetricSpecBuilder builder = new V2beta2MetricSpecBuilder(item);_visitables.get("metrics").add(builder);this.metrics.add(builder);} return (A)this;
    }

    public A removeFromMetrics(V2beta2MetricSpec... items){
            for (V2beta2MetricSpec item : items) {V2beta2MetricSpecBuilder builder = new V2beta2MetricSpecBuilder(item);_visitables.get("metrics").remove(builder);if (this.metrics != null) {this.metrics.remove(builder);}} return (A)this;
    }

    public A removeAllFromMetrics(Collection<V2beta2MetricSpec> items){
            for (V2beta2MetricSpec item : items) {V2beta2MetricSpecBuilder builder = new V2beta2MetricSpecBuilder(item);_visitables.get("metrics").remove(builder);if (this.metrics != null) {this.metrics.remove(builder);}} return (A)this;
    }

    public A removeMatchingFromMetrics(io.kubernetes.client.fluent.Predicate<V2beta2MetricSpecBuilder> predicate){
            if (metrics == null) return (A) this;
            final Iterator<V2beta2MetricSpecBuilder> each = metrics.iterator();
            final List visitables = _visitables.get("metrics");
            while (each.hasNext()) {
              V2beta2MetricSpecBuilder builder = each.next();
              if (predicate.apply(builder)) {
                visitables.remove(builder);
                each.remove();
              }
            }
            return (A)this;
    }

    
/**
 * This method has been deprecated, please use method buildMetrics instead.
 * @return The buildable object.
 */
@Deprecated public List<V2beta2MetricSpec> getMetrics(){
            return build(metrics);
    }

    public List<V2beta2MetricSpec> buildMetrics(){
            return build(metrics);
    }

    public V2beta2MetricSpec buildMetric(int index){
            return this.metrics.get(index).build();
    }

    public V2beta2MetricSpec buildFirstMetric(){
            return this.metrics.get(0).build();
    }

    public V2beta2MetricSpec buildLastMetric(){
            return this.metrics.get(metrics.size() - 1).build();
    }

    public V2beta2MetricSpec buildMatchingMetric(io.kubernetes.client.fluent.Predicate<V2beta2MetricSpecBuilder> predicate){
            for (V2beta2MetricSpecBuilder item: metrics) { if(predicate.apply(item)){ return item.build();} } return null;
    }

    public Boolean hasMatchingMetric(io.kubernetes.client.fluent.Predicate<V2beta2MetricSpecBuilder> predicate){
            for (V2beta2MetricSpecBuilder item: metrics) { if(predicate.apply(item)){ return true;} } return false;
    }

    public A withMetrics(List<V2beta2MetricSpec> metrics){
            if (this.metrics != null) { _visitables.get("metrics").removeAll(this.metrics);}
            if (metrics != null) {this.metrics = new ArrayList<V2beta2MetricSpecBuilder>(); for (V2beta2MetricSpec item : metrics){this.addToMetrics(item);}} else { this.metrics = null;} return (A) this;
    }

    public A withMetrics(V2beta2MetricSpec... metrics){
            if (this.metrics != null) {this.metrics.clear();}
            if (metrics != null) {for (V2beta2MetricSpec item :metrics){ this.addToMetrics(item);}} return (A) this;
    }

    public Boolean hasMetrics(){
            return metrics != null && !metrics.isEmpty();
    }

    public V2beta2HorizontalPodAutoscalerSpecFluent.MetricsNested<A> addNewMetric(){
            return new MetricsNestedImpl();
    }

    public V2beta2HorizontalPodAutoscalerSpecFluent.MetricsNested<A> addNewMetricLike(V2beta2MetricSpec item){
            return new MetricsNestedImpl(-1, item);
    }

    public V2beta2HorizontalPodAutoscalerSpecFluent.MetricsNested<A> setNewMetricLike(int index,V2beta2MetricSpec item){
            return new MetricsNestedImpl(index, item);
    }

    public V2beta2HorizontalPodAutoscalerSpecFluent.MetricsNested<A> editMetric(int index){
            if (metrics.size() <= index) throw new RuntimeException("Can't edit metrics. Index exceeds size.");
            return setNewMetricLike(index, buildMetric(index));
    }

    public V2beta2HorizontalPodAutoscalerSpecFluent.MetricsNested<A> editFirstMetric(){
            if (metrics.size() == 0) throw new RuntimeException("Can't edit first metrics. The list is empty.");
            return setNewMetricLike(0, buildMetric(0));
    }

    public V2beta2HorizontalPodAutoscalerSpecFluent.MetricsNested<A> editLastMetric(){
            int index = metrics.size() - 1;
            if (index < 0) throw new RuntimeException("Can't edit last metrics. The list is empty.");
            return setNewMetricLike(index, buildMetric(index));
    }

    public V2beta2HorizontalPodAutoscalerSpecFluent.MetricsNested<A> editMatchingMetric(io.kubernetes.client.fluent.Predicate<V2beta2MetricSpecBuilder> predicate){
            int index = -1;
            for (int i=0;i<metrics.size();i++) { 
            if (predicate.apply(metrics.get(i))) {index = i; break;}
            } 
            if (index < 0) throw new RuntimeException("Can't edit matching metrics. No match found.");
            return setNewMetricLike(index, buildMetric(index));
    }

    public Integer getMinReplicas(){
            return this.minReplicas;
    }

    public A withMinReplicas(Integer minReplicas){
            this.minReplicas=minReplicas; return (A) this;
    }

    public Boolean hasMinReplicas(){
            return this.minReplicas != null;
    }

    
/**
 * This method has been deprecated, please use method buildScaleTargetRef instead.
 * @return The buildable object.
 */
@Deprecated public V2beta2CrossVersionObjectReference getScaleTargetRef(){
            return this.scaleTargetRef!=null?this.scaleTargetRef.build():null;
    }

    public V2beta2CrossVersionObjectReference buildScaleTargetRef(){
            return this.scaleTargetRef!=null?this.scaleTargetRef.build():null;
    }

    public A withScaleTargetRef(V2beta2CrossVersionObjectReference scaleTargetRef){
            _visitables.get("scaleTargetRef").remove(this.scaleTargetRef);
            if (scaleTargetRef!=null){ this.scaleTargetRef= new V2beta2CrossVersionObjectReferenceBuilder(scaleTargetRef); _visitables.get("scaleTargetRef").add(this.scaleTargetRef);} return (A) this;
    }

    public Boolean hasScaleTargetRef(){
            return this.scaleTargetRef != null;
    }

    public V2beta2HorizontalPodAutoscalerSpecFluent.ScaleTargetRefNested<A> withNewScaleTargetRef(){
            return new ScaleTargetRefNestedImpl();
    }

    public V2beta2HorizontalPodAutoscalerSpecFluent.ScaleTargetRefNested<A> withNewScaleTargetRefLike(V2beta2CrossVersionObjectReference item){
            return new ScaleTargetRefNestedImpl(item);
    }

    public V2beta2HorizontalPodAutoscalerSpecFluent.ScaleTargetRefNested<A> editScaleTargetRef(){
            return withNewScaleTargetRefLike(getScaleTargetRef());
    }

    public V2beta2HorizontalPodAutoscalerSpecFluent.ScaleTargetRefNested<A> editOrNewScaleTargetRef(){
            return withNewScaleTargetRefLike(getScaleTargetRef() != null ? getScaleTargetRef(): new V2beta2CrossVersionObjectReferenceBuilder().build());
    }

    public V2beta2HorizontalPodAutoscalerSpecFluent.ScaleTargetRefNested<A> editOrNewScaleTargetRefLike(V2beta2CrossVersionObjectReference item){
            return withNewScaleTargetRefLike(getScaleTargetRef() != null ? getScaleTargetRef(): item);
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            V2beta2HorizontalPodAutoscalerSpecFluentImpl that = (V2beta2HorizontalPodAutoscalerSpecFluentImpl) o;
            if (maxReplicas != null ? !maxReplicas.equals(that.maxReplicas) :that.maxReplicas != null) return false;
            if (metrics != null ? !metrics.equals(that.metrics) :that.metrics != null) return false;
            if (minReplicas != null ? !minReplicas.equals(that.minReplicas) :that.minReplicas != null) return false;
            if (scaleTargetRef != null ? !scaleTargetRef.equals(that.scaleTargetRef) :that.scaleTargetRef != null) return false;
            return true;
    }


    public class MetricsNestedImpl<N> extends V2beta2MetricSpecFluentImpl<V2beta2HorizontalPodAutoscalerSpecFluent.MetricsNested<N>> implements V2beta2HorizontalPodAutoscalerSpecFluent.MetricsNested<N>,io.kubernetes.client.fluent.Nested<N>{

            private final V2beta2MetricSpecBuilder builder;
        private final int index;
    
            MetricsNestedImpl(int index,V2beta2MetricSpec item){
                    this.index = index;
                    this.builder = new V2beta2MetricSpecBuilder(this, item);
            }
            MetricsNestedImpl(){
                    this.index = -1;
                    this.builder = new V2beta2MetricSpecBuilder(this);
            }
    
    public N and(){
            return (N) V2beta2HorizontalPodAutoscalerSpecFluentImpl.this.setToMetrics(index, builder.build());
    }
    public N endMetric(){
            return and();
    }

}
    public class ScaleTargetRefNestedImpl<N> extends V2beta2CrossVersionObjectReferenceFluentImpl<V2beta2HorizontalPodAutoscalerSpecFluent.ScaleTargetRefNested<N>> implements V2beta2HorizontalPodAutoscalerSpecFluent.ScaleTargetRefNested<N>,io.kubernetes.client.fluent.Nested<N>{

            private final V2beta2CrossVersionObjectReferenceBuilder builder;
    
            ScaleTargetRefNestedImpl(V2beta2CrossVersionObjectReference item){
                    this.builder = new V2beta2CrossVersionObjectReferenceBuilder(this, item);
            }
            ScaleTargetRefNestedImpl(){
                    this.builder = new V2beta2CrossVersionObjectReferenceBuilder(this);
            }
    
    public N and(){
            return (N) V2beta2HorizontalPodAutoscalerSpecFluentImpl.this.withScaleTargetRef(builder.build());
    }
    public N endScaleTargetRef(){
            return and();
    }

}


}
