/*
 * Decompiled with CFR 0.152.
 */
package io.kubernetes.client.openapi.models;

import com.google.gson.annotations.SerializedName;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.Objects;
import javax.annotation.Nullable;
import org.joda.time.DateTime;

@ApiModel(description="ManagedFieldsEntry is a workflow-id, a FieldSet and the group version of the resource that the fieldset applies to.")
public class V1ManagedFieldsEntry {
    public static final String SERIALIZED_NAME_API_VERSION = "apiVersion";
    @SerializedName(value="apiVersion")
    private String apiVersion;
    public static final String SERIALIZED_NAME_FIELDS = "fields";
    @SerializedName(value="fields")
    private Object fields;
    public static final String SERIALIZED_NAME_MANAGER = "manager";
    @SerializedName(value="manager")
    private String manager;
    public static final String SERIALIZED_NAME_OPERATION = "operation";
    @SerializedName(value="operation")
    private String operation;
    public static final String SERIALIZED_NAME_TIME = "time";
    @SerializedName(value="time")
    private DateTime time;

    public V1ManagedFieldsEntry apiVersion(String apiVersion) {
        this.apiVersion = apiVersion;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="APIVersion defines the version of this resource that this field set applies to. The format is \"group/version\" just like the top-level APIVersion field. It is necessary to track the version of a field set because it cannot be automatically converted.")
    public String getApiVersion() {
        return this.apiVersion;
    }

    public void setApiVersion(String apiVersion) {
        this.apiVersion = apiVersion;
    }

    public V1ManagedFieldsEntry fields(Object fields) {
        this.fields = fields;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Fields identifies a set of fields.")
    public Object getFields() {
        return this.fields;
    }

    public void setFields(Object fields) {
        this.fields = fields;
    }

    public V1ManagedFieldsEntry manager(String manager) {
        this.manager = manager;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Manager is an identifier of the workflow managing these fields.")
    public String getManager() {
        return this.manager;
    }

    public void setManager(String manager) {
        this.manager = manager;
    }

    public V1ManagedFieldsEntry operation(String operation) {
        this.operation = operation;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Operation is the type of operation which lead to this ManagedFieldsEntry being created. The only valid values for this field are 'Apply' and 'Update'.")
    public String getOperation() {
        return this.operation;
    }

    public void setOperation(String operation) {
        this.operation = operation;
    }

    public V1ManagedFieldsEntry time(DateTime time) {
        this.time = time;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Time is timestamp of when these fields were set. It should always be empty if Operation is 'Apply'")
    public DateTime getTime() {
        return this.time;
    }

    public void setTime(DateTime time) {
        this.time = time;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        V1ManagedFieldsEntry v1ManagedFieldsEntry = (V1ManagedFieldsEntry)o;
        return Objects.equals(this.apiVersion, v1ManagedFieldsEntry.apiVersion) && Objects.equals(this.fields, v1ManagedFieldsEntry.fields) && Objects.equals(this.manager, v1ManagedFieldsEntry.manager) && Objects.equals(this.operation, v1ManagedFieldsEntry.operation) && Objects.equals(this.time, v1ManagedFieldsEntry.time);
    }

    public int hashCode() {
        return Objects.hash(this.apiVersion, this.fields, this.manager, this.operation, this.time);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class V1ManagedFieldsEntry {\n");
        sb.append("    apiVersion: ").append(this.toIndentedString(this.apiVersion)).append("\n");
        sb.append("    fields: ").append(this.toIndentedString(this.fields)).append("\n");
        sb.append("    manager: ").append(this.toIndentedString(this.manager)).append("\n");
        sb.append("    operation: ").append(this.toIndentedString(this.operation)).append("\n");
        sb.append("    time: ").append(this.toIndentedString(this.time)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

