/*
 * Decompiled with CFR 0.152.
 */
package io.kubernetes.client.openapi.models;

import com.google.gson.annotations.SerializedName;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.Objects;
import javax.annotation.Nullable;

@ApiModel(description="WindowsSecurityContextOptions contain Windows-specific options and credentials.")
public class V1WindowsSecurityContextOptions {
    public static final String SERIALIZED_NAME_GMSA_CREDENTIAL_SPEC = "gmsaCredentialSpec";
    @SerializedName(value="gmsaCredentialSpec")
    private String gmsaCredentialSpec;
    public static final String SERIALIZED_NAME_GMSA_CREDENTIAL_SPEC_NAME = "gmsaCredentialSpecName";
    @SerializedName(value="gmsaCredentialSpecName")
    private String gmsaCredentialSpecName;

    public V1WindowsSecurityContextOptions gmsaCredentialSpec(String gmsaCredentialSpec) {
        this.gmsaCredentialSpec = gmsaCredentialSpec;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="GMSACredentialSpec is where the GMSA admission webhook (https://github.com/kubernetes-sigs/windows-gmsa) inlines the contents of the GMSA credential spec named by the GMSACredentialSpecName field. This field is alpha-level and is only honored by servers that enable the WindowsGMSA feature flag.")
    public String getGmsaCredentialSpec() {
        return this.gmsaCredentialSpec;
    }

    public void setGmsaCredentialSpec(String gmsaCredentialSpec) {
        this.gmsaCredentialSpec = gmsaCredentialSpec;
    }

    public V1WindowsSecurityContextOptions gmsaCredentialSpecName(String gmsaCredentialSpecName) {
        this.gmsaCredentialSpecName = gmsaCredentialSpecName;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="GMSACredentialSpecName is the name of the GMSA credential spec to use. This field is alpha-level and is only honored by servers that enable the WindowsGMSA feature flag.")
    public String getGmsaCredentialSpecName() {
        return this.gmsaCredentialSpecName;
    }

    public void setGmsaCredentialSpecName(String gmsaCredentialSpecName) {
        this.gmsaCredentialSpecName = gmsaCredentialSpecName;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        V1WindowsSecurityContextOptions v1WindowsSecurityContextOptions = (V1WindowsSecurityContextOptions)o;
        return Objects.equals(this.gmsaCredentialSpec, v1WindowsSecurityContextOptions.gmsaCredentialSpec) && Objects.equals(this.gmsaCredentialSpecName, v1WindowsSecurityContextOptions.gmsaCredentialSpecName);
    }

    public int hashCode() {
        return Objects.hash(this.gmsaCredentialSpec, this.gmsaCredentialSpecName);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class V1WindowsSecurityContextOptions {\n");
        sb.append("    gmsaCredentialSpec: ").append(this.toIndentedString(this.gmsaCredentialSpec)).append("\n");
        sb.append("    gmsaCredentialSpecName: ").append(this.toIndentedString(this.gmsaCredentialSpecName)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

