/*
 * Decompiled with CFR 0.152.
 */
package io.kubernetes.client.openapi.models;

import com.google.gson.annotations.SerializedName;
import io.kubernetes.client.openapi.models.V1beta1ReplicaSetCondition;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;

@ApiModel(description="ReplicaSetStatus represents the current status of a ReplicaSet.")
public class V1beta1ReplicaSetStatus {
    public static final String SERIALIZED_NAME_AVAILABLE_REPLICAS = "availableReplicas";
    @SerializedName(value="availableReplicas")
    private Integer availableReplicas;
    public static final String SERIALIZED_NAME_CONDITIONS = "conditions";
    @SerializedName(value="conditions")
    private List<V1beta1ReplicaSetCondition> conditions = null;
    public static final String SERIALIZED_NAME_FULLY_LABELED_REPLICAS = "fullyLabeledReplicas";
    @SerializedName(value="fullyLabeledReplicas")
    private Integer fullyLabeledReplicas;
    public static final String SERIALIZED_NAME_OBSERVED_GENERATION = "observedGeneration";
    @SerializedName(value="observedGeneration")
    private Long observedGeneration;
    public static final String SERIALIZED_NAME_READY_REPLICAS = "readyReplicas";
    @SerializedName(value="readyReplicas")
    private Integer readyReplicas;
    public static final String SERIALIZED_NAME_REPLICAS = "replicas";
    @SerializedName(value="replicas")
    private Integer replicas;

    public V1beta1ReplicaSetStatus availableReplicas(Integer availableReplicas) {
        this.availableReplicas = availableReplicas;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The number of available replicas (ready for at least minReadySeconds) for this replica set.")
    public Integer getAvailableReplicas() {
        return this.availableReplicas;
    }

    public void setAvailableReplicas(Integer availableReplicas) {
        this.availableReplicas = availableReplicas;
    }

    public V1beta1ReplicaSetStatus conditions(List<V1beta1ReplicaSetCondition> conditions) {
        this.conditions = conditions;
        return this;
    }

    public V1beta1ReplicaSetStatus addConditionsItem(V1beta1ReplicaSetCondition conditionsItem) {
        if (this.conditions == null) {
            this.conditions = new ArrayList<V1beta1ReplicaSetCondition>();
        }
        this.conditions.add(conditionsItem);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Represents the latest available observations of a replica set's current state.")
    public List<V1beta1ReplicaSetCondition> getConditions() {
        return this.conditions;
    }

    public void setConditions(List<V1beta1ReplicaSetCondition> conditions) {
        this.conditions = conditions;
    }

    public V1beta1ReplicaSetStatus fullyLabeledReplicas(Integer fullyLabeledReplicas) {
        this.fullyLabeledReplicas = fullyLabeledReplicas;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The number of pods that have labels matching the labels of the pod template of the replicaset.")
    public Integer getFullyLabeledReplicas() {
        return this.fullyLabeledReplicas;
    }

    public void setFullyLabeledReplicas(Integer fullyLabeledReplicas) {
        this.fullyLabeledReplicas = fullyLabeledReplicas;
    }

    public V1beta1ReplicaSetStatus observedGeneration(Long observedGeneration) {
        this.observedGeneration = observedGeneration;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="ObservedGeneration reflects the generation of the most recently observed ReplicaSet.")
    public Long getObservedGeneration() {
        return this.observedGeneration;
    }

    public void setObservedGeneration(Long observedGeneration) {
        this.observedGeneration = observedGeneration;
    }

    public V1beta1ReplicaSetStatus readyReplicas(Integer readyReplicas) {
        this.readyReplicas = readyReplicas;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The number of ready replicas for this replica set.")
    public Integer getReadyReplicas() {
        return this.readyReplicas;
    }

    public void setReadyReplicas(Integer readyReplicas) {
        this.readyReplicas = readyReplicas;
    }

    public V1beta1ReplicaSetStatus replicas(Integer replicas) {
        this.replicas = replicas;
        return this;
    }

    @ApiModelProperty(required=true, value="Replicas is the most recently oberved number of replicas. More info: https://kubernetes.io/docs/concepts/workloads/controllers/replicationcontroller/#what-is-a-replicationcontroller")
    public Integer getReplicas() {
        return this.replicas;
    }

    public void setReplicas(Integer replicas) {
        this.replicas = replicas;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        V1beta1ReplicaSetStatus v1beta1ReplicaSetStatus = (V1beta1ReplicaSetStatus)o;
        return Objects.equals(this.availableReplicas, v1beta1ReplicaSetStatus.availableReplicas) && Objects.equals(this.conditions, v1beta1ReplicaSetStatus.conditions) && Objects.equals(this.fullyLabeledReplicas, v1beta1ReplicaSetStatus.fullyLabeledReplicas) && Objects.equals(this.observedGeneration, v1beta1ReplicaSetStatus.observedGeneration) && Objects.equals(this.readyReplicas, v1beta1ReplicaSetStatus.readyReplicas) && Objects.equals(this.replicas, v1beta1ReplicaSetStatus.replicas);
    }

    public int hashCode() {
        return Objects.hash(this.availableReplicas, this.conditions, this.fullyLabeledReplicas, this.observedGeneration, this.readyReplicas, this.replicas);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class V1beta1ReplicaSetStatus {\n");
        sb.append("    availableReplicas: ").append(this.toIndentedString(this.availableReplicas)).append("\n");
        sb.append("    conditions: ").append(this.toIndentedString(this.conditions)).append("\n");
        sb.append("    fullyLabeledReplicas: ").append(this.toIndentedString(this.fullyLabeledReplicas)).append("\n");
        sb.append("    observedGeneration: ").append(this.toIndentedString(this.observedGeneration)).append("\n");
        sb.append("    readyReplicas: ").append(this.toIndentedString(this.readyReplicas)).append("\n");
        sb.append("    replicas: ").append(this.toIndentedString(this.replicas)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

