/*
 * Decompiled with CFR 0.152.
 */
package io.seata.rm.datasource.undo.oracle;

import io.seata.common.exception.ShouldNeverHappenException;
import io.seata.rm.datasource.ColumnUtils;
import io.seata.rm.datasource.sql.struct.Field;
import io.seata.rm.datasource.sql.struct.Row;
import io.seata.rm.datasource.sql.struct.TableRecords;
import io.seata.rm.datasource.undo.AbstractUndoExecutor;
import io.seata.rm.datasource.undo.SQLUndoLog;
import java.util.List;
import java.util.stream.Collectors;

public class OracleUndoUpdateExecutor
extends AbstractUndoExecutor {
    private static final String UPDATE_SQL_TEMPLATE = "UPDATE %s SET %s WHERE %s = ?";

    @Override
    protected String buildUndoSQL() {
        TableRecords beforeImage = this.sqlUndoLog.getBeforeImage();
        List<Row> beforeImageRows = beforeImage.getRows();
        if (beforeImageRows == null || beforeImageRows.size() == 0) {
            throw new ShouldNeverHappenException("Invalid UNDO LOG");
        }
        Row row = beforeImageRows.get(0);
        Field pkField = row.primaryKeys().get(0);
        List<Field> nonPkFields = row.nonPrimaryKeys();
        String updateColumns = nonPkFields.stream().map(field -> ColumnUtils.addEscape(field.getName(), ColumnUtils.Escape.STANDARD) + " = ?").collect(Collectors.joining(", "));
        return String.format(UPDATE_SQL_TEMPLATE, ColumnUtils.addEscape(this.sqlUndoLog.getTableName(), ColumnUtils.Escape.STANDARD), updateColumns, ColumnUtils.addEscape(pkField.getName(), ColumnUtils.Escape.STANDARD));
    }

    public OracleUndoUpdateExecutor(SQLUndoLog sqlUndoLog) {
        super(sqlUndoLog);
    }

    @Override
    protected TableRecords getUndoRows() {
        return this.sqlUndoLog.getBeforeImage();
    }
}

