/*
 * Decompiled with CFR 0.152.
 */
package io.shardingjdbc.core.parsing.parser.clause;

import io.shardingjdbc.core.constant.OrderType;
import io.shardingjdbc.core.parsing.lexer.LexerEngine;
import io.shardingjdbc.core.parsing.lexer.dialect.oracle.OracleKeyword;
import io.shardingjdbc.core.parsing.lexer.token.DefaultKeyword;
import io.shardingjdbc.core.parsing.lexer.token.Symbol;
import io.shardingjdbc.core.parsing.parser.clause.SQLClauseParser;
import io.shardingjdbc.core.parsing.parser.clause.expression.BasicExpressionParser;
import io.shardingjdbc.core.parsing.parser.context.OrderItem;
import io.shardingjdbc.core.parsing.parser.dialect.ExpressionParserFactory;
import io.shardingjdbc.core.parsing.parser.exception.SQLParsingException;
import io.shardingjdbc.core.parsing.parser.expression.SQLExpression;
import io.shardingjdbc.core.parsing.parser.expression.SQLIdentifierExpression;
import io.shardingjdbc.core.parsing.parser.expression.SQLIgnoreExpression;
import io.shardingjdbc.core.parsing.parser.expression.SQLNumberExpression;
import io.shardingjdbc.core.parsing.parser.expression.SQLPropertyExpression;
import io.shardingjdbc.core.parsing.parser.sql.dql.select.SelectStatement;
import io.shardingjdbc.core.util.SQLUtil;
import java.util.LinkedList;

public class OrderByClauseParser
implements SQLClauseParser {
    private final LexerEngine lexerEngine;
    private final BasicExpressionParser basicExpressionParser;

    public OrderByClauseParser(LexerEngine lexerEngine) {
        this.lexerEngine = lexerEngine;
        this.basicExpressionParser = ExpressionParserFactory.createBasicExpressionParser(lexerEngine);
    }

    public final void parse(SelectStatement selectStatement) {
        if (!this.lexerEngine.skipIfEqual(DefaultKeyword.ORDER)) {
            return;
        }
        LinkedList<OrderItem> result = new LinkedList<OrderItem>();
        this.lexerEngine.skipIfEqual(OracleKeyword.SIBLINGS);
        this.lexerEngine.accept(DefaultKeyword.BY);
        do {
            result.add(this.parseSelectOrderByItem(selectStatement));
        } while (this.lexerEngine.skipIfEqual(Symbol.COMMA));
        selectStatement.getOrderByItems().addAll(result);
    }

    private OrderItem parseSelectOrderByItem(SelectStatement selectStatement) {
        SQLExpression sqlExpression = this.basicExpressionParser.parse(selectStatement);
        OrderType orderByType = OrderType.ASC;
        if (this.lexerEngine.skipIfEqual(DefaultKeyword.ASC)) {
            orderByType = OrderType.ASC;
        } else if (this.lexerEngine.skipIfEqual(DefaultKeyword.DESC)) {
            orderByType = OrderType.DESC;
        }
        if (sqlExpression instanceof SQLNumberExpression) {
            return new OrderItem(((SQLNumberExpression)sqlExpression).getNumber().intValue(), orderByType, this.getNullOrderType());
        }
        if (sqlExpression instanceof SQLIdentifierExpression) {
            return new OrderItem(SQLUtil.getExactlyValue(((SQLIdentifierExpression)sqlExpression).getName()), orderByType, this.getNullOrderType(), selectStatement.getAlias(SQLUtil.getExactlyValue(((SQLIdentifierExpression)sqlExpression).getName())));
        }
        if (sqlExpression instanceof SQLPropertyExpression) {
            SQLPropertyExpression sqlPropertyExpression = (SQLPropertyExpression)sqlExpression;
            return new OrderItem(SQLUtil.getExactlyValue(sqlPropertyExpression.getOwner().getName()), SQLUtil.getExactlyValue(sqlPropertyExpression.getName()), orderByType, this.getNullOrderType(), selectStatement.getAlias(SQLUtil.getExactlyValue(sqlPropertyExpression.getOwner().getName()) + "." + SQLUtil.getExactlyValue(sqlPropertyExpression.getName())));
        }
        if (sqlExpression instanceof SQLIgnoreExpression) {
            SQLIgnoreExpression sqlIgnoreExpression = (SQLIgnoreExpression)sqlExpression;
            return new OrderItem(sqlIgnoreExpression.getExpression(), orderByType, this.getNullOrderType(), selectStatement.getAlias(sqlIgnoreExpression.getExpression()));
        }
        throw new SQLParsingException(this.lexerEngine);
    }

    protected OrderType getNullOrderType() {
        return OrderType.ASC;
    }

    public LexerEngine getLexerEngine() {
        return this.lexerEngine;
    }
}

