/*
 * Decompiled with CFR 0.152.
 */
package io.shardingjdbc.core.routing.strategy.inline;

import com.google.common.base.Joiner;
import com.google.common.base.Preconditions;
import groovy.lang.Closure;
import groovy.lang.GroovyShell;
import groovy.util.Expando;
import io.shardingjdbc.core.api.algorithm.sharding.ListShardingValue;
import io.shardingjdbc.core.api.algorithm.sharding.PreciseShardingValue;
import io.shardingjdbc.core.api.algorithm.sharding.ShardingValue;
import io.shardingjdbc.core.routing.strategy.ShardingStrategy;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import java.util.TreeSet;

public final class InlineShardingStrategy
implements ShardingStrategy {
    private final String shardingColumn;
    private final Closure<?> closure;

    public InlineShardingStrategy(String shardingColumn, String inlineExpression) {
        this.shardingColumn = shardingColumn;
        this.closure = (Closure)new GroovyShell().evaluate(Joiner.on((String)"").join((Object)"{it -> \"", (Object)inlineExpression.trim(), new Object[]{"\"}"}));
    }

    @Override
    public Collection<String> doSharding(Collection<String> availableTargetNames, Collection<ShardingValue> shardingValues) {
        ShardingValue shardingValue = shardingValues.iterator().next();
        Preconditions.checkState((boolean)(shardingValue instanceof ListShardingValue), (Object)"Inline strategy cannot support range sharding.");
        Collection<String> shardingResult = this.doSharding((ListShardingValue)shardingValue);
        TreeSet<String> result = new TreeSet<String>(String.CASE_INSENSITIVE_ORDER);
        result.addAll(shardingResult);
        return result;
    }

    private Collection<String> doSharding(ListShardingValue shardingValue) {
        LinkedList<String> result = new LinkedList<String>();
        for (PreciseShardingValue each : this.transferToPreciseShardingValues(shardingValue)) {
            result.add(this.execute(each));
        }
        return result;
    }

    private List<PreciseShardingValue> transferToPreciseShardingValues(ListShardingValue<?> shardingValue) {
        ArrayList<PreciseShardingValue> result = new ArrayList<PreciseShardingValue>(shardingValue.getValues().size());
        for (Comparable each : shardingValue.getValues()) {
            result.add(new PreciseShardingValue<Comparable>(shardingValue.getLogicTableName(), shardingValue.getColumnName(), each));
        }
        return result;
    }

    private String execute(PreciseShardingValue shardingValue) {
        Closure result = this.closure.rehydrate((Object)new Expando(), null, null);
        result.setResolveStrategy(3);
        result.setProperty(shardingValue.getColumnName(), shardingValue.getValue());
        return result.call().toString();
    }

    @Override
    public Collection<String> getShardingColumns() {
        TreeSet<String> result = new TreeSet<String>(String.CASE_INSENSITIVE_ORDER);
        result.add(this.shardingColumn);
        return result;
    }
}

