/*
 * Decompiled with CFR 0.152.
 */
package io.shardingjdbc.transaction.storage;

import io.shardingjdbc.transaction.datasource.TransactionLogDataSource;
import io.shardingjdbc.transaction.storage.TransactionLogStorage;
import io.shardingjdbc.transaction.storage.impl.MemoryTransactionLogStorage;
import io.shardingjdbc.transaction.storage.impl.RdbTransactionLogStorage;

public final class TransactionLogStorageFactory {
    public static TransactionLogStorage createTransactionLogStorage(TransactionLogDataSource transactionLogDataSource) {
        switch (transactionLogDataSource.getType()) {
            case MEMORY: {
                return new MemoryTransactionLogStorage();
            }
            case RDB: {
                return new RdbTransactionLogStorage(transactionLogDataSource.getDataSource());
            }
        }
        throw new UnsupportedOperationException();
    }

    private TransactionLogStorageFactory() {
    }
}

