/*
 * Decompiled with CFR 0.152.
 */
package io.shardingjdbc.transaction.storage.impl;

import io.shardingjdbc.transaction.constants.SoftTransactionType;
import io.shardingjdbc.transaction.storage.TransactionLog;
import io.shardingjdbc.transaction.storage.TransactionLogStorage;
import java.sql.Connection;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicInteger;

public final class MemoryTransactionLogStorage
implements TransactionLogStorage {
    private static final ConcurrentHashMap<String, TransactionLog> DATA = new ConcurrentHashMap();

    @Override
    public void add(TransactionLog transactionLog) {
        DATA.putIfAbsent(transactionLog.getId(), transactionLog);
    }

    @Override
    public void remove(String id) {
        DATA.remove(id);
    }

    @Override
    public List<TransactionLog> findEligibleTransactionLogs(int size, int maxDeliveryTryTimes, long maxDeliveryTryDelayMillis) {
        ArrayList<TransactionLog> result = new ArrayList<TransactionLog>();
        int count = 0;
        for (TransactionLog each : DATA.values()) {
            if (count >= size) break;
            if (each.getAsyncDeliveryTryTimes() < maxDeliveryTryTimes && SoftTransactionType.BestEffortsDelivery == each.getTransactionType() && each.getCreationTime() < System.currentTimeMillis() - maxDeliveryTryDelayMillis) {
                result.add(each);
            }
            ++count;
        }
        return result;
    }

    @Override
    public void increaseAsyncDeliveryTryTimes(String id) {
        if (DATA.containsKey(id)) {
            TransactionLog transactionLog = DATA.get(id);
            transactionLog.setAsyncDeliveryTryTimes(new AtomicInteger(transactionLog.getAsyncDeliveryTryTimes()).incrementAndGet());
            DATA.put(id, transactionLog);
        }
    }

    @Override
    public boolean processData(Connection connection, TransactionLog transactionLog, int maxDeliveryTryTimes) {
        return false;
    }
}

