/*
 * Decompiled with CFR 0.152.
 */
package io.shardingjdbc.transaction.storage.impl;

import com.google.gson.Gson;
import com.google.gson.reflect.TypeToken;
import io.shardingjdbc.transaction.constants.SoftTransactionType;
import io.shardingjdbc.transaction.exception.TransactionCompensationException;
import io.shardingjdbc.transaction.exception.TransactionLogStorageException;
import io.shardingjdbc.transaction.storage.TransactionLog;
import io.shardingjdbc.transaction.storage.TransactionLogStorage;
import java.beans.ConstructorProperties;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import javax.sql.DataSource;

public final class RdbTransactionLogStorage
implements TransactionLogStorage {
    private final DataSource dataSource;

    @Override
    public void add(TransactionLog transactionLog) {
        String sql = "INSERT INTO `transaction_log` (`id`, `transaction_type`, `data_source`, `sql`, `parameters`, `creation_time`) VALUES (?, ?, ?, ?, ?, ?);";
        try (Connection conn = this.dataSource.getConnection();
             PreparedStatement preparedStatement = conn.prepareStatement(sql);){
            preparedStatement.setString(1, transactionLog.getId());
            preparedStatement.setString(2, SoftTransactionType.BestEffortsDelivery.name());
            preparedStatement.setString(3, transactionLog.getDataSource());
            preparedStatement.setString(4, transactionLog.getSql());
            preparedStatement.setString(5, new Gson().toJson(transactionLog.getParameters()));
            preparedStatement.setLong(6, transactionLog.getCreationTime());
            preparedStatement.executeUpdate();
        }
        catch (SQLException ex) {
            throw new TransactionLogStorageException(ex);
        }
    }

    @Override
    public void remove(String id) {
        String sql = "DELETE FROM `transaction_log` WHERE `id`=?;";
        try (Connection conn = this.dataSource.getConnection();
             PreparedStatement preparedStatement = conn.prepareStatement(sql);){
            preparedStatement.setString(1, id);
            preparedStatement.executeUpdate();
        }
        catch (SQLException ex) {
            throw new TransactionLogStorageException(ex);
        }
    }

    @Override
    public List<TransactionLog> findEligibleTransactionLogs(int size, int maxDeliveryTryTimes, long maxDeliveryTryDelayMillis) {
        ArrayList<TransactionLog> result = new ArrayList<TransactionLog>(size);
        String sql = "SELECT `id`, `transaction_type`, `data_source`, `sql`, `parameters`, `creation_time`, `async_delivery_try_times` FROM `transaction_log` WHERE `async_delivery_try_times`<? AND `transaction_type`=? AND `creation_time`<? LIMIT ?;";
        try (Connection conn = this.dataSource.getConnection();
             PreparedStatement preparedStatement = conn.prepareStatement(sql);){
            preparedStatement.setInt(1, maxDeliveryTryTimes);
            preparedStatement.setString(2, SoftTransactionType.BestEffortsDelivery.name());
            preparedStatement.setLong(3, System.currentTimeMillis() - maxDeliveryTryDelayMillis);
            preparedStatement.setInt(4, size);
            try (ResultSet rs = preparedStatement.executeQuery();){
                while (rs.next()) {
                    Gson gson = new Gson();
                    List parameters = (List)gson.fromJson(rs.getString(5), new TypeToken<List<Object>>(){}.getType());
                    result.add(new TransactionLog(rs.getString(1), "", SoftTransactionType.valueOf(rs.getString(2)), rs.getString(3), rs.getString(4), parameters, rs.getLong(6), rs.getInt(7)));
                }
            }
        }
        catch (SQLException ex) {
            throw new TransactionLogStorageException(ex);
        }
        return result;
    }

    @Override
    public void increaseAsyncDeliveryTryTimes(String id) {
        String sql = "UPDATE `transaction_log` SET `async_delivery_try_times`=`async_delivery_try_times`+1 WHERE `id`=?;";
        try (Connection conn = this.dataSource.getConnection();
             PreparedStatement preparedStatement = conn.prepareStatement(sql);){
            preparedStatement.setString(1, id);
            preparedStatement.executeUpdate();
        }
        catch (SQLException ex) {
            throw new TransactionLogStorageException(ex);
        }
    }

    @Override
    public boolean processData(Connection connection, TransactionLog transactionLog, int maxDeliveryTryTimes) {
        try (Connection conn = connection;
             PreparedStatement preparedStatement = conn.prepareStatement(transactionLog.getSql());){
            for (int parameterIndex = 0; parameterIndex < transactionLog.getParameters().size(); ++parameterIndex) {
                preparedStatement.setObject(parameterIndex + 1, transactionLog.getParameters().get(parameterIndex));
            }
            preparedStatement.executeUpdate();
        }
        catch (SQLException ex) {
            this.increaseAsyncDeliveryTryTimes(transactionLog.getId());
            throw new TransactionCompensationException(ex);
        }
        this.remove(transactionLog.getId());
        return true;
    }

    @ConstructorProperties(value={"dataSource"})
    public RdbTransactionLogStorage(DataSource dataSource) {
        this.dataSource = dataSource;
    }
}

