/*
 * Decompiled with CFR 0.152.
 */
package springfox.documentation.swagger.readers.parameter;

import com.google.common.base.Strings;
import io.swagger.annotations.ApiParam;
import java.lang.annotation.Annotation;
import org.springframework.core.MethodParameter;
import org.springframework.core.annotation.Order;
import org.springframework.stereotype.Component;
import springfox.documentation.schema.Enums;
import springfox.documentation.service.AllowableValues;
import springfox.documentation.spi.DocumentationType;
import springfox.documentation.spi.service.ParameterBuilderPlugin;
import springfox.documentation.spi.service.contexts.ParameterContext;
import springfox.documentation.swagger.common.SwaggerPluginSupport;
import springfox.documentation.swagger.schema.ApiModelProperties;

@Component(value="swaggerParameterAllowableReader")
@Order(value=-2147482648)
public class ParameterAllowableReader
implements ParameterBuilderPlugin {
    public void apply(ParameterContext context) {
        MethodParameter methodParameter = context.methodParameter();
        AllowableValues allowableValues = null;
        String allowableValueString = this.findAnnotatedAllowableValues(methodParameter);
        if (!Strings.isNullOrEmpty((String)allowableValueString)) {
            allowableValues = ApiModelProperties.allowableValueFromString(allowableValueString);
        } else {
            if (methodParameter.getParameterType().isEnum()) {
                allowableValues = Enums.allowableValues((Class)methodParameter.getParameterType());
            }
            if (methodParameter.getParameterType().isArray()) {
                allowableValues = Enums.allowableValues(methodParameter.getParameterType().getComponentType());
            }
        }
        context.parameterBuilder().allowableValues(allowableValues);
    }

    public boolean supports(DocumentationType delimiter) {
        return SwaggerPluginSupport.pluginDoesApply(delimiter);
    }

    private String findAnnotatedAllowableValues(MethodParameter methodParameter) {
        Annotation[] methodAnnotations = methodParameter.getParameterAnnotations();
        if (null != methodAnnotations) {
            for (Annotation annotation : methodAnnotations) {
                if (!(annotation instanceof ApiParam)) continue;
                return ((ApiParam)annotation).allowableValues();
            }
        }
        return null;
    }
}

