/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.ext.unit.impl;

import io.vertx.core.Handler;
import io.vertx.ext.unit.TestContext;
import io.vertx.ext.unit.impl.Result;
import io.vertx.ext.unit.impl.Task;
import io.vertx.ext.unit.impl.TestContextImpl;
import io.vertx.ext.unit.impl.TestContextTask;
import io.vertx.ext.unit.impl.TestResultImpl;
import io.vertx.ext.unit.report.TestCaseReport;
import io.vertx.ext.unit.report.TestResult;
import java.util.Map;
import java.util.function.Function;

public class TestCaseReportImpl
implements TestCaseReport {
    private final String name;
    private final long timeout;
    private final int repeat;
    private final Map<String, Object> attributes;
    private final Handler<TestContext> before;
    private final Handler<TestContext> test;
    private final Handler<TestContext> after;
    private final Handler<Throwable> unhandledFailureHandler;
    private volatile Handler<TestResult> completionHandler;

    public TestCaseReportImpl(String name, long timeout, int repeat, Map<String, Object> attributes, Handler<TestContext> before, Handler<TestContext> test, Handler<TestContext> after, Handler<Throwable> unhandledFailureHandler) {
        this.attributes = attributes;
        this.timeout = timeout;
        this.repeat = repeat;
        this.name = name;
        this.before = before;
        this.test = test;
        this.after = after;
        this.unhandledFailureHandler = unhandledFailureHandler;
    }

    Task<?> buildTask(Task<?> nextTask) {
        Task<Result> task = (result, context) -> {
            if (this.completionHandler != null) {
                this.completionHandler.handle((Object)new TestResultImpl(this.name, result.beginTime, result.duration(), result.failure));
            }
            nextTask.execute(null, context);
        };
        for (int count = 0; count < this.repeat; ++count) {
            task = this.runTask(task);
        }
        return task;
    }

    private Task<Result> runTask(Task<Result> next) {
        TestContextImpl testContext = new TestContextImpl(this.attributes, this.unhandledFailureHandler);
        TestContextTask afterHandler = this.after != null ? new TestContextTask(testContext, this.after, next, this.timeout) : next;
        TestContextTask testHandler = new TestContextTask(testContext, this.test, afterHandler, this.timeout);
        if (this.before != null) {
            Function<Result, Task<Result>> tmp = result -> {
                if (result.failure != null) {
                    return next;
                }
                return testHandler;
            };
            return new TestContextTask(testContext, this.before, tmp, this.timeout);
        }
        return testHandler;
    }

    @Override
    public String name() {
        return this.name;
    }

    @Override
    public TestCaseReport endHandler(Handler<TestResult> handler) {
        this.completionHandler = handler;
        return this;
    }
}

