/*
 * Decompiled with CFR 0.152.
 */
package brave.kafka.clients;

import brave.Span;
import brave.Tracer;
import brave.internal.Nullable;
import brave.kafka.clients.KafkaTracing;
import brave.kafka.clients.TracingCallback;
import brave.propagation.CurrentTraceContext;
import brave.propagation.TraceContext;
import java.time.Duration;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import org.apache.kafka.clients.consumer.OffsetAndMetadata;
import org.apache.kafka.clients.producer.Callback;
import org.apache.kafka.clients.producer.Producer;
import org.apache.kafka.clients.producer.ProducerRecord;
import org.apache.kafka.clients.producer.RecordMetadata;
import org.apache.kafka.common.Metric;
import org.apache.kafka.common.MetricName;
import org.apache.kafka.common.PartitionInfo;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.header.Headers;

final class TracingProducer<K, V>
implements Producer<K, V> {
    final Producer<K, V> delegate;
    final KafkaTracing kafkaTracing;
    final CurrentTraceContext current;
    final Tracer tracer;
    final TraceContext.Injector<Headers> injector;
    @Nullable
    final String remoteServiceName;

    TracingProducer(Producer<K, V> delegate, KafkaTracing kafkaTracing) {
        this.delegate = delegate;
        this.kafkaTracing = kafkaTracing;
        this.current = kafkaTracing.tracing.currentTraceContext();
        this.tracer = kafkaTracing.tracing.tracer();
        this.injector = kafkaTracing.injector;
        this.remoteServiceName = kafkaTracing.remoteServiceName;
    }

    public void initTransactions() {
        this.delegate.initTransactions();
    }

    public void beginTransaction() {
        this.delegate.beginTransaction();
    }

    public void commitTransaction() {
        this.delegate.commitTransaction();
    }

    public void abortTransaction() {
        this.delegate.abortTransaction();
    }

    public Future<RecordMetadata> send(ProducerRecord<K, V> record) {
        return this.send(record, null);
    }

    public Future<RecordMetadata> send(ProducerRecord<K, V> record, @Nullable Callback callback) {
        Future future;
        block11: {
            TraceContext maybeParent = this.current.get();
            Span span = maybeParent == null ? this.tracer.nextSpan(this.kafkaTracing.extractAndClearHeaders(record.headers())) : this.tracer.newChild(maybeParent);
            if (!span.isNoop()) {
                span.kind(Span.Kind.PRODUCER).name("send");
                if (this.remoteServiceName != null) {
                    span.remoteServiceName(this.remoteServiceName);
                }
                if (record.key() instanceof String && !"".equals(record.key())) {
                    span.tag("kafka.key", record.key().toString());
                }
                span.tag("kafka.topic", record.topic());
                span.start();
            }
            this.injector.inject(span.context(), (Object)record.headers());
            Tracer.SpanInScope ws = this.tracer.withSpanInScope(span);
            try {
                future = this.delegate.send(record, TracingCallback.create(callback, span, this.current));
                if (ws == null) break block11;
            }
            catch (Throwable throwable) {
                try {
                    if (ws != null) {
                        try {
                            ws.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (Error | RuntimeException e) {
                    span.error(e).finish();
                    throw e;
                }
            }
            ws.close();
        }
        return future;
    }

    public void flush() {
        this.delegate.flush();
    }

    public List<PartitionInfo> partitionsFor(String topic) {
        return this.delegate.partitionsFor(topic);
    }

    public Map<MetricName, ? extends Metric> metrics() {
        return this.delegate.metrics();
    }

    public void close() {
        this.delegate.close();
    }

    public void close(long timeout, TimeUnit unit) {
        this.delegate.close(timeout, unit);
    }

    public void close(Duration duration) {
        this.delegate.close(duration);
    }

    public void sendOffsetsToTransaction(Map<TopicPartition, OffsetAndMetadata> offsets, String consumerGroupId) {
        this.delegate.sendOffsetsToTransaction(offsets, consumerGroupId);
    }
}

