/*
 * Decompiled with CFR 0.152.
 */
package zipkin.autoconfigure.collector.rabbitmq;

import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Condition;
import org.springframework.context.annotation.ConditionContext;
import org.springframework.context.annotation.Conditional;
import org.springframework.context.annotation.Configuration;
import org.springframework.core.type.AnnotatedTypeMetadata;
import zipkin.autoconfigure.collector.rabbitmq.ZipkinRabbitMQCollectorProperties;
import zipkin.collector.CollectorMetrics;
import zipkin.collector.CollectorSampler;
import zipkin.collector.rabbitmq.RabbitMQCollector;
import zipkin.storage.StorageComponent;

@Configuration
@Conditional(value={RabbitMqAddressesSet.class})
@EnableConfigurationProperties(value={ZipkinRabbitMQCollectorProperties.class})
public class ZipkinRabbitMQCollectorAutoConfiguration {
    @Bean(initMethod="start")
    RabbitMQCollector rabbitMq(ZipkinRabbitMQCollectorProperties properties, CollectorSampler sampler, CollectorMetrics metrics, StorageComponent storage) {
        return properties.toBuilder().sampler(sampler).metrics(metrics).storage(storage).build();
    }

    static final class RabbitMqAddressesSet
    implements Condition {
        RabbitMqAddressesSet() {
        }

        public boolean matches(ConditionContext context, AnnotatedTypeMetadata a) {
            return !RabbitMqAddressesSet.isEmpty(context.getEnvironment().getProperty("zipkin.collector.rabbitmq.addresses"));
        }

        private static boolean isEmpty(String s) {
            return s == null || s.isEmpty();
        }
    }
}

